import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [config](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsconfig.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Config extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    protected resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [config](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsconfig.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Returns the current configuration items for resources that are present in your AWS Config aggregator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_BatchGetAggregateResourceConfig.html
     */
    batchGetAggregateResourceConfig(): this;
    /**
     * Returns the current configuration for one or more requested resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_BatchGetResourceConfig.html
     */
    batchGetResourceConfig(): this;
    /**
     * Deletes the authorization granted to the specified configuration aggregator account in a specified region
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteAggregationAuthorization.html
     */
    deleteAggregationAuthorization(): this;
    /**
     * Deletes the specified AWS Config rule and all of its evaluation results
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConfigRule.html
     */
    deleteConfigRule(): this;
    /**
     * Deletes the specified configuration aggregator and the aggregated data associated with the aggregator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConfigurationAggregator.html
     */
    deleteConfigurationAggregator(): this;
    /**
     * Deletes the configuration recorder
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConfigurationRecorder.html
     */
    deleteConfigurationRecorder(): this;
    /**
     * Deletes the specified conformance pack and all the AWS Config rules and all evaluation results within that conformance pack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConformancePack.html
     */
    deleteConformancePack(): this;
    /**
     * Deletes the delivery channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteDeliveryChannel.html
     */
    deleteDeliveryChannel(): this;
    /**
     * Deletes the evaluation results for the specified Config rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteEvaluationResults.html
     */
    deleteEvaluationResults(): this;
    /**
     * Deletes the specified organization config rule and all of its evaluation results from all member accounts in that organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteOrganizationConfigRule.html
     */
    deleteOrganizationConfigRule(): this;
    /**
     * Deletes the specified organization conformance pack and all of its evaluation results from all member accounts in that organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteOrganizationConformancePack.html
     */
    deleteOrganizationConformancePack(): this;
    /**
     * Deletes pending authorization requests for a specified aggregator account in a specified region
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeletePendingAggregationRequest.html
     */
    deletePendingAggregationRequest(): this;
    /**
     * Deletes the remediation configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteRemediationConfiguration.html
     */
    deleteRemediationConfiguration(): this;
    /**
     * Deletes one or more remediation exceptions for specific resource keys for a specific AWS Config Rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteRemediationExceptions.html
     */
    deleteRemediationExceptions(): this;
    /**
     * Deletes the retention configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteRetentionConfiguration.html
     */
    deleteRetentionConfiguration(): this;
    /**
     * Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeliverConfigSnapshot.html
     */
    deliverConfigSnapshot(): this;
    /**
     * Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant rules
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeAggregateComplianceByConfigRules.html
     */
    describeAggregateComplianceByConfigRules(): this;
    /**
     * Returns a list of authorizations granted to various aggregator accounts and regions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeAggregationAuthorizations.html
     */
    describeAggregationAuthorizations(): this;
    /**
     * Indicates whether the specified AWS Config rules are compliant
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeComplianceByConfigRule.html
     */
    describeComplianceByConfigRule(): this;
    /**
     * Indicates whether the specified AWS resources are compliant
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeComplianceByResource.html
     */
    describeComplianceByResource(): this;
    /**
     * Returns status information for each of your AWS managed Config rules
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigRuleEvaluationStatus.html
     */
    describeConfigRuleEvaluationStatus(): this;
    /**
     * Returns details about your AWS Config rules
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigRules.html
     */
    describeConfigRules(): this;
    /**
     * Returns status information for sources within an aggregator
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationAggregatorSourcesStatus.html
     */
    describeConfigurationAggregatorSourcesStatus(): this;
    /**
     * Returns the details of one or more configuration aggregators
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationAggregators.html
     */
    describeConfigurationAggregators(): this;
    /**
     * Returns the current status of the specified configuration recorder
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html
     */
    describeConfigurationRecorderStatus(): this;
    /**
     * Returns the name of one or more specified configuration recorders
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html
     */
    describeConfigurationRecorders(): this;
    /**
     * Returns compliance information for each rule in that conformance pack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConformancePackCompliance.html
     */
    describeConformancePackCompliance(): this;
    /**
     * Provides one or more conformance packs deployment status.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConformancePackStatus.html
     */
    describeConformancePackStatus(): this;
    /**
     * Returns a list of one or more conformance packs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConformancePacks.html
     */
    describeConformancePacks(): this;
    /**
     * Returns the current status of the specified delivery channel
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeDeliveryChannelStatus.html
     */
    describeDeliveryChannelStatus(): this;
    /**
     * Returns details about the specified delivery channel
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeDeliveryChannels.html
     */
    describeDeliveryChannels(): this;
    /**
     * Provides organization config rule deployment status for an organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeOrganizationConfigRuleStatuses.html
     */
    describeOrganizationConfigRuleStatuses(): this;
    /**
     * Returns a list of organization config rules.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeOrganizationConfigRules.html
     */
    describeOrganizationConfigRules(): this;
    /**
     * Provides organization conformance pack deployment status for an organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeOrganizationConformancePackStatuses.html
     */
    describeOrganizationConformancePackStatuses(): this;
    /**
     * Returns a list of organization conformance packs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeOrganizationConformancePacks.html
     */
    describeOrganizationConformancePacks(): this;
    /**
     * Returns a list of all pending aggregation requests
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribePendingAggregationRequests.html
     */
    describePendingAggregationRequests(): this;
    /**
     * Returns the details of one or more remediation configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeRemediationConfigurations.html
     */
    describeRemediationConfigurations(): this;
    /**
     * Returns the details of one or more remediation exceptions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeRemediationExceptions.html
     */
    describeRemediationExceptions(): this;
    /**
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps and any error messages for steps that have failed
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeRemediationExecutionStatus.html
     */
    describeRemediationExecutionStatus(): this;
    /**
     * Returns the details of one or more retention configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeRetentionConfigurations.html
     */
    describeRetentionConfigurations(): this;
    /**
     * Returns the evaluation results for the specified AWS Config rule for a specific resource in a rule
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetAggregateComplianceDetailsByConfigRule.html
     */
    getAggregateComplianceDetailsByConfigRule(): this;
    /**
     * Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetAggregateConfigRuleComplianceSummary.html
     */
    getAggregateConfigRuleComplianceSummary(): this;
    /**
     * Returns the resource counts across accounts and regions that are present in your AWS Config aggregator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetAggregateDiscoveredResourceCounts.html
     */
    getAggregateDiscoveredResourceCounts(): this;
    /**
     * Returns configuration item that is aggregated for your specific resource in a specific source account and region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetAggregateResourceConfig.html
     */
    getAggregateResourceConfig(): this;
    /**
     * Returns the evaluation results for the specified AWS Config rule
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceDetailsByConfigRule.html
     */
    getComplianceDetailsByConfigRule(): this;
    /**
     * Returns the evaluation results for the specified AWS resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceDetailsByResource.html
     */
    getComplianceDetailsByResource(): this;
    /**
     * Returns the number of AWS Config rules that are compliant and noncompliant, up to a maximum of 25 for each
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceSummaryByConfigRule.html
     */
    getComplianceSummaryByConfigRule(): this;
    /**
     * Returns the number of resources that are compliant and the number that are noncompliant
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceSummaryByResourceType.html
     */
    getComplianceSummaryByResourceType(): this;
    /**
     * Returns compliance details of a conformance pack for all AWS resources that are monitered by conformance pack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetConformancePackComplianceDetails.html
     */
    getConformancePackComplianceDetails(): this;
    /**
     * Provides compliance summary for one or more conformance packs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetConformancePackComplianceSummary.html
     */
    getConformancePackComplianceSummary(): this;
    /**
     * Returns the resource types, the number of each resource type, and the total number of resources that AWS Config is recording in this region for your AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetDiscoveredResourceCounts.html
     */
    getDiscoveredResourceCounts(): this;
    /**
     * Returns detailed status for each member account within an organization for a given organization config rule.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetOrganizationConfigRuleDetailedStatus.html
     */
    getOrganizationConfigRuleDetailedStatus(): this;
    /**
     * Returns detailed status for each member account within an organization for a given organization conformance pack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetOrganizationConformancePackDetailedStatus.html
     */
    getOrganizationConformancePackDetailedStatus(): this;
    /**
     * Returns a list of configuration items for the specified resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetResourceConfigHistory.html
     */
    getResourceConfigHistory(): this;
    /**
     * Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource type across accounts and regions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ListAggregateDiscoveredResources.html
     */
    listAggregateDiscoveredResources(): this;
    /**
     * Accepts a resource type and returns a list of resource identifiers for the resources of that type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ListDiscoveredResources.html
     */
    listDiscoveredResources(): this;
    /**
     * List the tags for AWS Config resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ListTagsForResource.html
     */
    listTagsForResource(): this;
    /**
     * Authorizes the aggregator account and region to collect data from the source account and region
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutAggregationAuthorization.html
     */
    putAggregationAuthorization(): this;
    /**
     * Adds or updates an AWS Config rule for evaluating whether your AWS resources comply with your desired configurations
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigRule.html
     */
    putConfigRule(): this;
    /**
     * Creates and updates the configuration aggregator with the selected source accounts and regions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationAggregator.html
     */
    putConfigurationAggregator(): this;
    /**
     * Creates a new configuration recorder to record the selected resource configurations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html
     */
    putConfigurationRecorder(): this;
    /**
     * Creates or updates a conformance pack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutConformancePack.html
     */
    putConformancePack(): this;
    /**
     * Creates a delivery channel object to deliver configuration information to an Amazon S3 bucket and Amazon SNS topic
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutDeliveryChannel.html
     */
    putDeliveryChannel(): this;
    /**
     * Used by an AWS Lambda function to deliver evaluation results to AWS Config
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutEvaluations.html
     */
    putEvaluations(): this;
    /**
     * Adds or updates organization config rule for your entire organization evaluating whether your AWS resources comply with your desired configurations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConfigRule.html
     */
    putOrganizationConfigRule(): this;
    /**
     * Adds or updates organization conformance pack for your entire organization evaluating whether your AWS resources comply with your desired configurations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConformancePack.html
     */
    putOrganizationConformancePack(): this;
    /**
     * Adds or updates the remediation configuration with a specific AWS Config rule with the selected target or action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutRemediationConfigurations.html
     */
    putRemediationConfigurations(): this;
    /**
     * Adds or updates remediation exceptions for specific resources for a specific AWS Config rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutRemediationExceptions.html
     */
    putRemediationExceptions(): this;
    /**
     * Creates and updates the retention configuration with details about retention period (number of days) that AWS Config stores your historical information
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutRetentionConfiguration.html
     */
    putRetentionConfiguration(): this;
    /**
     * Accepts a structured query language (SQL) SELECT command and an aggregator to query configuration state of AWS resources across multiple accounts and regions, performs the corresponding search, and returns resource configurations matching the properties.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_SelectAggregateResourceConfig.html
     */
    selectAggregateResourceConfig(): this;
    /**
     * Accepts a structured query language (SQL) SELECT command, performs the corresponding search, and returns resource configurations matching the properties
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_SelectResourceConfig.html
     */
    selectResourceConfig(): this;
    /**
     * Evaluates your resources against the specified Config rules
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_StartConfigRulesEvaluation.html
     */
    startConfigRulesEvaluation(): this;
    /**
     * Starts recording configurations of the AWS resources you have selected to record in your AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_StartConfigurationRecorder.html
     */
    startConfigurationRecorder(): this;
    /**
     * Runs an on-demand remediation for the specified AWS Config rules against the last known remediation configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_StartRemediationExecution.html
     */
    startRemediationExecution(): this;
    /**
     * Stops recording configurations of the AWS resources you have selected to record in your AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html
     */
    stopConfigurationRecorder(): this;
    /**
     * Associates the specified tags to a resource with the specified resourceArn
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_TagResource.html
     */
    tagResource(): this;
    /**
     * Deletes specified tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_UntagResource.html
     */
    untagResource(): this;
    /**
     * Adds a resource of type AggregationAuthorization to the statement
     *
     * https://docs.aws.amazon.com/config/latest/developerguide/config-concepts.htmlAPI_AggregationAuthorization.html
     *
     * @param aggregatorAccount - Identifier for the aggregatorAccount.
     * @param aggregatorRegion - Identifier for the aggregatorRegion.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAggregationAuthorization(aggregatorAccount: string, aggregatorRegion: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ConfigurationAggregator to the statement
     *
     * https://docs.aws.amazon.com/config/latest/developerguide/config-concepts.htmlAPI_ConfigurationAggregator.html
     *
     * @param aggregatorId - Identifier for the aggregatorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfigurationAggregator(aggregatorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ConfigRule to the statement
     *
     * https://docs.aws.amazon.com/config/latest/developerguide/config-concepts.htmlAPI_ConfigRule.html
     *
     * @param configRuleId - Identifier for the configRuleId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfigRule(configRuleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ConformancePack to the statement
     *
     * https://docs.aws.amazon.com/config/latest/developerguide/config-concepts.htmlAPI_ConformancePack.html
     *
     * @param conformancePackName - Identifier for the conformancePackName.
     * @param conformancePackId - Identifier for the conformancePackId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConformancePack(conformancePackName: string, conformancePackId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type OrganizationConfigRule to the statement
     *
     * https://docs.aws.amazon.com/config/latest/developerguide/config-concepts.htmlAPI_OrganizationConfigRule.html
     *
     * @param organizationConfigRuleId - Identifier for the organizationConfigRuleId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onOrganizationConfigRule(organizationConfigRuleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type OrganizationConformancePack to the statement
     *
     * https://docs.aws.amazon.com/config/latest/developerguide/config-concepts.htmlAPI_OrganizationConformancePack.html
     *
     * @param organizationConformancePackId - Identifier for the organizationConformancePackId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onOrganizationConformancePack(organizationConformancePackId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type RemediationConfiguration to the statement
     *
     * https://docs.aws.amazon.com/config/latest/developerguide/config-concepts.htmlAPI_RemediationConfiguration.html
     *
     * @param remediationConfigurationId - Identifier for the remediationConfigurationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onRemediationConfiguration(remediationConfigurationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters actions based on the allowed set of values for each of the tags
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .putAggregationAuthorization()
     * - .putConfigRule()
     * - .putConfigurationAggregator()
     * - .tagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: string): this;
    /**
     * Filters actions based on tag-value assoicated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - AggregationAuthorization
     * - ConfigurationAggregator
     * - ConfigRule
     * - ConformancePack
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: string): this;
    /**
     * Filters actions based on the presence of mandatory tags in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .putAggregationAuthorization()
     * - .putConfigRule()
     * - .putConfigurationAggregator()
     * - .tagResource()
     * - .untagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: string): this;
}
