import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [sms](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsservermigrationservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Sms extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    protected resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [sms](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsservermigrationservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create an application configuration to migrate on-premise application onto AWS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_CreateApp.html
     */
    createApp(): this;
    /**
     * Grants permission to create a job to migrate on-premise server onto AWS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_CreateReplicationJob.html
     */
    createReplicationJob(): this;
    /**
     * Grants permission to delete an existing application configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteApp.html
     */
    deleteApp(): this;
    /**
     * Grants permission to delete launch configuration for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppLaunchConfiguration.html
     */
    deleteAppLaunchConfiguration(): this;
    /**
     * Grants permission to delete replication configuration for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppReplicationConfiguration.html
     */
    deleteAppReplicationConfiguration(): this;
    /**
     * Grants permission to delete validation configuration for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppValidationConfiguration.html
     */
    deleteAppValidationConfiguration(): this;
    /**
     * Grants permission to delete an existing job to migrate on-premise server onto AWS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteReplicationJob.html
     */
    deleteReplicationJob(): this;
    /**
     * Grants permission to delete the complete list of on-premise servers gathered into AWS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteServerCatalog.html
     */
    deleteServerCatalog(): this;
    /**
     * Grants permission to disassociate a connector that has been associated
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DisassociateConnector.html
     */
    disassociateConnector(): this;
    /**
     * Grants permission to generate a changeSet for the CloudFormation stack of an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GenerateChangeSet.html
     */
    generateChangeSet(): this;
    /**
     * Grants permission to generate a CloudFormation template for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GenerateTemplate.html
     */
    generateTemplate(): this;
    /**
     * Grants permission to get the configuration and statuses for an existing application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetApp.html
     */
    getApp(): this;
    /**
     * Grants permission to get launch configuration for an existing application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppLaunchConfiguration.html
     */
    getAppLaunchConfiguration(): this;
    /**
     * Grants permission to get replication configuration for an existing application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppReplicationConfiguration.html
     */
    getAppReplicationConfiguration(): this;
    /**
     * Grants permission to get validation configuration for an existing application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppValidationConfiguration.html
     */
    getAppValidationConfiguration(): this;
    /**
     * Grants permission to get notification sent from application validation script.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppValidationOutput.html
     */
    getAppValidationOutput(): this;
    /**
     * Grants permission to get all connectors that have been associated
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetConnectors.html
     */
    getConnectors(): this;
    /**
     * Grants permission to gets messages from AWS Server Migration Service to Server Migration Connector
     *
     * Access Level: Read
     */
    getMessages(): this;
    /**
     * Grants permission to get all existing jobs to migrate on-premise servers onto AWS
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetReplicationJobs.html
     */
    getReplicationJobs(): this;
    /**
     * Grants permission to get all runs for an existing job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetReplicationRuns.html
     */
    getReplicationRuns(): this;
    /**
     * Grants permission to get all servers that have been imported
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetServers.html
     */
    getServers(): this;
    /**
     * Grants permission to import application catalog from AWS Application Discovery Service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ImportAppCatalog.html
     */
    importAppCatalog(): this;
    /**
     * Grants permission to gather a complete list of on-premise servers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ImportServerCatalog.html
     */
    importServerCatalog(): this;
    /**
     * Grants permission to create and launch a CloudFormation stack for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_LaunchApp.html
     */
    launchApp(): this;
    /**
     * Grants permission to get a list of summaries for existing applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ListAppss.html
     */
    listApps(): this;
    /**
     * Grants permission to send notification for application validation script
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_NotifyAppValidationOutput.html
     */
    notifyAppValidationOutput(): this;
    /**
     * Grants permission to create or update launch configuration for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppLaunchConfiguration.html
     */
    putAppLaunchConfiguration(): this;
    /**
     * Grants permission to create or update replication configuration for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppReplicationConfiguration.html
     */
    putAppReplicationConfiguration(): this;
    /**
     * Grants permission to put validation configuration for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppValidationConfiguration.html
     */
    putAppValidationConfiguration(): this;
    /**
     * Grants permission to send message from Server Migration Connector to AWS Server Migration Service
     *
     * Access Level: Write
     */
    sendMessage(): this;
    /**
     * Grants permission to create and start replication jobs for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartAppReplication.html
     */
    startAppReplication(): this;
    /**
     * Grants permission to start a replication run for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartOnDemandAppReplication.html
     */
    startOnDemandAppReplication(): this;
    /**
     * Grants permission to start a replication run for an existing replication job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartOnDemandReplicationRun.html
     */
    startOnDemandReplicationRun(): this;
    /**
     * Grants permission to stop and delete replication jobs for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StopAppReplication.html
     */
    stopAppReplication(): this;
    /**
     * Grants permission to terminate the CloudFormation stack for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_TerminateApp.html
     */
    terminateApp(): this;
    /**
     * Grants permission to update an existing application configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_UpdateApp.html
     */
    updateApp(): this;
    /**
     * Grants permission to update an existing job to migrate on-premise server onto AWS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_UpdateReplicationJob.html
     */
    updateReplicationJob(): this;
}
