"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithCDKPrincipal = void 0;
// @ts-ignore only available after swapping 1-base
const iam = require("@aws-cdk/aws-iam");
const _6_principals_1 = require("./6-principals");
/**
 * Adds CDK specific "principal" functionality to the Policy Statement
 */
class PolicyStatementWithCDKPrincipal extends _6_principals_1.PolicyStatementWithPrincipal {
    constructor() {
        super(...arguments);
        this.cdkPrincipals = [];
        this.cdkPrincipalsApplied = false;
    }
    /**
     * Adds any number of CDK principals to the statement
     * @param principals Principals to add to the statement
     */
    forCdkPrincipal(...principals) {
        this.cdkPrincipals.push(...principals);
        return this;
    }
    cdkApplyPrincipals() {
        if (!this.cdkPrincipalsApplied) {
            const mode = this.useNotPrincipals ? 'addNotPrincipals' : 'addPrincipals';
            // @ts-ignore only available after swapping 1-base
            this[mode](...this.cdkPrincipals);
            if (this.hasPrincipals()) {
                Object.keys(this.principals).forEach((prefix) => {
                    switch (prefix) {
                        case _6_principals_1.PrincipalType.AWS:
                            this.principals[prefix].forEach((arn) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new iam.ArnPrincipal(arn));
                            });
                            break;
                        case _6_principals_1.PrincipalType.CANONICAL_USER:
                            this.principals[prefix].forEach((userId) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new iam.CanonicalUserPrincipal(userId));
                            });
                            break;
                        case _6_principals_1.PrincipalType.FEDERATED:
                            this.principals[prefix].forEach((provider) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new iam.FederatedPrincipal(provider, {}));
                            });
                            break;
                        case _6_principals_1.PrincipalType.SERVICE:
                            this.principals[prefix].forEach((service) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new iam.ServicePrincipal(service));
                            });
                            break;
                        default:
                            throw Error(`Unhandled principal type: ${prefix}`);
                    }
                });
            }
            this.cdkPrincipalsApplied = true;
        }
    }
}
exports.PolicyStatementWithCDKPrincipal = PolicyStatementWithCDKPrincipal;
//# sourceMappingURL=data:application/json;base64,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