# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags
from .validators import boolean, integer
from .validators.athena import validate_encryptionoption, validate_workgroup_state


class DataCatalog(AWSObject):
    """
    `DataCatalog <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-datacatalog.html>`__
    """

    resource_type = "AWS::Athena::DataCatalog"

    props: PropsDictType = {
        "Description": (str, False),
        "Name": (str, True),
        "Parameters": (dict, False),
        "Tags": (Tags, False),
        "Type": (str, True),
    }


class NamedQuery(AWSObject):
    """
    `NamedQuery <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html>`__
    """

    resource_type = "AWS::Athena::NamedQuery"

    props: PropsDictType = {
        "Database": (str, True),
        "Description": (str, False),
        "Name": (str, False),
        "QueryString": (str, True),
        "WorkGroup": (str, False),
    }


class PreparedStatement(AWSObject):
    """
    `PreparedStatement <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-preparedstatement.html>`__
    """

    resource_type = "AWS::Athena::PreparedStatement"

    props: PropsDictType = {
        "Description": (str, False),
        "QueryStatement": (str, True),
        "StatementName": (str, True),
        "WorkGroup": (str, True),
    }


class EngineVersion(AWSProperty):
    """
    `EngineVersion <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-engineversion.html>`__
    """

    props: PropsDictType = {
        "EffectiveEngineVersion": (str, False),
        "SelectedEngineVersion": (str, False),
    }


class EncryptionConfiguration(AWSProperty):
    """
    `EncryptionConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-encryptionconfiguration.html>`__
    """

    props: PropsDictType = {
        "EncryptionOption": (validate_encryptionoption, True),
        "KmsKey": (str, False),
    }


class ResultConfiguration(AWSProperty):
    """
    `ResultConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfiguration.html>`__
    """

    props: PropsDictType = {
        "EncryptionConfiguration": (EncryptionConfiguration, False),
        "OutputLocation": (str, False),
    }


class WorkGroupConfiguration(AWSProperty):
    """
    `WorkGroupConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfiguration.html>`__
    """

    props: PropsDictType = {
        "BytesScannedCutoffPerQuery": (integer, False),
        "EnforceWorkGroupConfiguration": (boolean, False),
        "EngineVersion": (EngineVersion, False),
        "PublishCloudWatchMetricsEnabled": (boolean, False),
        "RequesterPaysEnabled": (boolean, False),
        "ResultConfiguration": (ResultConfiguration, False),
    }


class ResultConfigurationUpdates(AWSProperty):
    """
    `ResultConfigurationUpdates <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-resultconfigurationupdates.html>`__
    """

    props: PropsDictType = {
        "EncryptionConfiguration": (EncryptionConfiguration, False),
        "OutputLocation": (str, False),
        "RemoveEncryptionConfiguration": (boolean, False),
        "RemoveOutputLocation": (boolean, False),
    }


class WorkGroupConfigurationUpdates(AWSProperty):
    """
    `WorkGroupConfigurationUpdates <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-athena-workgroup-workgroupconfigurationupdates.html>`__
    """

    props: PropsDictType = {
        "BytesScannedCutoffPerQuery": (integer, False),
        "EnforceWorkGroupConfiguration": (boolean, False),
        "EngineVersion": (EngineVersion, False),
        "PublishCloudWatchMetricsEnabled": (boolean, False),
        "RemoveBytesScannedCutoffPerQuery": (boolean, False),
        "RequesterPaysEnabled": (boolean, False),
        "ResultConfigurationUpdates": (ResultConfigurationUpdates, False),
    }


class WorkGroup(AWSObject):
    """
    `WorkGroup <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-workgroup.html>`__
    """

    resource_type = "AWS::Athena::WorkGroup"

    props: PropsDictType = {
        "Description": (str, False),
        "Name": (str, True),
        "RecursiveDeleteOption": (boolean, False),
        "State": (validate_workgroup_state, False),
        "Tags": (Tags, False),
        "WorkGroupConfiguration": (WorkGroupConfiguration, False),
        "WorkGroupConfigurationUpdates": (WorkGroupConfigurationUpdates, False),
    }
