# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags
from .validators import boolean, integer


class ContactFlow(AWSObject):
    """
    `ContactFlow <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-contactflow.html>`__
    """

    resource_type = "AWS::Connect::ContactFlow"

    props: PropsDictType = {
        "Content": (str, True),
        "Description": (str, False),
        "InstanceArn": (str, True),
        "Name": (str, True),
        "State": (str, False),
        "Tags": (Tags, False),
        "Type": (str, False),
    }


class ContactFlowModule(AWSObject):
    """
    `ContactFlowModule <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-contactflowmodule.html>`__
    """

    resource_type = "AWS::Connect::ContactFlowModule"

    props: PropsDictType = {
        "Content": (str, True),
        "Description": (str, False),
        "InstanceArn": (str, True),
        "Name": (str, True),
        "State": (str, False),
        "Tags": (Tags, False),
    }


class HoursOfOperationTimeSlice(AWSProperty):
    """
    `HoursOfOperationTimeSlice <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-hoursofoperation-hoursofoperationtimeslice.html>`__
    """

    props: PropsDictType = {
        "Hours": (integer, True),
        "Minutes": (integer, True),
    }


class HoursOfOperationConfig(AWSProperty):
    """
    `HoursOfOperationConfig <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-hoursofoperation-hoursofoperationconfig.html>`__
    """

    props: PropsDictType = {
        "Day": (str, True),
        "EndTime": (HoursOfOperationTimeSlice, True),
        "StartTime": (HoursOfOperationTimeSlice, True),
    }


class HoursOfOperation(AWSObject):
    """
    `HoursOfOperation <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-hoursofoperation.html>`__
    """

    resource_type = "AWS::Connect::HoursOfOperation"

    props: PropsDictType = {
        "Config": ([HoursOfOperationConfig], True),
        "Description": (str, False),
        "InstanceArn": (str, True),
        "Name": (str, True),
        "Tags": (Tags, False),
        "TimeZone": (str, True),
    }


class PhoneNumberQuickConnectConfig(AWSProperty):
    """
    `PhoneNumberQuickConnectConfig <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-quickconnect-phonenumberquickconnectconfig.html>`__
    """

    props: PropsDictType = {
        "PhoneNumber": (str, True),
    }


class QueueQuickConnectConfig(AWSProperty):
    """
    `QueueQuickConnectConfig <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-quickconnect-queuequickconnectconfig.html>`__
    """

    props: PropsDictType = {
        "ContactFlowArn": (str, True),
        "QueueArn": (str, True),
    }


class UserQuickConnectConfig(AWSProperty):
    """
    `UserQuickConnectConfig <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-quickconnect-userquickconnectconfig.html>`__
    """

    props: PropsDictType = {
        "ContactFlowArn": (str, True),
        "UserArn": (str, True),
    }


class QuickConnectConfig(AWSProperty):
    """
    `QuickConnectConfig <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-quickconnect-quickconnectconfig.html>`__
    """

    props: PropsDictType = {
        "PhoneConfig": (PhoneNumberQuickConnectConfig, False),
        "QueueConfig": (QueueQuickConnectConfig, False),
        "QuickConnectType": (str, True),
        "UserConfig": (UserQuickConnectConfig, False),
    }


class QuickConnect(AWSObject):
    """
    `QuickConnect <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-quickconnect.html>`__
    """

    resource_type = "AWS::Connect::QuickConnect"

    props: PropsDictType = {
        "Description": (str, False),
        "InstanceArn": (str, True),
        "Name": (str, True),
        "QuickConnectConfig": (QuickConnectConfig, True),
        "Tags": (Tags, False),
    }


class UserIdentityInfo(AWSProperty):
    """
    `UserIdentityInfo <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-user-useridentityinfo.html>`__
    """

    props: PropsDictType = {
        "Email": (str, False),
        "FirstName": (str, False),
        "LastName": (str, False),
    }


class UserPhoneConfig(AWSProperty):
    """
    `UserPhoneConfig <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-user-userphoneconfig.html>`__
    """

    props: PropsDictType = {
        "AfterContactWorkTimeLimit": (integer, False),
        "AutoAccept": (boolean, False),
        "DeskPhoneNumber": (str, False),
        "PhoneType": (str, True),
    }


class User(AWSObject):
    """
    `User <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-user.html>`__
    """

    resource_type = "AWS::Connect::User"

    props: PropsDictType = {
        "DirectoryUserId": (str, False),
        "HierarchyGroupArn": (str, False),
        "IdentityInfo": (UserIdentityInfo, False),
        "InstanceArn": (str, True),
        "Password": (str, False),
        "PhoneConfig": (UserPhoneConfig, True),
        "RoutingProfileArn": (str, True),
        "SecurityProfileArns": ([str], True),
        "Tags": (Tags, False),
        "Username": (str, True),
    }


class UserHierarchyGroup(AWSObject):
    """
    `UserHierarchyGroup <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-userhierarchygroup.html>`__
    """

    resource_type = "AWS::Connect::UserHierarchyGroup"

    props: PropsDictType = {
        "InstanceArn": (str, True),
        "Name": (str, True),
        "ParentGroupArn": (str, False),
    }
