# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags
from .validators import boolean, double, integer


class Domain(AWSObject):
    """
    `Domain <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html>`__
    """

    resource_type = "AWS::CustomerProfiles::Domain"

    props: PropsDictType = {
        "DeadLetterQueueUrl": (str, False),
        "DefaultEncryptionKey": (str, False),
        "DefaultExpirationDays": (integer, False),
        "DomainName": (str, True),
        "Tags": (Tags, False),
    }


class IncrementalPullConfig(AWSProperty):
    """
    `IncrementalPullConfig <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-incrementalpullconfig.html>`__
    """

    props: PropsDictType = {
        "DatetimeTypeFieldName": (str, False),
    }


class MarketoSourceProperties(AWSProperty):
    """
    `MarketoSourceProperties <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-marketosourceproperties.html>`__
    """

    props: PropsDictType = {
        "Object": (str, True),
    }


class S3SourceProperties(AWSProperty):
    """
    `S3SourceProperties <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-s3sourceproperties.html>`__
    """

    props: PropsDictType = {
        "BucketName": (str, True),
        "BucketPrefix": (str, False),
    }


class SalesforceSourceProperties(AWSProperty):
    """
    `SalesforceSourceProperties <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-salesforcesourceproperties.html>`__
    """

    props: PropsDictType = {
        "EnableDynamicFieldUpdate": (boolean, False),
        "IncludeDeletedRecords": (boolean, False),
        "Object": (str, True),
    }


class ServiceNowSourceProperties(AWSProperty):
    """
    `ServiceNowSourceProperties <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-servicenowsourceproperties.html>`__
    """

    props: PropsDictType = {
        "Object": (str, True),
    }


class ZendeskSourceProperties(AWSProperty):
    """
    `ZendeskSourceProperties <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-zendesksourceproperties.html>`__
    """

    props: PropsDictType = {
        "Object": (str, True),
    }


class SourceConnectorProperties(AWSProperty):
    """
    `SourceConnectorProperties <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html>`__
    """

    props: PropsDictType = {
        "Marketo": (MarketoSourceProperties, False),
        "S3": (S3SourceProperties, False),
        "Salesforce": (SalesforceSourceProperties, False),
        "ServiceNow": (ServiceNowSourceProperties, False),
        "Zendesk": (ZendeskSourceProperties, False),
    }


class SourceFlowConfig(AWSProperty):
    """
    `SourceFlowConfig <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html>`__
    """

    props: PropsDictType = {
        "ConnectorProfileName": (str, False),
        "ConnectorType": (str, True),
        "IncrementalPullConfig": (IncrementalPullConfig, False),
        "SourceConnectorProperties": (SourceConnectorProperties, True),
    }


class ConnectorOperator(AWSProperty):
    """
    `ConnectorOperator <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html>`__
    """

    props: PropsDictType = {
        "Marketo": (str, False),
        "S3": (str, False),
        "Salesforce": (str, False),
        "ServiceNow": (str, False),
        "Zendesk": (str, False),
    }


class TaskPropertiesMap(AWSProperty):
    """
    `TaskPropertiesMap <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-taskpropertiesmap.html>`__
    """

    props: PropsDictType = {
        "OperatorPropertyKey": (str, True),
        "Property": (str, True),
    }


class Task(AWSProperty):
    """
    `Task <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html>`__
    """

    props: PropsDictType = {
        "ConnectorOperator": (ConnectorOperator, False),
        "DestinationField": (str, False),
        "SourceFields": ([str], True),
        "TaskProperties": ([TaskPropertiesMap], False),
        "TaskType": (str, True),
    }


class ScheduledTriggerProperties(AWSProperty):
    """
    `ScheduledTriggerProperties <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html>`__
    """

    props: PropsDictType = {
        "DataPullMode": (str, False),
        "FirstExecutionFrom": (double, False),
        "ScheduleEndTime": (double, False),
        "ScheduleExpression": (str, True),
        "ScheduleOffset": (integer, False),
        "ScheduleStartTime": (double, False),
        "Timezone": (str, False),
    }


class TriggerProperties(AWSProperty):
    """
    `TriggerProperties <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerproperties.html>`__
    """

    props: PropsDictType = {
        "Scheduled": (ScheduledTriggerProperties, False),
    }


class TriggerConfig(AWSProperty):
    """
    `TriggerConfig <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerconfig.html>`__
    """

    props: PropsDictType = {
        "TriggerProperties": (TriggerProperties, False),
        "TriggerType": (str, True),
    }


class FlowDefinition(AWSProperty):
    """
    `FlowDefinition <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html>`__
    """

    props: PropsDictType = {
        "Description": (str, False),
        "FlowName": (str, True),
        "KmsArn": (str, True),
        "SourceFlowConfig": (SourceFlowConfig, True),
        "Tasks": ([Task], True),
        "TriggerConfig": (TriggerConfig, True),
    }


class ObjectTypeMapping(AWSProperty):
    """
    `ObjectTypeMapping <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-objecttypemapping.html>`__
    """

    props: PropsDictType = {
        "Key": (str, True),
        "Value": (str, True),
    }


class Integration(AWSObject):
    """
    `Integration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html>`__
    """

    resource_type = "AWS::CustomerProfiles::Integration"

    props: PropsDictType = {
        "DomainName": (str, True),
        "FlowDefinition": (FlowDefinition, False),
        "ObjectTypeName": (str, False),
        "ObjectTypeNames": ([ObjectTypeMapping], False),
        "Tags": (Tags, False),
        "Uri": (str, False),
    }


class ObjectTypeField(AWSProperty):
    """
    `ObjectTypeField <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-objecttypefield.html>`__
    """

    props: PropsDictType = {
        "ContentType": (str, False),
        "Source": (str, False),
        "Target": (str, False),
    }


class FieldMap(AWSProperty):
    """
    `FieldMap <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-fieldmap.html>`__
    """

    props: PropsDictType = {
        "Name": (str, False),
        "ObjectTypeField": (ObjectTypeField, False),
    }


class ObjectTypeKey(AWSProperty):
    """
    `ObjectTypeKey <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-objecttypekey.html>`__
    """

    props: PropsDictType = {
        "FieldNames": ([str], False),
        "StandardIdentifiers": ([str], False),
    }


class KeyMap(AWSProperty):
    """
    `KeyMap <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-keymap.html>`__
    """

    props: PropsDictType = {
        "Name": (str, False),
        "ObjectTypeKeyList": ([ObjectTypeKey], False),
    }


class ObjectType(AWSObject):
    """
    `ObjectType <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html>`__
    """

    resource_type = "AWS::CustomerProfiles::ObjectType"

    props: PropsDictType = {
        "AllowProfileCreation": (boolean, False),
        "Description": (str, False),
        "DomainName": (str, True),
        "EncryptionKey": (str, False),
        "ExpirationDays": (integer, False),
        "Fields": ([FieldMap], False),
        "Keys": ([KeyMap], False),
        "ObjectTypeName": (str, False),
        "Tags": (Tags, False),
        "TemplateId": (str, False),
    }
