# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags
from .validators import boolean
from .validators.fms import validate_json_checker


class NotificationChannel(AWSObject):
    """
    `NotificationChannel <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-notificationchannel.html>`__
    """

    resource_type = "AWS::FMS::NotificationChannel"

    props: PropsDictType = {
        "SnsRoleName": (str, True),
        "SnsTopicArn": (str, True),
    }


class IEMap(AWSProperty):
    """
    `IEMap <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-iemap.html>`__
    """

    props: PropsDictType = {
        "ACCOUNT": ([str], False),
        "ORGUNIT": ([str], False),
    }


class Policy(AWSObject):
    """
    `Policy <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html>`__
    """

    resource_type = "AWS::FMS::Policy"

    props: PropsDictType = {
        "DeleteAllPolicyResources": (boolean, False),
        "ExcludeMap": (IEMap, False),
        "ExcludeResourceTags": (boolean, True),
        "IncludeMap": (IEMap, False),
        "PolicyName": (str, True),
        "RemediationEnabled": (boolean, True),
        "ResourceTags": (Tags, False),
        "ResourceType": (str, True),
        "ResourceTypeList": ([str], False),
        "ResourcesCleanUp": (boolean, False),
        "SecurityServicePolicyData": (validate_json_checker, True),
        "Tags": (Tags, False),
    }
