# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType
from .validators import boolean, integer


class ComponentDependencyRequirement(AWSProperty):
    """
    `ComponentDependencyRequirement <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentdependencyrequirement.html>`__
    """

    props: PropsDictType = {
        "DependencyType": (str, False),
        "VersionRequirement": (str, False),
    }


class ComponentPlatform(AWSProperty):
    """
    `ComponentPlatform <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentplatform.html>`__
    """

    props: PropsDictType = {
        "Attributes": (dict, False),
        "Name": (str, False),
    }


class LambdaEventSource(AWSProperty):
    """
    `LambdaEventSource <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaeventsource.html>`__
    """

    props: PropsDictType = {
        "Topic": (str, False),
        "Type": (str, False),
    }


class LambdaDeviceMount(AWSProperty):
    """
    `LambdaDeviceMount <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html>`__
    """

    props: PropsDictType = {
        "AddGroupOwner": (boolean, False),
        "Path": (str, False),
        "Permission": (str, False),
    }


class LambdaVolumeMount(AWSProperty):
    """
    `LambdaVolumeMount <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html>`__
    """

    props: PropsDictType = {
        "AddGroupOwner": (boolean, False),
        "DestinationPath": (str, False),
        "Permission": (str, False),
        "SourcePath": (str, False),
    }


class LambdaContainerParams(AWSProperty):
    """
    `LambdaContainerParams <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html>`__
    """

    props: PropsDictType = {
        "Devices": ([LambdaDeviceMount], False),
        "MemorySizeInKB": (integer, False),
        "MountROSysfs": (boolean, False),
        "Volumes": ([LambdaVolumeMount], False),
    }


class LambdaLinuxProcessParams(AWSProperty):
    """
    `LambdaLinuxProcessParams <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdalinuxprocessparams.html>`__
    """

    props: PropsDictType = {
        "ContainerParams": (LambdaContainerParams, False),
        "IsolationMode": (str, False),
    }


class LambdaExecutionParameters(AWSProperty):
    """
    `LambdaExecutionParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html>`__
    """

    props: PropsDictType = {
        "EnvironmentVariables": (dict, False),
        "EventSources": ([LambdaEventSource], False),
        "ExecArgs": ([str], False),
        "InputPayloadEncodingType": (str, False),
        "LinuxProcessParams": (LambdaLinuxProcessParams, False),
        "MaxIdleTimeInSeconds": (integer, False),
        "MaxInstancesCount": (integer, False),
        "MaxQueueSize": (integer, False),
        "Pinned": (boolean, False),
        "StatusTimeoutInSeconds": (integer, False),
        "TimeoutInSeconds": (integer, False),
    }


class LambdaFunctionRecipeSource(AWSProperty):
    """
    `LambdaFunctionRecipeSource <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html>`__
    """

    props: PropsDictType = {
        "ComponentDependencies": (dict, False),
        "ComponentLambdaParameters": (LambdaExecutionParameters, False),
        "ComponentName": (str, False),
        "ComponentPlatforms": ([ComponentPlatform], False),
        "ComponentVersion": (str, False),
        "LambdaArn": (str, False),
    }


class ComponentVersion(AWSObject):
    """
    `ComponentVersion <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html>`__
    """

    resource_type = "AWS::GreengrassV2::ComponentVersion"

    props: PropsDictType = {
        "InlineRecipe": (str, False),
        "LambdaFunction": (LambdaFunctionRecipeSource, False),
        "Tags": (dict, False),
    }
