# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType
from .validators import double, integer


class DateFilter(AWSProperty):
    """
    `DateFilter <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-datefilter.html>`__
    """

    props: PropsDictType = {
        "EndInclusive": (integer, False),
        "StartInclusive": (integer, False),
    }


class MapFilter(AWSProperty):
    """
    `MapFilter <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-mapfilter.html>`__
    """

    props: PropsDictType = {
        "Comparison": (str, True),
        "Key": (str, False),
        "Value": (str, False),
    }


class NumberFilter(AWSProperty):
    """
    `NumberFilter <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-numberfilter.html>`__
    """

    props: PropsDictType = {
        "LowerInclusive": (double, False),
        "UpperInclusive": (double, False),
    }


class StringFilter(AWSProperty):
    """
    `StringFilter <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-stringfilter.html>`__
    """

    props: PropsDictType = {
        "Comparison": (str, True),
        "Value": (str, True),
    }


class PackageFilter(AWSProperty):
    """
    `PackageFilter <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-packagefilter.html>`__
    """

    props: PropsDictType = {
        "Architecture": (StringFilter, False),
        "Epoch": (NumberFilter, False),
        "Name": (StringFilter, False),
        "Release": (StringFilter, False),
        "SourceLayerHash": (StringFilter, False),
        "Version": (StringFilter, False),
    }


class PortRangeFilter(AWSProperty):
    """
    `PortRangeFilter <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-portrangefilter.html>`__
    """

    props: PropsDictType = {
        "BeginInclusive": (integer, False),
        "EndInclusive": (integer, False),
    }


class FilterCriteria(AWSProperty):
    """
    `FilterCriteria <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-filter-filtercriteria.html>`__
    """

    props: PropsDictType = {
        "AwsAccountId": ([StringFilter], False),
        "ComponentId": ([StringFilter], False),
        "ComponentType": ([StringFilter], False),
        "Ec2InstanceImageId": ([StringFilter], False),
        "Ec2InstanceSubnetId": ([StringFilter], False),
        "Ec2InstanceVpcId": ([StringFilter], False),
        "EcrImageArchitecture": ([StringFilter], False),
        "EcrImageHash": ([StringFilter], False),
        "EcrImagePushedAt": ([DateFilter], False),
        "EcrImageRegistry": ([StringFilter], False),
        "EcrImageRepositoryName": ([StringFilter], False),
        "EcrImageTags": ([StringFilter], False),
        "FindingArn": ([StringFilter], False),
        "FindingStatus": ([StringFilter], False),
        "FindingType": ([StringFilter], False),
        "FirstObservedAt": ([DateFilter], False),
        "InspectorScore": ([NumberFilter], False),
        "LastObservedAt": ([DateFilter], False),
        "NetworkProtocol": ([StringFilter], False),
        "PortRange": ([PortRangeFilter], False),
        "RelatedVulnerabilities": ([StringFilter], False),
        "ResourceId": ([StringFilter], False),
        "ResourceTags": ([MapFilter], False),
        "ResourceType": ([StringFilter], False),
        "Severity": ([StringFilter], False),
        "Title": ([StringFilter], False),
        "UpdatedAt": ([DateFilter], False),
        "VendorSeverity": ([StringFilter], False),
        "VulnerabilityId": ([StringFilter], False),
        "VulnerabilitySource": ([StringFilter], False),
        "VulnerablePackages": ([PackageFilter], False),
    }


class Filter(AWSObject):
    """
    `Filter <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html>`__
    """

    resource_type = "AWS::InspectorV2::Filter"

    props: PropsDictType = {
        "Description": (str, False),
        "FilterAction": (str, True),
        "FilterCriteria": (FilterCriteria, True),
        "Name": (str, True),
    }
