# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType
from .validators import boolean


class DataLakePrincipal(AWSProperty):
    """
    `DataLakePrincipal <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-datalakeprincipal.html>`__
    """

    props: PropsDictType = {
        "DataLakePrincipalIdentifier": (str, False),
    }


class DataLakeSettings(AWSObject):
    """
    `DataLakeSettings <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-datalakesettings.html>`__
    """

    resource_type = "AWS::LakeFormation::DataLakeSettings"

    props: PropsDictType = {
        "Admins": ([DataLakePrincipal], False),
        "TrustedResourceOwners": ([str], False),
    }


class DataLocationResource(AWSProperty):
    """
    `DataLocationResource <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-datalocationresource.html>`__
    """

    props: PropsDictType = {
        "CatalogId": (str, False),
        "S3Resource": (str, False),
    }


class DatabaseResource(AWSProperty):
    """
    `DatabaseResource <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-databaseresource.html>`__
    """

    props: PropsDictType = {
        "CatalogId": (str, False),
        "Name": (str, False),
    }


class TableWildcard(AWSProperty):
    """
    `TableWildcard <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tablewildcard.html>`__
    """

    props: PropsDictType = {}


class TableResource(AWSProperty):
    """
    `TableResource <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tableresource.html>`__
    """

    props: PropsDictType = {
        "CatalogId": (str, False),
        "DatabaseName": (str, False),
        "Name": (str, False),
        "TableWildcard": (TableWildcard, False),
    }


class ColumnWildcard(AWSProperty):
    """
    `ColumnWildcard <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-columnwildcard.html>`__
    """

    props: PropsDictType = {
        "ExcludedColumnNames": ([str], False),
    }


class TableWithColumnsResource(AWSProperty):
    """
    `TableWithColumnsResource <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-tablewithcolumnsresource.html>`__
    """

    props: PropsDictType = {
        "CatalogId": (str, False),
        "ColumnNames": ([str], False),
        "ColumnWildcard": (ColumnWildcard, False),
        "DatabaseName": (str, False),
        "Name": (str, False),
    }


class ResourceProperty(AWSProperty):
    """
    `ResourceProperty <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-resource.html>`__
    """

    props: PropsDictType = {
        "DataLocationResource": (DataLocationResource, False),
        "DatabaseResource": (DatabaseResource, False),
        "TableResource": (TableResource, False),
        "TableWithColumnsResource": (TableWithColumnsResource, False),
    }


class Permissions(AWSObject):
    """
    `Permissions <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-permissions.html>`__
    """

    resource_type = "AWS::LakeFormation::Permissions"

    props: PropsDictType = {
        "DataLakePrincipal": (DataLakePrincipal, True),
        "Permissions": ([str], False),
        "PermissionsWithGrantOption": ([str], False),
        "Resource": (ResourceProperty, True),
    }


class Resource(AWSObject):
    """
    `Resource <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-resource.html>`__
    """

    resource_type = "AWS::LakeFormation::Resource"

    props: PropsDictType = {
        "ResourceArn": (str, True),
        "RoleArn": (str, False),
        "UseServiceLinkedRole": (boolean, True),
    }
