# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags
from .validators import integer


class CustomerGatewayAssociation(AWSObject):
    """
    `CustomerGatewayAssociation <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-customergatewayassociation.html>`__
    """

    resource_type = "AWS::NetworkManager::CustomerGatewayAssociation"

    props: PropsDictType = {
        "CustomerGatewayArn": (str, True),
        "DeviceId": (str, True),
        "GlobalNetworkId": (str, True),
        "LinkId": (str, False),
    }


class Location(AWSProperty):
    """
    `Location <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-site-location.html>`__
    """

    props: PropsDictType = {
        "Address": (str, False),
        "Latitude": (str, False),
        "Longitude": (str, False),
    }


class Device(AWSObject):
    """
    `Device <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-device.html>`__
    """

    resource_type = "AWS::NetworkManager::Device"

    props: PropsDictType = {
        "Description": (str, False),
        "GlobalNetworkId": (str, True),
        "Location": (Location, False),
        "Model": (str, False),
        "SerialNumber": (str, False),
        "SiteId": (str, False),
        "Tags": (Tags, False),
        "Type": (str, False),
        "Vendor": (str, False),
    }


class GlobalNetwork(AWSObject):
    """
    `GlobalNetwork <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-globalnetwork.html>`__
    """

    resource_type = "AWS::NetworkManager::GlobalNetwork"

    props: PropsDictType = {
        "Description": (str, False),
        "Tags": (Tags, False),
    }


class Bandwidth(AWSProperty):
    """
    `Bandwidth <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-link-bandwidth.html>`__
    """

    props: PropsDictType = {
        "DownloadSpeed": (integer, False),
        "UploadSpeed": (integer, False),
    }


class Link(AWSObject):
    """
    `Link <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-link.html>`__
    """

    resource_type = "AWS::NetworkManager::Link"

    props: PropsDictType = {
        "Bandwidth": (Bandwidth, True),
        "Description": (str, False),
        "GlobalNetworkId": (str, True),
        "Provider": (str, False),
        "SiteId": (str, True),
        "Tags": (Tags, False),
        "Type": (str, False),
    }


class LinkAssociation(AWSObject):
    """
    `LinkAssociation <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-linkassociation.html>`__
    """

    resource_type = "AWS::NetworkManager::LinkAssociation"

    props: PropsDictType = {
        "DeviceId": (str, True),
        "GlobalNetworkId": (str, True),
        "LinkId": (str, True),
    }


class Site(AWSObject):
    """
    `Site <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-site.html>`__
    """

    resource_type = "AWS::NetworkManager::Site"

    props: PropsDictType = {
        "Description": (str, False),
        "GlobalNetworkId": (str, True),
        "Location": (Location, False),
        "Tags": (Tags, False),
    }


class TransitGatewayRegistration(AWSObject):
    """
    `TransitGatewayRegistration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-transitgatewayregistration.html>`__
    """

    resource_type = "AWS::NetworkManager::TransitGatewayRegistration"

    props: PropsDictType = {
        "GlobalNetworkId": (str, True),
        "TransitGatewayArn": (str, True),
    }
