# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags
from .validators import boolean, integer
from .validators.route53 import AlarmIdentifier  # noqa: F401
from .validators.route53 import AliasTarget  # noqa: F401
from .validators.route53 import HealthCheckConfiguration  # noqa: F401


class DNSSEC(AWSObject):
    """
    `DNSSEC <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-dnssec.html>`__
    """

    resource_type = "AWS::Route53::DNSSEC"

    props: PropsDictType = {
        "HostedZoneId": (str, True),
    }


class HealthCheck(AWSObject):
    """
    `HealthCheck <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html>`__
    """

    resource_type = "AWS::Route53::HealthCheck"

    props: PropsDictType = {
        "HealthCheckConfig": (HealthCheckConfiguration, True),
        "HealthCheckTags": (Tags, False),
    }


class HostedZoneConfiguration(AWSProperty):
    """
    `HostedZoneConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzoneconfig.html>`__
    """

    props: PropsDictType = {
        "Comment": (str, False),
    }


class HostedZoneVPCs(AWSProperty):
    """
    `HostedZoneVPCs <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-vpc.html>`__
    """

    props: PropsDictType = {
        "VPCId": (str, True),
        "VPCRegion": (str, True),
    }


class QueryLoggingConfig(AWSProperty):
    """
    `QueryLoggingConfig <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-queryloggingconfig.html>`__
    """

    props: PropsDictType = {
        "CloudWatchLogsLogGroupArn": (str, True),
    }


class HostedZone(AWSObject):
    """
    `HostedZone <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html>`__
    """

    resource_type = "AWS::Route53::HostedZone"

    props: PropsDictType = {
        "HostedZoneConfig": (HostedZoneConfiguration, False),
        "HostedZoneTags": (Tags, False),
        "Name": (str, False),
        "QueryLoggingConfig": (QueryLoggingConfig, False),
        "VPCs": ([HostedZoneVPCs], False),
    }


class KeySigningKey(AWSObject):
    """
    `KeySigningKey <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-keysigningkey.html>`__
    """

    resource_type = "AWS::Route53::KeySigningKey"

    props: PropsDictType = {
        "HostedZoneId": (str, True),
        "KeyManagementServiceArn": (str, True),
        "Name": (str, True),
        "Status": (str, True),
    }


class GeoLocation(AWSProperty):
    """
    `GeoLocation <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html>`__
    """

    props: PropsDictType = {
        "ContinentCode": (str, False),
        "CountryCode": (str, False),
        "SubdivisionCode": (str, False),
    }


class RecordSet(AWSProperty):
    """
    `RecordSet <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html>`__
    """

    props: PropsDictType = {
        "AliasTarget": (AliasTarget, False),
        "Failover": (str, False),
        "GeoLocation": (GeoLocation, False),
        "HealthCheckId": (str, False),
        "HostedZoneId": (str, False),
        "HostedZoneName": (str, False),
        "MultiValueAnswer": (boolean, False),
        "Name": (str, True),
        "Region": (str, False),
        "ResourceRecords": ([str], False),
        "SetIdentifier": (str, False),
        "TTL": (str, False),
        "Type": (str, True),
        "Weight": (integer, False),
    }


class RecordSetGroup(AWSObject):
    """
    `RecordSetGroup <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html>`__
    """

    resource_type = "AWS::Route53::RecordSetGroup"

    props: PropsDictType = {
        "Comment": (str, False),
        "HostedZoneId": (str, False),
        "HostedZoneName": (str, False),
        "RecordSets": ([RecordSet], False),
    }


class RecordSetType(AWSObject):
    """
    `RecordSetType <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html>`__
    """

    resource_type = "AWS::Route53::RecordSet"

    props: PropsDictType = {
        "AliasTarget": (AliasTarget, False),
        "Comment": (str, False),
        "Failover": (str, False),
        "GeoLocation": (GeoLocation, False),
        "HealthCheckId": (str, False),
        "HostedZoneId": (str, False),
        "HostedZoneName": (str, False),
        "MultiValueAnswer": (boolean, False),
        "Name": (str, True),
        "Region": (str, False),
        "ResourceRecords": ([str], False),
        "SetIdentifier": (str, False),
        "TTL": (str, False),
        "Type": (str, True),
        "Weight": (integer, False),
    }
