# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags
from .validators import boolean, double


class AppMonitorConfiguration(AWSProperty):
    """
    `AppMonitorConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html>`__
    """

    props: PropsDictType = {
        "AllowCookies": (boolean, False),
        "EnableXRay": (boolean, False),
        "ExcludedPages": ([str], False),
        "FavoritePages": ([str], False),
        "GuestRoleArn": (str, False),
        "IdentityPoolId": (str, False),
        "IncludedPages": ([str], False),
        "SessionSampleRate": (double, False),
        "Telemetries": ([str], False),
    }


class AppMonitor(AWSObject):
    """
    `AppMonitor <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html>`__
    """

    resource_type = "AWS::RUM::AppMonitor"

    props: PropsDictType = {
        "AppMonitorConfiguration": (AppMonitorConfiguration, False),
        "CwLogEnabled": (boolean, False),
        "Domain": (str, True),
        "Name": (str, True),
        "Tags": (Tags, False),
    }
