# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType
from .validators import boolean


class TransformationConfiguration(AWSProperty):
    """
    `TransformationConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-transformationconfiguration.html>`__
    """

    props: PropsDictType = {
        "Actions": ([str], True),
        "ContentTransformation": (dict, True),
    }


class ObjectLambdaConfiguration(AWSProperty):
    """
    `ObjectLambdaConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3objectlambda-accesspoint-objectlambdaconfiguration.html>`__
    """

    props: PropsDictType = {
        "AllowedFeatures": ([str], False),
        "CloudWatchMetricsEnabled": (boolean, False),
        "SupportingAccessPoint": (str, True),
        "TransformationConfigurations": ([TransformationConfiguration], True),
    }


class AccessPoint(AWSObject):
    """
    `AccessPoint <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspoint.html>`__
    """

    resource_type = "AWS::S3ObjectLambda::AccessPoint"

    props: PropsDictType = {
        "Name": (str, False),
        "ObjectLambdaConfiguration": (ObjectLambdaConfiguration, True),
    }


class AccessPointPolicy(AWSObject):
    """
    `AccessPointPolicy <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3objectlambda-accesspointpolicy.html>`__
    """

    resource_type = "AWS::S3ObjectLambda::AccessPointPolicy"

    props: PropsDictType = {
        "ObjectLambdaAccessPoint": (str, True),
        "PolicyDocument": (dict, True),
    }
