# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType
from .validators import boolean, integer


class ChannelTargetInfo(AWSProperty):
    """
    `ChannelTargetInfo <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-contact-channeltargetinfo.html>`__
    """

    props: PropsDictType = {
        "ChannelId": (str, True),
        "RetryIntervalInMinutes": (integer, True),
    }


class ContactTargetInfo(AWSProperty):
    """
    `ContactTargetInfo <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-contact-contacttargetinfo.html>`__
    """

    props: PropsDictType = {
        "ContactId": (str, True),
        "IsEssential": (boolean, True),
    }


class Targets(AWSProperty):
    """
    `Targets <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-contact-targets.html>`__
    """

    props: PropsDictType = {
        "ChannelTargetInfo": (ChannelTargetInfo, False),
        "ContactTargetInfo": (ContactTargetInfo, False),
    }


class Stage(AWSProperty):
    """
    `Stage <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-contact-stage.html>`__
    """

    props: PropsDictType = {
        "DurationInMinutes": (integer, True),
        "Targets": ([Targets], False),
    }


class Contact(AWSObject):
    """
    `Contact <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-contact.html>`__
    """

    resource_type = "AWS::SSMContacts::Contact"

    props: PropsDictType = {
        "Alias": (str, True),
        "DisplayName": (str, True),
        "Plan": ([Stage], True),
        "Type": (str, True),
    }


class ContactChannel(AWSObject):
    """
    `ContactChannel <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-contactchannel.html>`__
    """

    resource_type = "AWS::SSMContacts::ContactChannel"

    props: PropsDictType = {
        "ChannelAddress": (str, True),
        "ChannelName": (str, True),
        "ChannelType": (str, True),
        "ContactId": (str, True),
        "DeferActivation": (boolean, False),
    }
