# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags


class ServerSideEncryptionConfiguration(AWSProperty):
    """
    `ServerSideEncryptionConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-serversideencryptionconfiguration.html>`__
    """

    props: PropsDictType = {
        "KmsKeyId": (str, False),
    }


class Assistant(AWSObject):
    """
    `Assistant <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistant.html>`__
    """

    resource_type = "AWS::Wisdom::Assistant"

    props: PropsDictType = {
        "Description": (str, False),
        "Name": (str, True),
        "ServerSideEncryptionConfiguration": (ServerSideEncryptionConfiguration, False),
        "Tags": (Tags, False),
        "Type": (str, True),
    }


class AssociationData(AWSProperty):
    """
    `AssociationData <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-assistantassociation-associationdata.html>`__
    """

    props: PropsDictType = {
        "KnowledgeBaseId": (str, True),
    }


class AssistantAssociation(AWSObject):
    """
    `AssistantAssociation <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-assistantassociation.html>`__
    """

    resource_type = "AWS::Wisdom::AssistantAssociation"

    props: PropsDictType = {
        "AssistantId": (str, True),
        "Association": (AssociationData, True),
        "AssociationType": (str, True),
        "Tags": (Tags, False),
    }


class RenderingConfiguration(AWSProperty):
    """
    `RenderingConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-renderingconfiguration.html>`__
    """

    props: PropsDictType = {
        "TemplateUri": (str, False),
    }


class AppIntegrationsConfiguration(AWSProperty):
    """
    `AppIntegrationsConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-appintegrationsconfiguration.html>`__
    """

    props: PropsDictType = {
        "AppIntegrationArn": (str, True),
        "ObjectFields": ([str], True),
    }


class SourceConfiguration(AWSProperty):
    """
    `SourceConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-knowledgebase-sourceconfiguration.html>`__
    """

    props: PropsDictType = {
        "AppIntegrations": (AppIntegrationsConfiguration, False),
    }


class KnowledgeBase(AWSObject):
    """
    `KnowledgeBase <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html>`__
    """

    resource_type = "AWS::Wisdom::KnowledgeBase"

    props: PropsDictType = {
        "Description": (str, False),
        "KnowledgeBaseType": (str, True),
        "Name": (str, True),
        "RenderingConfiguration": (RenderingConfiguration, False),
        "ServerSideEncryptionConfiguration": (ServerSideEncryptionConfiguration, False),
        "SourceConfiguration": (SourceConfiguration, False),
        "Tags": (Tags, False),
    }
