# django-vue-rollup

A django-compressor filter to compile .vue files using [rollup](https://rollupjs.org/guide/en/).

## Installation

Install [django-compressor](https://github.com/django-compressor/django-compressor/) 
in your django project.

During installation, django-vue-rollup will call npm to install necessary packages, 
so make sure you have npm installed.

In order to avoid any possible conflicts, the npm packages will installed into a
local node prefix inside of django-vue-rollup's package directory.

Once you have ensured that npm is available, you can install django-vue-rollup:

```
pip install django-vue-rollup
```

Finally, add the provided Vue Compiler to your COMPRESS_PRECOMPILERS setting:

```python
COMPRESS_PRECOMPILERS = (
    ('text/vue', 'django_vue_rollup.VueCompiler'),
)
```

To include and compile .vue files, you can use a \<script> tag with the type text/vue, for example:

```html
{% load compress %}

{% compress js %}
    <script type="text/vue" src="{% static 'myapp/js/my-vue-component.vue' %}"></script>
{% endcompress %}
```

The output format of the compiled vue file will be [IIFE](https://en.wikipedia.org/wiki/Immediately_invoked_function_expression). The export name will be automatically generated by converting your input file name to camel case. For example, the export name in the Example above would be `MyVueComponent`. The default export can be accessed using `MyVueComponent.default`, other named exports by replacing `default` with their respective names.  

## Disclaimer

I am a Python and Django expert, not a Javascript expert and i have developed this python package
based on what exactly i needed for my application, because to my surprise, i couldn't find a
solution for this that didn't ask you to run a second javascript-based server.

If there is a feature you're missing or you feel that something about the way this code handles
things is not how it should be done, please feel very welcome to submit an issue or a pull request!
