## Installation

```shell
pip install icdcrawl
```

## Quick Start

```python
>>> import icdcrawl

>>> icdcrawl.icd10data_com("https://www.icd10data.com/ICD10CM/Codes/I00-I99/I10-I16")      
['I10', 'I11', 'I11.0', 'I11.9', 'I12', 'I12.0', 'I12.9', 'I13', 'I13.0', 'I13.1', 'I13.10', 'I13.11', 'I13.2', 'I15', 'I15.0', 'I15.1', 'I15.2', 'I15.8', 'I15.9', 'I16', 'I16.0', 'I16.1', 'I16.9']

>>> icdcrawl.icd9data_com("http://www.icd9data.com/2015/Volume1/390-459/401-405/default.htm") 
['401', '401.0', '401.1', '401.9', '402', '402.0', '402.00', '402.01', '402.1', '402.10', '402.11', '402.9', '402.90', '402.91', '403', '403.0', '403.00', '403.01', '403.1', '403.10', '403.11', '403.9', '403.90', '403.91', '404', '404.0', '404.00', '404.01', '404.02', '404.03', '404.1', '404.10', '404.11', '404.12', '404.13', '404.9', '404.90', '404.91', '404.92', '404.93', '405', '405.0', '405.01', '405.09', '405.1', '405.11', '405.19', '405.9', '405.91', '405.99']

>>> icdcrawl.icdsearch_idv_tw(['430', '431', '432', '4320', '4321', '4329'], trans_to=10)    
['I60.00', 'I60.01', 'I60.02', 'I60.10', 'I60.11', 'I60.12', 'I60.20', 'I60.21', 'I60.22', 'I60.30', 'I60.31', 'I60.32', 'I60.4', 'I60.50', 'I60.51', 'I60.52', 'I60.6', 'I60.7', 'I60.8', 'I60.9', 'I61.0', 'I61.1', 'I61.2', 'I61.3', 'I61.4', 'I61.5', 'I61.6', 'I61.8', 'I61.9', 'I62.00', 'I62.01', 'I62.02', 'I62.03', 'I62.1', 'I62.9']
```

> ⚠️ **Don't request too frequently**, or websites may prohibit crawlers from accessing.

## Supported Websites

* icd10data.com
* icd9data.com
* icdsearch.idv.tw
* ... (todo)
