import icdcrawl
import pytest


@pytest.mark.parametrize(
    ["url", "icd9_codes"],
    # fmt: off
    [
        ["https://www.icd10data.com/ICD10CM/Codes/I00-I99/I10-I16", ['I10', 'I11', 'I110', 'I119', 'I12', 'I120', 'I129', 'I13', 'I130', 'I131', 'I1310', 'I1311', 'I132', 'I15', 'I150', 'I151', 'I152', 'I158', 'I159', 'I16', 'I160', 'I161', 'I169']],
        ["https://www.icd10data.com/ICD10CM/Codes/E00-E89/E08-E13", ['E08', 'E080', 'E0800', 'E0801', 'E081', 'E0810', 'E0811', 'E082', 'E0821', 'E0822', 'E0829', 'E083', 'E0831', 'E08311', 'E08319', 'E0832', 'E08321', 'E083211', 'E083212', 'E083213', 'E083219', 'E08329', 'E083291', 'E083292', 'E083293', 'E083299', 'E0833', 'E08331', 'E083311', 'E083312', 'E083313', 'E083319', 'E08339', 'E083391', 'E083392', 'E083393', 'E083399', 'E0834', 'E08341', 'E083411', 'E083412', 'E083413', 'E083419', 'E08349', 'E083491', 'E083492', 'E083493', 'E083499', 'E0835', 'E08351', 'E083511', 'E083512', 'E083513', 'E083519', 'E08352', 'E083521', 'E083522', 'E083523', 'E083529', 'E08353', 'E083531', 'E083532', 'E083533', 'E083539', 'E08354', 'E083541', 'E083542', 'E083543', 'E083549', 'E08355', 'E083551', 'E083552', 'E083553', 'E083559', 'E08359', 'E083591', 'E083592', 'E083593', 'E083599', 'E0836', 'E0837', 'E0837X1', 'E0837X2', 'E0837X3', 'E0837X9', 'E0839', 'E084', 'E0840', 'E0841', 'E0842', 'E0843', 'E0844', 'E0849', 'E085', 'E0851', 'E0852', 'E0859', 'E086', 'E0861', 'E08610', 'E08618', 'E0862', 'E08620', 'E08621', 'E08622', 'E08628', 'E0863', 'E08630', 'E08638', 'E0864', 'E08641', 'E08649', 'E0865', 'E0869', 'E088', 'E089', 'E09', 'E090', 'E0900', 'E0901', 'E091', 'E0910', 'E0911', 'E092', 'E0921', 'E0922', 'E0929', 'E093', 'E0931', 'E09311', 'E09319', 'E0932', 'E09321', 'E093211', 'E093212', 'E093213', 'E093219', 'E09329', 'E093291', 'E093292', 'E093293', 'E093299', 'E0933', 'E09331', 'E093311', 'E093312', 'E093313', 'E093319', 'E09339', 'E093391', 'E093392', 'E093393', 'E093399', 'E0934', 'E09341', 'E093411', 'E093412', 'E093413', 'E093419', 'E09349', 'E093491', 'E093492', 'E093493', 'E093499', 'E0935', 'E09351', 'E093511', 'E093512', 'E093513', 'E093519', 'E09352', 'E093521', 'E093522', 'E093523', 'E093529', 'E09353', 'E093531', 'E093532', 'E093533', 'E093539', 'E09354', 'E093541', 'E093542', 'E093543', 'E093549', 'E09355', 'E093551', 'E093552', 'E093553', 'E093559', 'E09359', 'E093591', 'E093592', 'E093593', 'E093599', 'E0936', 'E0937', 'E0937X1', 'E0937X2', 'E0937X3', 'E0937X9', 'E0939', 'E094', 'E0940', 'E0941', 'E0942', 'E0943', 'E0944', 'E0949', 'E095', 'E0951', 'E0952', 'E0959', 'E096', 'E0961', 'E09610', 'E09618', 'E0962', 'E09620', 'E09621', 'E09622', 'E09628', 'E0963', 'E09630', 'E09638', 'E0964', 'E09641', 'E09649', 'E0965', 'E0969', 'E098', 'E099', 'E10', 'E101', 'E1010', 'E1011', 'E102', 'E1021', 'E1022', 'E1029', 'E103', 'E1031', 'E10311', 'E10319', 'E1032', 'E10321', 'E103211', 'E103212', 'E103213', 'E103219', 'E10329', 'E103291', 'E103292', 'E103293', 'E103299', 'E1033', 'E10331', 'E103311', 'E103312', 'E103313', 'E103319', 'E10339', 'E103391', 'E103392', 'E103393', 'E103399', 'E1034', 'E10341', 'E103411', 'E103412', 'E103413', 'E103419', 'E10349', 'E103491', 'E103492', 'E103493', 'E103499', 'E1035', 'E10351', 'E103511', 'E103512', 'E103513', 'E103519', 'E10352', 'E103521', 'E103522', 'E103523', 'E103529', 'E10353', 'E103531', 'E103532', 'E103533', 'E103539', 'E10354', 'E103541', 'E103542', 'E103543', 'E103549', 'E10355', 'E103551', 'E103552', 'E103553', 'E103559', 'E10359', 'E103591', 'E103592', 'E103593', 'E103599', 'E1036', 'E1037', 'E1037X1', 'E1037X2', 'E1037X3', 'E1037X9', 'E1039', 'E104', 'E1040', 'E1041', 'E1042', 'E1043', 'E1044', 'E1049', 'E105', 'E1051', 'E1052', 'E1059', 'E106', 'E1061', 'E10610', 'E10618', 'E1062', 'E10620', 'E10621', 'E10622', 'E10628', 'E1063', 'E10630', 'E10638', 'E1064', 'E10641', 'E10649', 'E1065', 'E1069', 'E108', 'E109', 'E11', 'E110', 'E1100', 'E1101', 'E111', 'E1110', 'E1111', 'E112', 'E1121', 'E1122', 'E1129', 'E113', 'E1131', 'E11311', 'E11319', 'E1132', 'E11321', 'E113211', 'E113212', 'E113213', 'E113219', 'E11329', 'E113291', 'E113292', 'E113293', 'E113299', 'E1133', 'E11331', 'E113311', 'E113312', 'E113313', 'E113319', 'E11339', 'E113391', 'E113392', 'E113393', 'E113399', 'E1134', 'E11341', 'E113411', 'E113412', 'E113413', 'E113419', 'E11349', 'E113491', 'E113492', 'E113493', 'E113499', 'E1135', 'E11351', 'E113511', 'E113512', 'E113513', 'E113519', 'E11352', 'E113521', 'E113522', 'E113523', 'E113529', 'E11353', 'E113531', 'E113532', 'E113533', 'E113539', 'E11354', 'E113541', 'E113542', 'E113543', 'E113549', 'E11355', 'E113551', 'E113552', 'E113553', 'E113559', 'E11359', 'E113591', 'E113592', 'E113593', 'E113599', 'E1136', 'E1137', 'E1137X1', 'E1137X2', 'E1137X3', 'E1137X9', 'E1139', 'E114', 'E1140', 'E1141', 'E1142', 'E1143', 'E1144', 'E1149', 'E115', 'E1151', 'E1152', 'E1159', 'E116', 'E1161', 'E11610', 'E11618', 'E1162', 'E11620', 'E11621', 'E11622', 'E11628', 'E1163', 'E11630', 'E11638', 'E1164', 'E11641', 'E11649', 'E1165', 'E1169', 'E118', 'E119', 'E13', 'E130', 'E1300', 'E1301', 'E131', 'E1310', 'E1311', 'E132', 'E1321', 'E1322', 'E1329', 'E133', 'E1331', 'E13311', 'E13319', 'E1332', 'E13321', 'E133211', 'E133212', 'E133213', 'E133219', 'E13329', 'E133291', 'E133292', 'E133293', 'E133299', 'E1333', 'E13331', 'E133311', 'E133312', 'E133313', 'E133319', 'E13339', 'E133391', 'E133392', 'E133393', 'E133399', 'E1334', 'E13341', 'E133411', 'E133412', 'E133413', 'E133419', 'E13349', 'E133491', 'E133492', 'E133493', 'E133499', 'E1335', 'E13351', 'E133511', 'E133512', 'E133513', 'E133519', 'E13352', 'E133521', 'E133522', 'E133523', 'E133529', 'E13353', 'E133531', 'E133532', 'E133533', 'E133539', 'E13354', 'E133541', 'E133542', 'E133543', 'E133549', 'E13355', 'E133551', 'E133552', 'E133553', 'E133559', 'E13359', 'E133591', 'E133592', 'E133593', 'E133599', 'E1336', 'E1337', 'E1337X1', 'E1337X2', 'E1337X3', 'E1337X9', 'E1339', 'E134', 'E1340', 'E1341', 'E1342', 'E1343', 'E1344', 'E1349', 'E135', 'E1351', 'E1352', 'E1359', 'E136', 'E1361', 'E13610', 'E13618', 'E1362', 'E13620', 'E13621', 'E13622', 'E13628', 'E1363', 'E13630', 'E13638', 'E1364', 'E13641', 'E13649', 'E1365', 'E1369', 'E138', 'E139']],
        ["https://www.icd10data.com/ICD10CM/Codes/E00-E89/E70-E88/E78-", ['E78', 'E780', 'E7800', 'E7801', 'E781', 'E782', 'E783', 'E784', 'E7841', 'E7849', 'E785', 'E786', 'E787', 'E7870', 'E7871', 'E7872', 'E7879', 'E788', 'E7881', 'E7889', 'E789']]
    ],
    # fmt: on
)
def test_icd10data_com(url, icd9_codes):
    assert icdcrawl.icd10data_com(url, dot=False) == icd9_codes


@pytest.mark.parametrize(
    ["url", "icd10_codes"],
    # fmt: off
    [
        ["http://www.icd9data.com/2015/Volume1/240-279/270-279/272/default.htm", ['272', '2720', '2721', '2722', '2723', '2724', '2725', '2726', '2727', '2728', '2729']],
        ["http://www.icd9data.com/2015/Volume1/240-279/249-259/250/default.htm", ['250', '2500', '25000', '25001', '25002', '25003', '2501', '25010', '25011', '25012', '25013', '2502', '25020', '25021', '25022', '25023', '2503', '25030', '25031', '25032', '25033', '2504', '25040', '25041', '25042', '25043', '2505', '25050', '25051', '25052', '25053', '2506', '25060', '25061', '25062', '25063', '2507', '25070', '25071', '25072', '25073', '2508', '25080', '25081', '25082', '25083', '2509', '25090', '25091', '25092', '25093']],
        ["http://www.icd9data.com/2015/Volume1/390-459/401-405/default.htm", ['401', '4010', '4011', '4019', '402', '4020', '40200', '40201', '4021', '40210', '40211', '4029', '40290', '40291', '403', '4030', '40300', '40301', '4031', '40310', '40311', '4039', '40390', '40391', '404', '4040', '40400', '40401', '40402', '40403', '4041', '40410', '40411', '40412', '40413', '4049', '40490', '40491', '40492', '40493', '405', '4050', '40501', '40509', '4051', '40511', '40519', '4059', '40591', '40599']]
    ],
    # fmt: on
)
def test_icd9data_com(url, icd10_codes):
    assert icdcrawl.icd9data_com(url, dot=False) == icd10_codes


@pytest.mark.parametrize(
    ["url", "trans_to", "icd_code"],
    # fmt: off
    [
        [["430", "431", "432", "4320", "4321", "4329"], 10, ['I6000', 'I6001', 'I6002', 'I6010', 'I6011', 'I6012', 'I6020', 'I6021', 'I6022', 'I6030', 'I6031', 'I6032', 'I604', 'I6050', 'I6051', 'I6052', 'I606', 'I607', 'I608', 'I609', 'I610', 'I611', 'I612', 'I613', 'I614', 'I615', 'I616', 'I618', 'I619', 'I6200', 'I6201', 'I6202', 'I6203', 'I621', 'I629']],
        [['433', '4330', '43300', '43301', '4331', '43310', '43311', '4332', '43320', '43321', '4333', '43330', '43331', '4338', '43380', '43381', '4339', '43390', '43391', '434', '4340', '43400', '43401', '4341', '43410', '43411', '4349', '43490', '43491', '435', '4350', '4351', '4352', '4353', '4358', '4359'], 10, ['G450', 'G451', 'G452', 'G458', 'G459', 'G460', 'G461', 'G462', 'I6300', 'I63011', 'I63012', 'I63019', 'I6302', 'I63031', 'I63032', 'I63039', 'I6309', 'I6310', 'I63111', 'I63112', 'I63119', 'I6312', 'I63131', 'I63132', 'I63139', 'I6319', 'I6320', 'I63211', 'I63212', 'I63219', 'I6322', 'I63231', 'I63232', 'I63239', 'I6329', 'I6330', 'I63311', 'I63312', 'I63319', 'I63321', 'I63322', 'I63329', 'I63331', 'I63332', 'I63339', 'I63341', 'I63342', 'I63349', 'I6339', 'I6340', 'I63411', 'I63412', 'I63419', 'I63421', 'I63422', 'I63429', 'I63431', 'I63432', 'I63439', 'I63441', 'I63442', 'I63449', 'I6349', 'I6350', 'I63511', 'I63512', 'I63519', 'I63521', 'I63522', 'I63529', 'I63531', 'I63532', 'I63539', 'I63541', 'I63542', 'I63549', 'I6359', 'I636', 'I638', 'I639', 'I6501', 'I6502', 'I6503', 'I6509', 'I651', 'I6521', 'I6522', 'I6523', 'I6529', 'I658', 'I659', 'I6601', 'I6602', 'I6603', 'I6609', 'I6611', 'I6612', 'I6613', 'I6619', 'I6621', 'I6622', 'I6623', 'I6629', 'I663', 'I668', 'I669', 'I67841', 'I67848']],
    ]
    # fmt: on
)
def test_icdsearch_idv_tw(url, trans_to, icd_code):
    assert icdcrawl.icdsearch_idv_tw(url, trans_to, dot=False) == icd_code
