# -*- coding: utf-8 -*-
#
# Copyright (c) 2015, Alcatel-Lucent Inc, 2017 Nokia
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of the copyright holder nor the names of its contributors
#       may be used to endorse or promote products derived from this software without
#       specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.




from .fetchers import NUMetadatasFetcher


from .fetchers import NUGlobalMetadatasFetcher


from .fetchers import NUUsersFetcher


from .fetchers import NUEventLogsFetcher

from bambou import NURESTObject


class NUGroup(NURESTObject):
    """ Represents a Group in the VSD

        Notes:
            Identifies a group within an enterprise
    """

    __rest_name__ = "group"
    __resource_name__ = "groups"

    
    ## Constants
    
    CONST_ROLE_ADMINOPERATOR = "ADMINOPERATOR"
    
    CONST_ROLE_NETCONFMGR = "NETCONFMGR"
    
    CONST_MANAGEMENT_MODE_CMS = "CMS"
    
    CONST_ROLE_ORGNETWORKDESIGNER = "ORGNETWORKDESIGNER"
    
    CONST_ROLE_CMS = "CMS"
    
    CONST_ROLE_UNKNOWN = "UNKNOWN"
    
    CONST_ROLE_PREACTIVATION = "PREACTIVATION"
    
    CONST_ENTITY_SCOPE_GLOBAL = "GLOBAL"
    
    CONST_ROLE_STATS = "STATS"
    
    CONST_ROLE_CSPOPERATOR = "CSPOPERATOR"
    
    CONST_ROLE_USER = "USER"
    
    CONST_MANAGEMENT_MODE_RESERVED = "RESERVED"
    
    CONST_ENTITY_SCOPE_ENTERPRISE = "ENTERPRISE"
    
    CONST_ROLE_JMS = "JMS"
    
    CONST_ROLE_ORGUSER = "ORGUSER"
    
    CONST_ROLE_CSPROOT = "CSPROOT"
    
    CONST_ROLE_SYSTEM = "SYSTEM"
    
    CONST_ROLE_POSTACTIVATION = "POSTACTIVATION"
    
    CONST_ROLE_SECURITYADMINISTRATOR = "SECURITYADMINISTRATOR"
    
    CONST_ROLE_ORGADMIN = "ORGADMIN"
    
    CONST_MANAGEMENT_MODE_DEFAULT = "DEFAULT"
    
    

    def __init__(self, **kwargs):
        """ Initializes a Group instance

            Notes:
                You can specify all parameters while calling this methods.
                A special argument named `data` will enable you to load the
                object from a Python dictionary

            Examples:
                >>> group = NUGroup(id=u'xxxx-xxx-xxx-xxx', name=u'Group')
                >>> group = NUGroup(data=my_dict)
        """

        super(NUGroup, self).__init__()

        # Read/Write Attributes
        
        self._ldap_group_dn = None
        self._name = None
        self._management_mode = None
        self._last_updated_by = None
        self._last_updated_date = None
        self._account_restrictions = None
        self._description = None
        self._restriction_date = None
        self._embedded_metadata = None
        self._entity_scope = None
        self._role = None
        self._creation_date = None
        self._private = None
        self._owner = None
        self._external_id = None
        
        self.expose_attribute(local_name="ldap_group_dn", remote_name="LDAPGroupDN", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="name", remote_name="name", attribute_type=str, is_required=True, is_unique=False)
        self.expose_attribute(local_name="management_mode", remote_name="managementMode", attribute_type=str, is_required=False, is_unique=False, choices=[u'CMS', u'DEFAULT', u'RESERVED'])
        self.expose_attribute(local_name="last_updated_by", remote_name="lastUpdatedBy", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="last_updated_date", remote_name="lastUpdatedDate", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="account_restrictions", remote_name="accountRestrictions", attribute_type=bool, is_required=False, is_unique=False)
        self.expose_attribute(local_name="description", remote_name="description", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="restriction_date", remote_name="restrictionDate", attribute_type=float, is_required=False, is_unique=False)
        self.expose_attribute(local_name="embedded_metadata", remote_name="embeddedMetadata", attribute_type=list, is_required=False, is_unique=False)
        self.expose_attribute(local_name="entity_scope", remote_name="entityScope", attribute_type=str, is_required=False, is_unique=False, choices=[u'ENTERPRISE', u'GLOBAL'])
        self.expose_attribute(local_name="role", remote_name="role", attribute_type=str, is_required=False, is_unique=False, choices=[u'ADMINOPERATOR', u'CMS', u'CSPOPERATOR', u'CSPROOT', u'JMS', u'NETCONFMGR', u'ORGADMIN', u'ORGNETWORKDESIGNER', u'ORGUSER', u'POSTACTIVATION', u'PREACTIVATION', u'SECURITYADMINISTRATOR', u'STATS', u'SYSTEM', u'UNKNOWN', u'USER'])
        self.expose_attribute(local_name="creation_date", remote_name="creationDate", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="private", remote_name="private", attribute_type=bool, is_required=False, is_unique=False)
        self.expose_attribute(local_name="owner", remote_name="owner", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="external_id", remote_name="externalID", attribute_type=str, is_required=False, is_unique=True)
        

        # Fetchers
        
        
        self.metadatas = NUMetadatasFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.global_metadatas = NUGlobalMetadatasFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.users = NUUsersFetcher.fetcher_with_object(parent_object=self, relationship="member")
        
        
        self.event_logs = NUEventLogsFetcher.fetcher_with_object(parent_object=self, relationship="child")
        

        self._compute_args(**kwargs)

    # Properties
    
    @property
    def ldap_group_dn(self):
        """ Get ldap_group_dn value.

            Notes:
                The LDAP distinguished name (DN) for the group.

                
                This attribute is named `LDAPGroupDN` in VSD API.
                
        """
        return self._ldap_group_dn

    @ldap_group_dn.setter
    def ldap_group_dn(self, value):
        """ Set ldap_group_dn value.

            Notes:
                The LDAP distinguished name (DN) for the group.

                
                This attribute is named `LDAPGroupDN` in VSD API.
                
        """
        self._ldap_group_dn = value

    
    @property
    def name(self):
        """ Get name value.

            Notes:
                A unique name of the group

                
        """
        return self._name

    @name.setter
    def name(self, value):
        """ Set name value.

            Notes:
                A unique name of the group

                
        """
        self._name = value

    
    @property
    def management_mode(self):
        """ Get management_mode value.

            Notes:
                Management mode of the user object - allows for override of external authorization and syncup

                
                This attribute is named `managementMode` in VSD API.
                
        """
        return self._management_mode

    @management_mode.setter
    def management_mode(self, value):
        """ Set management_mode value.

            Notes:
                Management mode of the user object - allows for override of external authorization and syncup

                
                This attribute is named `managementMode` in VSD API.
                
        """
        self._management_mode = value

    
    @property
    def last_updated_by(self):
        """ Get last_updated_by value.

            Notes:
                ID of the user who last updated the object.

                
                This attribute is named `lastUpdatedBy` in VSD API.
                
        """
        return self._last_updated_by

    @last_updated_by.setter
    def last_updated_by(self, value):
        """ Set last_updated_by value.

            Notes:
                ID of the user who last updated the object.

                
                This attribute is named `lastUpdatedBy` in VSD API.
                
        """
        self._last_updated_by = value

    
    @property
    def last_updated_date(self):
        """ Get last_updated_date value.

            Notes:
                Time stamp when this object was last updated.

                
                This attribute is named `lastUpdatedDate` in VSD API.
                
        """
        return self._last_updated_date

    @last_updated_date.setter
    def last_updated_date(self, value):
        """ Set last_updated_date value.

            Notes:
                Time stamp when this object was last updated.

                
                This attribute is named `lastUpdatedDate` in VSD API.
                
        """
        self._last_updated_date = value

    
    @property
    def account_restrictions(self):
        """ Get account_restrictions value.

            Notes:
                Determines whether group is disabled or not.

                
                This attribute is named `accountRestrictions` in VSD API.
                
        """
        return self._account_restrictions

    @account_restrictions.setter
    def account_restrictions(self, value):
        """ Set account_restrictions value.

            Notes:
                Determines whether group is disabled or not.

                
                This attribute is named `accountRestrictions` in VSD API.
                
        """
        self._account_restrictions = value

    
    @property
    def description(self):
        """ Get description value.

            Notes:
                Description of the group

                
        """
        return self._description

    @description.setter
    def description(self, value):
        """ Set description value.

            Notes:
                Description of the group

                
        """
        self._description = value

    
    @property
    def restriction_date(self):
        """ Get restriction_date value.

            Notes:
                When the group was disabled.

                
                This attribute is named `restrictionDate` in VSD API.
                
        """
        return self._restriction_date

    @restriction_date.setter
    def restriction_date(self, value):
        """ Set restriction_date value.

            Notes:
                When the group was disabled.

                
                This attribute is named `restrictionDate` in VSD API.
                
        """
        self._restriction_date = value

    
    @property
    def embedded_metadata(self):
        """ Get embedded_metadata value.

            Notes:
                Metadata objects associated with this entity. This will contain a list of Metadata objects if the API request is made using the special flag to enable the embedded Metadata feature. Only a maximum of Metadata objects is returned based on the value set in the system configuration.

                
                This attribute is named `embeddedMetadata` in VSD API.
                
        """
        return self._embedded_metadata

    @embedded_metadata.setter
    def embedded_metadata(self, value):
        """ Set embedded_metadata value.

            Notes:
                Metadata objects associated with this entity. This will contain a list of Metadata objects if the API request is made using the special flag to enable the embedded Metadata feature. Only a maximum of Metadata objects is returned based on the value set in the system configuration.

                
                This attribute is named `embeddedMetadata` in VSD API.
                
        """
        self._embedded_metadata = value

    
    @property
    def entity_scope(self):
        """ Get entity_scope value.

            Notes:
                Specify if scope of entity is Data center or Enterprise level

                
                This attribute is named `entityScope` in VSD API.
                
        """
        return self._entity_scope

    @entity_scope.setter
    def entity_scope(self, value):
        """ Set entity_scope value.

            Notes:
                Specify if scope of entity is Data center or Enterprise level

                
                This attribute is named `entityScope` in VSD API.
                
        """
        self._entity_scope = value

    
    @property
    def role(self):
        """ Get role value.

            Notes:
                The role associated with this group.

                
        """
        return self._role

    @role.setter
    def role(self, value):
        """ Set role value.

            Notes:
                The role associated with this group.

                
        """
        self._role = value

    
    @property
    def creation_date(self):
        """ Get creation_date value.

            Notes:
                Time stamp when this object was created.

                
                This attribute is named `creationDate` in VSD API.
                
        """
        return self._creation_date

    @creation_date.setter
    def creation_date(self, value):
        """ Set creation_date value.

            Notes:
                Time stamp when this object was created.

                
                This attribute is named `creationDate` in VSD API.
                
        """
        self._creation_date = value

    
    @property
    def private(self):
        """ Get private value.

            Notes:
                A private group is visible only by the owner of the group. Public groups are visible by all users in the enterprise

                
        """
        return self._private

    @private.setter
    def private(self, value):
        """ Set private value.

            Notes:
                A private group is visible only by the owner of the group. Public groups are visible by all users in the enterprise

                
        """
        self._private = value

    
    @property
    def owner(self):
        """ Get owner value.

            Notes:
                Identifies the user that has created this object.

                
        """
        return self._owner

    @owner.setter
    def owner(self, value):
        """ Set owner value.

            Notes:
                Identifies the user that has created this object.

                
        """
        self._owner = value

    
    @property
    def external_id(self):
        """ Get external_id value.

            Notes:
                External object ID. Used for integration with third party systems

                
                This attribute is named `externalID` in VSD API.
                
        """
        return self._external_id

    @external_id.setter
    def external_id(self, value):
        """ Set external_id value.

            Notes:
                External object ID. Used for integration with third party systems

                
                This attribute is named `externalID` in VSD API.
                
        """
        self._external_id = value

    

    