from .data import ParseCompound

COMPARTMENT_MAP = {
    "CYTOSOL": "CYTOSOL",
    "IN": "CYTOSOL",
    "UNKNOWN-SPACE": "CYTOSOL",
    "SIDE-1": "CYTOSOL",
    "SIDE-2": "EXTRACELLULAR",
    "EXTRACELLULAR": "EXTRACELLULAR",
    "CHL-THY-MEM": "PERIPLASM",
    "CHLOR-STR": "CYTOSOL",
    "CHROM-STR": "CYTOSOL",
    "GOLGI-LUM": "CYTOSOL",
    "LYS-LUM": "CYTOSOL",
    "MIT-IM-SPC": "CYTOSOL",
    "MIT-IMEM": "PERIPLASM",
    "MIT-LUM": "CYTOSOL",
    "OUTER-MEM": "PERIPLASM",
    "PERI-BAC": "PERIPLASM",
    "PERI-BAC-GN": "PERIPLASM",
    "PERIPLASM": "PERIPLASM",
    "PEROX-LUM": "CYTOSOL",
    "PLASMA-MEM": "PERIPLASM",
    "PLAST-IMEM": "PERIPLASM",
    "PLASTID-STR": "PERIPLASM",
    "PM-ANIMAL": "PERIPLASM",
    "PM-BAC-ACT": "PERIPLASM",
    "PM-BAC-NEG": "PERIPLASM",
    "PM-BAC-POS": "PERIPLASM",
    "RGH-ER-LUM": "CYTOSOL",
    "PM-FUNGI": "PERIPLASM",
    "RGH-ER-MEM": "PERIPLASM",
    "THY-LUM-CYA": "CYTOSOL",
    "VAC-LUM": "CYTOSOL",
    "VAC-MEM": "PERIPLASM",
    "VESICLE": "PERIPLASM",
    "OUT": "PERIPLASM",
    "THY-MEM-CYA": "PERIPLASM",
    "VESICLE-MEM": "PERIPLASM",
}

TYPE_MAP = {
    "ETR-Quinones": "Ubiquinones",
    "ETR-Quinols": "Ubiquinols",
}

COMPARTMENT_SUFFIXES = {
    # Common to all
    "CYTOSOL": "c",
    "EXTRACELLULAR": "e",
    "PERIPLASM": "p",
    "MITOCHONDRIA": "m",
    "PEROXISOME": "x",
    "ER": "r",
    "VACUOLE": "v",
    "NUCLEUS": "n",
    "GOLGI": "g",
    "THYLAKOID": "u",
    "LYSOSOME": "l",
    "CHLOROPLAST": "h",
    "FLAGELLUM": "f",
    "EYESPOT": "s",
    "INTERMEMBRANE": "im",
    "CARBOXYSOME": "cx",
    "THYLAKOID-MEMBRANE": "um",
    "CYTOSOLIC-MEMBRANE": "cm",
    "INNER-MITOCHONDRIA": "i",
    "MITOCHONDRIA-INNER-MEMBRANE": "mm",
    "WILDTYPE": "w",
    "CYTOCHROME-COMPLEX": "y",
}

MANUAL_ADDITIONS = {
    "Acceptor_c": ParseCompound(
        base_id="Acceptor",
        id="Acceptor_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 1},
    ),
    "Donor-H2_c": ParseCompound(
        base_id="Donor-H2",
        id="Donor-H2_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 1, "H": 2},
    ),
    "Oxidized-ferredoxins_c": ParseCompound(
        base_id="Oxidized-ferredoxins",
        id="Oxidized-ferredoxins_c",
        compartment="CYTOSOL",
        charge=1,
        formula={"Unknown": 1},
    ),
    "Reduced-ferredoxins_c": ParseCompound(
        base_id="Reduced-ferredoxins",
        id="Reduced-ferredoxins_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 1},
    ),
    "Red-NADPH-Hemoprotein-Reductases_c": ParseCompound(
        base_id="Red-NADPH-Hemoprotein-Reductases",
        id="Red-NADPH-Hemoprotein-Reductases_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 1, "H": 2},
    ),
    "Ox-NADPH-Hemoprotein-Reductases_c": ParseCompound(
        base_id="Ox-NADPH-Hemoprotein-Reductases",
        id="Ox-NADPH-Hemoprotein-Reductases_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 1},
    ),
    "Cytochromes-C-Oxidized_c": ParseCompound(
        base_id="Cytochromes-C-Oxidized",
        id="Cytochromes-C-Oxidized_c",
        compartment="CYTOSOL",
        charge=1,
        formula={"Unknown": 1},
    ),
    "Cytochromes-C-Reduced_c": ParseCompound(
        base_id="Cytochromes-C-Reduced",
        id="Cytochromes-C-Reduced_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 1},
    ),
    "Oxidized-Plastocyanins_c": ParseCompound(
        base_id="Oxidized-Plastocyanins",
        id="Oxidized-Plastocyanins_c",
        compartment="CYTOSOL",
        charge=1,
        formula={"Unknown": 1},
    ),
    "Plastocyanin-Reduced_c": ParseCompound(
        base_id="Plastocyanin-Reduced",
        id="Plastocyanin-Reduced_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 1},
    ),
    "ETF-Oxidized_c": ParseCompound(
        base_id="ETF-Oxidized",
        id="ETF-Oxidized_c",
        compartment="CYTOSOL",
        charge=1,
        formula={"Unknown": 1},
    ),
    "ETF-Reduced_c": ParseCompound(
        base_id="ETF-Reduced",
        id="ETF-Reduced_c",
        compartment="CYTOSOL",
        charge=2,
        formula={"Unknown": 1, "H": 3},
    ),
    "Ox-Glutaredoxins_c": ParseCompound(
        base_id="Ox-Glutaredoxins",
        id="Ox-Glutaredoxins_c",
        compartment="CYTOSOL",
        charge=1,
        formula={"Unknown": 1},
    ),
    "Red-Glutaredoxins_c": ParseCompound(
        base_id="Red-Glutaredoxins",
        id="Red-Glutaredoxins_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 1},
    ),
    "Ox-Thioredoxin_c": ParseCompound(
        base_id="Ox-Thioredoxin",
        id="Ox-Thioredoxin_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 1},
    ),
    "Red-Thioredoxin_c": ParseCompound(
        base_id="Red-Thioredoxin",
        id="Red-Thioredoxin_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 1, "H": 2},
    ),
    "Ox-FMN-Flavoproteins_c": ParseCompound(
        base_id="Ox-FMN-Flavoproteins",
        id="Ox-FMN-Flavoproteins_c",
        compartment="CYTOSOL",
        charge=1,
        formula={"Unknown": 1},
    ),
    "Red-FMNH2-Flavoproteins_c": ParseCompound(
        base_id="Red-FMNH2-Flavoproteins",
        id="Red-FMNH2-Flavoproteins_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 1, "H": 2},
    ),
    "Ox-FAD-Flavoproteins_c": ParseCompound(
        base_id="Ox-FAD-Flavoproteins",
        id="Ox-FAD-Flavoproteins_c",
        compartment="CYTOSOL",
        charge=1,
        formula={"Unknown": 1},
    ),
    "Red-FADH2-Flavoproteins_c": ParseCompound(
        base_id="Red-FADH2-Flavoproteins",
        id="Red-FADH2-Flavoproteins_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 1, "H": 2},
    ),
    "Light_c": ParseCompound(
        base_id="Light",
        id="Light_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 0},
    ),
    "Oxidized-flavodoxins_c": ParseCompound(
        base_id="Oxidized-flavodoxins",
        id="Oxidized-flavodoxins_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 1},
    ),
    "Reduced-flavodoxins_c": ParseCompound(
        base_id="Reduced-flavodoxins",
        id="Reduced-flavodoxins_c",
        compartment="CYTOSOL",
        charge=0,
        formula={"Unknown": 1, "H": 2},
    ),
}
