from dict_tools import differ
from typing import Any, Dict

__func_alias__ = {
    "list_": "list",
}


async def absent(hub, ctx, name: str) -> Dict[str, Any]:
    ret = {
        "name": name,
        "result": True,
        "changes": None,
        "comment": "",
    }

    changes_old = hub.exec.vultr.util.get(
        name, await hub.exec.vultr.dns.domain.list(ctx), ["domain"]
    )
    if not changes_old:
        ret["comment"] = f"Vultr dns.domain {name} is already absent"
        return ret

    if ctx["test"]:
        ret["comment"] = f"Vultr dns.domain {name} would be deleted"
        return ret

    result = await hub.exec.vultr.dns.domain.delete(ctx, domain=name)
    ret["result"] = result[0]
    ret["comment"] = result[1].get(
        "VULTR_API_REQUEST_STATUS", f"Deleted vultr dns.domain: {name}"
    )

    changes_new = hub.exec.vultr.util.get(
        name, await hub.exec.vultr.dns.domain.list(ctx), ["domain"]
    )

    ret["changes"] = differ.deep_diff(changes_old, changes_new)

    return ret


async def present(hub, ctx, name: str, ip: str) -> Dict[str, Any]:
    ret = {
        "name": name,
        "result": True,
        "changes": None,
        "comment": "",
    }

    changes_old = hub.exec.vultr.util.get(
        name, await hub.exec.vultr.dns.domain.list(ctx), ["domain"]
    )
    if changes_old:
        ret["comment"] = f"Vultr instance {name} is already present"
        return ret

    if ctx["test"]:
        return ret

    result = await hub.exec.vultr.dns.domain.create(ctx, domain=name, ip=ip)
    ret["result"] = result[0]
    ret["comment"] = result[1].get(
        "VULTR_API_REQUEST_STATUS", f"Created vultr dns.domain: {name}"
    )

    changes_new = hub.exec.vultr.util.get(
        name, await hub.exec.vultr.dns.domain.list(ctx), ["domain"]
    )

    ret["changes"] = differ.deep_diff(changes_old, changes_new)

    return ret
