# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags
from .validators import boolean, double
from .validators.backup import (
    backup_vault_name,
    validate_backup_selection,
    validate_json_checker,
)


class AdvancedBackupSettingResourceType(AWSProperty):
    """
    `AdvancedBackupSettingResourceType <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-advancedbackupsettingresourcetype.html>`__
    """

    props: PropsDictType = {
        "BackupOptions": (dict, True),
        "ResourceType": (str, True),
    }


class LifecycleResourceType(AWSProperty):
    """
    `LifecycleResourceType <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-lifecycleresourcetype.html>`__
    """

    props: PropsDictType = {
        "DeleteAfterDays": (double, False),
        "MoveToColdStorageAfterDays": (double, False),
    }


class CopyActionResourceType(AWSProperty):
    """
    `CopyActionResourceType <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-copyactionresourcetype.html>`__
    """

    props: PropsDictType = {
        "DestinationBackupVaultArn": (str, True),
        "Lifecycle": (LifecycleResourceType, False),
    }


class BackupRuleResourceType(AWSProperty):
    """
    `BackupRuleResourceType <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html>`__
    """

    props: PropsDictType = {
        "CompletionWindowMinutes": (double, False),
        "CopyActions": ([CopyActionResourceType], False),
        "EnableContinuousBackup": (boolean, False),
        "Lifecycle": (LifecycleResourceType, False),
        "RecoveryPointTags": (dict, False),
        "RuleName": (str, True),
        "ScheduleExpression": (str, False),
        "StartWindowMinutes": (double, False),
        "TargetBackupVault": (str, True),
    }


class BackupPlanResourceType(AWSProperty):
    """
    `BackupPlanResourceType <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupplanresourcetype.html>`__
    """

    props: PropsDictType = {
        "AdvancedBackupSettings": ([AdvancedBackupSettingResourceType], False),
        "BackupPlanName": (str, True),
        "BackupPlanRule": ([BackupRuleResourceType], True),
    }


class BackupPlan(AWSObject):
    """
    `BackupPlan <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html>`__
    """

    resource_type = "AWS::Backup::BackupPlan"

    props: PropsDictType = {
        "BackupPlan": (BackupPlanResourceType, True),
        "BackupPlanTags": (dict, False),
    }


class ConditionResourceType(AWSProperty):
    """
    `ConditionResourceType <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-conditionresourcetype.html>`__
    """

    props: PropsDictType = {
        "ConditionKey": (str, True),
        "ConditionType": (str, True),
        "ConditionValue": (str, True),
    }


class BackupSelectionResourceType(AWSProperty):
    """
    `BackupSelectionResourceType <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html>`__
    """

    props: PropsDictType = {
        "Conditions": (dict, False),
        "IamRoleArn": (str, True),
        "ListOfTags": ([ConditionResourceType], False),
        "NotResources": ([str], False),
        "Resources": ([str], False),
        "SelectionName": (str, True),
    }

    def validate(self):
        validate_backup_selection(self)


class BackupSelection(AWSObject):
    """
    `BackupSelection <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html>`__
    """

    resource_type = "AWS::Backup::BackupSelection"

    props: PropsDictType = {
        "BackupPlanId": (str, True),
        "BackupSelection": (BackupSelectionResourceType, True),
    }


class LockConfigurationType(AWSProperty):
    """
    `LockConfigurationType <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-lockconfigurationtype.html>`__
    """

    props: PropsDictType = {
        "ChangeableForDays": (double, False),
        "MaxRetentionDays": (double, False),
        "MinRetentionDays": (double, True),
    }


class NotificationObjectType(AWSProperty):
    """
    `NotificationObjectType <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html>`__
    """

    props: PropsDictType = {
        "BackupVaultEvents": ([str], True),
        "SNSTopicArn": (str, True),
    }


class BackupVault(AWSObject):
    """
    `BackupVault <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html>`__
    """

    resource_type = "AWS::Backup::BackupVault"

    props: PropsDictType = {
        "AccessPolicy": (validate_json_checker, False),
        "BackupVaultName": (backup_vault_name, True),
        "BackupVaultTags": (dict, False),
        "EncryptionKeyArn": (str, False),
        "LockConfiguration": (LockConfigurationType, False),
        "Notifications": (NotificationObjectType, False),
    }


class ControlInputParameter(AWSProperty):
    """
    `ControlInputParameter <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-framework-controlinputparameter.html>`__
    """

    props: PropsDictType = {
        "ParameterName": (str, True),
        "ParameterValue": (str, True),
    }


class FrameworkControl(AWSProperty):
    """
    `FrameworkControl <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-framework-frameworkcontrol.html>`__
    """

    props: PropsDictType = {
        "ControlInputParameters": ([ControlInputParameter], False),
        "ControlName": (str, True),
        "ControlScope": (dict, False),
    }


class Framework(AWSObject):
    """
    `Framework <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-framework.html>`__
    """

    resource_type = "AWS::Backup::Framework"

    props: PropsDictType = {
        "FrameworkControls": ([FrameworkControl], True),
        "FrameworkDescription": (str, False),
        "FrameworkName": (str, False),
        "FrameworkTags": (Tags, False),
    }


class ReportPlan(AWSObject):
    """
    `ReportPlan <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html>`__
    """

    resource_type = "AWS::Backup::ReportPlan"

    props: PropsDictType = {
        "ReportDeliveryChannel": (dict, True),
        "ReportPlanDescription": (str, False),
        "ReportPlanName": (str, False),
        "ReportPlanTags": (Tags, False),
        "ReportSetting": (dict, True),
    }
