# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, PropsDictType
from .validators import boolean
from .validators.chatbot import validate_logginglevel


class SlackChannelConfiguration(AWSObject):
    """
    `SlackChannelConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-chatbot-slackchannelconfiguration.html>`__
    """

    resource_type = "AWS::Chatbot::SlackChannelConfiguration"

    props: PropsDictType = {
        "ConfigurationName": (str, True),
        "GuardrailPolicies": ([str], False),
        "IamRoleArn": (str, True),
        "LoggingLevel": (validate_logginglevel, False),
        "SlackChannelId": (str, True),
        "SlackWorkspaceId": (str, True),
        "SnsTopicArns": ([str], False),
        "UserRoleRequired": (boolean, False),
    }
