# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags
from .validators import boolean


class DataResource(AWSProperty):
    """
    `DataResource <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-dataresource.html>`__
    """

    props: PropsDictType = {
        "Type": (str, True),
        "Values": ([str], False),
    }


class EventSelector(AWSProperty):
    """
    `EventSelector <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html>`__
    """

    props: PropsDictType = {
        "DataResources": ([DataResource], False),
        "ExcludeManagementEventSources": ([str], False),
        "IncludeManagementEvents": (boolean, False),
        "ReadWriteType": (str, False),
    }


class InsightSelector(AWSProperty):
    """
    `InsightSelector <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-insightselector.html>`__
    """

    props: PropsDictType = {
        "InsightType": (str, False),
    }


class Trail(AWSObject):
    """
    `Trail <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html>`__
    """

    resource_type = "AWS::CloudTrail::Trail"

    props: PropsDictType = {
        "CloudWatchLogsLogGroupArn": (str, False),
        "CloudWatchLogsRoleArn": (str, False),
        "EnableLogFileValidation": (boolean, False),
        "EventSelectors": ([EventSelector], False),
        "IncludeGlobalServiceEvents": (boolean, False),
        "InsightSelectors": ([InsightSelector], False),
        "IsLogging": (boolean, True),
        "IsMultiRegionTrail": (boolean, False),
        "IsOrganizationTrail": (boolean, False),
        "KMSKeyId": (str, False),
        "S3BucketName": (str, True),
        "S3KeyPrefix": (str, False),
        "SnsTopicName": (str, False),
        "Tags": (Tags, False),
        "TrailName": (str, False),
    }
