# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags
from .validators import boolean, integer


class ArtifactDetails(AWSProperty):
    """
    `ArtifactDetails <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-artifactdetails.html>`__
    """

    props: PropsDictType = {
        "MaximumCount": (integer, True),
        "MinimumCount": (integer, True),
    }


class ConfigurationProperties(AWSProperty):
    """
    `ConfigurationProperties <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html>`__
    """

    props: PropsDictType = {
        "Description": (str, False),
        "Key": (boolean, True),
        "Name": (str, True),
        "Queryable": (boolean, False),
        "Required": (boolean, True),
        "Secret": (boolean, True),
        "Type": (str, False),
    }


class Settings(AWSProperty):
    """
    `Settings <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html>`__
    """

    props: PropsDictType = {
        "EntityUrlTemplate": (str, False),
        "ExecutionUrlTemplate": (str, False),
        "RevisionUrlTemplate": (str, False),
        "ThirdPartyConfigurationUrl": (str, False),
    }


class CustomActionType(AWSObject):
    """
    `CustomActionType <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html>`__
    """

    resource_type = "AWS::CodePipeline::CustomActionType"

    props: PropsDictType = {
        "Category": (str, True),
        "ConfigurationProperties": ([ConfigurationProperties], False),
        "InputArtifactDetails": (ArtifactDetails, True),
        "OutputArtifactDetails": (ArtifactDetails, True),
        "Provider": (str, True),
        "Settings": (Settings, False),
        "Tags": (Tags, False),
        "Version": (str, True),
    }


class EncryptionKey(AWSProperty):
    """
    `EncryptionKey <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore-encryptionkey.html>`__
    """

    props: PropsDictType = {
        "Id": (str, True),
        "Type": (str, True),
    }


class ArtifactStore(AWSProperty):
    """
    `ArtifactStore <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html>`__
    """

    props: PropsDictType = {
        "EncryptionKey": (EncryptionKey, False),
        "Location": (str, True),
        "Type": (str, True),
    }


class ArtifactStoreMap(AWSProperty):
    """
    `ArtifactStoreMap <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstoremap.html>`__
    """

    props: PropsDictType = {
        "ArtifactStore": (ArtifactStore, True),
        "Region": (str, True),
    }


class DisableInboundStageTransitions(AWSProperty):
    """
    `DisableInboundStageTransitions <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-disableinboundstagetransitions.html>`__
    """

    props: PropsDictType = {
        "Reason": (str, True),
        "StageName": (str, True),
    }


class ActionTypeId(AWSProperty):
    """
    `ActionTypeId <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions-actiontypeid.html>`__
    """

    props: PropsDictType = {
        "Category": (str, True),
        "Owner": (str, True),
        "Provider": (str, True),
        "Version": (str, True),
    }


class InputArtifacts(AWSProperty):
    """
    `InputArtifacts <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions-inputartifacts.html>`__
    """

    props: PropsDictType = {
        "Name": (str, True),
    }


class OutputArtifacts(AWSProperty):
    """
    `OutputArtifacts <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions-outputartifacts.html>`__
    """

    props: PropsDictType = {
        "Name": (str, True),
    }


class Actions(AWSProperty):
    """
    `Actions <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-actions.html>`__
    """

    props: PropsDictType = {
        "ActionTypeId": (ActionTypeId, True),
        "Configuration": (dict, False),
        "InputArtifacts": ([InputArtifacts], False),
        "Name": (str, True),
        "Namespace": (str, False),
        "OutputArtifacts": ([OutputArtifacts], False),
        "Region": (str, False),
        "RoleArn": (str, False),
        "RunOrder": (integer, False),
    }


class Blockers(AWSProperty):
    """
    `Blockers <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages-blockers.html>`__
    """

    props: PropsDictType = {
        "Name": (str, True),
        "Type": (str, True),
    }


class Stages(AWSProperty):
    """
    `Stages <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stages.html>`__
    """

    props: PropsDictType = {
        "Actions": ([Actions], True),
        "Blockers": ([Blockers], False),
        "Name": (str, True),
    }


class Pipeline(AWSObject):
    """
    `Pipeline <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html>`__
    """

    resource_type = "AWS::CodePipeline::Pipeline"

    props: PropsDictType = {
        "ArtifactStore": (ArtifactStore, False),
        "ArtifactStores": ([ArtifactStoreMap], False),
        "DisableInboundStageTransitions": ([DisableInboundStageTransitions], False),
        "Name": (str, False),
        "RestartExecutionOnUpdate": (boolean, False),
        "RoleArn": (str, True),
        "Stages": ([Stages], True),
        "Tags": (Tags, False),
    }


class WebhookAuthConfiguration(AWSProperty):
    """
    `WebhookAuthConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-webhook-webhookauthconfiguration.html>`__
    """

    props: PropsDictType = {
        "AllowedIPRange": (str, False),
        "SecretToken": (str, False),
    }


class WebhookFilterRule(AWSProperty):
    """
    `WebhookFilterRule <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-webhook-webhookfilterrule.html>`__
    """

    props: PropsDictType = {
        "JsonPath": (str, True),
        "MatchEquals": (str, False),
    }


class Webhook(AWSObject):
    """
    `Webhook <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-webhook.html>`__
    """

    resource_type = "AWS::CodePipeline::Webhook"

    props: PropsDictType = {
        "Authentication": (str, True),
        "AuthenticationConfiguration": (WebhookAuthConfiguration, True),
        "Filters": ([WebhookFilterRule], True),
        "Name": (str, False),
        "RegisterWithThirdParty": (boolean, False),
        "TargetAction": (str, True),
        "TargetPipeline": (str, True),
        "TargetPipelineVersion": (integer, True),
    }
