# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags
from .validators import boolean, integer
from .validators.fsx import (
    storage_type,
    validate_lustreconfiguration_deploymenttype,
    validate_lustreconfiguration_perunitstoragethroughput,
)


class LustreConfiguration(AWSProperty):
    """
    `LustreConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html>`__
    """

    props: PropsDictType = {
        "AutoImportPolicy": (str, False),
        "AutomaticBackupRetentionDays": (integer, False),
        "CopyTagsToBackups": (boolean, False),
        "DailyAutomaticBackupStartTime": (str, False),
        "DataCompressionType": (str, False),
        "DeploymentType": (validate_lustreconfiguration_deploymenttype, False),
        "DriveCacheType": (str, False),
        "ExportPath": (str, False),
        "ImportPath": (str, False),
        "ImportedFileChunkSize": (integer, False),
        "PerUnitStorageThroughput": (
            validate_lustreconfiguration_perunitstoragethroughput,
            False,
        ),
        "WeeklyMaintenanceStartTime": (str, False),
    }


class DiskIopsConfiguration(AWSProperty):
    """
    `DiskIopsConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-diskiopsconfiguration.html>`__
    """

    props: PropsDictType = {
        "Iops": (integer, False),
        "Mode": (str, False),
    }


class OntapConfiguration(AWSProperty):
    """
    `OntapConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-ontapconfiguration.html>`__
    """

    props: PropsDictType = {
        "AutomaticBackupRetentionDays": (integer, False),
        "DailyAutomaticBackupStartTime": (str, False),
        "DeploymentType": (str, True),
        "DiskIopsConfiguration": (DiskIopsConfiguration, False),
        "EndpointIpAddressRange": (str, False),
        "FsxAdminPassword": (str, False),
        "PreferredSubnetId": (str, False),
        "RouteTableIds": ([str], False),
        "ThroughputCapacity": (integer, False),
        "WeeklyMaintenanceStartTime": (str, False),
    }


class ClientConfigurations(AWSProperty):
    """
    `ClientConfigurations <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-nfsexports-clientconfigurations.html>`__
    """

    props: PropsDictType = {
        "Clients": (str, False),
        "Options": ([str], False),
    }


class NfsExports(AWSProperty):
    """
    `NfsExports <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-nfsexports.html>`__
    """

    props: PropsDictType = {
        "ClientConfigurations": ([ClientConfigurations], False),
    }


class UserAndGroupQuotas(AWSProperty):
    """
    `UserAndGroupQuotas <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration-userandgroupquotas.html>`__
    """

    props: PropsDictType = {
        "Id": (integer, False),
        "StorageCapacityQuotaGiB": (integer, False),
        "Type": (str, False),
    }


class RootVolumeConfiguration(AWSProperty):
    """
    `RootVolumeConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration-rootvolumeconfiguration.html>`__
    """

    props: PropsDictType = {
        "CopyTagsToSnapshots": (boolean, False),
        "DataCompressionType": (str, False),
        "NfsExports": ([NfsExports], False),
        "ReadOnly": (boolean, False),
        "RecordSizeKiB": (integer, False),
        "UserAndGroupQuotas": ([UserAndGroupQuotas], False),
    }


class OpenZFSConfiguration(AWSProperty):
    """
    `OpenZFSConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-openzfsconfiguration.html>`__
    """

    props: PropsDictType = {
        "AutomaticBackupRetentionDays": (integer, False),
        "CopyTagsToBackups": (boolean, False),
        "CopyTagsToVolumes": (boolean, False),
        "DailyAutomaticBackupStartTime": (str, False),
        "DeploymentType": (str, True),
        "DiskIopsConfiguration": (DiskIopsConfiguration, False),
        "Options": ([str], False),
        "RootVolumeConfiguration": (RootVolumeConfiguration, False),
        "ThroughputCapacity": (integer, False),
        "WeeklyMaintenanceStartTime": (str, False),
    }


class AuditLogConfiguration(AWSProperty):
    """
    `AuditLogConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-auditlogconfiguration.html>`__
    """

    props: PropsDictType = {
        "AuditLogDestination": (str, False),
        "FileAccessAuditLogLevel": (str, True),
        "FileShareAccessAuditLogLevel": (str, True),
    }


class SelfManagedActiveDirectoryConfiguration(AWSProperty):
    """
    `SelfManagedActiveDirectoryConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html>`__
    """

    props: PropsDictType = {
        "DnsIps": ([str], False),
        "DomainName": (str, False),
        "FileSystemAdministratorsGroup": (str, False),
        "OrganizationalUnitDistinguishedName": (str, False),
        "Password": (str, False),
        "UserName": (str, False),
    }


class WindowsConfiguration(AWSProperty):
    """
    `WindowsConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html>`__
    """

    props: PropsDictType = {
        "ActiveDirectoryId": (str, False),
        "Aliases": ([str], False),
        "AuditLogConfiguration": (AuditLogConfiguration, False),
        "AutomaticBackupRetentionDays": (integer, False),
        "CopyTagsToBackups": (boolean, False),
        "DailyAutomaticBackupStartTime": (str, False),
        "DeploymentType": (str, False),
        "PreferredSubnetId": (str, False),
        "SelfManagedActiveDirectoryConfiguration": (
            SelfManagedActiveDirectoryConfiguration,
            False,
        ),
        "ThroughputCapacity": (integer, True),
        "WeeklyMaintenanceStartTime": (str, False),
    }


class FileSystem(AWSObject):
    """
    `FileSystem <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html>`__
    """

    resource_type = "AWS::FSx::FileSystem"

    props: PropsDictType = {
        "BackupId": (str, False),
        "FileSystemType": (str, True),
        "FileSystemTypeVersion": (str, False),
        "KmsKeyId": (str, False),
        "LustreConfiguration": (LustreConfiguration, False),
        "OntapConfiguration": (OntapConfiguration, False),
        "OpenZFSConfiguration": (OpenZFSConfiguration, False),
        "SecurityGroupIds": ([str], False),
        "StorageCapacity": (integer, False),
        "StorageType": (storage_type, False),
        "SubnetIds": ([str], True),
        "Tags": (Tags, False),
        "WindowsConfiguration": (WindowsConfiguration, False),
    }
