# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType
from .validators import boolean, integer


class CFNKubernetesAuditLogsConfiguration(AWSProperty):
    """
    `CFNKubernetesAuditLogsConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-detector-cfnkubernetesauditlogsconfiguration.html>`__
    """

    props: PropsDictType = {
        "Enable": (boolean, False),
    }


class CFNKubernetesConfiguration(AWSProperty):
    """
    `CFNKubernetesConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-detector-cfnkubernetesconfiguration.html>`__
    """

    props: PropsDictType = {
        "AuditLogs": (CFNKubernetesAuditLogsConfiguration, False),
    }


class CFNS3LogsConfiguration(AWSProperty):
    """
    `CFNS3LogsConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-detector-cfns3logsconfiguration.html>`__
    """

    props: PropsDictType = {
        "Enable": (boolean, False),
    }


class CFNDataSourceConfigurations(AWSProperty):
    """
    `CFNDataSourceConfigurations <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-detector-cfndatasourceconfigurations.html>`__
    """

    props: PropsDictType = {
        "Kubernetes": (CFNKubernetesConfiguration, False),
        "S3Logs": (CFNS3LogsConfiguration, False),
    }


class Detector(AWSObject):
    """
    `Detector <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-detector.html>`__
    """

    resource_type = "AWS::GuardDuty::Detector"

    props: PropsDictType = {
        "DataSources": (CFNDataSourceConfigurations, False),
        "Enable": (boolean, True),
        "FindingPublishingFrequency": (str, False),
    }


class Condition(AWSProperty):
    """
    `Condition <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-filter-condition.html>`__
    """

    props: PropsDictType = {
        "Eq": ([str], False),
        "Gte": (integer, False),
        "Lt": (integer, False),
        "Lte": (integer, False),
        "Neq": ([str], False),
    }


class FindingCriteria(AWSProperty):
    """
    `FindingCriteria <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-filter-findingcriteria.html>`__
    """

    props: PropsDictType = {
        "Criterion": (dict, False),
        "ItemType": (Condition, False),
    }


class Filter(AWSObject):
    """
    `Filter <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-filter.html>`__
    """

    resource_type = "AWS::GuardDuty::Filter"

    props: PropsDictType = {
        "Action": (str, True),
        "Description": (str, True),
        "DetectorId": (str, True),
        "FindingCriteria": (FindingCriteria, True),
        "Name": (str, True),
        "Rank": (integer, True),
    }


class IPSet(AWSObject):
    """
    `IPSet <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-ipset.html>`__
    """

    resource_type = "AWS::GuardDuty::IPSet"

    props: PropsDictType = {
        "Activate": (boolean, True),
        "DetectorId": (str, True),
        "Format": (str, True),
        "Location": (str, True),
        "Name": (str, False),
    }


class Master(AWSObject):
    """
    `Master <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-master.html>`__
    """

    resource_type = "AWS::GuardDuty::Master"

    props: PropsDictType = {
        "DetectorId": (str, True),
        "InvitationId": (str, False),
        "MasterId": (str, True),
    }


class Member(AWSObject):
    """
    `Member <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-member.html>`__
    """

    resource_type = "AWS::GuardDuty::Member"

    props: PropsDictType = {
        "DetectorId": (str, True),
        "DisableEmailNotification": (boolean, False),
        "Email": (str, True),
        "MemberId": (str, True),
        "Message": (str, False),
        "Status": (str, False),
    }


class ThreatIntelSet(AWSObject):
    """
    `ThreatIntelSet <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-threatintelset.html>`__
    """

    resource_type = "AWS::GuardDuty::ThreatIntelSet"

    props: PropsDictType = {
        "Activate": (boolean, True),
        "DetectorId": (str, True),
        "Format": (str, True),
        "Location": (str, True),
        "Name": (str, False),
    }
