# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType
from .validators import integer


class FailoverConfig(AWSProperty):
    """
    `FailoverConfig <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-failoverconfig.html>`__
    """

    props: PropsDictType = {
        "RecoveryWindow": (integer, False),
        "State": (str, False),
    }


class Encryption(AWSProperty):
    """
    `Encryption <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowsource-encryption.html>`__
    """

    props: PropsDictType = {
        "Algorithm": (str, True),
        "ConstantInitializationVector": (str, False),
        "DeviceId": (str, False),
        "KeyType": (str, False),
        "Region": (str, False),
        "ResourceId": (str, False),
        "RoleArn": (str, True),
        "SecretArn": (str, False),
        "Url": (str, False),
    }


class Source(AWSProperty):
    """
    `Source <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-source.html>`__
    """

    props: PropsDictType = {
        "Decryption": (Encryption, False),
        "Description": (str, False),
        "EntitlementArn": (str, False),
        "IngestIp": (str, False),
        "IngestPort": (integer, False),
        "MaxBitrate": (integer, False),
        "MaxLatency": (integer, False),
        "MinLatency": (integer, False),
        "Name": (str, False),
        "Protocol": (str, False),
        "SourceArn": (str, False),
        "SourceIngestPort": (str, False),
        "StreamId": (str, False),
        "VpcInterfaceName": (str, False),
        "WhitelistCidr": (str, False),
    }


class Flow(AWSObject):
    """
    `Flow <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flow.html>`__
    """

    resource_type = "AWS::MediaConnect::Flow"

    props: PropsDictType = {
        "AvailabilityZone": (str, False),
        "Name": (str, True),
        "Source": (Source, True),
        "SourceFailoverConfig": (FailoverConfig, False),
    }


class FlowEntitlement(AWSObject):
    """
    `FlowEntitlement <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html>`__
    """

    resource_type = "AWS::MediaConnect::FlowEntitlement"

    props: PropsDictType = {
        "DataTransferSubscriberFeePercent": (integer, False),
        "Description": (str, True),
        "Encryption": (Encryption, False),
        "EntitlementStatus": (str, False),
        "FlowArn": (str, True),
        "Name": (str, True),
        "Subscribers": ([str], True),
    }


class FlowOutputEncryption(AWSProperty):
    """
    `FlowOutputEncryption <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-encryption.html>`__
    """

    props: PropsDictType = {
        "Algorithm": (str, False),
        "KeyType": (str, False),
        "RoleArn": (str, True),
        "SecretArn": (str, True),
    }


class VpcInterfaceAttachment(AWSProperty):
    """
    `VpcInterfaceAttachment <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowoutput-vpcinterfaceattachment.html>`__
    """

    props: PropsDictType = {
        "VpcInterfaceName": (str, False),
    }


class FlowOutput(AWSObject):
    """
    `FlowOutput <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowoutput.html>`__
    """

    resource_type = "AWS::MediaConnect::FlowOutput"

    props: PropsDictType = {
        "CidrAllowList": ([str], False),
        "Description": (str, False),
        "Destination": (str, False),
        "Encryption": (FlowOutputEncryption, False),
        "FlowArn": (str, True),
        "MaxLatency": (integer, False),
        "MinLatency": (integer, False),
        "Name": (str, False),
        "Port": (integer, False),
        "Protocol": (str, True),
        "RemoteId": (str, False),
        "SmoothingLatency": (integer, False),
        "StreamId": (str, False),
        "VpcInterfaceAttachment": (VpcInterfaceAttachment, False),
    }


class FlowSource(AWSObject):
    """
    `FlowSource <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowsource.html>`__
    """

    resource_type = "AWS::MediaConnect::FlowSource"

    props: PropsDictType = {
        "Decryption": (Encryption, False),
        "Description": (str, True),
        "EntitlementArn": (str, False),
        "FlowArn": (str, False),
        "IngestPort": (integer, False),
        "MaxBitrate": (integer, False),
        "MaxLatency": (integer, False),
        "Name": (str, True),
        "Protocol": (str, False),
        "StreamId": (str, False),
        "VpcInterfaceName": (str, False),
        "WhitelistCidr": (str, False),
    }


class FlowVpcInterface(AWSObject):
    """
    `FlowVpcInterface <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowvpcinterface.html>`__
    """

    resource_type = "AWS::MediaConnect::FlowVpcInterface"

    props: PropsDictType = {
        "FlowArn": (str, True),
        "Name": (str, True),
        "RoleArn": (str, True),
        "SecurityGroupIds": ([str], True),
        "SubnetId": (str, True),
    }
