# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags
from .validators import boolean, integer
from .validators.opensearchservice import validate_search_service_engine_version


class MasterUserOptions(AWSProperty):
    """
    `MasterUserOptions <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-masteruseroptions.html>`__
    """

    props: PropsDictType = {
        "MasterUserARN": (str, False),
        "MasterUserName": (str, False),
        "MasterUserPassword": (str, False),
    }


class AdvancedSecurityOptionsInput(AWSProperty):
    """
    `AdvancedSecurityOptionsInput <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html>`__
    """

    props: PropsDictType = {
        "Enabled": (boolean, False),
        "InternalUserDatabaseEnabled": (boolean, False),
        "MasterUserOptions": (MasterUserOptions, False),
    }


class ZoneAwarenessConfig(AWSProperty):
    """
    `ZoneAwarenessConfig <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-zoneawarenessconfig.html>`__
    """

    props: PropsDictType = {
        "AvailabilityZoneCount": (integer, False),
    }


class ClusterConfig(AWSProperty):
    """
    `ClusterConfig <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html>`__
    """

    props: PropsDictType = {
        "DedicatedMasterCount": (integer, False),
        "DedicatedMasterEnabled": (boolean, False),
        "DedicatedMasterType": (str, False),
        "InstanceCount": (integer, False),
        "InstanceType": (str, False),
        "WarmCount": (integer, False),
        "WarmEnabled": (boolean, False),
        "WarmType": (str, False),
        "ZoneAwarenessConfig": (ZoneAwarenessConfig, False),
        "ZoneAwarenessEnabled": (boolean, False),
    }


class CognitoOptions(AWSProperty):
    """
    `CognitoOptions <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-cognitooptions.html>`__
    """

    props: PropsDictType = {
        "Enabled": (boolean, False),
        "IdentityPoolId": (str, False),
        "RoleArn": (str, False),
        "UserPoolId": (str, False),
    }


class DomainEndpointOptions(AWSProperty):
    """
    `DomainEndpointOptions <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html>`__
    """

    props: PropsDictType = {
        "CustomEndpoint": (str, False),
        "CustomEndpointCertificateArn": (str, False),
        "CustomEndpointEnabled": (boolean, False),
        "EnforceHTTPS": (boolean, False),
        "TLSSecurityPolicy": (str, False),
    }


class EBSOptions(AWSProperty):
    """
    `EBSOptions <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-ebsoptions.html>`__
    """

    props: PropsDictType = {
        "EBSEnabled": (boolean, False),
        "Iops": (integer, False),
        "VolumeSize": (integer, False),
        "VolumeType": (str, False),
    }


class EncryptionAtRestOptions(AWSProperty):
    """
    `EncryptionAtRestOptions <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-encryptionatrestoptions.html>`__
    """

    props: PropsDictType = {
        "Enabled": (boolean, False),
        "KmsKeyId": (str, False),
    }


class LogPublishingOption(AWSProperty):
    """
    `LogPublishingOption <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-logpublishingoption.html>`__
    """

    props: PropsDictType = {
        "CloudWatchLogsLogGroupArn": (str, False),
        "Enabled": (boolean, False),
    }


class NodeToNodeEncryptionOptions(AWSProperty):
    """
    `NodeToNodeEncryptionOptions <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodetonodeencryptionoptions.html>`__
    """

    props: PropsDictType = {
        "Enabled": (boolean, False),
    }


class SnapshotOptions(AWSProperty):
    """
    `SnapshotOptions <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-snapshotoptions.html>`__
    """

    props: PropsDictType = {
        "AutomatedSnapshotStartHour": (integer, False),
    }


class VPCOptions(AWSProperty):
    """
    `VPCOptions <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-vpcoptions.html>`__
    """

    props: PropsDictType = {
        "SecurityGroupIds": ([str], False),
        "SubnetIds": ([str], False),
    }


class Domain(AWSObject):
    """
    `Domain <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html>`__
    """

    resource_type = "AWS::OpenSearchService::Domain"

    props: PropsDictType = {
        "AccessPolicies": (dict, False),
        "AdvancedOptions": (dict, False),
        "AdvancedSecurityOptions": (AdvancedSecurityOptionsInput, False),
        "ClusterConfig": (ClusterConfig, False),
        "CognitoOptions": (CognitoOptions, False),
        "DomainEndpointOptions": (DomainEndpointOptions, False),
        "DomainName": (str, False),
        "EBSOptions": (EBSOptions, False),
        "EncryptionAtRestOptions": (EncryptionAtRestOptions, False),
        "EngineVersion": (validate_search_service_engine_version, False),
        "LogPublishingOptions": (dict, False),
        "NodeToNodeEncryptionOptions": (NodeToNodeEncryptionOptions, False),
        "SnapshotOptions": (SnapshotOptions, False),
        "Tags": (Tags, False),
        "VPCOptions": (VPCOptions, False),
    }
