# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags
from .validators import boolean, double


class AnalysisError(AWSProperty):
    """
    `AnalysisError <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html>`__
    """

    props: PropsDictType = {
        "Message": (str, False),
        "Type": (str, False),
    }


class DataSetReference(AWSProperty):
    """
    `DataSetReference <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetreference.html>`__
    """

    props: PropsDictType = {
        "DataSetArn": (str, True),
        "DataSetPlaceholder": (str, True),
    }


class AnalysisSourceTemplate(AWSProperty):
    """
    `AnalysisSourceTemplate <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html>`__
    """

    props: PropsDictType = {
        "Arn": (str, True),
        "DataSetReferences": ([DataSetReference], True),
    }


class AnalysisSourceEntity(AWSProperty):
    """
    `AnalysisSourceEntity <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html>`__
    """

    props: PropsDictType = {
        "SourceTemplate": (AnalysisSourceTemplate, False),
    }


class DateTimeParameter(AWSProperty):
    """
    `DateTimeParameter <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimeparameter.html>`__
    """

    props: PropsDictType = {
        "Name": (str, True),
        "Values": ([str], True),
    }


class DecimalParameter(AWSProperty):
    """
    `DecimalParameter <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-decimalparameter.html>`__
    """

    props: PropsDictType = {
        "Name": (str, True),
        "Values": ([double], True),
    }


class IntegerParameter(AWSProperty):
    """
    `IntegerParameter <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameter.html>`__
    """

    props: PropsDictType = {
        "Name": (str, True),
        "Values": ([double], True),
    }


class StringParameter(AWSProperty):
    """
    `StringParameter <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-stringparameter.html>`__
    """

    props: PropsDictType = {
        "Name": (str, True),
        "Values": ([str], True),
    }


class Parameters(AWSProperty):
    """
    `Parameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html>`__
    """

    props: PropsDictType = {
        "DateTimeParameters": ([DateTimeParameter], False),
        "DecimalParameters": ([DecimalParameter], False),
        "IntegerParameters": ([IntegerParameter], False),
        "StringParameters": ([StringParameter], False),
    }


class ResourcePermission(AWSProperty):
    """
    `ResourcePermission <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-resourcepermission.html>`__
    """

    props: PropsDictType = {
        "Actions": ([str], True),
        "Principal": (str, True),
    }


class Analysis(AWSObject):
    """
    `Analysis <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html>`__
    """

    resource_type = "AWS::QuickSight::Analysis"

    props: PropsDictType = {
        "AnalysisId": (str, True),
        "AwsAccountId": (str, True),
        "Errors": ([AnalysisError], False),
        "Name": (str, False),
        "Parameters": (Parameters, False),
        "Permissions": ([ResourcePermission], False),
        "SourceEntity": (AnalysisSourceEntity, True),
        "Tags": (Tags, False),
        "ThemeArn": (str, False),
    }


class AdHocFilteringOption(AWSProperty):
    """
    `AdHocFilteringOption <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-adhocfilteringoption.html>`__
    """

    props: PropsDictType = {
        "AvailabilityStatus": (str, False),
    }


class ExportToCSVOption(AWSProperty):
    """
    `ExportToCSVOption <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-exporttocsvoption.html>`__
    """

    props: PropsDictType = {
        "AvailabilityStatus": (str, False),
    }


class SheetControlsOption(AWSProperty):
    """
    `SheetControlsOption <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheetcontrolsoption.html>`__
    """

    props: PropsDictType = {
        "VisibilityState": (str, False),
    }


class DashboardPublishOptions(AWSProperty):
    """
    `DashboardPublishOptions <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html>`__
    """

    props: PropsDictType = {
        "AdHocFilteringOption": (AdHocFilteringOption, False),
        "ExportToCSVOption": (ExportToCSVOption, False),
        "SheetControlsOption": (SheetControlsOption, False),
    }


class DashboardSourceTemplate(AWSProperty):
    """
    `DashboardSourceTemplate <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourcetemplate.html>`__
    """

    props: PropsDictType = {
        "Arn": (str, True),
        "DataSetReferences": ([DataSetReference], True),
    }


class DashboardSourceEntity(AWSProperty):
    """
    `DashboardSourceEntity <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourceentity.html>`__
    """

    props: PropsDictType = {
        "SourceTemplate": (DashboardSourceTemplate, False),
    }


class Dashboard(AWSObject):
    """
    `Dashboard <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html>`__
    """

    resource_type = "AWS::QuickSight::Dashboard"

    props: PropsDictType = {
        "AwsAccountId": (str, True),
        "DashboardId": (str, True),
        "DashboardPublishOptions": (DashboardPublishOptions, False),
        "Name": (str, False),
        "Parameters": (Parameters, False),
        "Permissions": ([ResourcePermission], False),
        "SourceEntity": (DashboardSourceEntity, True),
        "Tags": (Tags, False),
        "ThemeArn": (str, False),
        "VersionDescription": (str, False),
    }


class GeoSpatialColumnGroup(AWSProperty):
    """
    `GeoSpatialColumnGroup <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html>`__
    """

    props: PropsDictType = {
        "Columns": ([str], True),
        "CountryCode": (str, False),
        "Name": (str, True),
    }


class ColumnGroup(AWSProperty):
    """
    `ColumnGroup <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columngroup.html>`__
    """

    props: PropsDictType = {
        "GeoSpatialColumnGroup": (GeoSpatialColumnGroup, False),
    }


class ColumnLevelPermissionRule(AWSProperty):
    """
    `ColumnLevelPermissionRule <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html>`__
    """

    props: PropsDictType = {
        "ColumnNames": ([str], False),
        "Principals": ([str], False),
    }


class FieldFolder(AWSProperty):
    """
    `FieldFolder <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html>`__
    """

    props: PropsDictType = {
        "Columns": ([str], False),
        "Description": (str, False),
    }


class IngestionWaitPolicy(AWSProperty):
    """
    `IngestionWaitPolicy <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html>`__
    """

    props: PropsDictType = {
        "IngestionWaitTimeInHours": (double, False),
        "WaitForSpiceIngestion": (boolean, False),
    }


class JoinKeyProperties(AWSProperty):
    """
    `JoinKeyProperties <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinkeyproperties.html>`__
    """

    props: PropsDictType = {
        "UniqueKey": (boolean, False),
    }


class JoinInstruction(AWSProperty):
    """
    `JoinInstruction <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html>`__
    """

    props: PropsDictType = {
        "LeftJoinKeyProperties": (JoinKeyProperties, False),
        "LeftOperand": (str, True),
        "OnClause": (str, True),
        "RightJoinKeyProperties": (JoinKeyProperties, False),
        "RightOperand": (str, True),
        "Type": (str, True),
    }


class LogicalTableSource(AWSProperty):
    """
    `LogicalTableSource <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html>`__
    """

    props: PropsDictType = {
        "JoinInstruction": (JoinInstruction, False),
        "PhysicalTableId": (str, False),
    }


class CastColumnTypeOperation(AWSProperty):
    """
    `CastColumnTypeOperation <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html>`__
    """

    props: PropsDictType = {
        "ColumnName": (str, True),
        "Format": (str, False),
        "NewColumnType": (str, True),
    }


class CalculatedColumn(AWSProperty):
    """
    `CalculatedColumn <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html>`__
    """

    props: PropsDictType = {
        "ColumnId": (str, True),
        "ColumnName": (str, True),
        "Expression": (str, True),
    }


class CreateColumnsOperation(AWSProperty):
    """
    `CreateColumnsOperation <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html>`__
    """

    props: PropsDictType = {
        "Columns": ([CalculatedColumn], True),
    }


class FilterOperation(AWSProperty):
    """
    `FilterOperation <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html>`__
    """

    props: PropsDictType = {
        "ConditionExpression": (str, True),
    }


class ProjectOperation(AWSProperty):
    """
    `ProjectOperation <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html>`__
    """

    props: PropsDictType = {
        "ProjectedColumns": ([str], True),
    }


class RenameColumnOperation(AWSProperty):
    """
    `RenameColumnOperation <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html>`__
    """

    props: PropsDictType = {
        "ColumnName": (str, True),
        "NewColumnName": (str, True),
    }


class ColumnDescription(AWSProperty):
    """
    `ColumnDescription <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columndescription.html>`__
    """

    props: PropsDictType = {
        "Text": (str, False),
    }


class ColumnTag(AWSProperty):
    """
    `ColumnTag <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html>`__
    """

    props: PropsDictType = {
        "ColumnDescription": (ColumnDescription, False),
        "ColumnGeographicRole": (str, False),
    }


class TagColumnOperation(AWSProperty):
    """
    `TagColumnOperation <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-tagcolumnoperation.html>`__
    """

    props: PropsDictType = {
        "ColumnName": (str, True),
        "Tags": ([ColumnTag], True),
    }


class TransformOperation(AWSProperty):
    """
    `TransformOperation <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html>`__
    """

    props: PropsDictType = {
        "CastColumnTypeOperation": (CastColumnTypeOperation, False),
        "CreateColumnsOperation": (CreateColumnsOperation, False),
        "FilterOperation": (FilterOperation, False),
        "ProjectOperation": (ProjectOperation, False),
        "RenameColumnOperation": (RenameColumnOperation, False),
        "TagColumnOperation": (TagColumnOperation, False),
    }


class LogicalTable(AWSProperty):
    """
    `LogicalTable <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html>`__
    """

    props: PropsDictType = {
        "Alias": (str, True),
        "DataTransforms": ([TransformOperation], False),
        "Source": (LogicalTableSource, True),
    }


class InputColumn(AWSProperty):
    """
    `InputColumn <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html>`__
    """

    props: PropsDictType = {
        "Name": (str, True),
        "Type": (str, True),
    }


class CustomSql(AWSProperty):
    """
    `CustomSql <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html>`__
    """

    props: PropsDictType = {
        "Columns": ([InputColumn], True),
        "DataSourceArn": (str, True),
        "Name": (str, True),
        "SqlQuery": (str, True),
    }


class RelationalTable(AWSProperty):
    """
    `RelationalTable <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html>`__
    """

    props: PropsDictType = {
        "Catalog": (str, False),
        "DataSourceArn": (str, True),
        "InputColumns": ([InputColumn], True),
        "Name": (str, True),
        "Schema": (str, False),
    }


class UploadSettings(AWSProperty):
    """
    `UploadSettings <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html>`__
    """

    props: PropsDictType = {
        "ContainsHeader": (boolean, False),
        "Delimiter": (str, False),
        "Format": (str, False),
        "StartFromRow": (double, False),
        "TextQualifier": (str, False),
    }


class S3Source(AWSProperty):
    """
    `S3Source <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-s3source.html>`__
    """

    props: PropsDictType = {
        "DataSourceArn": (str, True),
        "InputColumns": ([InputColumn], True),
        "UploadSettings": (UploadSettings, False),
    }


class PhysicalTable(AWSProperty):
    """
    `PhysicalTable <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html>`__
    """

    props: PropsDictType = {
        "CustomSql": (CustomSql, False),
        "RelationalTable": (RelationalTable, False),
        "S3Source": (S3Source, False),
    }


class RowLevelPermissionDataSet(AWSProperty):
    """
    `RowLevelPermissionDataSet <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html>`__
    """

    props: PropsDictType = {
        "Arn": (str, True),
        "FormatVersion": (str, False),
        "Namespace": (str, False),
        "PermissionPolicy": (str, True),
    }


class DataSet(AWSObject):
    """
    `DataSet <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html>`__
    """

    resource_type = "AWS::QuickSight::DataSet"

    props: PropsDictType = {
        "AwsAccountId": (str, False),
        "ColumnGroups": ([ColumnGroup], False),
        "ColumnLevelPermissionRules": ([ColumnLevelPermissionRule], False),
        "DataSetId": (str, False),
        "FieldFolders": (dict, False),
        "ImportMode": (str, False),
        "IngestionWaitPolicy": (IngestionWaitPolicy, False),
        "LogicalTableMap": (dict, False),
        "Name": (str, False),
        "Permissions": ([ResourcePermission], False),
        "PhysicalTableMap": (dict, False),
        "RowLevelPermissionDataSet": (RowLevelPermissionDataSet, False),
        "Tags": (Tags, False),
    }


class AmazonElasticsearchParameters(AWSProperty):
    """
    `AmazonElasticsearchParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-amazonelasticsearchparameters.html>`__
    """

    props: PropsDictType = {
        "Domain": (str, True),
    }


class AmazonOpenSearchParameters(AWSProperty):
    """
    `AmazonOpenSearchParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-amazonopensearchparameters.html>`__
    """

    props: PropsDictType = {
        "Domain": (str, True),
    }


class AthenaParameters(AWSProperty):
    """
    `AthenaParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-athenaparameters.html>`__
    """

    props: PropsDictType = {
        "WorkGroup": (str, False),
    }


class AuroraParameters(AWSProperty):
    """
    `AuroraParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-auroraparameters.html>`__
    """

    props: PropsDictType = {
        "Database": (str, True),
        "Host": (str, True),
        "Port": (double, True),
    }


class AuroraPostgreSqlParameters(AWSProperty):
    """
    `AuroraPostgreSqlParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-aurorapostgresqlparameters.html>`__
    """

    props: PropsDictType = {
        "Database": (str, True),
        "Host": (str, True),
        "Port": (double, True),
    }


class MariaDbParameters(AWSProperty):
    """
    `MariaDbParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mariadbparameters.html>`__
    """

    props: PropsDictType = {
        "Database": (str, True),
        "Host": (str, True),
        "Port": (double, True),
    }


class MySqlParameters(AWSProperty):
    """
    `MySqlParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-mysqlparameters.html>`__
    """

    props: PropsDictType = {
        "Database": (str, True),
        "Host": (str, True),
        "Port": (double, True),
    }


class OracleParameters(AWSProperty):
    """
    `OracleParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-oracleparameters.html>`__
    """

    props: PropsDictType = {
        "Database": (str, True),
        "Host": (str, True),
        "Port": (double, True),
    }


class PostgreSqlParameters(AWSProperty):
    """
    `PostgreSqlParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-postgresqlparameters.html>`__
    """

    props: PropsDictType = {
        "Database": (str, True),
        "Host": (str, True),
        "Port": (double, True),
    }


class PrestoParameters(AWSProperty):
    """
    `PrestoParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-prestoparameters.html>`__
    """

    props: PropsDictType = {
        "Catalog": (str, True),
        "Host": (str, True),
        "Port": (double, True),
    }


class RdsParameters(AWSProperty):
    """
    `RdsParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-rdsparameters.html>`__
    """

    props: PropsDictType = {
        "Database": (str, True),
        "InstanceId": (str, True),
    }


class RedshiftParameters(AWSProperty):
    """
    `RedshiftParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-redshiftparameters.html>`__
    """

    props: PropsDictType = {
        "ClusterId": (str, False),
        "Database": (str, True),
        "Host": (str, False),
        "Port": (double, False),
    }


class ManifestFileLocation(AWSProperty):
    """
    `ManifestFileLocation <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-manifestfilelocation.html>`__
    """

    props: PropsDictType = {
        "Bucket": (str, True),
        "Key": (str, True),
    }


class S3Parameters(AWSProperty):
    """
    `S3Parameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-s3parameters.html>`__
    """

    props: PropsDictType = {
        "ManifestFileLocation": (ManifestFileLocation, True),
    }


class SnowflakeParameters(AWSProperty):
    """
    `SnowflakeParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-snowflakeparameters.html>`__
    """

    props: PropsDictType = {
        "Database": (str, True),
        "Host": (str, True),
        "Warehouse": (str, True),
    }


class SparkParameters(AWSProperty):
    """
    `SparkParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sparkparameters.html>`__
    """

    props: PropsDictType = {
        "Host": (str, True),
        "Port": (double, True),
    }


class SqlServerParameters(AWSProperty):
    """
    `SqlServerParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sqlserverparameters.html>`__
    """

    props: PropsDictType = {
        "Database": (str, True),
        "Host": (str, True),
        "Port": (double, True),
    }


class TeradataParameters(AWSProperty):
    """
    `TeradataParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-teradataparameters.html>`__
    """

    props: PropsDictType = {
        "Database": (str, True),
        "Host": (str, True),
        "Port": (double, True),
    }


class DataSourceParameters(AWSProperty):
    """
    `DataSourceParameters <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceparameters.html>`__
    """

    props: PropsDictType = {
        "AmazonElasticsearchParameters": (AmazonElasticsearchParameters, False),
        "AmazonOpenSearchParameters": (AmazonOpenSearchParameters, False),
        "AthenaParameters": (AthenaParameters, False),
        "AuroraParameters": (AuroraParameters, False),
        "AuroraPostgreSqlParameters": (AuroraPostgreSqlParameters, False),
        "MariaDbParameters": (MariaDbParameters, False),
        "MySqlParameters": (MySqlParameters, False),
        "OracleParameters": (OracleParameters, False),
        "PostgreSqlParameters": (PostgreSqlParameters, False),
        "PrestoParameters": (PrestoParameters, False),
        "RdsParameters": (RdsParameters, False),
        "RedshiftParameters": (RedshiftParameters, False),
        "S3Parameters": (S3Parameters, False),
        "SnowflakeParameters": (SnowflakeParameters, False),
        "SparkParameters": (SparkParameters, False),
        "SqlServerParameters": (SqlServerParameters, False),
        "TeradataParameters": (TeradataParameters, False),
    }


class CredentialPair(AWSProperty):
    """
    `CredentialPair <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-credentialpair.html>`__
    """

    props: PropsDictType = {
        "AlternateDataSourceParameters": ([DataSourceParameters], False),
        "Password": (str, True),
        "Username": (str, True),
    }


class DataSourceCredentials(AWSProperty):
    """
    `DataSourceCredentials <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourcecredentials.html>`__
    """

    props: PropsDictType = {
        "CopySourceArn": (str, False),
        "CredentialPair": (CredentialPair, False),
    }


class DataSourceErrorInfo(AWSProperty):
    """
    `DataSourceErrorInfo <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-datasourceerrorinfo.html>`__
    """

    props: PropsDictType = {
        "Message": (str, False),
        "Type": (str, False),
    }


class SslProperties(AWSProperty):
    """
    `SslProperties <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-sslproperties.html>`__
    """

    props: PropsDictType = {
        "DisableSsl": (boolean, False),
    }


class VpcConnectionProperties(AWSProperty):
    """
    `VpcConnectionProperties <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-datasource-vpcconnectionproperties.html>`__
    """

    props: PropsDictType = {
        "VpcConnectionArn": (str, True),
    }


class DataSource(AWSObject):
    """
    `DataSource <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-datasource.html>`__
    """

    resource_type = "AWS::QuickSight::DataSource"

    props: PropsDictType = {
        "AlternateDataSourceParameters": ([DataSourceParameters], False),
        "AwsAccountId": (str, False),
        "Credentials": (DataSourceCredentials, False),
        "DataSourceId": (str, False),
        "DataSourceParameters": (DataSourceParameters, False),
        "ErrorInfo": (DataSourceErrorInfo, False),
        "Name": (str, False),
        "Permissions": ([ResourcePermission], False),
        "SslProperties": (SslProperties, False),
        "Tags": (Tags, False),
        "Type": (str, False),
        "VpcConnectionProperties": (VpcConnectionProperties, False),
    }


class TemplateSourceAnalysis(AWSProperty):
    """
    `TemplateSourceAnalysis <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceanalysis.html>`__
    """

    props: PropsDictType = {
        "Arn": (str, True),
        "DataSetReferences": ([DataSetReference], True),
    }


class TemplateSourceTemplate(AWSProperty):
    """
    `TemplateSourceTemplate <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourcetemplate.html>`__
    """

    props: PropsDictType = {
        "Arn": (str, True),
    }


class TemplateSourceEntity(AWSProperty):
    """
    `TemplateSourceEntity <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceentity.html>`__
    """

    props: PropsDictType = {
        "SourceAnalysis": (TemplateSourceAnalysis, False),
        "SourceTemplate": (TemplateSourceTemplate, False),
    }


class Template(AWSObject):
    """
    `Template <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html>`__
    """

    resource_type = "AWS::QuickSight::Template"

    props: PropsDictType = {
        "AwsAccountId": (str, True),
        "Name": (str, False),
        "Permissions": ([ResourcePermission], False),
        "SourceEntity": (TemplateSourceEntity, True),
        "Tags": (Tags, False),
        "TemplateId": (str, True),
        "VersionDescription": (str, False),
    }


class DataColorPalette(AWSProperty):
    """
    `DataColorPalette <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-datacolorpalette.html>`__
    """

    props: PropsDictType = {
        "Colors": ([str], False),
        "EmptyFillColor": (str, False),
        "MinMaxGradient": ([str], False),
    }


class GutterStyle(AWSProperty):
    """
    `GutterStyle <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-gutterstyle.html>`__
    """

    props: PropsDictType = {
        "Show": (boolean, False),
    }


class MarginStyle(AWSProperty):
    """
    `MarginStyle <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-marginstyle.html>`__
    """

    props: PropsDictType = {
        "Show": (boolean, False),
    }


class TileLayoutStyle(AWSProperty):
    """
    `TileLayoutStyle <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilelayoutstyle.html>`__
    """

    props: PropsDictType = {
        "Gutter": (GutterStyle, False),
        "Margin": (MarginStyle, False),
    }


class BorderStyle(AWSProperty):
    """
    `BorderStyle <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-borderstyle.html>`__
    """

    props: PropsDictType = {
        "Show": (boolean, False),
    }


class TileStyle(AWSProperty):
    """
    `TileStyle <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilestyle.html>`__
    """

    props: PropsDictType = {
        "Border": (BorderStyle, False),
    }


class SheetStyle(AWSProperty):
    """
    `SheetStyle <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-sheetstyle.html>`__
    """

    props: PropsDictType = {
        "Tile": (TileStyle, False),
        "TileLayout": (TileLayoutStyle, False),
    }


class Font(AWSProperty):
    """
    `Font <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-font.html>`__
    """

    props: PropsDictType = {
        "FontFamily": (str, False),
    }


class Typography(AWSProperty):
    """
    `Typography <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-typography.html>`__
    """

    props: PropsDictType = {
        "FontFamilies": ([Font], False),
    }


class UIColorPalette(AWSProperty):
    """
    `UIColorPalette <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html>`__
    """

    props: PropsDictType = {
        "Accent": (str, False),
        "AccentForeground": (str, False),
        "Danger": (str, False),
        "DangerForeground": (str, False),
        "Dimension": (str, False),
        "DimensionForeground": (str, False),
        "Measure": (str, False),
        "MeasureForeground": (str, False),
        "PrimaryBackground": (str, False),
        "PrimaryForeground": (str, False),
        "SecondaryBackground": (str, False),
        "SecondaryForeground": (str, False),
        "Success": (str, False),
        "SuccessForeground": (str, False),
        "Warning": (str, False),
        "WarningForeground": (str, False),
    }


class ThemeConfiguration(AWSProperty):
    """
    `ThemeConfiguration <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html>`__
    """

    props: PropsDictType = {
        "DataColorPalette": (DataColorPalette, False),
        "Sheet": (SheetStyle, False),
        "Typography": (Typography, False),
        "UIColorPalette": (UIColorPalette, False),
    }


class Theme(AWSObject):
    """
    `Theme <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html>`__
    """

    resource_type = "AWS::QuickSight::Theme"

    props: PropsDictType = {
        "AwsAccountId": (str, True),
        "BaseThemeId": (str, False),
        "Configuration": (ThemeConfiguration, False),
        "Name": (str, False),
        "Permissions": ([ResourcePermission], False),
        "Tags": (Tags, False),
        "ThemeId": (str, True),
        "VersionDescription": (str, False),
    }
