# Copyright (c) 2012-2022, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***


from . import AWSObject, AWSProperty, PropsDictType, Tags
from .validators import boolean
from .validators.sns import policytypes


class SubscriptionResource(AWSObject):
    """
    `SubscriptionResource <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html>`__
    """

    resource_type = "AWS::SNS::Subscription"

    props: PropsDictType = {
        "DeliveryPolicy": (dict, False),
        "Endpoint": (str, False),
        "FilterPolicy": (dict, False),
        "Protocol": (str, True),
        "RawMessageDelivery": (boolean, False),
        "RedrivePolicy": (dict, False),
        "Region": (str, False),
        "SubscriptionRoleArn": (str, False),
        "TopicArn": (str, True),
    }


class Subscription(AWSProperty):
    """
    `Subscription <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-subscription.html>`__
    """

    props: PropsDictType = {
        "Endpoint": (str, True),
        "Protocol": (str, True),
    }


class Topic(AWSObject):
    """
    `Topic <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-topic.html>`__
    """

    resource_type = "AWS::SNS::Topic"

    props: PropsDictType = {
        "ContentBasedDeduplication": (boolean, False),
        "DisplayName": (str, False),
        "FifoTopic": (boolean, False),
        "KmsMasterKeyId": (str, False),
        "Subscription": ([Subscription], False),
        "Tags": (Tags, False),
        "TopicName": (str, False),
    }


class TopicPolicy(AWSObject):
    """
    `TopicPolicy <http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html>`__
    """

    resource_type = "AWS::SNS::TopicPolicy"

    props: PropsDictType = {
        "PolicyDocument": (policytypes, True),
        "Topics": ([str], True),
    }
