# -*- coding: utf-8 -*-
#######
# actinia-core - an open source REST API for scalable, distributed, high
# performance processing of geographical data that uses GRASS GIS for
# computational tasks. For details, see https://actinia.mundialis.de/
#
# Copyright (c) 2016-2018 Sören Gebbert and mundialis GmbH & Co. KG
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
#######

"""
Tests: Raster async export test case
"""
import unittest
import time

try:
    from .test_resource_base import ActiniaResourceTestCaseBase, URL_PREFIX
except ModuleNotFoundError:
    from test_resource_base import ActiniaResourceTestCaseBase, URL_PREFIX

__license__ = "GPLv3"
__author__ = "Sören Gebbert"
__copyright__ = (
    "Copyright 2016-2018, Sören Gebbert and mundialis GmbH & Co. KG"
)
__maintainer__ = "Sören Gebbert"
__email__ = "soerengebbert@googlemail.com"


class RasterAsyncExport(ActiniaResourceTestCaseBase):
    def test_export(self):
        rv = self.server.post(
            f"{URL_PREFIX}/locations/nc_spm_08/mapsets/PERMANENT/raster_layers"
            "/elevation/geotiff_async",
            headers=self.user_auth_header,
        )
        resp = self.waitAsyncStatusAssertHTTP(
            rv, headers=self.user_auth_header
        )

        # Get the exported results
        urls = resp["urls"]["resources"]

        for url in urls:
            print(url)
            rv = self.server.get(url, headers=self.user_auth_header)
            self.assertEqual(
                rv.status_code,
                200,
                "HTML status code is wrong %i" % rv.status_code,
            )
            self.assertEqual(
                rv.mimetype, "image/tiff", "Wrong mimetype %s" % rv.mimetype
            )
            print(rv.headers)

        time.sleep(1)

    def test_export_region(self):
        rv = self.server.post(
            f"{URL_PREFIX}/locations/nc_spm_08/mapsets/PERMANENT/raster_layers"
            "/elevation/geotiff_async_orig",
            headers=self.user_auth_header,
        )
        resp = self.waitAsyncStatusAssertHTTP(
            rv, headers=self.user_auth_header
        )

        # Get the exported results
        urls = resp["urls"]["resources"]

        for url in urls:
            print(url)
            rv = self.server.get(url, headers=self.user_auth_header)
            self.assertEqual(
                rv.status_code,
                200,
                "HTML status code is wrong %i" % rv.status_code,
            )
            self.assertEqual(
                rv.mimetype, "image/tiff", "Wrong mimetype %s" % rv.mimetype
            )
            print(rv.headers)

        time.sleep(1)

    def test_export_error(self):
        rv = self.server.post(
            f"{URL_PREFIX}/locations/nc_spm_08/mapsets/PERMANENT/"
            "raster_layers/elevationion/geotiff_async",
            headers=self.user_auth_header,
        )
        self.waitAsyncStatusAssertHTTP(
            rv,
            headers=self.user_auth_header,
            http_status=400,
            status="error",
            message_check="AsyncProcessError:",
        )


if __name__ == "__main__":
    unittest.main()
