# Copyright 2021 Agnostiq Inc.
#
# This file is part of Covalent.
#
# Licensed under the GNU Affero General Public License 3.0 (the "License").
# A copy of the License may be obtained with this software package or at
#
#      https://www.gnu.org/licenses/agpl-3.0.en.html
#
# Use of this file is prohibited except in compliance with the License. Any
# modifications or derivative works of this file must retain this copyright
# notice, and modified files must contain a notice indicating that they have
# been altered from the originals.
#
# Covalent is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE. See the License for more details.
#
# Relief from the License may be granted by purchasing a commercial license.

"""v13

Revision ID: 97202f5f47cb
Revises: 26d71848a404
Create Date: 2022-10-16 13:00:13.554644

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
# pragma: allowlist nextline secret
revision = "97202f5f47cb"
# pragma: allowlist nextline secret
down_revision = "26d71848a404"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("electrons", schema=None) as batch_op:
        batch_op.add_column(sa.Column("error_filename", sa.Text(), nullable=True))
        batch_op.drop_column("info_filename")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("electrons", schema=None) as batch_op:
        batch_op.add_column(sa.Column("info_filename", sa.TEXT(), nullable=True))
        batch_op.drop_column("error_filename")

    # ### end Alembic commands ###
