# -*- coding: utf-8 -*-
"""
Configuration IMPORT/EXPORT default device port configurations

**Version:** 1.3.0b3

**Author:** CloudGenix

**Copyright:** (c) 2017, 2018 CloudGenix, Inc

**License:** MIT

**Location:** <https://github.com/CloudGenix/cloudgenix_config>

#### Synopsis
Intended to be a small, lightweight SDK wrapper around the CloudGenix API for easy use.
Initial version requires knowledge of JSON/Dict objects for POST/PUT/PATCH operations.

#### Requirements
* Active CloudGenix Account
* Python >= 2.7 or >=3.6
* Python modules:
    * CloudGenix Python SDK >= 5.0.1b1 - <https://github.com/CloudGenix/sdk-python>

#### License
MIT

#### For more info
 * Get help and additional CloudGenix Documentation at <http://support.cloudgenix.com>
 * View the autogenerated documentation in the `docs/` directory, or at <https://cloudgenix.github.io/sdk-python/>.
 * View in-python help using `help()` functions. (example: `help(cgx_sess.get.login)`)
"""

__author__ = "CloudGenix Developer Support <developers@cloudgenix.com>"
__email__ = "developers@cloudgenix.com"
__copyright__ = "Copyright (c) 2017, 2018 CloudGenix, Inc"
__license__ = """
    MIT License

    Copyright (c) 2017, 2018 CloudGenix, Inc

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.
"""


member_port = """
            name: null
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
"""

default_backwards_bypasspairs = {
    "lan 1wan 1": "wan 1lan 1",
    "lan 2wan 2": "wan 2lan 2",
    "lan 3wan 3": "wan 3lan 3",
    "lan 4wan 4": "wan 4lan 4",
    "54": "45"
}


ion_3000 = """
          controller 1:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          controller 2:
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          internet 1:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: public
          internet 2:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: public
          internet bypass 1:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          internet bypass 2:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          lan 1:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          lan 2:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          lan 3:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          lan 4:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          wan 1:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          wan 1lan 1:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair:
              lan: lan 1
              lan_state_propagation: false
              use_relay: true
              wan: wan 1
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: bypasspair
            used_for: private_wan
          wan 2:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          wan 2lan 2:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair:
              lan: lan 2
              lan_state_propagation: false
              use_relay: true
              wan: wan 2
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: bypasspair
            used_for: private_wan
          wan 3:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          wan 3lan 3:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair:
              lan: lan 3
              lan_state_propagation: false
              use_relay: true
              wan: wan 3
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: bypasspair
            used_for: private_wan
          wan 4:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          wan 4lan 4:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair:
              lan: lan 4
              lan_state_propagation: false
              use_relay: true
              wan: wan 4
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: bypasspair
            used_for: private_wan
"""

ion_7000 = """
          '1':
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '10':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '11':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '12':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '13':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '14':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '2':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: private_wan
          '3':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '4':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '5':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '6':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '7':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '8':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '9':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          controller 1:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          controller 2:
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
"""

ion_2000 = """
          '1':
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: public
          '2':
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: public
          '3':
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: public
          '4':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '5':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '45':
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair:
              lan: '5'
              lan_state_propagation: false
              use_relay: true
              wan: '4'
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: bypasspair
            used_for: private_wan
          controller:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
"""

ion_3102v = """
          '1':
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: public
          '2':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          controller 1:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
"""

ion_1000 = """
          '1':
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '2':
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '3':
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '4':
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
"""

ion_9000 = """
          '1':
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '10':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '11':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '12':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '13':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '14':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '15':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '16':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '2':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: private_wan
          '3':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '4':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '5':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '6':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '7':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '8':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          '9':
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config: null
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          controller 1:
            admin_up: true
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
          controller 2:
            admin_up: false
            attached_lan_networks: null
            bound_interfaces: null
            bypass_pair: null
            description: null
            devicemgmt_policysetstack_id: null
            dhcp_relay: null
            directed_broadcast: false
            ethernet_port:
              full_duplex: false
              speed: 0
            ipv4_config:
              dhcp_config:
                client_id: null
                hostname: null
              dns_v4_config: null
              routes: null
              static_config: null
              type: dhcp
            mac_address: null
            mtu: 1500
            nat_address: null
            nat_pools: null
            nat_port: 0
            nat_zone_id: null
            network_context_id: null
            parent: null
            pppoe_config: null
            scope: local
            service_link_config: null
            site_wan_interface_ids: null
            sub_interface: null
            tags:
            type: port
            used_for: none
"""

ion_3104v = ion_3102v
ion_3108v = ion_3102v
ion_7108v = ion_3102v
ion_7116v = ion_3102v
ion_7132v = ion_3102v

