# Generated by Django 2.2.4 on 2019-10-02 14:27

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import djmoney.models.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Archive',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('Negative', 'Negative'), ('Slide', 'Slide'), ('Print', 'Print')], help_text='What is stored in this archive?', max_length=8)),
                ('name', models.CharField(help_text='Name of this archive', max_length=45, unique=True)),
                ('max_width', models.PositiveIntegerField(blank=True, help_text='Maximum width of media that this archive can store', null=True)),
                ('max_height', models.PositiveIntegerField(blank=True, help_text='Maximum height of media that this archive can store', null=True)),
                ('location', models.CharField(blank=True, help_text='Location of this archive', max_length=45, null=True)),
                ('storage', models.CharField(blank=True, choices=[('Ringbinder', 'Ringbinder'), ('Folder', 'Folder'), ('Box', 'Box'), ('Portfolio', 'Portfolio'), ('Slide tray', 'Slide tray')], help_text='The type of storage used for this archive', max_length=45, null=True)),
                ('sealed', models.BooleanField(default=0, help_text='Whether or not this archive is sealed (closed to new additions)')),
            ],
            options={
                'verbose_name_plural': 'archives',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Battery',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Common name of the battery', max_length=45, unique=True)),
                ('voltage', models.DecimalField(blank=True, decimal_places=2, help_text='Nominal voltage of the battery', max_digits=5, null=True)),
                ('chemistry', models.CharField(blank=True, help_text='Battery chemistry (e.g. Alkaline, Lithium, etc)', max_length=45, null=True)),
                ('other_names', models.CharField(blank=True, help_text='Alternative names for this kind of battery', max_length=45, null=True)),
            ],
            options={
                'verbose_name_plural': 'batteries',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='BulkFilm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('purchase_date', models.DateField(blank=True, help_text='Purchase date of this bulk roll', null=True)),
                ('cost_currency', djmoney.models.fields.CurrencyField(choices=[('XUA', 'ADB Unit of Account'), ('AFN', 'Afghani'), ('DZD', 'Algerian Dinar'), ('ARS', 'Argentine Peso'), ('AMD', 'Armenian Dram'), ('AWG', 'Aruban Guilder'), ('AUD', 'Australian Dollar'), ('AZN', 'Azerbaijanian Manat'), ('BSD', 'Bahamian Dollar'), ('BHD', 'Bahraini Dinar'), ('THB', 'Baht'), ('PAB', 'Balboa'), ('BBD', 'Barbados Dollar'), ('BYN', 'Belarussian Ruble'), ('BYR', 'Belarussian Ruble'), ('BZD', 'Belize Dollar'), ('BMD', 'Bermudian Dollar (customarily known as Bermuda Dollar)'), ('BTN', 'Bhutanese ngultrum'), ('VEF', 'Bolivar Fuerte'), ('BOB', 'Boliviano'), ('XBA', 'Bond Markets Units European Composite Unit (EURCO)'), ('BRL', 'Brazilian Real'), ('BND', 'Brunei Dollar'), ('BGN', 'Bulgarian Lev'), ('BIF', 'Burundi Franc'), ('XOF', 'CFA Franc BCEAO'), ('XAF', 'CFA franc BEAC'), ('XPF', 'CFP Franc'), ('CAD', 'Canadian Dollar'), ('CVE', 'Cape Verde Escudo'), ('KYD', 'Cayman Islands Dollar'), ('CLP', 'Chilean peso'), ('XTS', 'Codes specifically reserved for testing purposes'), ('COP', 'Colombian peso'), ('KMF', 'Comoro Franc'), ('CDF', 'Congolese franc'), ('BAM', 'Convertible Marks'), ('NIO', 'Cordoba Oro'), ('CRC', 'Costa Rican Colon'), ('HRK', 'Croatian Kuna'), ('CUP', 'Cuban Peso'), ('CUC', 'Cuban convertible peso'), ('CZK', 'Czech Koruna'), ('GMD', 'Dalasi'), ('DKK', 'Danish Krone'), ('MKD', 'Denar'), ('DJF', 'Djibouti Franc'), ('STD', 'Dobra'), ('DOP', 'Dominican Peso'), ('VND', 'Dong'), ('XCD', 'East Caribbean Dollar'), ('EGP', 'Egyptian Pound'), ('SVC', 'El Salvador Colon'), ('ETB', 'Ethiopian Birr'), ('EUR', 'Euro'), ('XBB', 'European Monetary Unit (E.M.U.-6)'), ('XBD', 'European Unit of Account 17(E.U.A.-17)'), ('XBC', 'European Unit of Account 9(E.U.A.-9)'), ('FKP', 'Falkland Islands Pound'), ('FJD', 'Fiji Dollar'), ('HUF', 'Forint'), ('GHS', 'Ghana Cedi'), ('GIP', 'Gibraltar Pound'), ('XAU', 'Gold'), ('XFO', 'Gold-Franc'), ('PYG', 'Guarani'), ('GNF', 'Guinea Franc'), ('GYD', 'Guyana Dollar'), ('HTG', 'Haitian gourde'), ('HKD', 'Hong Kong Dollar'), ('UAH', 'Hryvnia'), ('ISK', 'Iceland Krona'), ('INR', 'Indian Rupee'), ('IRR', 'Iranian Rial'), ('IQD', 'Iraqi Dinar'), ('IMP', 'Isle of Man Pound'), ('JMD', 'Jamaican Dollar'), ('JOD', 'Jordanian Dinar'), ('KES', 'Kenyan Shilling'), ('PGK', 'Kina'), ('LAK', 'Kip'), ('KWD', 'Kuwaiti Dinar'), ('AOA', 'Kwanza'), ('MMK', 'Kyat'), ('GEL', 'Lari'), ('LVL', 'Latvian Lats'), ('LBP', 'Lebanese Pound'), ('ALL', 'Lek'), ('HNL', 'Lempira'), ('SLL', 'Leone'), ('LSL', 'Lesotho loti'), ('LRD', 'Liberian Dollar'), ('LYD', 'Libyan Dinar'), ('SZL', 'Lilangeni'), ('LTL', 'Lithuanian Litas'), ('MGA', 'Malagasy Ariary'), ('MWK', 'Malawian Kwacha'), ('MYR', 'Malaysian Ringgit'), ('TMM', 'Manat'), ('MUR', 'Mauritius Rupee'), ('MZN', 'Metical'), ('MXV', 'Mexican Unidad de Inversion (UDI)'), ('MXN', 'Mexican peso'), ('MDL', 'Moldovan Leu'), ('MAD', 'Moroccan Dirham'), ('BOV', 'Mvdol'), ('NGN', 'Naira'), ('ERN', 'Nakfa'), ('NAD', 'Namibian Dollar'), ('NPR', 'Nepalese Rupee'), ('ANG', 'Netherlands Antillian Guilder'), ('ILS', 'New Israeli Sheqel'), ('RON', 'New Leu'), ('TWD', 'New Taiwan Dollar'), ('NZD', 'New Zealand Dollar'), ('KPW', 'North Korean Won'), ('NOK', 'Norwegian Krone'), ('PEN', 'Nuevo Sol'), ('MRO', 'Ouguiya'), ('TOP', 'Paanga'), ('PKR', 'Pakistan Rupee'), ('XPD', 'Palladium'), ('MOP', 'Pataca'), ('PHP', 'Philippine Peso'), ('XPT', 'Platinum'), ('GBP', 'Pound Sterling'), ('BWP', 'Pula'), ('QAR', 'Qatari Rial'), ('GTQ', 'Quetzal'), ('ZAR', 'Rand'), ('OMR', 'Rial Omani'), ('KHR', 'Riel'), ('MVR', 'Rufiyaa'), ('IDR', 'Rupiah'), ('RUB', 'Russian Ruble'), ('RWF', 'Rwanda Franc'), ('XDR', 'SDR'), ('SHP', 'Saint Helena Pound'), ('SAR', 'Saudi Riyal'), ('RSD', 'Serbian Dinar'), ('SCR', 'Seychelles Rupee'), ('XAG', 'Silver'), ('SGD', 'Singapore Dollar'), ('SBD', 'Solomon Islands Dollar'), ('KGS', 'Som'), ('SOS', 'Somali Shilling'), ('TJS', 'Somoni'), ('SSP', 'South Sudanese Pound'), ('LKR', 'Sri Lanka Rupee'), ('XSU', 'Sucre'), ('SDG', 'Sudanese Pound'), ('SRD', 'Surinam Dollar'), ('SEK', 'Swedish Krona'), ('CHF', 'Swiss Franc'), ('SYP', 'Syrian Pound'), ('BDT', 'Taka'), ('WST', 'Tala'), ('TZS', 'Tanzanian Shilling'), ('KZT', 'Tenge'), ('XXX', 'The codes assigned for transactions where no currency is involved'), ('TTD', 'Trinidad and Tobago Dollar'), ('MNT', 'Tugrik'), ('TND', 'Tunisian Dinar'), ('TRY', 'Turkish Lira'), ('TMT', 'Turkmenistan New Manat'), ('TVD', 'Tuvalu dollar'), ('AED', 'UAE Dirham'), ('XFU', 'UIC-Franc'), ('USD', 'US Dollar'), ('USN', 'US Dollar (Next day)'), ('UGX', 'Uganda Shilling'), ('CLF', 'Unidad de Fomento'), ('COU', 'Unidad de Valor Real'), ('UYI', 'Uruguay Peso en Unidades Indexadas (URUIURUI)'), ('UYU', 'Uruguayan peso'), ('UZS', 'Uzbekistan Sum'), ('VUV', 'Vatu'), ('CHE', 'WIR Euro'), ('CHW', 'WIR Franc'), ('KRW', 'Won'), ('YER', 'Yemeni Rial'), ('JPY', 'Yen'), ('CNY', 'Yuan Renminbi'), ('ZMK', 'Zambian Kwacha'), ('ZMW', 'Zambian Kwacha'), ('ZWD', 'Zimbabwe Dollar A/06'), ('ZWN', 'Zimbabwe dollar A/08'), ('ZWL', 'Zimbabwe dollar A/09'), ('PLN', 'Zloty')], default='GBP', editable=False, max_length=3)),
                ('cost', djmoney.models.fields.MoneyField(blank=True, decimal_places=2, default_currency='GBP', help_text='Purchase cost of this bulk roll', max_digits=12, null=True)),
                ('source', models.CharField(blank=True, help_text='Place where this bulk roll was bought from', max_length=45, null=True)),
                ('batch', models.CharField(blank=True, help_text='Batch code of this bulk roll', max_length=45, null=True)),
                ('expiry', models.DateField(blank=True, help_text='Expiry date of this bulk roll', null=True)),
            ],
            options={
                'verbose_name_plural': 'bulk films',
            },
        ),
        migrations.CreateModel(
            name='Camera',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('acquired', models.DateField(blank=True, help_text='Date on which the camera was acquired', null=True)),
                ('cost_currency', djmoney.models.fields.CurrencyField(choices=[('XUA', 'ADB Unit of Account'), ('AFN', 'Afghani'), ('DZD', 'Algerian Dinar'), ('ARS', 'Argentine Peso'), ('AMD', 'Armenian Dram'), ('AWG', 'Aruban Guilder'), ('AUD', 'Australian Dollar'), ('AZN', 'Azerbaijanian Manat'), ('BSD', 'Bahamian Dollar'), ('BHD', 'Bahraini Dinar'), ('THB', 'Baht'), ('PAB', 'Balboa'), ('BBD', 'Barbados Dollar'), ('BYN', 'Belarussian Ruble'), ('BYR', 'Belarussian Ruble'), ('BZD', 'Belize Dollar'), ('BMD', 'Bermudian Dollar (customarily known as Bermuda Dollar)'), ('BTN', 'Bhutanese ngultrum'), ('VEF', 'Bolivar Fuerte'), ('BOB', 'Boliviano'), ('XBA', 'Bond Markets Units European Composite Unit (EURCO)'), ('BRL', 'Brazilian Real'), ('BND', 'Brunei Dollar'), ('BGN', 'Bulgarian Lev'), ('BIF', 'Burundi Franc'), ('XOF', 'CFA Franc BCEAO'), ('XAF', 'CFA franc BEAC'), ('XPF', 'CFP Franc'), ('CAD', 'Canadian Dollar'), ('CVE', 'Cape Verde Escudo'), ('KYD', 'Cayman Islands Dollar'), ('CLP', 'Chilean peso'), ('XTS', 'Codes specifically reserved for testing purposes'), ('COP', 'Colombian peso'), ('KMF', 'Comoro Franc'), ('CDF', 'Congolese franc'), ('BAM', 'Convertible Marks'), ('NIO', 'Cordoba Oro'), ('CRC', 'Costa Rican Colon'), ('HRK', 'Croatian Kuna'), ('CUP', 'Cuban Peso'), ('CUC', 'Cuban convertible peso'), ('CZK', 'Czech Koruna'), ('GMD', 'Dalasi'), ('DKK', 'Danish Krone'), ('MKD', 'Denar'), ('DJF', 'Djibouti Franc'), ('STD', 'Dobra'), ('DOP', 'Dominican Peso'), ('VND', 'Dong'), ('XCD', 'East Caribbean Dollar'), ('EGP', 'Egyptian Pound'), ('SVC', 'El Salvador Colon'), ('ETB', 'Ethiopian Birr'), ('EUR', 'Euro'), ('XBB', 'European Monetary Unit (E.M.U.-6)'), ('XBD', 'European Unit of Account 17(E.U.A.-17)'), ('XBC', 'European Unit of Account 9(E.U.A.-9)'), ('FKP', 'Falkland Islands Pound'), ('FJD', 'Fiji Dollar'), ('HUF', 'Forint'), ('GHS', 'Ghana Cedi'), ('GIP', 'Gibraltar Pound'), ('XAU', 'Gold'), ('XFO', 'Gold-Franc'), ('PYG', 'Guarani'), ('GNF', 'Guinea Franc'), ('GYD', 'Guyana Dollar'), ('HTG', 'Haitian gourde'), ('HKD', 'Hong Kong Dollar'), ('UAH', 'Hryvnia'), ('ISK', 'Iceland Krona'), ('INR', 'Indian Rupee'), ('IRR', 'Iranian Rial'), ('IQD', 'Iraqi Dinar'), ('IMP', 'Isle of Man Pound'), ('JMD', 'Jamaican Dollar'), ('JOD', 'Jordanian Dinar'), ('KES', 'Kenyan Shilling'), ('PGK', 'Kina'), ('LAK', 'Kip'), ('KWD', 'Kuwaiti Dinar'), ('AOA', 'Kwanza'), ('MMK', 'Kyat'), ('GEL', 'Lari'), ('LVL', 'Latvian Lats'), ('LBP', 'Lebanese Pound'), ('ALL', 'Lek'), ('HNL', 'Lempira'), ('SLL', 'Leone'), ('LSL', 'Lesotho loti'), ('LRD', 'Liberian Dollar'), ('LYD', 'Libyan Dinar'), ('SZL', 'Lilangeni'), ('LTL', 'Lithuanian Litas'), ('MGA', 'Malagasy Ariary'), ('MWK', 'Malawian Kwacha'), ('MYR', 'Malaysian Ringgit'), ('TMM', 'Manat'), ('MUR', 'Mauritius Rupee'), ('MZN', 'Metical'), ('MXV', 'Mexican Unidad de Inversion (UDI)'), ('MXN', 'Mexican peso'), ('MDL', 'Moldovan Leu'), ('MAD', 'Moroccan Dirham'), ('BOV', 'Mvdol'), ('NGN', 'Naira'), ('ERN', 'Nakfa'), ('NAD', 'Namibian Dollar'), ('NPR', 'Nepalese Rupee'), ('ANG', 'Netherlands Antillian Guilder'), ('ILS', 'New Israeli Sheqel'), ('RON', 'New Leu'), ('TWD', 'New Taiwan Dollar'), ('NZD', 'New Zealand Dollar'), ('KPW', 'North Korean Won'), ('NOK', 'Norwegian Krone'), ('PEN', 'Nuevo Sol'), ('MRO', 'Ouguiya'), ('TOP', 'Paanga'), ('PKR', 'Pakistan Rupee'), ('XPD', 'Palladium'), ('MOP', 'Pataca'), ('PHP', 'Philippine Peso'), ('XPT', 'Platinum'), ('GBP', 'Pound Sterling'), ('BWP', 'Pula'), ('QAR', 'Qatari Rial'), ('GTQ', 'Quetzal'), ('ZAR', 'Rand'), ('OMR', 'Rial Omani'), ('KHR', 'Riel'), ('MVR', 'Rufiyaa'), ('IDR', 'Rupiah'), ('RUB', 'Russian Ruble'), ('RWF', 'Rwanda Franc'), ('XDR', 'SDR'), ('SHP', 'Saint Helena Pound'), ('SAR', 'Saudi Riyal'), ('RSD', 'Serbian Dinar'), ('SCR', 'Seychelles Rupee'), ('XAG', 'Silver'), ('SGD', 'Singapore Dollar'), ('SBD', 'Solomon Islands Dollar'), ('KGS', 'Som'), ('SOS', 'Somali Shilling'), ('TJS', 'Somoni'), ('SSP', 'South Sudanese Pound'), ('LKR', 'Sri Lanka Rupee'), ('XSU', 'Sucre'), ('SDG', 'Sudanese Pound'), ('SRD', 'Surinam Dollar'), ('SEK', 'Swedish Krona'), ('CHF', 'Swiss Franc'), ('SYP', 'Syrian Pound'), ('BDT', 'Taka'), ('WST', 'Tala'), ('TZS', 'Tanzanian Shilling'), ('KZT', 'Tenge'), ('XXX', 'The codes assigned for transactions where no currency is involved'), ('TTD', 'Trinidad and Tobago Dollar'), ('MNT', 'Tugrik'), ('TND', 'Tunisian Dinar'), ('TRY', 'Turkish Lira'), ('TMT', 'Turkmenistan New Manat'), ('TVD', 'Tuvalu dollar'), ('AED', 'UAE Dirham'), ('XFU', 'UIC-Franc'), ('USD', 'US Dollar'), ('USN', 'US Dollar (Next day)'), ('UGX', 'Uganda Shilling'), ('CLF', 'Unidad de Fomento'), ('COU', 'Unidad de Valor Real'), ('UYI', 'Uruguay Peso en Unidades Indexadas (URUIURUI)'), ('UYU', 'Uruguayan peso'), ('UZS', 'Uzbekistan Sum'), ('VUV', 'Vatu'), ('CHE', 'WIR Euro'), ('CHW', 'WIR Franc'), ('KRW', 'Won'), ('YER', 'Yemeni Rial'), ('JPY', 'Yen'), ('CNY', 'Yuan Renminbi'), ('ZMK', 'Zambian Kwacha'), ('ZMW', 'Zambian Kwacha'), ('ZWD', 'Zimbabwe Dollar A/06'), ('ZWN', 'Zimbabwe dollar A/08'), ('ZWL', 'Zimbabwe dollar A/09'), ('PLN', 'Zloty')], default='GBP', editable=False, max_length=3)),
                ('cost', djmoney.models.fields.MoneyField(blank=True, decimal_places=2, default_currency='GBP', help_text='Price paid for this camera', max_digits=12, null=True)),
                ('serial', models.CharField(blank=True, help_text='Serial number of the camera', max_length=45, null=True)),
                ('datecode', models.CharField(blank=True, help_text='Date code of the camera, if different from the serial number', max_length=45, null=True)),
                ('manufactured', models.PositiveIntegerField(blank=True, help_text='Year of manufacture of the camera', null=True)),
                ('own', models.BooleanField(blank=True, help_text='Whether the camera is currently owned', null=True)),
                ('notes', models.CharField(blank=True, help_text='Freeform text field for extra notes', max_length=100, null=True)),
                ('lost', models.DateField(blank=True, help_text='Date on which the camera was lost/sold/etc', null=True)),
                ('lost_price_currency', djmoney.models.fields.CurrencyField(choices=[('XUA', 'ADB Unit of Account'), ('AFN', 'Afghani'), ('DZD', 'Algerian Dinar'), ('ARS', 'Argentine Peso'), ('AMD', 'Armenian Dram'), ('AWG', 'Aruban Guilder'), ('AUD', 'Australian Dollar'), ('AZN', 'Azerbaijanian Manat'), ('BSD', 'Bahamian Dollar'), ('BHD', 'Bahraini Dinar'), ('THB', 'Baht'), ('PAB', 'Balboa'), ('BBD', 'Barbados Dollar'), ('BYN', 'Belarussian Ruble'), ('BYR', 'Belarussian Ruble'), ('BZD', 'Belize Dollar'), ('BMD', 'Bermudian Dollar (customarily known as Bermuda Dollar)'), ('BTN', 'Bhutanese ngultrum'), ('VEF', 'Bolivar Fuerte'), ('BOB', 'Boliviano'), ('XBA', 'Bond Markets Units European Composite Unit (EURCO)'), ('BRL', 'Brazilian Real'), ('BND', 'Brunei Dollar'), ('BGN', 'Bulgarian Lev'), ('BIF', 'Burundi Franc'), ('XOF', 'CFA Franc BCEAO'), ('XAF', 'CFA franc BEAC'), ('XPF', 'CFP Franc'), ('CAD', 'Canadian Dollar'), ('CVE', 'Cape Verde Escudo'), ('KYD', 'Cayman Islands Dollar'), ('CLP', 'Chilean peso'), ('XTS', 'Codes specifically reserved for testing purposes'), ('COP', 'Colombian peso'), ('KMF', 'Comoro Franc'), ('CDF', 'Congolese franc'), ('BAM', 'Convertible Marks'), ('NIO', 'Cordoba Oro'), ('CRC', 'Costa Rican Colon'), ('HRK', 'Croatian Kuna'), ('CUP', 'Cuban Peso'), ('CUC', 'Cuban convertible peso'), ('CZK', 'Czech Koruna'), ('GMD', 'Dalasi'), ('DKK', 'Danish Krone'), ('MKD', 'Denar'), ('DJF', 'Djibouti Franc'), ('STD', 'Dobra'), ('DOP', 'Dominican Peso'), ('VND', 'Dong'), ('XCD', 'East Caribbean Dollar'), ('EGP', 'Egyptian Pound'), ('SVC', 'El Salvador Colon'), ('ETB', 'Ethiopian Birr'), ('EUR', 'Euro'), ('XBB', 'European Monetary Unit (E.M.U.-6)'), ('XBD', 'European Unit of Account 17(E.U.A.-17)'), ('XBC', 'European Unit of Account 9(E.U.A.-9)'), ('FKP', 'Falkland Islands Pound'), ('FJD', 'Fiji Dollar'), ('HUF', 'Forint'), ('GHS', 'Ghana Cedi'), ('GIP', 'Gibraltar Pound'), ('XAU', 'Gold'), ('XFO', 'Gold-Franc'), ('PYG', 'Guarani'), ('GNF', 'Guinea Franc'), ('GYD', 'Guyana Dollar'), ('HTG', 'Haitian gourde'), ('HKD', 'Hong Kong Dollar'), ('UAH', 'Hryvnia'), ('ISK', 'Iceland Krona'), ('INR', 'Indian Rupee'), ('IRR', 'Iranian Rial'), ('IQD', 'Iraqi Dinar'), ('IMP', 'Isle of Man Pound'), ('JMD', 'Jamaican Dollar'), ('JOD', 'Jordanian Dinar'), ('KES', 'Kenyan Shilling'), ('PGK', 'Kina'), ('LAK', 'Kip'), ('KWD', 'Kuwaiti Dinar'), ('AOA', 'Kwanza'), ('MMK', 'Kyat'), ('GEL', 'Lari'), ('LVL', 'Latvian Lats'), ('LBP', 'Lebanese Pound'), ('ALL', 'Lek'), ('HNL', 'Lempira'), ('SLL', 'Leone'), ('LSL', 'Lesotho loti'), ('LRD', 'Liberian Dollar'), ('LYD', 'Libyan Dinar'), ('SZL', 'Lilangeni'), ('LTL', 'Lithuanian Litas'), ('MGA', 'Malagasy Ariary'), ('MWK', 'Malawian Kwacha'), ('MYR', 'Malaysian Ringgit'), ('TMM', 'Manat'), ('MUR', 'Mauritius Rupee'), ('MZN', 'Metical'), ('MXV', 'Mexican Unidad de Inversion (UDI)'), ('MXN', 'Mexican peso'), ('MDL', 'Moldovan Leu'), ('MAD', 'Moroccan Dirham'), ('BOV', 'Mvdol'), ('NGN', 'Naira'), ('ERN', 'Nakfa'), ('NAD', 'Namibian Dollar'), ('NPR', 'Nepalese Rupee'), ('ANG', 'Netherlands Antillian Guilder'), ('ILS', 'New Israeli Sheqel'), ('RON', 'New Leu'), ('TWD', 'New Taiwan Dollar'), ('NZD', 'New Zealand Dollar'), ('KPW', 'North Korean Won'), ('NOK', 'Norwegian Krone'), ('PEN', 'Nuevo Sol'), ('MRO', 'Ouguiya'), ('TOP', 'Paanga'), ('PKR', 'Pakistan Rupee'), ('XPD', 'Palladium'), ('MOP', 'Pataca'), ('PHP', 'Philippine Peso'), ('XPT', 'Platinum'), ('GBP', 'Pound Sterling'), ('BWP', 'Pula'), ('QAR', 'Qatari Rial'), ('GTQ', 'Quetzal'), ('ZAR', 'Rand'), ('OMR', 'Rial Omani'), ('KHR', 'Riel'), ('MVR', 'Rufiyaa'), ('IDR', 'Rupiah'), ('RUB', 'Russian Ruble'), ('RWF', 'Rwanda Franc'), ('XDR', 'SDR'), ('SHP', 'Saint Helena Pound'), ('SAR', 'Saudi Riyal'), ('RSD', 'Serbian Dinar'), ('SCR', 'Seychelles Rupee'), ('XAG', 'Silver'), ('SGD', 'Singapore Dollar'), ('SBD', 'Solomon Islands Dollar'), ('KGS', 'Som'), ('SOS', 'Somali Shilling'), ('TJS', 'Somoni'), ('SSP', 'South Sudanese Pound'), ('LKR', 'Sri Lanka Rupee'), ('XSU', 'Sucre'), ('SDG', 'Sudanese Pound'), ('SRD', 'Surinam Dollar'), ('SEK', 'Swedish Krona'), ('CHF', 'Swiss Franc'), ('SYP', 'Syrian Pound'), ('BDT', 'Taka'), ('WST', 'Tala'), ('TZS', 'Tanzanian Shilling'), ('KZT', 'Tenge'), ('XXX', 'The codes assigned for transactions where no currency is involved'), ('TTD', 'Trinidad and Tobago Dollar'), ('MNT', 'Tugrik'), ('TND', 'Tunisian Dinar'), ('TRY', 'Turkish Lira'), ('TMT', 'Turkmenistan New Manat'), ('TVD', 'Tuvalu dollar'), ('AED', 'UAE Dirham'), ('XFU', 'UIC-Franc'), ('USD', 'US Dollar'), ('USN', 'US Dollar (Next day)'), ('UGX', 'Uganda Shilling'), ('CLF', 'Unidad de Fomento'), ('COU', 'Unidad de Valor Real'), ('UYI', 'Uruguay Peso en Unidades Indexadas (URUIURUI)'), ('UYU', 'Uruguayan peso'), ('UZS', 'Uzbekistan Sum'), ('VUV', 'Vatu'), ('CHE', 'WIR Euro'), ('CHW', 'WIR Franc'), ('KRW', 'Won'), ('YER', 'Yemeni Rial'), ('JPY', 'Yen'), ('CNY', 'Yuan Renminbi'), ('ZMK', 'Zambian Kwacha'), ('ZMW', 'Zambian Kwacha'), ('ZWD', 'Zimbabwe Dollar A/06'), ('ZWN', 'Zimbabwe dollar A/08'), ('ZWL', 'Zimbabwe dollar A/09'), ('PLN', 'Zloty')], default='GBP', editable=False, max_length=3)),
                ('lost_price', djmoney.models.fields.MoneyField(blank=True, decimal_places=2, default_currency='GBP', help_text='Sale price of the camera', max_digits=12, null=True)),
                ('source', models.CharField(blank=True, help_text='Where the camera was acquired from', max_length=150, null=True)),
                ('condition_notes', models.CharField(blank=True, help_text='Description of condition', max_length=150, null=True)),
            ],
            options={
                'verbose_name_plural': 'cameras',
                'ordering': ['cameramodel__manufacturer', 'cameramodel__model', 'serial'],
            },
        ),
        migrations.CreateModel(
            name='Condition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(help_text='Condition shortcode (e.g. EXC)', max_length=6)),
                ('name', models.CharField(help_text='Full name of condition (e.g. Excellent)', max_length=45)),
                ('min_rating', models.PositiveIntegerField(help_text='The lowest percentage rating that encompasses this condition', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(100)])),
                ('max_rating', models.PositiveIntegerField(help_text='The highest percentage rating that encompasses this condition', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(100)])),
                ('description', models.CharField(help_text='Longer description of condition', max_length=300)),
            ],
            options={
                'verbose_name_plural': 'conditions',
            },
        ),
        migrations.CreateModel(
            name='Developer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of the developer', max_length=45)),
                ('for_paper', models.BooleanField(blank=True, help_text='Whether this developer can be used with paper', null=True)),
                ('for_film', models.BooleanField(blank=True, help_text='Whether this developer can be used with film', null=True)),
                ('chemistry', models.CharField(blank=True, help_text='The key chemistry on which this developer is based (e.g. phenidone)', max_length=45, null=True)),
            ],
            options={
                'verbose_name_plural': 'developers',
                'ordering': ['manufacturer', 'name'],
            },
        ),
        migrations.CreateModel(
            name='Enlarger',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model', models.CharField(help_text='Name/model of the enlarger', max_length=45)),
                ('type', models.CharField(blank=True, choices=[('Diffusion', 'Diffusion'), ('Condenser', 'Condenser')], help_text='The type of optical system in the enlarger', max_length=15, null=True)),
                ('light_source', models.CharField(blank=True, choices=[('Incandescent', 'Incandescent'), ('Cold cathode', 'Cold cathode'), ('LED', 'LED')], help_text='The type of light source used in the enlarger', max_length=15, null=True)),
                ('acquired', models.DateField(blank=True, help_text='Date on which the enlarger was acquired', null=True)),
                ('lost', models.DateField(blank=True, help_text='Date on which the enlarger was lost/sold', null=True)),
                ('introduced', models.PositiveIntegerField(blank=True, help_text='Year in which the enlarger was introduced', null=True)),
                ('discontinued', models.PositiveIntegerField(blank=True, help_text='Year in which the enlarger was discontinued', null=True)),
                ('cost_currency', djmoney.models.fields.CurrencyField(choices=[('XUA', 'ADB Unit of Account'), ('AFN', 'Afghani'), ('DZD', 'Algerian Dinar'), ('ARS', 'Argentine Peso'), ('AMD', 'Armenian Dram'), ('AWG', 'Aruban Guilder'), ('AUD', 'Australian Dollar'), ('AZN', 'Azerbaijanian Manat'), ('BSD', 'Bahamian Dollar'), ('BHD', 'Bahraini Dinar'), ('THB', 'Baht'), ('PAB', 'Balboa'), ('BBD', 'Barbados Dollar'), ('BYN', 'Belarussian Ruble'), ('BYR', 'Belarussian Ruble'), ('BZD', 'Belize Dollar'), ('BMD', 'Bermudian Dollar (customarily known as Bermuda Dollar)'), ('BTN', 'Bhutanese ngultrum'), ('VEF', 'Bolivar Fuerte'), ('BOB', 'Boliviano'), ('XBA', 'Bond Markets Units European Composite Unit (EURCO)'), ('BRL', 'Brazilian Real'), ('BND', 'Brunei Dollar'), ('BGN', 'Bulgarian Lev'), ('BIF', 'Burundi Franc'), ('XOF', 'CFA Franc BCEAO'), ('XAF', 'CFA franc BEAC'), ('XPF', 'CFP Franc'), ('CAD', 'Canadian Dollar'), ('CVE', 'Cape Verde Escudo'), ('KYD', 'Cayman Islands Dollar'), ('CLP', 'Chilean peso'), ('XTS', 'Codes specifically reserved for testing purposes'), ('COP', 'Colombian peso'), ('KMF', 'Comoro Franc'), ('CDF', 'Congolese franc'), ('BAM', 'Convertible Marks'), ('NIO', 'Cordoba Oro'), ('CRC', 'Costa Rican Colon'), ('HRK', 'Croatian Kuna'), ('CUP', 'Cuban Peso'), ('CUC', 'Cuban convertible peso'), ('CZK', 'Czech Koruna'), ('GMD', 'Dalasi'), ('DKK', 'Danish Krone'), ('MKD', 'Denar'), ('DJF', 'Djibouti Franc'), ('STD', 'Dobra'), ('DOP', 'Dominican Peso'), ('VND', 'Dong'), ('XCD', 'East Caribbean Dollar'), ('EGP', 'Egyptian Pound'), ('SVC', 'El Salvador Colon'), ('ETB', 'Ethiopian Birr'), ('EUR', 'Euro'), ('XBB', 'European Monetary Unit (E.M.U.-6)'), ('XBD', 'European Unit of Account 17(E.U.A.-17)'), ('XBC', 'European Unit of Account 9(E.U.A.-9)'), ('FKP', 'Falkland Islands Pound'), ('FJD', 'Fiji Dollar'), ('HUF', 'Forint'), ('GHS', 'Ghana Cedi'), ('GIP', 'Gibraltar Pound'), ('XAU', 'Gold'), ('XFO', 'Gold-Franc'), ('PYG', 'Guarani'), ('GNF', 'Guinea Franc'), ('GYD', 'Guyana Dollar'), ('HTG', 'Haitian gourde'), ('HKD', 'Hong Kong Dollar'), ('UAH', 'Hryvnia'), ('ISK', 'Iceland Krona'), ('INR', 'Indian Rupee'), ('IRR', 'Iranian Rial'), ('IQD', 'Iraqi Dinar'), ('IMP', 'Isle of Man Pound'), ('JMD', 'Jamaican Dollar'), ('JOD', 'Jordanian Dinar'), ('KES', 'Kenyan Shilling'), ('PGK', 'Kina'), ('LAK', 'Kip'), ('KWD', 'Kuwaiti Dinar'), ('AOA', 'Kwanza'), ('MMK', 'Kyat'), ('GEL', 'Lari'), ('LVL', 'Latvian Lats'), ('LBP', 'Lebanese Pound'), ('ALL', 'Lek'), ('HNL', 'Lempira'), ('SLL', 'Leone'), ('LSL', 'Lesotho loti'), ('LRD', 'Liberian Dollar'), ('LYD', 'Libyan Dinar'), ('SZL', 'Lilangeni'), ('LTL', 'Lithuanian Litas'), ('MGA', 'Malagasy Ariary'), ('MWK', 'Malawian Kwacha'), ('MYR', 'Malaysian Ringgit'), ('TMM', 'Manat'), ('MUR', 'Mauritius Rupee'), ('MZN', 'Metical'), ('MXV', 'Mexican Unidad de Inversion (UDI)'), ('MXN', 'Mexican peso'), ('MDL', 'Moldovan Leu'), ('MAD', 'Moroccan Dirham'), ('BOV', 'Mvdol'), ('NGN', 'Naira'), ('ERN', 'Nakfa'), ('NAD', 'Namibian Dollar'), ('NPR', 'Nepalese Rupee'), ('ANG', 'Netherlands Antillian Guilder'), ('ILS', 'New Israeli Sheqel'), ('RON', 'New Leu'), ('TWD', 'New Taiwan Dollar'), ('NZD', 'New Zealand Dollar'), ('KPW', 'North Korean Won'), ('NOK', 'Norwegian Krone'), ('PEN', 'Nuevo Sol'), ('MRO', 'Ouguiya'), ('TOP', 'Paanga'), ('PKR', 'Pakistan Rupee'), ('XPD', 'Palladium'), ('MOP', 'Pataca'), ('PHP', 'Philippine Peso'), ('XPT', 'Platinum'), ('GBP', 'Pound Sterling'), ('BWP', 'Pula'), ('QAR', 'Qatari Rial'), ('GTQ', 'Quetzal'), ('ZAR', 'Rand'), ('OMR', 'Rial Omani'), ('KHR', 'Riel'), ('MVR', 'Rufiyaa'), ('IDR', 'Rupiah'), ('RUB', 'Russian Ruble'), ('RWF', 'Rwanda Franc'), ('XDR', 'SDR'), ('SHP', 'Saint Helena Pound'), ('SAR', 'Saudi Riyal'), ('RSD', 'Serbian Dinar'), ('SCR', 'Seychelles Rupee'), ('XAG', 'Silver'), ('SGD', 'Singapore Dollar'), ('SBD', 'Solomon Islands Dollar'), ('KGS', 'Som'), ('SOS', 'Somali Shilling'), ('TJS', 'Somoni'), ('SSP', 'South Sudanese Pound'), ('LKR', 'Sri Lanka Rupee'), ('XSU', 'Sucre'), ('SDG', 'Sudanese Pound'), ('SRD', 'Surinam Dollar'), ('SEK', 'Swedish Krona'), ('CHF', 'Swiss Franc'), ('SYP', 'Syrian Pound'), ('BDT', 'Taka'), ('WST', 'Tala'), ('TZS', 'Tanzanian Shilling'), ('KZT', 'Tenge'), ('XXX', 'The codes assigned for transactions where no currency is involved'), ('TTD', 'Trinidad and Tobago Dollar'), ('MNT', 'Tugrik'), ('TND', 'Tunisian Dinar'), ('TRY', 'Turkish Lira'), ('TMT', 'Turkmenistan New Manat'), ('TVD', 'Tuvalu dollar'), ('AED', 'UAE Dirham'), ('XFU', 'UIC-Franc'), ('USD', 'US Dollar'), ('USN', 'US Dollar (Next day)'), ('UGX', 'Uganda Shilling'), ('CLF', 'Unidad de Fomento'), ('COU', 'Unidad de Valor Real'), ('UYI', 'Uruguay Peso en Unidades Indexadas (URUIURUI)'), ('UYU', 'Uruguayan peso'), ('UZS', 'Uzbekistan Sum'), ('VUV', 'Vatu'), ('CHE', 'WIR Euro'), ('CHW', 'WIR Franc'), ('KRW', 'Won'), ('YER', 'Yemeni Rial'), ('JPY', 'Yen'), ('CNY', 'Yuan Renminbi'), ('ZMK', 'Zambian Kwacha'), ('ZMW', 'Zambian Kwacha'), ('ZWD', 'Zimbabwe Dollar A/06'), ('ZWN', 'Zimbabwe dollar A/08'), ('ZWL', 'Zimbabwe dollar A/09'), ('PLN', 'Zloty')], default='GBP', editable=False, max_length=3)),
                ('cost', djmoney.models.fields.MoneyField(blank=True, decimal_places=2, default_currency='GBP', help_text='Purchase cost of this enlarger', max_digits=12, null=True)),
                ('lost_price_currency', djmoney.models.fields.CurrencyField(choices=[('XUA', 'ADB Unit of Account'), ('AFN', 'Afghani'), ('DZD', 'Algerian Dinar'), ('ARS', 'Argentine Peso'), ('AMD', 'Armenian Dram'), ('AWG', 'Aruban Guilder'), ('AUD', 'Australian Dollar'), ('AZN', 'Azerbaijanian Manat'), ('BSD', 'Bahamian Dollar'), ('BHD', 'Bahraini Dinar'), ('THB', 'Baht'), ('PAB', 'Balboa'), ('BBD', 'Barbados Dollar'), ('BYN', 'Belarussian Ruble'), ('BYR', 'Belarussian Ruble'), ('BZD', 'Belize Dollar'), ('BMD', 'Bermudian Dollar (customarily known as Bermuda Dollar)'), ('BTN', 'Bhutanese ngultrum'), ('VEF', 'Bolivar Fuerte'), ('BOB', 'Boliviano'), ('XBA', 'Bond Markets Units European Composite Unit (EURCO)'), ('BRL', 'Brazilian Real'), ('BND', 'Brunei Dollar'), ('BGN', 'Bulgarian Lev'), ('BIF', 'Burundi Franc'), ('XOF', 'CFA Franc BCEAO'), ('XAF', 'CFA franc BEAC'), ('XPF', 'CFP Franc'), ('CAD', 'Canadian Dollar'), ('CVE', 'Cape Verde Escudo'), ('KYD', 'Cayman Islands Dollar'), ('CLP', 'Chilean peso'), ('XTS', 'Codes specifically reserved for testing purposes'), ('COP', 'Colombian peso'), ('KMF', 'Comoro Franc'), ('CDF', 'Congolese franc'), ('BAM', 'Convertible Marks'), ('NIO', 'Cordoba Oro'), ('CRC', 'Costa Rican Colon'), ('HRK', 'Croatian Kuna'), ('CUP', 'Cuban Peso'), ('CUC', 'Cuban convertible peso'), ('CZK', 'Czech Koruna'), ('GMD', 'Dalasi'), ('DKK', 'Danish Krone'), ('MKD', 'Denar'), ('DJF', 'Djibouti Franc'), ('STD', 'Dobra'), ('DOP', 'Dominican Peso'), ('VND', 'Dong'), ('XCD', 'East Caribbean Dollar'), ('EGP', 'Egyptian Pound'), ('SVC', 'El Salvador Colon'), ('ETB', 'Ethiopian Birr'), ('EUR', 'Euro'), ('XBB', 'European Monetary Unit (E.M.U.-6)'), ('XBD', 'European Unit of Account 17(E.U.A.-17)'), ('XBC', 'European Unit of Account 9(E.U.A.-9)'), ('FKP', 'Falkland Islands Pound'), ('FJD', 'Fiji Dollar'), ('HUF', 'Forint'), ('GHS', 'Ghana Cedi'), ('GIP', 'Gibraltar Pound'), ('XAU', 'Gold'), ('XFO', 'Gold-Franc'), ('PYG', 'Guarani'), ('GNF', 'Guinea Franc'), ('GYD', 'Guyana Dollar'), ('HTG', 'Haitian gourde'), ('HKD', 'Hong Kong Dollar'), ('UAH', 'Hryvnia'), ('ISK', 'Iceland Krona'), ('INR', 'Indian Rupee'), ('IRR', 'Iranian Rial'), ('IQD', 'Iraqi Dinar'), ('IMP', 'Isle of Man Pound'), ('JMD', 'Jamaican Dollar'), ('JOD', 'Jordanian Dinar'), ('KES', 'Kenyan Shilling'), ('PGK', 'Kina'), ('LAK', 'Kip'), ('KWD', 'Kuwaiti Dinar'), ('AOA', 'Kwanza'), ('MMK', 'Kyat'), ('GEL', 'Lari'), ('LVL', 'Latvian Lats'), ('LBP', 'Lebanese Pound'), ('ALL', 'Lek'), ('HNL', 'Lempira'), ('SLL', 'Leone'), ('LSL', 'Lesotho loti'), ('LRD', 'Liberian Dollar'), ('LYD', 'Libyan Dinar'), ('SZL', 'Lilangeni'), ('LTL', 'Lithuanian Litas'), ('MGA', 'Malagasy Ariary'), ('MWK', 'Malawian Kwacha'), ('MYR', 'Malaysian Ringgit'), ('TMM', 'Manat'), ('MUR', 'Mauritius Rupee'), ('MZN', 'Metical'), ('MXV', 'Mexican Unidad de Inversion (UDI)'), ('MXN', 'Mexican peso'), ('MDL', 'Moldovan Leu'), ('MAD', 'Moroccan Dirham'), ('BOV', 'Mvdol'), ('NGN', 'Naira'), ('ERN', 'Nakfa'), ('NAD', 'Namibian Dollar'), ('NPR', 'Nepalese Rupee'), ('ANG', 'Netherlands Antillian Guilder'), ('ILS', 'New Israeli Sheqel'), ('RON', 'New Leu'), ('TWD', 'New Taiwan Dollar'), ('NZD', 'New Zealand Dollar'), ('KPW', 'North Korean Won'), ('NOK', 'Norwegian Krone'), ('PEN', 'Nuevo Sol'), ('MRO', 'Ouguiya'), ('TOP', 'Paanga'), ('PKR', 'Pakistan Rupee'), ('XPD', 'Palladium'), ('MOP', 'Pataca'), ('PHP', 'Philippine Peso'), ('XPT', 'Platinum'), ('GBP', 'Pound Sterling'), ('BWP', 'Pula'), ('QAR', 'Qatari Rial'), ('GTQ', 'Quetzal'), ('ZAR', 'Rand'), ('OMR', 'Rial Omani'), ('KHR', 'Riel'), ('MVR', 'Rufiyaa'), ('IDR', 'Rupiah'), ('RUB', 'Russian Ruble'), ('RWF', 'Rwanda Franc'), ('XDR', 'SDR'), ('SHP', 'Saint Helena Pound'), ('SAR', 'Saudi Riyal'), ('RSD', 'Serbian Dinar'), ('SCR', 'Seychelles Rupee'), ('XAG', 'Silver'), ('SGD', 'Singapore Dollar'), ('SBD', 'Solomon Islands Dollar'), ('KGS', 'Som'), ('SOS', 'Somali Shilling'), ('TJS', 'Somoni'), ('SSP', 'South Sudanese Pound'), ('LKR', 'Sri Lanka Rupee'), ('XSU', 'Sucre'), ('SDG', 'Sudanese Pound'), ('SRD', 'Surinam Dollar'), ('SEK', 'Swedish Krona'), ('CHF', 'Swiss Franc'), ('SYP', 'Syrian Pound'), ('BDT', 'Taka'), ('WST', 'Tala'), ('TZS', 'Tanzanian Shilling'), ('KZT', 'Tenge'), ('XXX', 'The codes assigned for transactions where no currency is involved'), ('TTD', 'Trinidad and Tobago Dollar'), ('MNT', 'Tugrik'), ('TND', 'Tunisian Dinar'), ('TRY', 'Turkish Lira'), ('TMT', 'Turkmenistan New Manat'), ('TVD', 'Tuvalu dollar'), ('AED', 'UAE Dirham'), ('XFU', 'UIC-Franc'), ('USD', 'US Dollar'), ('USN', 'US Dollar (Next day)'), ('UGX', 'Uganda Shilling'), ('CLF', 'Unidad de Fomento'), ('COU', 'Unidad de Valor Real'), ('UYI', 'Uruguay Peso en Unidades Indexadas (URUIURUI)'), ('UYU', 'Uruguayan peso'), ('UZS', 'Uzbekistan Sum'), ('VUV', 'Vatu'), ('CHE', 'WIR Euro'), ('CHW', 'WIR Franc'), ('KRW', 'Won'), ('YER', 'Yemeni Rial'), ('JPY', 'Yen'), ('CNY', 'Yuan Renminbi'), ('ZMK', 'Zambian Kwacha'), ('ZMW', 'Zambian Kwacha'), ('ZWD', 'Zimbabwe Dollar A/06'), ('ZWN', 'Zimbabwe dollar A/08'), ('ZWL', 'Zimbabwe dollar A/09'), ('PLN', 'Zloty')], default='GBP', editable=False, max_length=3)),
                ('lost_price', djmoney.models.fields.MoneyField(blank=True, decimal_places=2, default_currency='GBP', help_text='Sale price of the enlarger', max_digits=12, null=True)),
            ],
            options={
                'verbose_name_plural': 'enlargers',
                'ordering': ['manufacturer', 'model'],
            },
        ),
        migrations.CreateModel(
            name='ExposureProgram',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of exposure program as defined by EXIF tag ExposureProgram', max_length=45)),
            ],
            options={
                'verbose_name_plural': 'exposure programs',
            },
        ),
        migrations.CreateModel(
            name='Film',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('exposed_at', models.PositiveIntegerField(blank=True, help_text='ISO at which the film was exposed', null=True)),
                ('date_loaded', models.DateField(blank=True, help_text='Date when the film was loaded into a camera', null=True)),
                ('date_processed', models.DateField(blank=True, help_text='Date when the film was processed', null=True)),
                ('title', models.CharField(blank=True, help_text='Title of the film', max_length=150, null=True)),
                ('frames', models.PositiveIntegerField(blank=True, help_text='Expected (not actual) number of frames from the film', null=True)),
                ('directory', models.CharField(blank=True, help_text='Name of the directory that contains the scanned images from this film', max_length=100, null=True)),
                ('dev_uses', models.PositiveIntegerField(blank=True, help_text='Number of previous uses of the developer', null=True)),
                ('dev_time', models.DurationField(blank=True, help_text='Duration of development', null=True)),
                ('dev_temp', models.DecimalField(blank=True, decimal_places=1, help_text='Temperature of development', max_digits=3, null=True)),
                ('dev_n', models.IntegerField(blank=True, help_text='Number of the Push/Pull rating of the film, e.g. N+1, N-2', null=True)),
                ('development_notes', models.CharField(blank=True, help_text='Extra freeform notes about the development process', max_length=200, null=True)),
                ('bulk_film_loaded', models.DateField(blank=True, help_text='Date that this film was cut from a bulk roll', null=True)),
                ('film_batch', models.CharField(blank=True, help_text='Batch number of the film', max_length=45, null=True)),
                ('expiry_date', models.DateField(blank=True, help_text='Expiry date of the film', null=True)),
                ('purchase_date', models.DateField(blank=True, help_text='Date this film was purchased', null=True)),
                ('price_currency', djmoney.models.fields.CurrencyField(choices=[('XUA', 'ADB Unit of Account'), ('AFN', 'Afghani'), ('DZD', 'Algerian Dinar'), ('ARS', 'Argentine Peso'), ('AMD', 'Armenian Dram'), ('AWG', 'Aruban Guilder'), ('AUD', 'Australian Dollar'), ('AZN', 'Azerbaijanian Manat'), ('BSD', 'Bahamian Dollar'), ('BHD', 'Bahraini Dinar'), ('THB', 'Baht'), ('PAB', 'Balboa'), ('BBD', 'Barbados Dollar'), ('BYN', 'Belarussian Ruble'), ('BYR', 'Belarussian Ruble'), ('BZD', 'Belize Dollar'), ('BMD', 'Bermudian Dollar (customarily known as Bermuda Dollar)'), ('BTN', 'Bhutanese ngultrum'), ('VEF', 'Bolivar Fuerte'), ('BOB', 'Boliviano'), ('XBA', 'Bond Markets Units European Composite Unit (EURCO)'), ('BRL', 'Brazilian Real'), ('BND', 'Brunei Dollar'), ('BGN', 'Bulgarian Lev'), ('BIF', 'Burundi Franc'), ('XOF', 'CFA Franc BCEAO'), ('XAF', 'CFA franc BEAC'), ('XPF', 'CFP Franc'), ('CAD', 'Canadian Dollar'), ('CVE', 'Cape Verde Escudo'), ('KYD', 'Cayman Islands Dollar'), ('CLP', 'Chilean peso'), ('XTS', 'Codes specifically reserved for testing purposes'), ('COP', 'Colombian peso'), ('KMF', 'Comoro Franc'), ('CDF', 'Congolese franc'), ('BAM', 'Convertible Marks'), ('NIO', 'Cordoba Oro'), ('CRC', 'Costa Rican Colon'), ('HRK', 'Croatian Kuna'), ('CUP', 'Cuban Peso'), ('CUC', 'Cuban convertible peso'), ('CZK', 'Czech Koruna'), ('GMD', 'Dalasi'), ('DKK', 'Danish Krone'), ('MKD', 'Denar'), ('DJF', 'Djibouti Franc'), ('STD', 'Dobra'), ('DOP', 'Dominican Peso'), ('VND', 'Dong'), ('XCD', 'East Caribbean Dollar'), ('EGP', 'Egyptian Pound'), ('SVC', 'El Salvador Colon'), ('ETB', 'Ethiopian Birr'), ('EUR', 'Euro'), ('XBB', 'European Monetary Unit (E.M.U.-6)'), ('XBD', 'European Unit of Account 17(E.U.A.-17)'), ('XBC', 'European Unit of Account 9(E.U.A.-9)'), ('FKP', 'Falkland Islands Pound'), ('FJD', 'Fiji Dollar'), ('HUF', 'Forint'), ('GHS', 'Ghana Cedi'), ('GIP', 'Gibraltar Pound'), ('XAU', 'Gold'), ('XFO', 'Gold-Franc'), ('PYG', 'Guarani'), ('GNF', 'Guinea Franc'), ('GYD', 'Guyana Dollar'), ('HTG', 'Haitian gourde'), ('HKD', 'Hong Kong Dollar'), ('UAH', 'Hryvnia'), ('ISK', 'Iceland Krona'), ('INR', 'Indian Rupee'), ('IRR', 'Iranian Rial'), ('IQD', 'Iraqi Dinar'), ('IMP', 'Isle of Man Pound'), ('JMD', 'Jamaican Dollar'), ('JOD', 'Jordanian Dinar'), ('KES', 'Kenyan Shilling'), ('PGK', 'Kina'), ('LAK', 'Kip'), ('KWD', 'Kuwaiti Dinar'), ('AOA', 'Kwanza'), ('MMK', 'Kyat'), ('GEL', 'Lari'), ('LVL', 'Latvian Lats'), ('LBP', 'Lebanese Pound'), ('ALL', 'Lek'), ('HNL', 'Lempira'), ('SLL', 'Leone'), ('LSL', 'Lesotho loti'), ('LRD', 'Liberian Dollar'), ('LYD', 'Libyan Dinar'), ('SZL', 'Lilangeni'), ('LTL', 'Lithuanian Litas'), ('MGA', 'Malagasy Ariary'), ('MWK', 'Malawian Kwacha'), ('MYR', 'Malaysian Ringgit'), ('TMM', 'Manat'), ('MUR', 'Mauritius Rupee'), ('MZN', 'Metical'), ('MXV', 'Mexican Unidad de Inversion (UDI)'), ('MXN', 'Mexican peso'), ('MDL', 'Moldovan Leu'), ('MAD', 'Moroccan Dirham'), ('BOV', 'Mvdol'), ('NGN', 'Naira'), ('ERN', 'Nakfa'), ('NAD', 'Namibian Dollar'), ('NPR', 'Nepalese Rupee'), ('ANG', 'Netherlands Antillian Guilder'), ('ILS', 'New Israeli Sheqel'), ('RON', 'New Leu'), ('TWD', 'New Taiwan Dollar'), ('NZD', 'New Zealand Dollar'), ('KPW', 'North Korean Won'), ('NOK', 'Norwegian Krone'), ('PEN', 'Nuevo Sol'), ('MRO', 'Ouguiya'), ('TOP', 'Paanga'), ('PKR', 'Pakistan Rupee'), ('XPD', 'Palladium'), ('MOP', 'Pataca'), ('PHP', 'Philippine Peso'), ('XPT', 'Platinum'), ('GBP', 'Pound Sterling'), ('BWP', 'Pula'), ('QAR', 'Qatari Rial'), ('GTQ', 'Quetzal'), ('ZAR', 'Rand'), ('OMR', 'Rial Omani'), ('KHR', 'Riel'), ('MVR', 'Rufiyaa'), ('IDR', 'Rupiah'), ('RUB', 'Russian Ruble'), ('RWF', 'Rwanda Franc'), ('XDR', 'SDR'), ('SHP', 'Saint Helena Pound'), ('SAR', 'Saudi Riyal'), ('RSD', 'Serbian Dinar'), ('SCR', 'Seychelles Rupee'), ('XAG', 'Silver'), ('SGD', 'Singapore Dollar'), ('SBD', 'Solomon Islands Dollar'), ('KGS', 'Som'), ('SOS', 'Somali Shilling'), ('TJS', 'Somoni'), ('SSP', 'South Sudanese Pound'), ('LKR', 'Sri Lanka Rupee'), ('XSU', 'Sucre'), ('SDG', 'Sudanese Pound'), ('SRD', 'Surinam Dollar'), ('SEK', 'Swedish Krona'), ('CHF', 'Swiss Franc'), ('SYP', 'Syrian Pound'), ('BDT', 'Taka'), ('WST', 'Tala'), ('TZS', 'Tanzanian Shilling'), ('KZT', 'Tenge'), ('XXX', 'The codes assigned for transactions where no currency is involved'), ('TTD', 'Trinidad and Tobago Dollar'), ('MNT', 'Tugrik'), ('TND', 'Tunisian Dinar'), ('TRY', 'Turkish Lira'), ('TMT', 'Turkmenistan New Manat'), ('TVD', 'Tuvalu dollar'), ('AED', 'UAE Dirham'), ('XFU', 'UIC-Franc'), ('USD', 'US Dollar'), ('USN', 'US Dollar (Next day)'), ('UGX', 'Uganda Shilling'), ('CLF', 'Unidad de Fomento'), ('COU', 'Unidad de Valor Real'), ('UYI', 'Uruguay Peso en Unidades Indexadas (URUIURUI)'), ('UYU', 'Uruguayan peso'), ('UZS', 'Uzbekistan Sum'), ('VUV', 'Vatu'), ('CHE', 'WIR Euro'), ('CHW', 'WIR Franc'), ('KRW', 'Won'), ('YER', 'Yemeni Rial'), ('JPY', 'Yen'), ('CNY', 'Yuan Renminbi'), ('ZMK', 'Zambian Kwacha'), ('ZMW', 'Zambian Kwacha'), ('ZWD', 'Zimbabwe Dollar A/06'), ('ZWN', 'Zimbabwe dollar A/08'), ('ZWL', 'Zimbabwe dollar A/09'), ('PLN', 'Zloty')], default='GBP', editable=False, max_length=3)),
                ('price', djmoney.models.fields.MoneyField(blank=True, decimal_places=2, default_currency='GBP', help_text='Price paid for this film', max_digits=12, null=True)),
                ('archive', models.ForeignKey(blank=True, help_text='Archive that this film is stored in', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Archive')),
                ('bulk_film', models.ForeignKey(blank=True, help_text='Bulk film this film was cut from', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.BulkFilm')),
                ('camera', models.ForeignKey(blank=True, help_text='Camera that this film was loaded into', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Camera')),
                ('developer', models.ForeignKey(blank=True, help_text='Developer used to develop this film', limit_choices_to={'for_film': True}, null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Developer')),
            ],
            options={
                'verbose_name_plural': 'films',
            },
        ),
        migrations.CreateModel(
            name='FilmStock',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of the filmstock', max_length=45)),
                ('iso', models.PositiveIntegerField(blank=True, help_text='Nominal ISO speed of the film', null=True, verbose_name='ISO')),
                ('colour', models.BooleanField(blank=True, help_text='Whether the film is colour', null=True)),
                ('panchromatic', models.BooleanField(blank=True, help_text='Whether this film is panchromatic', null=True)),
            ],
            options={
                'verbose_name_plural': 'film stocks',
                'ordering': ['manufacturer', 'name'],
            },
        ),
        migrations.CreateModel(
            name='Filter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(help_text='Filter type (e.g. Red, CPL, UV)', max_length=45)),
                ('thread', models.DecimalField(blank=True, decimal_places=1, help_text='Diameter of screw thread in mm', max_digits=4, null=True)),
                ('attenuation', models.DecimalField(blank=True, decimal_places=1, help_text='Attenuation of this filter in decimal stops', max_digits=3, null=True)),
                ('qty', models.PositiveIntegerField(blank=True, default=1, help_text='Quantity of these filters available', null=True)),
            ],
            options={
                'verbose_name_plural': 'filters',
                'ordering': ['thread', 'type'],
            },
        ),
        migrations.CreateModel(
            name='FilterAdapter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('camera_thread', models.DecimalField(decimal_places=1, help_text='Diameter of camera-facing screw thread in mm', max_digits=3)),
                ('filter_thread', models.DecimalField(decimal_places=1, help_text='Diameter of filter-facing screw thread in mm', max_digits=3)),
            ],
            options={
                'verbose_name_plural': 'filter adapters',
                'ordering': ['camera_thread', 'filter_thread'],
            },
        ),
        migrations.CreateModel(
            name='Format',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('format', models.CharField(help_text='The name of this film/sensor format', max_length=45, unique=True)),
                ('digital', models.BooleanField(blank=True, help_text='Whether this is a digital format', null=True)),
            ],
            options={
                'verbose_name_plural': 'formats',
                'ordering': ['format'],
            },
        ),
        migrations.CreateModel(
            name='Lens',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('serial', models.CharField(blank=True, help_text='Serial number of this lens', max_length=45, null=True)),
                ('date_code', models.CharField(blank=True, help_text='Date code of this lens, if different from the serial number', max_length=45, null=True)),
                ('manufactured', models.PositiveIntegerField(blank=True, help_text='Year in which this specific lens was manufactured', null=True)),
                ('acquired', models.DateField(blank=True, help_text='Date on which this lens was acquired', null=True)),
                ('cost_currency', djmoney.models.fields.CurrencyField(choices=[('XUA', 'ADB Unit of Account'), ('AFN', 'Afghani'), ('DZD', 'Algerian Dinar'), ('ARS', 'Argentine Peso'), ('AMD', 'Armenian Dram'), ('AWG', 'Aruban Guilder'), ('AUD', 'Australian Dollar'), ('AZN', 'Azerbaijanian Manat'), ('BSD', 'Bahamian Dollar'), ('BHD', 'Bahraini Dinar'), ('THB', 'Baht'), ('PAB', 'Balboa'), ('BBD', 'Barbados Dollar'), ('BYN', 'Belarussian Ruble'), ('BYR', 'Belarussian Ruble'), ('BZD', 'Belize Dollar'), ('BMD', 'Bermudian Dollar (customarily known as Bermuda Dollar)'), ('BTN', 'Bhutanese ngultrum'), ('VEF', 'Bolivar Fuerte'), ('BOB', 'Boliviano'), ('XBA', 'Bond Markets Units European Composite Unit (EURCO)'), ('BRL', 'Brazilian Real'), ('BND', 'Brunei Dollar'), ('BGN', 'Bulgarian Lev'), ('BIF', 'Burundi Franc'), ('XOF', 'CFA Franc BCEAO'), ('XAF', 'CFA franc BEAC'), ('XPF', 'CFP Franc'), ('CAD', 'Canadian Dollar'), ('CVE', 'Cape Verde Escudo'), ('KYD', 'Cayman Islands Dollar'), ('CLP', 'Chilean peso'), ('XTS', 'Codes specifically reserved for testing purposes'), ('COP', 'Colombian peso'), ('KMF', 'Comoro Franc'), ('CDF', 'Congolese franc'), ('BAM', 'Convertible Marks'), ('NIO', 'Cordoba Oro'), ('CRC', 'Costa Rican Colon'), ('HRK', 'Croatian Kuna'), ('CUP', 'Cuban Peso'), ('CUC', 'Cuban convertible peso'), ('CZK', 'Czech Koruna'), ('GMD', 'Dalasi'), ('DKK', 'Danish Krone'), ('MKD', 'Denar'), ('DJF', 'Djibouti Franc'), ('STD', 'Dobra'), ('DOP', 'Dominican Peso'), ('VND', 'Dong'), ('XCD', 'East Caribbean Dollar'), ('EGP', 'Egyptian Pound'), ('SVC', 'El Salvador Colon'), ('ETB', 'Ethiopian Birr'), ('EUR', 'Euro'), ('XBB', 'European Monetary Unit (E.M.U.-6)'), ('XBD', 'European Unit of Account 17(E.U.A.-17)'), ('XBC', 'European Unit of Account 9(E.U.A.-9)'), ('FKP', 'Falkland Islands Pound'), ('FJD', 'Fiji Dollar'), ('HUF', 'Forint'), ('GHS', 'Ghana Cedi'), ('GIP', 'Gibraltar Pound'), ('XAU', 'Gold'), ('XFO', 'Gold-Franc'), ('PYG', 'Guarani'), ('GNF', 'Guinea Franc'), ('GYD', 'Guyana Dollar'), ('HTG', 'Haitian gourde'), ('HKD', 'Hong Kong Dollar'), ('UAH', 'Hryvnia'), ('ISK', 'Iceland Krona'), ('INR', 'Indian Rupee'), ('IRR', 'Iranian Rial'), ('IQD', 'Iraqi Dinar'), ('IMP', 'Isle of Man Pound'), ('JMD', 'Jamaican Dollar'), ('JOD', 'Jordanian Dinar'), ('KES', 'Kenyan Shilling'), ('PGK', 'Kina'), ('LAK', 'Kip'), ('KWD', 'Kuwaiti Dinar'), ('AOA', 'Kwanza'), ('MMK', 'Kyat'), ('GEL', 'Lari'), ('LVL', 'Latvian Lats'), ('LBP', 'Lebanese Pound'), ('ALL', 'Lek'), ('HNL', 'Lempira'), ('SLL', 'Leone'), ('LSL', 'Lesotho loti'), ('LRD', 'Liberian Dollar'), ('LYD', 'Libyan Dinar'), ('SZL', 'Lilangeni'), ('LTL', 'Lithuanian Litas'), ('MGA', 'Malagasy Ariary'), ('MWK', 'Malawian Kwacha'), ('MYR', 'Malaysian Ringgit'), ('TMM', 'Manat'), ('MUR', 'Mauritius Rupee'), ('MZN', 'Metical'), ('MXV', 'Mexican Unidad de Inversion (UDI)'), ('MXN', 'Mexican peso'), ('MDL', 'Moldovan Leu'), ('MAD', 'Moroccan Dirham'), ('BOV', 'Mvdol'), ('NGN', 'Naira'), ('ERN', 'Nakfa'), ('NAD', 'Namibian Dollar'), ('NPR', 'Nepalese Rupee'), ('ANG', 'Netherlands Antillian Guilder'), ('ILS', 'New Israeli Sheqel'), ('RON', 'New Leu'), ('TWD', 'New Taiwan Dollar'), ('NZD', 'New Zealand Dollar'), ('KPW', 'North Korean Won'), ('NOK', 'Norwegian Krone'), ('PEN', 'Nuevo Sol'), ('MRO', 'Ouguiya'), ('TOP', 'Paanga'), ('PKR', 'Pakistan Rupee'), ('XPD', 'Palladium'), ('MOP', 'Pataca'), ('PHP', 'Philippine Peso'), ('XPT', 'Platinum'), ('GBP', 'Pound Sterling'), ('BWP', 'Pula'), ('QAR', 'Qatari Rial'), ('GTQ', 'Quetzal'), ('ZAR', 'Rand'), ('OMR', 'Rial Omani'), ('KHR', 'Riel'), ('MVR', 'Rufiyaa'), ('IDR', 'Rupiah'), ('RUB', 'Russian Ruble'), ('RWF', 'Rwanda Franc'), ('XDR', 'SDR'), ('SHP', 'Saint Helena Pound'), ('SAR', 'Saudi Riyal'), ('RSD', 'Serbian Dinar'), ('SCR', 'Seychelles Rupee'), ('XAG', 'Silver'), ('SGD', 'Singapore Dollar'), ('SBD', 'Solomon Islands Dollar'), ('KGS', 'Som'), ('SOS', 'Somali Shilling'), ('TJS', 'Somoni'), ('SSP', 'South Sudanese Pound'), ('LKR', 'Sri Lanka Rupee'), ('XSU', 'Sucre'), ('SDG', 'Sudanese Pound'), ('SRD', 'Surinam Dollar'), ('SEK', 'Swedish Krona'), ('CHF', 'Swiss Franc'), ('SYP', 'Syrian Pound'), ('BDT', 'Taka'), ('WST', 'Tala'), ('TZS', 'Tanzanian Shilling'), ('KZT', 'Tenge'), ('XXX', 'The codes assigned for transactions where no currency is involved'), ('TTD', 'Trinidad and Tobago Dollar'), ('MNT', 'Tugrik'), ('TND', 'Tunisian Dinar'), ('TRY', 'Turkish Lira'), ('TMT', 'Turkmenistan New Manat'), ('TVD', 'Tuvalu dollar'), ('AED', 'UAE Dirham'), ('XFU', 'UIC-Franc'), ('USD', 'US Dollar'), ('USN', 'US Dollar (Next day)'), ('UGX', 'Uganda Shilling'), ('CLF', 'Unidad de Fomento'), ('COU', 'Unidad de Valor Real'), ('UYI', 'Uruguay Peso en Unidades Indexadas (URUIURUI)'), ('UYU', 'Uruguayan peso'), ('UZS', 'Uzbekistan Sum'), ('VUV', 'Vatu'), ('CHE', 'WIR Euro'), ('CHW', 'WIR Franc'), ('KRW', 'Won'), ('YER', 'Yemeni Rial'), ('JPY', 'Yen'), ('CNY', 'Yuan Renminbi'), ('ZMK', 'Zambian Kwacha'), ('ZMW', 'Zambian Kwacha'), ('ZWD', 'Zimbabwe Dollar A/06'), ('ZWN', 'Zimbabwe dollar A/08'), ('ZWL', 'Zimbabwe dollar A/09'), ('PLN', 'Zloty')], default='GBP', editable=False, max_length=3)),
                ('cost', djmoney.models.fields.MoneyField(blank=True, decimal_places=2, default_currency='GBP', help_text='Price paid for this lens', max_digits=12, null=True)),
                ('notes', models.CharField(blank=True, help_text='Freeform notes field', max_length=45, null=True)),
                ('own', models.BooleanField(blank=True, help_text='Whether we currently own this lens', null=True)),
                ('lost', models.DateField(blank=True, help_text='Date on which lens was lost/sold/disposed', null=True)),
                ('lost_price_currency', djmoney.models.fields.CurrencyField(choices=[('XUA', 'ADB Unit of Account'), ('AFN', 'Afghani'), ('DZD', 'Algerian Dinar'), ('ARS', 'Argentine Peso'), ('AMD', 'Armenian Dram'), ('AWG', 'Aruban Guilder'), ('AUD', 'Australian Dollar'), ('AZN', 'Azerbaijanian Manat'), ('BSD', 'Bahamian Dollar'), ('BHD', 'Bahraini Dinar'), ('THB', 'Baht'), ('PAB', 'Balboa'), ('BBD', 'Barbados Dollar'), ('BYN', 'Belarussian Ruble'), ('BYR', 'Belarussian Ruble'), ('BZD', 'Belize Dollar'), ('BMD', 'Bermudian Dollar (customarily known as Bermuda Dollar)'), ('BTN', 'Bhutanese ngultrum'), ('VEF', 'Bolivar Fuerte'), ('BOB', 'Boliviano'), ('XBA', 'Bond Markets Units European Composite Unit (EURCO)'), ('BRL', 'Brazilian Real'), ('BND', 'Brunei Dollar'), ('BGN', 'Bulgarian Lev'), ('BIF', 'Burundi Franc'), ('XOF', 'CFA Franc BCEAO'), ('XAF', 'CFA franc BEAC'), ('XPF', 'CFP Franc'), ('CAD', 'Canadian Dollar'), ('CVE', 'Cape Verde Escudo'), ('KYD', 'Cayman Islands Dollar'), ('CLP', 'Chilean peso'), ('XTS', 'Codes specifically reserved for testing purposes'), ('COP', 'Colombian peso'), ('KMF', 'Comoro Franc'), ('CDF', 'Congolese franc'), ('BAM', 'Convertible Marks'), ('NIO', 'Cordoba Oro'), ('CRC', 'Costa Rican Colon'), ('HRK', 'Croatian Kuna'), ('CUP', 'Cuban Peso'), ('CUC', 'Cuban convertible peso'), ('CZK', 'Czech Koruna'), ('GMD', 'Dalasi'), ('DKK', 'Danish Krone'), ('MKD', 'Denar'), ('DJF', 'Djibouti Franc'), ('STD', 'Dobra'), ('DOP', 'Dominican Peso'), ('VND', 'Dong'), ('XCD', 'East Caribbean Dollar'), ('EGP', 'Egyptian Pound'), ('SVC', 'El Salvador Colon'), ('ETB', 'Ethiopian Birr'), ('EUR', 'Euro'), ('XBB', 'European Monetary Unit (E.M.U.-6)'), ('XBD', 'European Unit of Account 17(E.U.A.-17)'), ('XBC', 'European Unit of Account 9(E.U.A.-9)'), ('FKP', 'Falkland Islands Pound'), ('FJD', 'Fiji Dollar'), ('HUF', 'Forint'), ('GHS', 'Ghana Cedi'), ('GIP', 'Gibraltar Pound'), ('XAU', 'Gold'), ('XFO', 'Gold-Franc'), ('PYG', 'Guarani'), ('GNF', 'Guinea Franc'), ('GYD', 'Guyana Dollar'), ('HTG', 'Haitian gourde'), ('HKD', 'Hong Kong Dollar'), ('UAH', 'Hryvnia'), ('ISK', 'Iceland Krona'), ('INR', 'Indian Rupee'), ('IRR', 'Iranian Rial'), ('IQD', 'Iraqi Dinar'), ('IMP', 'Isle of Man Pound'), ('JMD', 'Jamaican Dollar'), ('JOD', 'Jordanian Dinar'), ('KES', 'Kenyan Shilling'), ('PGK', 'Kina'), ('LAK', 'Kip'), ('KWD', 'Kuwaiti Dinar'), ('AOA', 'Kwanza'), ('MMK', 'Kyat'), ('GEL', 'Lari'), ('LVL', 'Latvian Lats'), ('LBP', 'Lebanese Pound'), ('ALL', 'Lek'), ('HNL', 'Lempira'), ('SLL', 'Leone'), ('LSL', 'Lesotho loti'), ('LRD', 'Liberian Dollar'), ('LYD', 'Libyan Dinar'), ('SZL', 'Lilangeni'), ('LTL', 'Lithuanian Litas'), ('MGA', 'Malagasy Ariary'), ('MWK', 'Malawian Kwacha'), ('MYR', 'Malaysian Ringgit'), ('TMM', 'Manat'), ('MUR', 'Mauritius Rupee'), ('MZN', 'Metical'), ('MXV', 'Mexican Unidad de Inversion (UDI)'), ('MXN', 'Mexican peso'), ('MDL', 'Moldovan Leu'), ('MAD', 'Moroccan Dirham'), ('BOV', 'Mvdol'), ('NGN', 'Naira'), ('ERN', 'Nakfa'), ('NAD', 'Namibian Dollar'), ('NPR', 'Nepalese Rupee'), ('ANG', 'Netherlands Antillian Guilder'), ('ILS', 'New Israeli Sheqel'), ('RON', 'New Leu'), ('TWD', 'New Taiwan Dollar'), ('NZD', 'New Zealand Dollar'), ('KPW', 'North Korean Won'), ('NOK', 'Norwegian Krone'), ('PEN', 'Nuevo Sol'), ('MRO', 'Ouguiya'), ('TOP', 'Paanga'), ('PKR', 'Pakistan Rupee'), ('XPD', 'Palladium'), ('MOP', 'Pataca'), ('PHP', 'Philippine Peso'), ('XPT', 'Platinum'), ('GBP', 'Pound Sterling'), ('BWP', 'Pula'), ('QAR', 'Qatari Rial'), ('GTQ', 'Quetzal'), ('ZAR', 'Rand'), ('OMR', 'Rial Omani'), ('KHR', 'Riel'), ('MVR', 'Rufiyaa'), ('IDR', 'Rupiah'), ('RUB', 'Russian Ruble'), ('RWF', 'Rwanda Franc'), ('XDR', 'SDR'), ('SHP', 'Saint Helena Pound'), ('SAR', 'Saudi Riyal'), ('RSD', 'Serbian Dinar'), ('SCR', 'Seychelles Rupee'), ('XAG', 'Silver'), ('SGD', 'Singapore Dollar'), ('SBD', 'Solomon Islands Dollar'), ('KGS', 'Som'), ('SOS', 'Somali Shilling'), ('TJS', 'Somoni'), ('SSP', 'South Sudanese Pound'), ('LKR', 'Sri Lanka Rupee'), ('XSU', 'Sucre'), ('SDG', 'Sudanese Pound'), ('SRD', 'Surinam Dollar'), ('SEK', 'Swedish Krona'), ('CHF', 'Swiss Franc'), ('SYP', 'Syrian Pound'), ('BDT', 'Taka'), ('WST', 'Tala'), ('TZS', 'Tanzanian Shilling'), ('KZT', 'Tenge'), ('XXX', 'The codes assigned for transactions where no currency is involved'), ('TTD', 'Trinidad and Tobago Dollar'), ('MNT', 'Tugrik'), ('TND', 'Tunisian Dinar'), ('TRY', 'Turkish Lira'), ('TMT', 'Turkmenistan New Manat'), ('TVD', 'Tuvalu dollar'), ('AED', 'UAE Dirham'), ('XFU', 'UIC-Franc'), ('USD', 'US Dollar'), ('USN', 'US Dollar (Next day)'), ('UGX', 'Uganda Shilling'), ('CLF', 'Unidad de Fomento'), ('COU', 'Unidad de Valor Real'), ('UYI', 'Uruguay Peso en Unidades Indexadas (URUIURUI)'), ('UYU', 'Uruguayan peso'), ('UZS', 'Uzbekistan Sum'), ('VUV', 'Vatu'), ('CHE', 'WIR Euro'), ('CHW', 'WIR Franc'), ('KRW', 'Won'), ('YER', 'Yemeni Rial'), ('JPY', 'Yen'), ('CNY', 'Yuan Renminbi'), ('ZMK', 'Zambian Kwacha'), ('ZMW', 'Zambian Kwacha'), ('ZWD', 'Zimbabwe Dollar A/06'), ('ZWN', 'Zimbabwe dollar A/08'), ('ZWL', 'Zimbabwe dollar A/09'), ('PLN', 'Zloty')], default='GBP', editable=False, max_length=3)),
                ('lost_price', djmoney.models.fields.MoneyField(blank=True, decimal_places=2, default_currency='GBP', help_text='Sale price of the lens', max_digits=12, null=True)),
                ('source', models.CharField(blank=True, help_text='Place where the lens was acquired from', max_length=150, null=True)),
                ('condition_notes', models.CharField(blank=True, help_text='Description of condition', max_length=150, null=True)),
                ('condition', models.ForeignKey(blank=True, help_text='Condition of this lens', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Condition')),
            ],
            options={
                'verbose_name_plural': 'lenses',
                'ordering': ['lensmodel__manufacturer', 'lensmodel__model', 'serial'],
            },
        ),
        migrations.CreateModel(
            name='Manufacturer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, help_text='Name of the manufacturer', max_length=45, unique=True)),
                ('city', models.CharField(blank=True, help_text='City in which the manufacturer is based', max_length=45, null=True)),
                ('country', models.CharField(blank=True, help_text='Country in which the manufacturer is based', max_length=45, null=True)),
                ('url', models.URLField(blank=True, help_text='URL to the manufacturers main website', max_length=45, null=True, verbose_name='URL')),
                ('founded', models.PositiveIntegerField(blank=True, help_text='Year in which the manufacturer was founded', null=True)),
                ('dissolved', models.PositiveIntegerField(blank=True, help_text='Year in which the manufacturer was dissolved', null=True)),
            ],
            options={
                'verbose_name_plural': 'manufacturers',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='MeteringMode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of metering mode as defined by EXIF tag MeteringMode', max_length=45)),
            ],
            options={
                'verbose_name_plural': 'metering modes',
            },
        ),
        migrations.CreateModel(
            name='MeteringType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of the metering technology (e.g. Selenium)', max_length=45)),
            ],
            options={
                'verbose_name_plural': 'metering types',
            },
        ),
        migrations.CreateModel(
            name='Mount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mount', models.CharField(help_text='Name of this lens mount (e.g. Canon FD)', max_length=45, unique=True)),
                ('shutter_in_lens', models.BooleanField(blank=True, default=0, help_text='Whether this lens mount system incorporates the shutter into the lens', null=True)),
                ('type', models.CharField(blank=True, choices=[('Bayonet', 'Bayonet'), ('Breech lock', 'Breech lock'), ('Screw', 'Screw'), ('Friction', 'Friction'), ('Lens board', 'Lens board')], help_text='The physical mount type of this lens mount', max_length=15, null=True)),
                ('purpose', models.CharField(blank=True, choices=[('Camera', 'Camera'), ('Enlarger', 'Enlarger'), ('Projector', 'Projector'), ('Telescope', 'Telescope'), ('Microscope', 'Microscope')], help_text='The intended purpose of this lens mount', max_length=15, null=True)),
                ('notes', models.CharField(blank=True, help_text='Freeform notes field', max_length=100, null=True)),
                ('digital_only', models.BooleanField(blank=True, default=0, help_text='Whether this mount is intended only for digital cameras', null=True)),
                ('manufacturer', models.ForeignKey(blank=True, help_text='Manufacturer who owns this lens mount', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer')),
            ],
            options={
                'verbose_name_plural': 'mounts',
                'ordering': ['mount'],
            },
        ),
        migrations.CreateModel(
            name='MountAdapter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('has_optics', models.BooleanField(blank=True, help_text='Whether this adapter includes optical elements', null=True)),
                ('infinity_focus', models.BooleanField(blank=True, help_text='Whether this adapter allows infinity focus', null=True)),
                ('notes', models.CharField(blank=True, help_text='Freeform notes', max_length=100, null=True)),
                ('camera_mount', models.ForeignKey(help_text='Mount used to attach a camera', on_delete=django.db.models.deletion.CASCADE, related_name='camera_mount', to='schema.Mount')),
                ('lens_mount', models.ForeignKey(help_text='Mount used to attach a lens', on_delete=django.db.models.deletion.CASCADE, related_name='lens_mount', to='schema.Mount')),
            ],
            options={
                'verbose_name_plural': 'mount adapters',
                'ordering': ['camera_mount', 'lens_mount'],
            },
        ),
        migrations.CreateModel(
            name='Negative',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('frame', models.CharField(help_text='Frame number or code of this negative', max_length=8)),
                ('caption', models.CharField(blank=True, help_text='Caption of this picture', max_length=150, null=True)),
                ('date', models.DateTimeField(blank=True, help_text='Date & time on which this picture was taken', null=True)),
                ('aperture', models.DecimalField(blank=True, decimal_places=1, help_text='Aperture used to take this picture (numerical part only)', max_digits=4, null=True)),
                ('notes', models.CharField(blank=True, help_text='Extra freeform notes about this exposure', max_length=200, null=True)),
                ('focal_length', models.PositiveIntegerField(blank=True, help_text='If a zoom lens was used, specify the focal length of the lens', null=True)),
                ('latitude', models.DecimalField(blank=True, decimal_places=6, help_text='Latitude of the location where the picture was taken', max_digits=9, null=True, validators=[django.core.validators.MinValueValidator(-90), django.core.validators.MaxValueValidator(90)])),
                ('longitude', models.DecimalField(blank=True, decimal_places=6, help_text='Longitude of the location where the picture was taken', max_digits=9, null=True, validators=[django.core.validators.MinValueValidator(-180), django.core.validators.MaxValueValidator(180)])),
                ('flash', models.BooleanField(blank=True, help_text='Whether flash was used', null=True)),
                ('copy_of', models.ForeignKey(blank=True, help_text='Negative that this was duplicated from', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='copy', to='schema.Negative')),
                ('exposure_program', models.ForeignKey(blank=True, help_text='Exposure program used when taking the image', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.ExposureProgram')),
                ('film', models.ForeignKey(help_text='Film that this negative belongs to', on_delete=django.db.models.deletion.CASCADE, to='schema.Film')),
                ('filter', models.ForeignKey(blank=True, help_text='Filter used when taking this negative', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Filter')),
                ('lens', models.ForeignKey(blank=True, help_text='Lens used to take this negative', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Lens')),
                ('metering_mode', models.ForeignKey(blank=True, help_text='Metering mode used when taking the image', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.MeteringMode')),
                ('mount_adapter', models.ForeignKey(blank=True, help_text='Mount adapter used to mount lens', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.MountAdapter')),
            ],
            options={
                'verbose_name_plural': 'negatives',
                'ordering': ['film', 'frame'],
            },
        ),
        migrations.CreateModel(
            name='NegativeSize',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Common name of the negative size (e.g. 35mm, 6x7, etc)', max_length=45, unique=True)),
                ('width', models.DecimalField(blank=True, decimal_places=1, help_text='Width of the negative size in mm', max_digits=4, null=True)),
                ('height', models.DecimalField(blank=True, decimal_places=1, help_text='Height of the negative size in mm', max_digits=4, null=True)),
                ('crop_factor', models.DecimalField(blank=True, decimal_places=2, help_text='Crop factor of this negative size', max_digits=4, null=True)),
                ('area', models.PositiveIntegerField(blank=True, help_text='Area of this negative size in sq. mm', null=True)),
                ('aspect_ratio', models.DecimalField(blank=True, decimal_places=2, help_text='Aspect ratio of this negative size, expressed as a single decimal (e.g. 3:2 is expressed as 1.5)', max_digits=4, null=True)),
            ],
            options={
                'verbose_name_plural': 'negative sizes',
                'ordering': ['area'],
            },
        ),
        migrations.CreateModel(
            name='PaperStock',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of this paper stock', max_length=45)),
                ('resin_coated', models.BooleanField(blank=True, help_text='Whether the paper is resin-coated', null=True)),
                ('tonable', models.BooleanField(blank=True, help_text='Whether this paper accepts chemical toning', null=True)),
                ('colour', models.BooleanField(blank=True, help_text='Whether this is a colour paper', null=True)),
                ('finish', models.CharField(blank=True, help_text='The finish of the paper surface', max_length=25, null=True)),
                ('manufacturer', models.ForeignKey(blank=True, help_text='Manufacturer of this paper stock', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer')),
            ],
            options={
                'verbose_name_plural': 'paper stocks',
                'ordering': ['manufacturer', 'name'],
            },
        ),
        migrations.CreateModel(
            name='Person',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of the photographer', max_length=45, unique=True)),
            ],
            options={
                'verbose_name_plural': 'people',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Print',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(blank=True, help_text='The date that the print was made', null=True)),
                ('height', models.DecimalField(blank=True, decimal_places=1, help_text='Height of the print in inches', max_digits=4, null=True)),
                ('width', models.DecimalField(blank=True, decimal_places=1, help_text='Width of the print in inches', max_digits=4, null=True)),
                ('aperture', models.DecimalField(blank=True, decimal_places=1, help_text='Aperture used to make this print (numerical part only, e.g. 5.6)', max_digits=3, null=True)),
                ('exposure_time', models.DurationField(blank=True, help_text='Exposure time of this print', null=True)),
                ('filtration_grade', models.DecimalField(blank=True, decimal_places=1, help_text='Contrast grade of paper used', max_digits=2, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(5)])),
                ('development_time', models.DurationField(blank=True, help_text='Development time of this print', null=True)),
                ('own', models.BooleanField(blank=True, help_text='Whether we currently own this print', null=True)),
                ('location', models.CharField(blank=True, help_text='The place where this print is currently', max_length=100, null=True)),
                ('sold_price_currency', djmoney.models.fields.CurrencyField(choices=[('XUA', 'ADB Unit of Account'), ('AFN', 'Afghani'), ('DZD', 'Algerian Dinar'), ('ARS', 'Argentine Peso'), ('AMD', 'Armenian Dram'), ('AWG', 'Aruban Guilder'), ('AUD', 'Australian Dollar'), ('AZN', 'Azerbaijanian Manat'), ('BSD', 'Bahamian Dollar'), ('BHD', 'Bahraini Dinar'), ('THB', 'Baht'), ('PAB', 'Balboa'), ('BBD', 'Barbados Dollar'), ('BYN', 'Belarussian Ruble'), ('BYR', 'Belarussian Ruble'), ('BZD', 'Belize Dollar'), ('BMD', 'Bermudian Dollar (customarily known as Bermuda Dollar)'), ('BTN', 'Bhutanese ngultrum'), ('VEF', 'Bolivar Fuerte'), ('BOB', 'Boliviano'), ('XBA', 'Bond Markets Units European Composite Unit (EURCO)'), ('BRL', 'Brazilian Real'), ('BND', 'Brunei Dollar'), ('BGN', 'Bulgarian Lev'), ('BIF', 'Burundi Franc'), ('XOF', 'CFA Franc BCEAO'), ('XAF', 'CFA franc BEAC'), ('XPF', 'CFP Franc'), ('CAD', 'Canadian Dollar'), ('CVE', 'Cape Verde Escudo'), ('KYD', 'Cayman Islands Dollar'), ('CLP', 'Chilean peso'), ('XTS', 'Codes specifically reserved for testing purposes'), ('COP', 'Colombian peso'), ('KMF', 'Comoro Franc'), ('CDF', 'Congolese franc'), ('BAM', 'Convertible Marks'), ('NIO', 'Cordoba Oro'), ('CRC', 'Costa Rican Colon'), ('HRK', 'Croatian Kuna'), ('CUP', 'Cuban Peso'), ('CUC', 'Cuban convertible peso'), ('CZK', 'Czech Koruna'), ('GMD', 'Dalasi'), ('DKK', 'Danish Krone'), ('MKD', 'Denar'), ('DJF', 'Djibouti Franc'), ('STD', 'Dobra'), ('DOP', 'Dominican Peso'), ('VND', 'Dong'), ('XCD', 'East Caribbean Dollar'), ('EGP', 'Egyptian Pound'), ('SVC', 'El Salvador Colon'), ('ETB', 'Ethiopian Birr'), ('EUR', 'Euro'), ('XBB', 'European Monetary Unit (E.M.U.-6)'), ('XBD', 'European Unit of Account 17(E.U.A.-17)'), ('XBC', 'European Unit of Account 9(E.U.A.-9)'), ('FKP', 'Falkland Islands Pound'), ('FJD', 'Fiji Dollar'), ('HUF', 'Forint'), ('GHS', 'Ghana Cedi'), ('GIP', 'Gibraltar Pound'), ('XAU', 'Gold'), ('XFO', 'Gold-Franc'), ('PYG', 'Guarani'), ('GNF', 'Guinea Franc'), ('GYD', 'Guyana Dollar'), ('HTG', 'Haitian gourde'), ('HKD', 'Hong Kong Dollar'), ('UAH', 'Hryvnia'), ('ISK', 'Iceland Krona'), ('INR', 'Indian Rupee'), ('IRR', 'Iranian Rial'), ('IQD', 'Iraqi Dinar'), ('IMP', 'Isle of Man Pound'), ('JMD', 'Jamaican Dollar'), ('JOD', 'Jordanian Dinar'), ('KES', 'Kenyan Shilling'), ('PGK', 'Kina'), ('LAK', 'Kip'), ('KWD', 'Kuwaiti Dinar'), ('AOA', 'Kwanza'), ('MMK', 'Kyat'), ('GEL', 'Lari'), ('LVL', 'Latvian Lats'), ('LBP', 'Lebanese Pound'), ('ALL', 'Lek'), ('HNL', 'Lempira'), ('SLL', 'Leone'), ('LSL', 'Lesotho loti'), ('LRD', 'Liberian Dollar'), ('LYD', 'Libyan Dinar'), ('SZL', 'Lilangeni'), ('LTL', 'Lithuanian Litas'), ('MGA', 'Malagasy Ariary'), ('MWK', 'Malawian Kwacha'), ('MYR', 'Malaysian Ringgit'), ('TMM', 'Manat'), ('MUR', 'Mauritius Rupee'), ('MZN', 'Metical'), ('MXV', 'Mexican Unidad de Inversion (UDI)'), ('MXN', 'Mexican peso'), ('MDL', 'Moldovan Leu'), ('MAD', 'Moroccan Dirham'), ('BOV', 'Mvdol'), ('NGN', 'Naira'), ('ERN', 'Nakfa'), ('NAD', 'Namibian Dollar'), ('NPR', 'Nepalese Rupee'), ('ANG', 'Netherlands Antillian Guilder'), ('ILS', 'New Israeli Sheqel'), ('RON', 'New Leu'), ('TWD', 'New Taiwan Dollar'), ('NZD', 'New Zealand Dollar'), ('KPW', 'North Korean Won'), ('NOK', 'Norwegian Krone'), ('PEN', 'Nuevo Sol'), ('MRO', 'Ouguiya'), ('TOP', 'Paanga'), ('PKR', 'Pakistan Rupee'), ('XPD', 'Palladium'), ('MOP', 'Pataca'), ('PHP', 'Philippine Peso'), ('XPT', 'Platinum'), ('GBP', 'Pound Sterling'), ('BWP', 'Pula'), ('QAR', 'Qatari Rial'), ('GTQ', 'Quetzal'), ('ZAR', 'Rand'), ('OMR', 'Rial Omani'), ('KHR', 'Riel'), ('MVR', 'Rufiyaa'), ('IDR', 'Rupiah'), ('RUB', 'Russian Ruble'), ('RWF', 'Rwanda Franc'), ('XDR', 'SDR'), ('SHP', 'Saint Helena Pound'), ('SAR', 'Saudi Riyal'), ('RSD', 'Serbian Dinar'), ('SCR', 'Seychelles Rupee'), ('XAG', 'Silver'), ('SGD', 'Singapore Dollar'), ('SBD', 'Solomon Islands Dollar'), ('KGS', 'Som'), ('SOS', 'Somali Shilling'), ('TJS', 'Somoni'), ('SSP', 'South Sudanese Pound'), ('LKR', 'Sri Lanka Rupee'), ('XSU', 'Sucre'), ('SDG', 'Sudanese Pound'), ('SRD', 'Surinam Dollar'), ('SEK', 'Swedish Krona'), ('CHF', 'Swiss Franc'), ('SYP', 'Syrian Pound'), ('BDT', 'Taka'), ('WST', 'Tala'), ('TZS', 'Tanzanian Shilling'), ('KZT', 'Tenge'), ('XXX', 'The codes assigned for transactions where no currency is involved'), ('TTD', 'Trinidad and Tobago Dollar'), ('MNT', 'Tugrik'), ('TND', 'Tunisian Dinar'), ('TRY', 'Turkish Lira'), ('TMT', 'Turkmenistan New Manat'), ('TVD', 'Tuvalu dollar'), ('AED', 'UAE Dirham'), ('XFU', 'UIC-Franc'), ('USD', 'US Dollar'), ('USN', 'US Dollar (Next day)'), ('UGX', 'Uganda Shilling'), ('CLF', 'Unidad de Fomento'), ('COU', 'Unidad de Valor Real'), ('UYI', 'Uruguay Peso en Unidades Indexadas (URUIURUI)'), ('UYU', 'Uruguayan peso'), ('UZS', 'Uzbekistan Sum'), ('VUV', 'Vatu'), ('CHE', 'WIR Euro'), ('CHW', 'WIR Franc'), ('KRW', 'Won'), ('YER', 'Yemeni Rial'), ('JPY', 'Yen'), ('CNY', 'Yuan Renminbi'), ('ZMK', 'Zambian Kwacha'), ('ZMW', 'Zambian Kwacha'), ('ZWD', 'Zimbabwe Dollar A/06'), ('ZWN', 'Zimbabwe dollar A/08'), ('ZWL', 'Zimbabwe dollar A/09'), ('PLN', 'Zloty')], default='GBP', editable=False, max_length=3)),
                ('sold_price', djmoney.models.fields.MoneyField(blank=True, decimal_places=2, default_currency='GBP', help_text='Sale price of the print', max_digits=12, null=True)),
                ('fine', models.BooleanField(blank=True, help_text='Whether this is a fine print', null=True)),
                ('notes', models.CharField(blank=True, help_text='Freeform notes about this print, e.g. dodging, burning & complex toning', max_length=200, null=True)),
                ('archive', models.ForeignKey(blank=True, help_text='Archive that this print is stored in', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Archive')),
                ('developer', models.ForeignKey(blank=True, help_text='Developer used to develop this print', limit_choices_to={'for_paper': True}, null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Developer')),
                ('enlarger', models.ForeignKey(blank=True, help_text='Enlarger used to make this print', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Enlarger')),
                ('lens', models.ForeignKey(blank=True, help_text='Enlarger lens used to make this print', limit_choices_to={'lensmodel__mount__purpose': 'Enlarger'}, null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Lens')),
                ('negative', models.ForeignKey(help_text='Negative that this print was made from', on_delete=django.db.models.deletion.CASCADE, to='schema.Negative')),
                ('paper_stock', models.ForeignKey(blank=True, help_text='Paper stock that this print was made on', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.PaperStock')),
                ('printer', models.ForeignKey(blank=True, help_text='Person who made this print', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Person')),
            ],
            options={
                'verbose_name_plural': 'prints',
            },
        ),
        migrations.CreateModel(
            name='Process',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of this developmenmt process (e.g. C-41, E-6)', max_length=25, unique=True)),
                ('colour', models.BooleanField(blank=True, help_text='Whether this is a colour process', null=True)),
                ('positive', models.BooleanField(blank=True, help_text='Whether this is a positive/reversal process', null=True)),
            ],
            options={
                'verbose_name_plural': 'processes',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Series',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of this collection, e.g. Canon FD SLRs', max_length=45, unique=True)),
            ],
            options={
                'verbose_name_plural': 'series',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='ShutterSpeed',
            fields=[
                ('shutter_speed', models.CharField(help_text='Shutter speed in fractional notation, e.g. 1/250', max_length=10, primary_key=True, serialize=False)),
                ('duration', models.DecimalField(decimal_places=5, help_text='Shutter speed in decimal notation, e.g. 0.04', max_digits=9)),
            ],
            options={
                'verbose_name_plural': 'shutter speeds',
                'ordering': ['duration'],
            },
        ),
        migrations.CreateModel(
            name='Toner',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of the toner', max_length=45)),
                ('formulation', models.CharField(blank=True, help_text='Chemical formulation of the toner', max_length=45, null=True)),
                ('stock_dilution', models.CharField(blank=True, help_text='Stock dilution of the toner', max_length=10, null=True)),
                ('manufacturer', models.ForeignKey(blank=True, help_text='Manufacturer of this toner', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer')),
            ],
            options={
                'verbose_name_plural': 'toners',
                'ordering': ['manufacturer', 'name'],
            },
        ),
        migrations.CreateModel(
            name='Toning',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('dilution', models.CharField(blank=True, help_text='Dilution of the toner', max_length=8, null=True)),
                ('duration', models.DurationField(blank=True, help_text='Duration of the toning', null=True)),
                ('order', models.PositiveIntegerField(blank=True, help_text='Order in which this toner was applied', null=True)),
                ('print', models.ForeignKey(help_text='Print that was toned', on_delete=django.db.models.deletion.CASCADE, to='schema.Print')),
                ('toner', models.ForeignKey(help_text='Toner used on this print', on_delete=django.db.models.deletion.CASCADE, to='schema.Toner')),
            ],
            options={
                'ordering': ['order'],
                'unique_together': {('print', 'order')},
            },
        ),
        migrations.CreateModel(
            name='Teleconverter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model', models.CharField(help_text='Model name of this teleconverter', max_length=45)),
                ('factor', models.DecimalField(blank=True, decimal_places=2, help_text='Magnification factor of this teleconverter (numerical part only, e.g. 1.4)', max_digits=4, null=True)),
                ('elements', models.PositiveIntegerField(blank=True, help_text='Number of optical elements used in this teleconverter', null=True)),
                ('groups', models.PositiveIntegerField(blank=True, help_text='Number of optical groups used in this teleconverter', null=True)),
                ('multicoated', models.BooleanField(blank=True, help_text='Whether this teleconverter is multi-coated', null=True)),
                ('manufacturer', models.ForeignKey(blank=True, help_text='Manufacturer of this teleconverter', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer')),
                ('mount', models.ForeignKey(blank=True, help_text='Lens mount used by this teleconverter', limit_choices_to={'purpose': 'Camera'}, null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Mount')),
            ],
            options={
                'verbose_name_plural': 'teleconverters',
                'ordering': ['manufacturer', 'model'],
            },
        ),
        migrations.CreateModel(
            name='Scan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('filename', models.CharField(help_text='Filename of the scan', max_length=128)),
                ('date', models.DateField(blank=True, help_text='Date that this scan was made', null=True)),
                ('colour', models.BooleanField(blank=True, help_text='Whether this is a colour image', null=True)),
                ('width', models.PositiveIntegerField(blank=True, help_text='Width of the scanned image in pixels', null=True)),
                ('height', models.PositiveIntegerField(blank=True, help_text='Height of the scanned image in pixels', null=True)),
                ('negative', models.ForeignKey(blank=True, help_text='Negative that this scan was made from', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Negative')),
                ('print', models.ForeignKey(blank=True, help_text='Print that this scan was made from', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Print')),
            ],
            options={
                'verbose_name_plural': 'scans',
            },
        ),
        migrations.CreateModel(
            name='Repair',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(blank=True, help_text='The date of the repair', null=True)),
                ('summary', models.CharField(help_text='Brief summary of the repair', max_length=100)),
                ('description', models.CharField(blank=True, help_text='Longer description of the repair', max_length=500, null=True)),
                ('camera', models.ForeignKey(blank=True, help_text='Camera that was repaired', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Camera')),
                ('lens', models.ForeignKey(blank=True, help_text='Lens that was repaired', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Lens')),
            ],
            options={
                'verbose_name_plural': 'repairs',
                'ordering': ['date'],
            },
        ),
        migrations.CreateModel(
            name='Projector',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model', models.CharField(help_text='Model name of this projector', max_length=45)),
                ('own', models.BooleanField(blank=True, help_text='Whether we currently own this projector', null=True)),
                ('cine', models.BooleanField(blank=True, help_text='Whether this is a cine (movie) projector', null=True)),
                ('manufacturer', models.ForeignKey(blank=True, help_text='Manufacturer of this projector', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer')),
                ('mount', models.ForeignKey(blank=True, help_text='Lens mount used by this projector', limit_choices_to={'purpose': 'Projector'}, null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Mount')),
                ('negative_size', models.ForeignKey(blank=True, help_text='Largest negative size this projector can accept', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.NegativeSize')),
            ],
            options={
                'verbose_name_plural': 'projectors',
                'ordering': ['manufacturer', 'model'],
            },
        ),
        migrations.AddField(
            model_name='print',
            name='toner',
            field=models.ManyToManyField(help_text='Toners and bleaches used to treat this print', through='schema.Toning', to='schema.Toner'),
        ),
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('width', models.PositiveIntegerField(blank=True, help_text='Width of print to be made', null=True)),
                ('height', models.PositiveIntegerField(blank=True, help_text='Height of print to be made', null=True)),
                ('added', models.DateField(blank=True, help_text='Date that the order was placed', null=True)),
                ('printed', models.BooleanField(blank=True, help_text='Whether the print has been made', null=True)),
                ('negative', models.ForeignKey(help_text='Negative that needs to be printed', on_delete=django.db.models.deletion.CASCADE, to='schema.Negative')),
                ('print', models.ForeignKey(blank=True, help_text='Print that was made to fulfil this order', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Print')),
                ('recipient', models.ForeignKey(help_text='Person who placed this order', on_delete=django.db.models.deletion.CASCADE, to='schema.Person')),
            ],
            options={
                'verbose_name_plural': 'orders',
                'ordering': ['added'],
            },
        ),
        migrations.AddField(
            model_name='negative',
            name='photographer',
            field=models.ForeignKey(blank=True, help_text='Photographer who took the negative', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Person'),
        ),
        migrations.AddField(
            model_name='negative',
            name='shutter_speed',
            field=models.ForeignKey(blank=True, help_text='Shutter speed used to take this negative', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.ShutterSpeed'),
        ),
        migrations.AddField(
            model_name='negative',
            name='teleconverter',
            field=models.ForeignKey(blank=True, help_text='Teleconverter used when taking this negative', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Teleconverter'),
        ),
        migrations.CreateModel(
            name='Movie',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Title of this movie', max_length=45)),
                ('description', models.CharField(blank=True, help_text='Description of this movie', max_length=200, null=True)),
                ('sound', models.BooleanField(blank=True, help_text='Whether this movie has sound', null=True)),
                ('fps', models.PositiveIntegerField(blank=True, help_text='Frame rate of this movie, in fps', null=True, verbose_name='FPS')),
                ('feet', models.PositiveIntegerField(blank=True, help_text='Length of this movie in feet', null=True)),
                ('duration', models.DurationField(blank=True, help_text='Duration of this movie', null=True)),
                ('date_loaded', models.DateField(blank=True, help_text='Date that the filmstock was loaded into a camera', null=True)),
                ('date_shot', models.DateField(blank=True, help_text='Date on which this movie was shot', null=True)),
                ('date_processed', models.DateField(blank=True, help_text='Date on which this movie was processed', null=True)),
                ('camera', models.ForeignKey(blank=True, help_text='Camera used to shoot this movie', limit_choices_to={'movie': True}, null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Camera')),
                ('filmstock', models.ForeignKey(blank=True, help_text='Filmstock that this movie was shot on', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.FilmStock')),
                ('format', models.ForeignKey(blank=True, help_text='Film format of this movie', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Format')),
                ('lens', models.ForeignKey(blank=True, help_text='Lens used to shoot this movie', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Lens')),
                ('process', models.ForeignKey(blank=True, help_text='Process used to develop this movie', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Process')),
            ],
            options={
                'verbose_name_plural': 'movies',
            },
        ),
        migrations.CreateModel(
            name='LightMeter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model', models.CharField(help_text='Model name or number of the light meter', max_length=45)),
                ('reflected', models.BooleanField(blank=True, help_text='Whether the meter is capable of reflected-light metering', null=True)),
                ('incident', models.BooleanField(blank=True, help_text='Whether the meter is capable of incident-light metering', null=True)),
                ('flash', models.BooleanField(blank=True, help_text='Whether the meter is capable of flash metering', null=True)),
                ('spot', models.BooleanField(blank=True, help_text='Whether the meter is capable of spot metering', null=True)),
                ('min_asa', models.PositiveIntegerField(blank=True, help_text='Minimum ISO/ASA that this meter is capable of handling', null=True, verbose_name='Min ISO')),
                ('max_asa', models.PositiveIntegerField(blank=True, help_text='Maximum ISO/ASA that this meter is capable of handling', null=True, verbose_name='Max ISO')),
                ('min_lv', models.PositiveIntegerField(blank=True, help_text='Minimum light value (LV/EV) that this meter is capable of handling', null=True, verbose_name='Min LV')),
                ('max_lv', models.PositiveIntegerField(blank=True, help_text='Maximum light value (LV/EV) that this meter is capable of handling', null=True, verbose_name='Max LV')),
                ('manufacturer', models.ForeignKey(blank=True, help_text='Manufacturer of this light meter', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer')),
                ('metering_type', models.ForeignKey(blank=True, help_text='Metering type used in this meter', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.MeteringType')),
            ],
            options={
                'verbose_name_plural': 'light meters',
                'ordering': ['manufacturer', 'model'],
            },
        ),
        migrations.CreateModel(
            name='LensModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model', models.CharField(help_text='Model name of this lens', max_length=45)),
                ('zoom', models.BooleanField(blank=True, help_text='Whether this is a zoom lens', null=True)),
                ('min_focal_length', models.PositiveIntegerField(blank=True, help_text='Shortest focal length of this lens, in mm', null=True)),
                ('max_focal_length', models.PositiveIntegerField(blank=True, help_text='Longest focal length of this lens, in mm', null=True)),
                ('closest_focus', models.PositiveIntegerField(blank=True, help_text='The closest focus possible with this lens, in cm', null=True)),
                ('max_aperture', models.DecimalField(blank=True, decimal_places=1, help_text='Maximum (widest) aperture available on this lens (numerical part only, e.g. 2.8)', max_digits=4, null=True)),
                ('min_aperture', models.DecimalField(blank=True, decimal_places=1, help_text='Minimum (narrowest) aperture available on this lens (numerical part only, e.g. 22)', max_digits=4, null=True)),
                ('elements', models.PositiveIntegerField(blank=True, help_text='Number of optical lens elements', null=True)),
                ('groups', models.PositiveIntegerField(blank=True, help_text='Number of optical groups', null=True)),
                ('weight', models.PositiveIntegerField(blank=True, help_text='Weight of this lens, in grammes (g)', null=True)),
                ('nominal_min_angle_diag', models.PositiveIntegerField(blank=True, help_text='Nominal minimum diagonal field of view from manufacturer specs', null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(360)], verbose_name='Min angle of view')),
                ('nominal_max_angle_diag', models.PositiveIntegerField(blank=True, help_text='Nominal maximum diagonal field of view from manufacturer specs', null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(360)], verbose_name='Max angle of view')),
                ('aperture_blades', models.PositiveIntegerField(blank=True, help_text='Number of aperture blades', null=True)),
                ('autofocus', models.BooleanField(blank=True, help_text='Whether this lens has autofocus capability', null=True)),
                ('filter_thread', models.DecimalField(blank=True, decimal_places=1, help_text='Diameter of lens filter thread, in mm', max_digits=4, null=True)),
                ('magnification', models.DecimalField(blank=True, decimal_places=3, help_text='Maximum magnification ratio of the lens, expressed like 0.765', max_digits=5, null=True)),
                ('url', models.URLField(blank=True, help_text='URL to more information about this lens', null=True)),
                ('introduced', models.PositiveIntegerField(blank=True, help_text='Year in which this lens model was introduced', null=True)),
                ('discontinued', models.PositiveIntegerField(blank=True, help_text='Year in which this lens model was discontinued', null=True)),
                ('fixed_mount', models.BooleanField(blank=True, help_text='Whether this is a fixed lens (i.e. on a compact camera)', null=True)),
                ('notes', models.CharField(blank=True, help_text='Freeform notes field', max_length=100, null=True)),
                ('coating', models.CharField(blank=True, help_text='Notes about the lens coating type', max_length=45, null=True)),
                ('hood', models.CharField(blank=True, help_text='Model number of the compatible lens hood', max_length=45, null=True)),
                ('exif_lenstype', models.CharField(blank=True, help_text='EXIF LensID number, if this lens has one officially registered. See documentation at http://www.sno.phy.queensu.ca/~phil/exiftool/TagNames/', max_length=45, null=True)),
                ('rectilinear', models.BooleanField(blank=True, default=1, help_text='Whether this is a rectilinear lens', null=True)),
                ('length', models.PositiveIntegerField(blank=True, help_text='Length of lens in mm', null=True)),
                ('diameter', models.PositiveIntegerField(blank=True, help_text='Width of lens in mm', null=True)),
                ('image_circle', models.PositiveIntegerField(blank=True, help_text='Diameter of image circle projected by lens, in mm', null=True)),
                ('formula', models.CharField(blank=True, help_text='Name of the type of lens formula (e.g. Tessar)', max_length=45, null=True)),
                ('shutter_model', models.CharField(blank=True, help_text='Name of the integrated shutter, if any', max_length=45, null=True)),
                ('manufacturer', models.ForeignKey(blank=True, help_text='Manufacturer of this lens model', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer')),
                ('mount', models.ForeignKey(blank=True, help_text='Mount used by this lens model', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Mount')),
                ('negative_size', models.ForeignKey(blank=True, help_text='Largest negative size that this lens is designed for', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.NegativeSize')),
                ('series', models.ManyToManyField(blank=True, to='schema.Series')),
            ],
            options={
                'verbose_name_plural': 'lens models',
                'ordering': ['manufacturer', 'model'],
            },
        ),
        migrations.AddField(
            model_name='lens',
            name='lensmodel',
            field=models.ForeignKey(help_text='Lens model of this lens', on_delete=django.db.models.deletion.CASCADE, to='schema.LensModel'),
        ),
        migrations.AddField(
            model_name='format',
            name='negative_size',
            field=models.ManyToManyField(blank=True, to='schema.NegativeSize'),
        ),
        migrations.CreateModel(
            name='FlashProtocol',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of the flash protocol', max_length=45)),
                ('manufacturer', models.ForeignKey(blank=True, help_text='Manufacturer who owns this flash protocol', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer')),
            ],
            options={
                'verbose_name_plural': 'flash protocols',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Flash',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model', models.CharField(help_text='Model name/number of the flash', max_length=45)),
                ('guide_number', models.PositiveIntegerField(blank=True, help_text='Guide number of the flash', null=True)),
                ('gn_info', models.CharField(blank=True, help_text='Extra freeform info about how the guide number was measured', max_length=45, null=True, verbose_name='Guide number info')),
                ('battery_powered', models.BooleanField(blank=True, help_text='Whether this flash takes batteries', null=True)),
                ('pc_sync', models.BooleanField(blank=True, help_text='Whether the flash has a PC sync socket', null=True, verbose_name='PC sync')),
                ('hot_shoe', models.BooleanField(blank=True, help_text='Whether the flash has a hot shoe connection', null=True)),
                ('light_stand', models.BooleanField(blank=True, help_text='Whether the flash can be used on a light stand', null=True)),
                ('battery_qty', models.PositiveIntegerField(blank=True, help_text='Quantity of batteries needed in this flash', null=True)),
                ('manual_control', models.BooleanField(blank=True, help_text='Whether this flash offers manual power control', null=True)),
                ('swivel_head', models.BooleanField(blank=True, help_text='Whether this flash has a horizontal swivel head', null=True)),
                ('tilt_head', models.BooleanField(blank=True, help_text='Whether this flash has a vertical tilt head', null=True)),
                ('zoom', models.BooleanField(blank=True, help_text='Whether this flash can zoom', null=True)),
                ('dslr_safe', models.BooleanField(blank=True, help_text='Whether this flash is safe to use with a digital camera', null=True, verbose_name='DSLR safe')),
                ('ttl', models.BooleanField(blank=True, help_text='Whether this flash supports TTL metering', null=True, verbose_name='TTL')),
                ('trigger_voltage', models.DecimalField(blank=True, decimal_places=1, help_text='Trigger voltage of the flash, in Volts', max_digits=5, null=True)),
                ('own', models.BooleanField(blank=True, help_text='Whether we currently own this flash', null=True)),
                ('acquired', models.DateField(blank=True, help_text='Date this flash was acquired', null=True)),
                ('cost_currency', djmoney.models.fields.CurrencyField(choices=[('XUA', 'ADB Unit of Account'), ('AFN', 'Afghani'), ('DZD', 'Algerian Dinar'), ('ARS', 'Argentine Peso'), ('AMD', 'Armenian Dram'), ('AWG', 'Aruban Guilder'), ('AUD', 'Australian Dollar'), ('AZN', 'Azerbaijanian Manat'), ('BSD', 'Bahamian Dollar'), ('BHD', 'Bahraini Dinar'), ('THB', 'Baht'), ('PAB', 'Balboa'), ('BBD', 'Barbados Dollar'), ('BYN', 'Belarussian Ruble'), ('BYR', 'Belarussian Ruble'), ('BZD', 'Belize Dollar'), ('BMD', 'Bermudian Dollar (customarily known as Bermuda Dollar)'), ('BTN', 'Bhutanese ngultrum'), ('VEF', 'Bolivar Fuerte'), ('BOB', 'Boliviano'), ('XBA', 'Bond Markets Units European Composite Unit (EURCO)'), ('BRL', 'Brazilian Real'), ('BND', 'Brunei Dollar'), ('BGN', 'Bulgarian Lev'), ('BIF', 'Burundi Franc'), ('XOF', 'CFA Franc BCEAO'), ('XAF', 'CFA franc BEAC'), ('XPF', 'CFP Franc'), ('CAD', 'Canadian Dollar'), ('CVE', 'Cape Verde Escudo'), ('KYD', 'Cayman Islands Dollar'), ('CLP', 'Chilean peso'), ('XTS', 'Codes specifically reserved for testing purposes'), ('COP', 'Colombian peso'), ('KMF', 'Comoro Franc'), ('CDF', 'Congolese franc'), ('BAM', 'Convertible Marks'), ('NIO', 'Cordoba Oro'), ('CRC', 'Costa Rican Colon'), ('HRK', 'Croatian Kuna'), ('CUP', 'Cuban Peso'), ('CUC', 'Cuban convertible peso'), ('CZK', 'Czech Koruna'), ('GMD', 'Dalasi'), ('DKK', 'Danish Krone'), ('MKD', 'Denar'), ('DJF', 'Djibouti Franc'), ('STD', 'Dobra'), ('DOP', 'Dominican Peso'), ('VND', 'Dong'), ('XCD', 'East Caribbean Dollar'), ('EGP', 'Egyptian Pound'), ('SVC', 'El Salvador Colon'), ('ETB', 'Ethiopian Birr'), ('EUR', 'Euro'), ('XBB', 'European Monetary Unit (E.M.U.-6)'), ('XBD', 'European Unit of Account 17(E.U.A.-17)'), ('XBC', 'European Unit of Account 9(E.U.A.-9)'), ('FKP', 'Falkland Islands Pound'), ('FJD', 'Fiji Dollar'), ('HUF', 'Forint'), ('GHS', 'Ghana Cedi'), ('GIP', 'Gibraltar Pound'), ('XAU', 'Gold'), ('XFO', 'Gold-Franc'), ('PYG', 'Guarani'), ('GNF', 'Guinea Franc'), ('GYD', 'Guyana Dollar'), ('HTG', 'Haitian gourde'), ('HKD', 'Hong Kong Dollar'), ('UAH', 'Hryvnia'), ('ISK', 'Iceland Krona'), ('INR', 'Indian Rupee'), ('IRR', 'Iranian Rial'), ('IQD', 'Iraqi Dinar'), ('IMP', 'Isle of Man Pound'), ('JMD', 'Jamaican Dollar'), ('JOD', 'Jordanian Dinar'), ('KES', 'Kenyan Shilling'), ('PGK', 'Kina'), ('LAK', 'Kip'), ('KWD', 'Kuwaiti Dinar'), ('AOA', 'Kwanza'), ('MMK', 'Kyat'), ('GEL', 'Lari'), ('LVL', 'Latvian Lats'), ('LBP', 'Lebanese Pound'), ('ALL', 'Lek'), ('HNL', 'Lempira'), ('SLL', 'Leone'), ('LSL', 'Lesotho loti'), ('LRD', 'Liberian Dollar'), ('LYD', 'Libyan Dinar'), ('SZL', 'Lilangeni'), ('LTL', 'Lithuanian Litas'), ('MGA', 'Malagasy Ariary'), ('MWK', 'Malawian Kwacha'), ('MYR', 'Malaysian Ringgit'), ('TMM', 'Manat'), ('MUR', 'Mauritius Rupee'), ('MZN', 'Metical'), ('MXV', 'Mexican Unidad de Inversion (UDI)'), ('MXN', 'Mexican peso'), ('MDL', 'Moldovan Leu'), ('MAD', 'Moroccan Dirham'), ('BOV', 'Mvdol'), ('NGN', 'Naira'), ('ERN', 'Nakfa'), ('NAD', 'Namibian Dollar'), ('NPR', 'Nepalese Rupee'), ('ANG', 'Netherlands Antillian Guilder'), ('ILS', 'New Israeli Sheqel'), ('RON', 'New Leu'), ('TWD', 'New Taiwan Dollar'), ('NZD', 'New Zealand Dollar'), ('KPW', 'North Korean Won'), ('NOK', 'Norwegian Krone'), ('PEN', 'Nuevo Sol'), ('MRO', 'Ouguiya'), ('TOP', 'Paanga'), ('PKR', 'Pakistan Rupee'), ('XPD', 'Palladium'), ('MOP', 'Pataca'), ('PHP', 'Philippine Peso'), ('XPT', 'Platinum'), ('GBP', 'Pound Sterling'), ('BWP', 'Pula'), ('QAR', 'Qatari Rial'), ('GTQ', 'Quetzal'), ('ZAR', 'Rand'), ('OMR', 'Rial Omani'), ('KHR', 'Riel'), ('MVR', 'Rufiyaa'), ('IDR', 'Rupiah'), ('RUB', 'Russian Ruble'), ('RWF', 'Rwanda Franc'), ('XDR', 'SDR'), ('SHP', 'Saint Helena Pound'), ('SAR', 'Saudi Riyal'), ('RSD', 'Serbian Dinar'), ('SCR', 'Seychelles Rupee'), ('XAG', 'Silver'), ('SGD', 'Singapore Dollar'), ('SBD', 'Solomon Islands Dollar'), ('KGS', 'Som'), ('SOS', 'Somali Shilling'), ('TJS', 'Somoni'), ('SSP', 'South Sudanese Pound'), ('LKR', 'Sri Lanka Rupee'), ('XSU', 'Sucre'), ('SDG', 'Sudanese Pound'), ('SRD', 'Surinam Dollar'), ('SEK', 'Swedish Krona'), ('CHF', 'Swiss Franc'), ('SYP', 'Syrian Pound'), ('BDT', 'Taka'), ('WST', 'Tala'), ('TZS', 'Tanzanian Shilling'), ('KZT', 'Tenge'), ('XXX', 'The codes assigned for transactions where no currency is involved'), ('TTD', 'Trinidad and Tobago Dollar'), ('MNT', 'Tugrik'), ('TND', 'Tunisian Dinar'), ('TRY', 'Turkish Lira'), ('TMT', 'Turkmenistan New Manat'), ('TVD', 'Tuvalu dollar'), ('AED', 'UAE Dirham'), ('XFU', 'UIC-Franc'), ('USD', 'US Dollar'), ('USN', 'US Dollar (Next day)'), ('UGX', 'Uganda Shilling'), ('CLF', 'Unidad de Fomento'), ('COU', 'Unidad de Valor Real'), ('UYI', 'Uruguay Peso en Unidades Indexadas (URUIURUI)'), ('UYU', 'Uruguayan peso'), ('UZS', 'Uzbekistan Sum'), ('VUV', 'Vatu'), ('CHE', 'WIR Euro'), ('CHW', 'WIR Franc'), ('KRW', 'Won'), ('YER', 'Yemeni Rial'), ('JPY', 'Yen'), ('CNY', 'Yuan Renminbi'), ('ZMK', 'Zambian Kwacha'), ('ZMW', 'Zambian Kwacha'), ('ZWD', 'Zimbabwe Dollar A/06'), ('ZWN', 'Zimbabwe dollar A/08'), ('ZWL', 'Zimbabwe dollar A/09'), ('PLN', 'Zloty')], default='GBP', editable=False, max_length=3)),
                ('cost', djmoney.models.fields.MoneyField(blank=True, decimal_places=2, default_currency='GBP', help_text='Purchase cost of this flash', max_digits=12, null=True)),
                ('battery_type', models.ForeignKey(blank=True, help_text='Type of battery required by this flash', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Battery')),
                ('flash_protocol', models.ForeignKey(blank=True, help_text='Flash protocol used by this flash', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.FlashProtocol')),
                ('manufacturer', models.ForeignKey(blank=True, help_text='Manufacturer of this flash', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer')),
            ],
            options={
                'verbose_name_plural': 'flashes',
                'ordering': ['manufacturer', 'model'],
            },
        ),
        migrations.AddField(
            model_name='filter',
            name='manufacturer',
            field=models.ForeignKey(blank=True, help_text='Manufacturer of this filter', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer'),
        ),
        migrations.AddField(
            model_name='filmstock',
            name='manufacturer',
            field=models.ForeignKey(blank=True, help_text='Manufacturer of this film', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer'),
        ),
        migrations.AddField(
            model_name='filmstock',
            name='process',
            field=models.ForeignKey(blank=True, help_text='Development process required by this film', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Process'),
        ),
        migrations.AddField(
            model_name='film',
            name='filmstock',
            field=models.ForeignKey(help_text='Filmstock that this film is', on_delete=django.db.models.deletion.CASCADE, to='schema.FilmStock'),
        ),
        migrations.AddField(
            model_name='film',
            name='format',
            field=models.ForeignKey(help_text='Film format of this film', on_delete=django.db.models.deletion.CASCADE, to='schema.Format'),
        ),
        migrations.AddField(
            model_name='film',
            name='processed_by',
            field=models.ForeignKey(blank=True, help_text='Person or place that processed this film', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Person'),
        ),
        migrations.AddField(
            model_name='enlarger',
            name='manufacturer',
            field=models.ForeignKey(blank=True, help_text='Manufacturer of this enlarger', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer'),
        ),
        migrations.AddField(
            model_name='enlarger',
            name='negative_size',
            field=models.ForeignKey(blank=True, help_text='Largest negative size that this enlarger can accept', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.NegativeSize'),
        ),
        migrations.AddField(
            model_name='developer',
            name='manufacturer',
            field=models.ForeignKey(blank=True, help_text='Manufacturer of this developer', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer'),
        ),
        migrations.CreateModel(
            name='CameraModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model', models.CharField(help_text='The model name of the camera', max_length=45)),
                ('focus_type', models.CharField(blank=True, choices=[('Autofocus', 'Autofocus'), ('Fixed focus', 'Fixed focus'), ('Zone focus', 'Zone focus'), ('Rangefinder', 'Rangefinder'), ('SLR', 'SLR'), ('TLR', 'TLR'), ('View camera', 'View camera')], help_text='Focus type used on this camera model', max_length=25, null=True)),
                ('metering', models.BooleanField(blank=True, help_text='Whether the camera has built-in metering', null=True)),
                ('coupled_metering', models.BooleanField(blank=True, help_text='Whether the cameras meter is coupled automatically', null=True)),
                ('body_type', models.CharField(blank=True, choices=[('Box camera', 'Box camera'), ('Folding camera', 'Folding camera'), ('Compact camera', 'Compact camera'), ('SLR', 'SLR'), ('TLR', 'TLR'), ('Bridge camera', 'Bridge camera'), ('View camera', 'View camera'), ('Pistol grip camera', 'Pistol grip camera'), ('Miniature camera', 'Miniature camera')], help_text='Body type of this camera model', max_length=25, null=True)),
                ('weight', models.PositiveIntegerField(blank=True, help_text='Weight of the camera body (without lens or batteries) in grammes (g)', null=True)),
                ('introduced', models.PositiveIntegerField(blank=True, help_text='Year in which the camera model was introduced', null=True)),
                ('discontinued', models.PositiveIntegerField(blank=True, help_text='Year in which the camera model was discontinued', null=True)),
                ('shutter_type', models.CharField(blank=True, choices=[('Focal plane cloth', 'Focal plane cloth'), ('Focal plane metal', 'Focal plane metal'), ('Leaf', 'Leaf'), ('Rotary', 'Rotary'), ('Sliding', 'Sliding'), ('Electronic', 'Electronic')], help_text='Type of shutter used on this camera model', max_length=25, null=True)),
                ('shutter_model', models.CharField(blank=True, help_text='Model of shutter', max_length=45, null=True)),
                ('cable_release', models.BooleanField(blank=True, help_text='Whether the camera has the facility for a remote cable release', null=True)),
                ('viewfinder_coverage', models.PositiveIntegerField(blank=True, help_text='Percentage coverage of the viewfinder. Mostly applicable to SLRs.', null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(100)])),
                ('power_drive', models.BooleanField(blank=True, help_text='Whether the camera has integrated motor drive', null=True)),
                ('continuous_fps', models.DecimalField(blank=True, decimal_places=1, help_text='The maximum rate at which the camera can shoot, in frames per second', max_digits=4, null=True)),
                ('video', models.BooleanField(blank=True, help_text='Whether the camera can take video/movie', null=True)),
                ('digital', models.BooleanField(blank=True, default=0, help_text='Whether this is a digital camera', null=True)),
                ('fixed_mount', models.BooleanField(blank=True, help_text='Whether the camera has a fixed lens', null=True)),
                ('battery_qty', models.PositiveIntegerField(blank=True, help_text='Quantity of batteries needed', null=True)),
                ('notes', models.CharField(blank=True, help_text='Freeform text field for extra notes', max_length=100, null=True)),
                ('bulb', models.BooleanField(blank=True, help_text='Whether the camera supports bulb (B) exposure', null=True)),
                ('time', models.BooleanField(blank=True, help_text='Whether the camera supports time (T) exposure', null=True)),
                ('min_iso', models.PositiveIntegerField(blank=True, help_text='Minimum ISO the camera will accept for metering', null=True, verbose_name='Min ISO')),
                ('max_iso', models.PositiveIntegerField(blank=True, help_text='Maximum ISO the camera will accept for metering', null=True, verbose_name='Max ISO')),
                ('af_points', models.PositiveIntegerField(blank=True, help_text='Number of autofocus points', null=True, verbose_name='Autofocus points')),
                ('int_flash', models.BooleanField(blank=True, help_text='Whether the camera has an integrated flash', null=True, verbose_name='Internal flash')),
                ('int_flash_gn', models.PositiveIntegerField(blank=True, help_text='Guide number of internal flash', null=True, verbose_name='Internal flash guide number')),
                ('ext_flash', models.BooleanField(blank=True, help_text='Whether the camera supports an external flash', null=True, verbose_name='External flash')),
                ('pc_sync', models.BooleanField(blank=True, help_text='Whether the camera has a PC sync socket for flash', null=True, verbose_name='PC sync')),
                ('hotshoe', models.BooleanField(blank=True, help_text='Whether the camera has a hotshoe', null=True)),
                ('coldshoe', models.BooleanField(blank=True, help_text='Whether the camera has a coldshoe or accessory shoe', null=True)),
                ('meter_min_ev', models.PositiveIntegerField(blank=True, help_text='Lowest EV/LV the built-in meter supports', null=True, verbose_name='Min EV')),
                ('meter_max_ev', models.PositiveIntegerField(blank=True, help_text='Highest EV/LV the built-in meter supports', null=True, verbose_name='Max EV')),
                ('dof_preview', models.BooleanField(blank=True, help_text='Whether the camera has depth of field preview', null=True, verbose_name='DoF preview')),
                ('tripod', models.BooleanField(blank=True, help_text='Whether the camera has a tripod bush', null=True)),
                ('battery_type', models.ForeignKey(blank=True, help_text='Battery type that this camera model needs', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Battery')),
                ('exposure_programs', models.ManyToManyField(blank=True, to='schema.ExposureProgram')),
                ('flash_metering', models.ForeignKey(blank=True, help_text='Whether this camera model supports flash metering', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.FlashProtocol')),
                ('format', models.ForeignKey(blank=True, help_text='Film format used by this camera model', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Format')),
                ('lensmodel', models.ForeignKey(blank=True, help_text='Lens model attached to this camera model, if it is a fixed-lens camera', limit_choices_to={'fixed_mount': True}, null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.LensModel')),
                ('manufacturer', models.ForeignKey(blank=True, help_text='Manufacturer of this camera model', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer')),
                ('metering_modes', models.ManyToManyField(blank=True, to='schema.MeteringMode')),
                ('metering_type', models.ForeignKey(blank=True, help_text='Metering type used on this camera model', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.MeteringType')),
                ('mount', models.ForeignKey(blank=True, help_text='Lens mount used by this camera model', limit_choices_to={'purpose': 'Camera'}, null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Mount')),
                ('negative_size', models.ForeignKey(blank=True, help_text='Size of negative created by this camera', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.NegativeSize')),
                ('series', models.ManyToManyField(blank=True, to='schema.Series')),
                ('shutter_speeds', models.ManyToManyField(blank=True, to='schema.ShutterSpeed')),
            ],
            options={
                'verbose_name_plural': 'camera models',
                'ordering': ['manufacturer', 'model'],
            },
        ),
        migrations.AddField(
            model_name='camera',
            name='cameramodel',
            field=models.ForeignKey(help_text='Camera model of this camera', on_delete=django.db.models.deletion.CASCADE, to='schema.CameraModel'),
        ),
        migrations.AddField(
            model_name='camera',
            name='condition',
            field=models.ForeignKey(blank=True, help_text='Condition of this camera', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Condition'),
        ),
        migrations.AddField(
            model_name='camera',
            name='display_lens',
            field=models.OneToOneField(blank=True, help_text='Lens that this camera should be displayed with', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='display_camera', to='schema.Lens'),
        ),
        migrations.AddField(
            model_name='camera',
            name='lens',
            field=models.ForeignKey(blank=True, help_text='Lens attached to this camera, if it is a fixed-lens camera', limit_choices_to={'lensmodel__fixed_mount': True}, null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Lens'),
        ),
        migrations.AddField(
            model_name='bulkfilm',
            name='filmstock',
            field=models.ForeignKey(help_text='Filmstock of this bulk film', on_delete=django.db.models.deletion.CASCADE, to='schema.FilmStock'),
        ),
        migrations.AddField(
            model_name='bulkfilm',
            name='format',
            field=models.ForeignKey(help_text='Film format of this bulk film', on_delete=django.db.models.deletion.CASCADE, to='schema.Format'),
        ),
        migrations.CreateModel(
            name='Accessory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('Battery grip', 'Battery grip'), ('Case', 'Case'), ('Film back', 'Film back'), ('Focusing screen', 'Focusing screen'), ('Lens hood', 'Lens hood'), ('Lens cap', 'Lens cap'), ('Power winder', 'Power winder'), ('Viewfinder', 'Viewfinder'), ('Rangefinder', 'Rangefinder')], help_text='Type of accessory', max_length=15)),
                ('model', models.CharField(help_text='Model of the accessory', max_length=45)),
                ('acquired', models.DateField(blank=True, help_text='Date that this accessory was acquired', null=True)),
                ('cost_currency', djmoney.models.fields.CurrencyField(choices=[('XUA', 'ADB Unit of Account'), ('AFN', 'Afghani'), ('DZD', 'Algerian Dinar'), ('ARS', 'Argentine Peso'), ('AMD', 'Armenian Dram'), ('AWG', 'Aruban Guilder'), ('AUD', 'Australian Dollar'), ('AZN', 'Azerbaijanian Manat'), ('BSD', 'Bahamian Dollar'), ('BHD', 'Bahraini Dinar'), ('THB', 'Baht'), ('PAB', 'Balboa'), ('BBD', 'Barbados Dollar'), ('BYN', 'Belarussian Ruble'), ('BYR', 'Belarussian Ruble'), ('BZD', 'Belize Dollar'), ('BMD', 'Bermudian Dollar (customarily known as Bermuda Dollar)'), ('BTN', 'Bhutanese ngultrum'), ('VEF', 'Bolivar Fuerte'), ('BOB', 'Boliviano'), ('XBA', 'Bond Markets Units European Composite Unit (EURCO)'), ('BRL', 'Brazilian Real'), ('BND', 'Brunei Dollar'), ('BGN', 'Bulgarian Lev'), ('BIF', 'Burundi Franc'), ('XOF', 'CFA Franc BCEAO'), ('XAF', 'CFA franc BEAC'), ('XPF', 'CFP Franc'), ('CAD', 'Canadian Dollar'), ('CVE', 'Cape Verde Escudo'), ('KYD', 'Cayman Islands Dollar'), ('CLP', 'Chilean peso'), ('XTS', 'Codes specifically reserved for testing purposes'), ('COP', 'Colombian peso'), ('KMF', 'Comoro Franc'), ('CDF', 'Congolese franc'), ('BAM', 'Convertible Marks'), ('NIO', 'Cordoba Oro'), ('CRC', 'Costa Rican Colon'), ('HRK', 'Croatian Kuna'), ('CUP', 'Cuban Peso'), ('CUC', 'Cuban convertible peso'), ('CZK', 'Czech Koruna'), ('GMD', 'Dalasi'), ('DKK', 'Danish Krone'), ('MKD', 'Denar'), ('DJF', 'Djibouti Franc'), ('STD', 'Dobra'), ('DOP', 'Dominican Peso'), ('VND', 'Dong'), ('XCD', 'East Caribbean Dollar'), ('EGP', 'Egyptian Pound'), ('SVC', 'El Salvador Colon'), ('ETB', 'Ethiopian Birr'), ('EUR', 'Euro'), ('XBB', 'European Monetary Unit (E.M.U.-6)'), ('XBD', 'European Unit of Account 17(E.U.A.-17)'), ('XBC', 'European Unit of Account 9(E.U.A.-9)'), ('FKP', 'Falkland Islands Pound'), ('FJD', 'Fiji Dollar'), ('HUF', 'Forint'), ('GHS', 'Ghana Cedi'), ('GIP', 'Gibraltar Pound'), ('XAU', 'Gold'), ('XFO', 'Gold-Franc'), ('PYG', 'Guarani'), ('GNF', 'Guinea Franc'), ('GYD', 'Guyana Dollar'), ('HTG', 'Haitian gourde'), ('HKD', 'Hong Kong Dollar'), ('UAH', 'Hryvnia'), ('ISK', 'Iceland Krona'), ('INR', 'Indian Rupee'), ('IRR', 'Iranian Rial'), ('IQD', 'Iraqi Dinar'), ('IMP', 'Isle of Man Pound'), ('JMD', 'Jamaican Dollar'), ('JOD', 'Jordanian Dinar'), ('KES', 'Kenyan Shilling'), ('PGK', 'Kina'), ('LAK', 'Kip'), ('KWD', 'Kuwaiti Dinar'), ('AOA', 'Kwanza'), ('MMK', 'Kyat'), ('GEL', 'Lari'), ('LVL', 'Latvian Lats'), ('LBP', 'Lebanese Pound'), ('ALL', 'Lek'), ('HNL', 'Lempira'), ('SLL', 'Leone'), ('LSL', 'Lesotho loti'), ('LRD', 'Liberian Dollar'), ('LYD', 'Libyan Dinar'), ('SZL', 'Lilangeni'), ('LTL', 'Lithuanian Litas'), ('MGA', 'Malagasy Ariary'), ('MWK', 'Malawian Kwacha'), ('MYR', 'Malaysian Ringgit'), ('TMM', 'Manat'), ('MUR', 'Mauritius Rupee'), ('MZN', 'Metical'), ('MXV', 'Mexican Unidad de Inversion (UDI)'), ('MXN', 'Mexican peso'), ('MDL', 'Moldovan Leu'), ('MAD', 'Moroccan Dirham'), ('BOV', 'Mvdol'), ('NGN', 'Naira'), ('ERN', 'Nakfa'), ('NAD', 'Namibian Dollar'), ('NPR', 'Nepalese Rupee'), ('ANG', 'Netherlands Antillian Guilder'), ('ILS', 'New Israeli Sheqel'), ('RON', 'New Leu'), ('TWD', 'New Taiwan Dollar'), ('NZD', 'New Zealand Dollar'), ('KPW', 'North Korean Won'), ('NOK', 'Norwegian Krone'), ('PEN', 'Nuevo Sol'), ('MRO', 'Ouguiya'), ('TOP', 'Paanga'), ('PKR', 'Pakistan Rupee'), ('XPD', 'Palladium'), ('MOP', 'Pataca'), ('PHP', 'Philippine Peso'), ('XPT', 'Platinum'), ('GBP', 'Pound Sterling'), ('BWP', 'Pula'), ('QAR', 'Qatari Rial'), ('GTQ', 'Quetzal'), ('ZAR', 'Rand'), ('OMR', 'Rial Omani'), ('KHR', 'Riel'), ('MVR', 'Rufiyaa'), ('IDR', 'Rupiah'), ('RUB', 'Russian Ruble'), ('RWF', 'Rwanda Franc'), ('XDR', 'SDR'), ('SHP', 'Saint Helena Pound'), ('SAR', 'Saudi Riyal'), ('RSD', 'Serbian Dinar'), ('SCR', 'Seychelles Rupee'), ('XAG', 'Silver'), ('SGD', 'Singapore Dollar'), ('SBD', 'Solomon Islands Dollar'), ('KGS', 'Som'), ('SOS', 'Somali Shilling'), ('TJS', 'Somoni'), ('SSP', 'South Sudanese Pound'), ('LKR', 'Sri Lanka Rupee'), ('XSU', 'Sucre'), ('SDG', 'Sudanese Pound'), ('SRD', 'Surinam Dollar'), ('SEK', 'Swedish Krona'), ('CHF', 'Swiss Franc'), ('SYP', 'Syrian Pound'), ('BDT', 'Taka'), ('WST', 'Tala'), ('TZS', 'Tanzanian Shilling'), ('KZT', 'Tenge'), ('XXX', 'The codes assigned for transactions where no currency is involved'), ('TTD', 'Trinidad and Tobago Dollar'), ('MNT', 'Tugrik'), ('TND', 'Tunisian Dinar'), ('TRY', 'Turkish Lira'), ('TMT', 'Turkmenistan New Manat'), ('TVD', 'Tuvalu dollar'), ('AED', 'UAE Dirham'), ('XFU', 'UIC-Franc'), ('USD', 'US Dollar'), ('USN', 'US Dollar (Next day)'), ('UGX', 'Uganda Shilling'), ('CLF', 'Unidad de Fomento'), ('COU', 'Unidad de Valor Real'), ('UYI', 'Uruguay Peso en Unidades Indexadas (URUIURUI)'), ('UYU', 'Uruguayan peso'), ('UZS', 'Uzbekistan Sum'), ('VUV', 'Vatu'), ('CHE', 'WIR Euro'), ('CHW', 'WIR Franc'), ('KRW', 'Won'), ('YER', 'Yemeni Rial'), ('JPY', 'Yen'), ('CNY', 'Yuan Renminbi'), ('ZMK', 'Zambian Kwacha'), ('ZMW', 'Zambian Kwacha'), ('ZWD', 'Zimbabwe Dollar A/06'), ('ZWN', 'Zimbabwe dollar A/08'), ('ZWL', 'Zimbabwe dollar A/09'), ('PLN', 'Zloty')], default='GBP', editable=False, max_length=3)),
                ('cost', djmoney.models.fields.MoneyField(blank=True, decimal_places=2, default_currency='GBP', help_text='Purchase cost of the accessory', max_digits=12, null=True)),
                ('lost', models.DateField(blank=True, help_text='Date that this accessory was lost', null=True)),
                ('lost_price_currency', djmoney.models.fields.CurrencyField(choices=[('XUA', 'ADB Unit of Account'), ('AFN', 'Afghani'), ('DZD', 'Algerian Dinar'), ('ARS', 'Argentine Peso'), ('AMD', 'Armenian Dram'), ('AWG', 'Aruban Guilder'), ('AUD', 'Australian Dollar'), ('AZN', 'Azerbaijanian Manat'), ('BSD', 'Bahamian Dollar'), ('BHD', 'Bahraini Dinar'), ('THB', 'Baht'), ('PAB', 'Balboa'), ('BBD', 'Barbados Dollar'), ('BYN', 'Belarussian Ruble'), ('BYR', 'Belarussian Ruble'), ('BZD', 'Belize Dollar'), ('BMD', 'Bermudian Dollar (customarily known as Bermuda Dollar)'), ('BTN', 'Bhutanese ngultrum'), ('VEF', 'Bolivar Fuerte'), ('BOB', 'Boliviano'), ('XBA', 'Bond Markets Units European Composite Unit (EURCO)'), ('BRL', 'Brazilian Real'), ('BND', 'Brunei Dollar'), ('BGN', 'Bulgarian Lev'), ('BIF', 'Burundi Franc'), ('XOF', 'CFA Franc BCEAO'), ('XAF', 'CFA franc BEAC'), ('XPF', 'CFP Franc'), ('CAD', 'Canadian Dollar'), ('CVE', 'Cape Verde Escudo'), ('KYD', 'Cayman Islands Dollar'), ('CLP', 'Chilean peso'), ('XTS', 'Codes specifically reserved for testing purposes'), ('COP', 'Colombian peso'), ('KMF', 'Comoro Franc'), ('CDF', 'Congolese franc'), ('BAM', 'Convertible Marks'), ('NIO', 'Cordoba Oro'), ('CRC', 'Costa Rican Colon'), ('HRK', 'Croatian Kuna'), ('CUP', 'Cuban Peso'), ('CUC', 'Cuban convertible peso'), ('CZK', 'Czech Koruna'), ('GMD', 'Dalasi'), ('DKK', 'Danish Krone'), ('MKD', 'Denar'), ('DJF', 'Djibouti Franc'), ('STD', 'Dobra'), ('DOP', 'Dominican Peso'), ('VND', 'Dong'), ('XCD', 'East Caribbean Dollar'), ('EGP', 'Egyptian Pound'), ('SVC', 'El Salvador Colon'), ('ETB', 'Ethiopian Birr'), ('EUR', 'Euro'), ('XBB', 'European Monetary Unit (E.M.U.-6)'), ('XBD', 'European Unit of Account 17(E.U.A.-17)'), ('XBC', 'European Unit of Account 9(E.U.A.-9)'), ('FKP', 'Falkland Islands Pound'), ('FJD', 'Fiji Dollar'), ('HUF', 'Forint'), ('GHS', 'Ghana Cedi'), ('GIP', 'Gibraltar Pound'), ('XAU', 'Gold'), ('XFO', 'Gold-Franc'), ('PYG', 'Guarani'), ('GNF', 'Guinea Franc'), ('GYD', 'Guyana Dollar'), ('HTG', 'Haitian gourde'), ('HKD', 'Hong Kong Dollar'), ('UAH', 'Hryvnia'), ('ISK', 'Iceland Krona'), ('INR', 'Indian Rupee'), ('IRR', 'Iranian Rial'), ('IQD', 'Iraqi Dinar'), ('IMP', 'Isle of Man Pound'), ('JMD', 'Jamaican Dollar'), ('JOD', 'Jordanian Dinar'), ('KES', 'Kenyan Shilling'), ('PGK', 'Kina'), ('LAK', 'Kip'), ('KWD', 'Kuwaiti Dinar'), ('AOA', 'Kwanza'), ('MMK', 'Kyat'), ('GEL', 'Lari'), ('LVL', 'Latvian Lats'), ('LBP', 'Lebanese Pound'), ('ALL', 'Lek'), ('HNL', 'Lempira'), ('SLL', 'Leone'), ('LSL', 'Lesotho loti'), ('LRD', 'Liberian Dollar'), ('LYD', 'Libyan Dinar'), ('SZL', 'Lilangeni'), ('LTL', 'Lithuanian Litas'), ('MGA', 'Malagasy Ariary'), ('MWK', 'Malawian Kwacha'), ('MYR', 'Malaysian Ringgit'), ('TMM', 'Manat'), ('MUR', 'Mauritius Rupee'), ('MZN', 'Metical'), ('MXV', 'Mexican Unidad de Inversion (UDI)'), ('MXN', 'Mexican peso'), ('MDL', 'Moldovan Leu'), ('MAD', 'Moroccan Dirham'), ('BOV', 'Mvdol'), ('NGN', 'Naira'), ('ERN', 'Nakfa'), ('NAD', 'Namibian Dollar'), ('NPR', 'Nepalese Rupee'), ('ANG', 'Netherlands Antillian Guilder'), ('ILS', 'New Israeli Sheqel'), ('RON', 'New Leu'), ('TWD', 'New Taiwan Dollar'), ('NZD', 'New Zealand Dollar'), ('KPW', 'North Korean Won'), ('NOK', 'Norwegian Krone'), ('PEN', 'Nuevo Sol'), ('MRO', 'Ouguiya'), ('TOP', 'Paanga'), ('PKR', 'Pakistan Rupee'), ('XPD', 'Palladium'), ('MOP', 'Pataca'), ('PHP', 'Philippine Peso'), ('XPT', 'Platinum'), ('GBP', 'Pound Sterling'), ('BWP', 'Pula'), ('QAR', 'Qatari Rial'), ('GTQ', 'Quetzal'), ('ZAR', 'Rand'), ('OMR', 'Rial Omani'), ('KHR', 'Riel'), ('MVR', 'Rufiyaa'), ('IDR', 'Rupiah'), ('RUB', 'Russian Ruble'), ('RWF', 'Rwanda Franc'), ('XDR', 'SDR'), ('SHP', 'Saint Helena Pound'), ('SAR', 'Saudi Riyal'), ('RSD', 'Serbian Dinar'), ('SCR', 'Seychelles Rupee'), ('XAG', 'Silver'), ('SGD', 'Singapore Dollar'), ('SBD', 'Solomon Islands Dollar'), ('KGS', 'Som'), ('SOS', 'Somali Shilling'), ('TJS', 'Somoni'), ('SSP', 'South Sudanese Pound'), ('LKR', 'Sri Lanka Rupee'), ('XSU', 'Sucre'), ('SDG', 'Sudanese Pound'), ('SRD', 'Surinam Dollar'), ('SEK', 'Swedish Krona'), ('CHF', 'Swiss Franc'), ('SYP', 'Syrian Pound'), ('BDT', 'Taka'), ('WST', 'Tala'), ('TZS', 'Tanzanian Shilling'), ('KZT', 'Tenge'), ('XXX', 'The codes assigned for transactions where no currency is involved'), ('TTD', 'Trinidad and Tobago Dollar'), ('MNT', 'Tugrik'), ('TND', 'Tunisian Dinar'), ('TRY', 'Turkish Lira'), ('TMT', 'Turkmenistan New Manat'), ('TVD', 'Tuvalu dollar'), ('AED', 'UAE Dirham'), ('XFU', 'UIC-Franc'), ('USD', 'US Dollar'), ('USN', 'US Dollar (Next day)'), ('UGX', 'Uganda Shilling'), ('CLF', 'Unidad de Fomento'), ('COU', 'Unidad de Valor Real'), ('UYI', 'Uruguay Peso en Unidades Indexadas (URUIURUI)'), ('UYU', 'Uruguayan peso'), ('UZS', 'Uzbekistan Sum'), ('VUV', 'Vatu'), ('CHE', 'WIR Euro'), ('CHW', 'WIR Franc'), ('KRW', 'Won'), ('YER', 'Yemeni Rial'), ('JPY', 'Yen'), ('CNY', 'Yuan Renminbi'), ('ZMK', 'Zambian Kwacha'), ('ZMW', 'Zambian Kwacha'), ('ZWD', 'Zimbabwe Dollar A/06'), ('ZWN', 'Zimbabwe dollar A/08'), ('ZWL', 'Zimbabwe dollar A/09'), ('PLN', 'Zloty')], default='GBP', editable=False, max_length=3)),
                ('lost_price', djmoney.models.fields.MoneyField(blank=True, decimal_places=2, default_currency='GBP', help_text='Sale price of the accessory', max_digits=12, null=True)),
                ('camera_model_compatibility', models.ManyToManyField(blank=True, to='schema.CameraModel')),
                ('lens_model_compatibility', models.ManyToManyField(blank=True, to='schema.LensModel')),
                ('manufacturer', models.ForeignKey(blank=True, help_text='Manufacturer of this accessory', null=True, on_delete=django.db.models.deletion.CASCADE, to='schema.Manufacturer')),
            ],
            options={
                'verbose_name_plural': 'accessories',
                'ordering': ['manufacturer', 'model'],
            },
        ),
        migrations.AlterUniqueTogether(
            name='negative',
            unique_together={('film', 'frame')},
        ),
        migrations.AlterUniqueTogether(
            name='lens',
            unique_together={('lensmodel', 'serial')},
        ),
        migrations.AlterUniqueTogether(
            name='camera',
            unique_together={('cameramodel', 'serial')},
        ),
    ]
