# coding: utf-8

from enum import Enum

class Mark(Enum):
    D = "底分型"
    G = "顶分型"

class Direction(Enum):
    Up = "向上"
    Down = "向下"

class Freq(Enum):
    F1 = "1分钟"
    F5 = "5分钟"
    F15 = "15分钟"
    F30 = "30分钟"
    F60 = "60分钟"
    D = "日线"
    W = "周线"
    M = "月线"

class Signals(Enum):
    Other = "Other~其他"
    Y = "Y~是"
    N = "N~否"

    INB = "INB~向下笔买点区间"
    INS = "INS~向上笔卖点区间"

    FXB = "FXB~向下笔结束分型左侧高点升破"
    FXS = "FXS~向上笔结束分型左侧低点跌破"

    BIU0 = "BIU0~向上笔顶分完成"
    BIU1 = "BIU1~向上笔走势延伸"

    BID0 = "BID0~向下笔底分完成"
    BID1 = "BID1~向下笔走势延伸"

    # TK = Triple K
    TK1 = "TK1~三K底分"
    TK2 = "TK2~三K上涨"
    TK3 = "TK3~三K顶分"
    TK4 = "TK4~三K下跌"

    # 信号值编码规则：
    # 笔数：X3 - 三笔信号；X5 - 五笔信号；X7 - 七笔信号；X9 - 九笔信号；
    # 多空：L - 多头信号；S - 空头信号；
    # 编号：A0 - A类基础型；A1 - A类变种1 ... 以此类推
    # 组合规则：笔数_多空_编号；如 X5LA0 表示五笔多头信号A0
    # ============================================================================================
    # 三笔形态信号
    # 具体描述：
    # --------------------------------------------------------------------------------------------
    X3LA0 = "X3LA0~向下不重合"
    X3LB0 = "X3LB0~向下奔走型中枢"
    X3LC0 = "X3LC0~向下三角收敛中枢"
    X3LD0 = "X3LD0~向下三角扩张中枢"
    X3LE0 = "X3LE0~向下盘背中枢"
    X3LF0 = "X3LF0~向下无背中枢"

    X3SA0 = "X3SA0~向上不重合"
    X3SB0 = "X3SB0~向上奔走型中枢"
    X3SC0 = "X3SC0~向上三角收敛中枢"
    X3SD0 = "X3SD0~向上三角扩张中枢"
    X3SE0 = "X3SE0~向上盘背中枢"
    X3SF0 = "X3SF0~向上无背中枢"

    # 五笔形态信号
    # 具体描述：https://blog.csdn.net/baidu_25764509/article/details/113639353
    # --------------------------------------------------------------------------------------------
    X5LA0 = "X5LA0~aAb式底背驰段"
    X5LB0 = "X5LB0~三买"
    X5LC0 = "X5LC0~类趋势底背驰段"
    X5LD0 = "X5LD0~向下三角扩张中枢"
    X5LE0 = "X5LE0~向下三角收敛中枢"
    X5LF0 = "X5LF0~上颈线突破"

    X5SA0 = "X5SA0~aAb式顶背驰段"
    X5SB0 = "X5SB0~三卖"
    X5SC0 = "X5SC0~类趋势顶背驰段"
    X5SD0 = "X5SD0~向上三角扩张中枢"
    X5SE0 = "X5SE0~向上三角收敛中枢"
    X5SF0 = "X5SF0~下颈线跌破"
    # --------------------------------------------------------------------------------------------
    # 七笔多头信号
    # 具体描述：https://blog.csdn.net/baidu_25764509/article/details/113649988
    # --------------------------------------------------------------------------------------------
    X7LA0 = "X7LA0~aAbcd式底背驰段"
    X7LB0 = "X7LB0~abcAd式底背驰段"
    X7LC0 = "X7LC0~aAb式底背驰段"
    X7LD0 = "X7LD0~类趋势底背驰段"

    X7LE0 = "X7LE0~BaA式右侧底"
    X7LE1 = "X7LE1~BaA式右侧底"

    X7LF0 = "X7LF0~类趋势底背驰强反弹后不创新低"

    X7SA0 = "X7SA0~aAbcd式顶背驰段"
    X7SB0 = "X7SB0~abcAd式顶背驰段"
    X7SC0 = "X7SC0~aAb式顶背驰段"
    X7SD0 = "X7SD0~类趋势顶背驰段"

    X7SE0 = "X7SE0~BaA式右侧顶"
    X7SE1 = "X7SE1~BaA式右侧顶"

    X7SF0 = "X7SF0~类趋势顶背驰强反弹后不创新高"

    # --------------------------------------------------------------------------------------------
    # 九笔信号
    # --------------------------------------------------------------------------------------------
    X9LA0 = "X9LA0~aAbBc式底背驰段"
    X9LB0 = "X9LB0~aAb式底背驰段"
    X9LC0 = "X9LC0~aAbcd式底背驰段"
    X9LD0 = "X9LD0~ABC式底背驰段"

    X9SA0 = "X9SA0~aAbBc式顶背驰段"
    X9SB0 = "X9SB0~aAb式顶背驰段"
    X9SC0 = "X9SC0~aAbcd式顶背驰段"
    X9SD0 = "X9SD0~ABC式顶背驰段"
    # --------------------------------------------------------------------------------------------
    # 同级别组合信号
    # R 表示倒转的意思，R1 就是倒数第1笔， R2 就是倒数第2笔，以此类推
    # --------------------------------------------------------------------------------------------
    R5X7R1X5LA0 = "R5X7R1X5LA0~倒5七笔为abcAd式底背驰段&倒1五笔为其他"


class Factors(Enum):
    Other = "Other~其他"
    Y = "Y~是"
    N = "N~否"

    BUE0 = "BUE0~向上笔结束"
    BUE1 = "BUE1~向上笔结束"
    BUE2 = "BUE2~向上笔结束"
    BUE3 = "BUE3~向上笔结束"
    BUE4 = "BUE4~向上笔结束"
    BUE5 = "BUE5~向上笔结束"

    BDE0 = "BDE0~向下笔结束"
    BDE1 = "BDE1~向下笔结束"
    BDE2 = "BDE2~向下笔结束"
    BDE3 = "BDE3~向下笔结束"
    BDE4 = "BDE4~向下笔结束"
    BDE5 = "BDE5~向下笔结束"

    # ============================================================================================
    # 以下是笔因子V1
    #
    # 因子值编码规则：
    # 类型：
    #   L1 - 向下笔转折右侧；L2 - 向下笔转折左侧；L3 - 向上笔中继右侧；L4 - 向上笔中继左侧；
    #   S1 - 向上笔转折右侧；S2 - 向上笔转折左侧；S3 - 向下笔中继右侧；S4 - 向下笔中继左侧；
    # 编号：A0 - A类基础型；A1 - A类变种1 ... 以此类推
    # 组合规则为 类型_编号
    # ============================================================================================
    L1A0 = "L1A0~次级别三买"

    L1B0 = "L1B0~本级别第N笔强底分转折"

    L2A0 = "L2A0~次级别底背驰"
    L2A1 = "L2A1~次级别底背驰&小级别上颈线突破"

    L2B0 = "L2B0~次级别aAbBc式底背驰"
    L2B1 = "L2B1~次级别aAbBc式底背驰&小级别上颈线突破"

    L3A0 = "L3A0~小级别近七笔为BaA式右侧底"
    L3B0 = "L3B0~小级别上颈线突破"
    L3C0 = "L3C0~次级别上颈线突破"
    L4A0 = "L4A0~小级别近七笔为底背驰"

    S1A0 = "S1A0~次级别三卖"
    S1A1 = "S1A1~次级别三卖&小级别下颈线跌破"

    S1B0 = "S1B0~次级别下颈线跌破"
    S1B1 = "S1B1~次级别和小级别近五笔都为下颈线跌破"

    S2A0 = "S2A0~次级别顶背驰"
    S2A1 = "S2A1~次级别顶背驰&小级别下颈线跌破"

    S3A0 = "S3A0~小级别近七笔为BaA式右侧顶"
    S3B0 = "S3B0~小级别下颈线跌破"
    S4A0 = "S4A0~小级别顶背驰"
    # ============================================================================================
    # 以下是笔因子V2
    #
    # 因子值编码规则：
    # 级别：C1 - 1分钟；C2 - 5分钟; C3 - 15分钟; C4 - 30分钟; C5 - 60分钟; C6 - 日线;
    # 类型：
    #   B1 - 笔的次级别类一买；B2 - 笔的次级别类二买；B3 - 笔的次级别类三买；
    #   S1 - 笔的次级别类一卖；S2 - 笔的次级别类二卖；S3 - 笔的次级别类三卖；
    # 编号：A0 - A类基础型；A1 - A类变种1 ... 以此类推
    # 组合规则为 本级别_类型_编号
    # ============================================================================================
    # C6B1A0 = "C6B1A0~"
    # C6B2A0 = "C6B2A0~"
    # C6B3A0 = "C6B3A0~"
    #
    # C6S1A0 = "C6S1A0~"
    # C6S2A0 = "C6S2A0~"
    # C6S3A0 = "C6S3A0~"


