"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
const util = require("./util");
/**
 * Represents a reference to a REST API's Empty model, which is available
 * as part of the model collection by default. This can be used for mapping
 * JSON responses from an integration to what is returned to a client,
 * where strong typing is not required. In the absence of any defined
 * model, the Empty model will be used to return the response payload
 * unmapped.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Empty Schema",
 *   "type" : "object"
 * }
 *
 * @see https://docs.amazonaws.cn/en_us/apigateway/latest/developerguide/models-mappings.html#models-mappings-models
 * @deprecated You should use @see Model.EMPTY_MODEL
 */
class EmptyModel {
    constructor() {
        this.modelId = 'Empty';
    }
}
exports.EmptyModel = EmptyModel;
/**
 * Represents a reference to a REST API's Error model, which is available
 * as part of the model collection by default. This can be used for mapping
 * error JSON responses from an integration to a client, where a simple
 * generic message field is sufficient to map and return an error payload.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Error Schema",
 *   "type" : "object",
 *   "properties" : {
 *     "message" : { "type" : "string" }
 *   }
 * }
 * @deprecated You should use @see Model.ERROR_MODEL
 */
class ErrorModel {
    constructor() {
        this.modelId = 'Error';
    }
}
exports.ErrorModel = ErrorModel;
class Model extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, {
            physicalName: props.modelName,
        });
        const modelProps = {
            name: this.physicalName,
            restApiId: props.restApi.restApiId,
            contentType: (_a = props.contentType) !== null && _a !== void 0 ? _a : 'application/json',
            description: props.description,
            schema: util.JsonSchemaMapper.toCfnJsonSchema(props.schema)
        };
        const resource = new apigateway_generated_1.CfnModel(this, 'Resource', modelProps);
        this.modelId = this.getResourceNameAttribute(resource.ref);
        const deployment = (props.restApi instanceof restapi_1.RestApi) ? props.restApi.latestDeployment : undefined;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({ model: modelProps });
        }
    }
    static fromModelName(scope, id, modelName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.modelId = modelName;
            }
        }
        return new Import(scope, id);
    }
}
exports.Model = Model;
/**
 * Represents a reference to a REST API's Error model, which is available
 * as part of the model collection by default. This can be used for mapping
 * error JSON responses from an integration to a client, where a simple
 * generic message field is sufficient to map and return an error payload.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Error Schema",
 *   "type" : "object",
 *   "properties" : {
 *     "message" : { "type" : "string" }
 *   }
 * }
 */
Model.ERROR_MODEL = new ErrorModel();
/**
 * Represents a reference to a REST API's Empty model, which is available
 * as part of the model collection by default. This can be used for mapping
 * JSON responses from an integration to what is returned to a client,
 * where strong typing is not required. In the absence of any defined
 * model, the Empty model will be used to return the response payload
 * unmapped.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Empty Schema",
 *   "type" : "object"
 * }
 *
 * @see https://docs.amazonaws.cn/en_us/apigateway/latest/developerguide/models-mappings.html#models-mappings-models
 */
Model.EMPTY_MODEL = new EmptyModel();
//# sourceMappingURL=data:application/json;base64,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