import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExternalProviderConfig {
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/external#alias ExternalProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/external external}
*/
export declare class ExternalProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "external";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/external external} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExternalProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: ExternalProviderConfig);
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
