class Rule34Post:
    """
    The data structure for images on rule34. By default, all items are none,
    they will only be something else if rule34.xxx specifies a value.

    if ``initialised`` is False, that means somehow this object wasn't initialised properly, and you should discard it
    """
    initialised = False  # If this is false, the post data isn't complete for whatever reason, dont use it

    # The image's data
    height = None  # Image dimension height
    width = None  # Image dimension width
    score = None  # The image's user determined rating
    file_url = None  # The image URL
    id = None # The id generated by rule34 for the image
    tags = None # All the tags associated with this image
    parent_id = None  # If this post is a child, this will show the ID of its parent
    has_children = None  # Is this post a parent?
    has_comments = None  # Are there comments on this post?
    has_notes = None  # Are there notes on this post?
    created_at = None  # When the post was posted, funnily enough
    change = None  # Not sure what this is used for, but all posts have it. If you know, leave an issue telling me
    md5 = None  # The MD5 hash of the post, i have no idea why its necessary to expose, but rule34.xxx generates it
    creator_ID = None  # The post author's ID
    rating = None  # The rating of the post, pretty much always "e", ie Explicit
    status = None # Not sure what this is used for, but all posts have it. If you know, leave an issue telling me
    source = None # The source of the image, if listed

    # SAMPLE VERSION - These are smaller images, saving some data, if necessary
    sample_url = None  # Sample Image URL
    sample_height = None  # Sample image dimension height
    sample_width = None  # Sample image dimension width

    # PREVIEW VERSION - A TINY version of the image, suitable for thumbnails
    preview_url = None  # Preview image URL
    preview_height = None  # Preview image height
    preview_width = None  # Preview image width


    def parse(self, post):
        """Processes the data returned by rule34 into a more useful object"""
        # If for whatever reason an attribute isn't in the data returned by r34, we set it to None

        try:
            self.height = int(post['@height']) if '@height' in post else None
            self.width = int(post['@width']) if '@width' in post else None
        except TypeError:
            # Occasionally rule34 sends invalid height/width values, this catches that
            pass

        self.score = int(post['@score']) if '@score' in post else None
        self.file_url = str(post['@file_url']) if '@file_url' in post else None
        self.id = str(post['@id']) if '@id' in post else None
        self.tags = post['@tags'].strip().split(" ") if '@tags' in post else None
        self.parent_id = int(post['@parent_ID']) if '@parentID' in post else None

        try:
            self.has_children = False if post['@has_children'] == "false" else True
        except KeyError:
            self.has_children = None

        self.has_comments = False if post['@has_comments'] == "false" else True
        self.has_notes = False if post['@has_notes'] == "false" else True
        self.created_at = str(post['@created_at']) if '@created_at' in post else None
        self.change = str(post['@change']) if '@change' in post else None
        self.md5 = str(post['@md5']) if '@md5' in post else None
        self.creator_ID = int(post['@creator_id']) if '@creator_id' in post else None
        self.rating = str(post['@rating']) if '@rating' in post else None
        self.status = str(post['@status']) if '@status' in post else None
        self.source = str(post['@source']) if '@source' in post else None

        # SAMPLE VERSION - These are smaller images, saving some data, if necessary
        self.sample_url = str(post['@sample_url']) if '@sample_url' in post else None
        self.sample_height = int(post['@sample_height']) if '@sample_height' in post else None
        self.sample_width = int(post['@sample_width']) if '@sample_width' in post else None

        # PREVIEW VERSION - A TINY version of the image, suitable for thumbnails
        self.preview_url = str(post['@preview_url']) if '@preview_url' in post else None
        self.preview_height = int(post['@preview_height']) if '@preview_height' in post else None
        self.preview_width = int(post['@preview_width']) if '@preview_width' in post else None

        self.initialised = True
