# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-11-05 20:22


from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0008_alter_user_username_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='FieldList',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('model', models.CharField(max_length=100, verbose_name='model')),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('is_enable', models.BooleanField(default=True, verbose_name='Is enable')),
                ('is_sharable', models.BooleanField(verbose_name='Is sharable')),
                ('default', models.CharField(blank=True, max_length=200, null=True, verbose_name='Default')),
            ],
            options={
                'verbose_name': 'Field',
                'verbose_name_plural': 'Fields',
            },
        ),
        migrations.CreateModel(
            name='Management',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('application', models.CharField(max_length=100, verbose_name='Application')),
                ('constraint', models.CharField(max_length=200, verbose_name='constraints')),
                ('start_date', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Start date')),
                ('end_date', models.DateTimeField(blank=True, null=True, verbose_name='End date')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is Active')),
                ('fields', models.ManyToManyField(to='managements.FieldList', verbose_name='fields')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='auth.Group', verbose_name='group')),
                ('parent_obj', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='managements.Management', verbose_name='Parent')),
            ],
            options={
                'verbose_name': 'Admin Permission',
                'verbose_name_plural': 'Admin Permissions',
            },
        ),
        migrations.CreateModel(
            name='ManagementActions',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=50, verbose_name='Function title')),
                ('description', models.CharField(max_length=100, verbose_name='Description')),
            ],
            options={
                'verbose_name': 'Admin action',
                'verbose_name_plural': 'Admin actions',
            },
        ),
        migrations.CreateModel(
            name='ManagementPermission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('description', models.CharField(max_length=100, verbose_name='Description')),
            ],
        ),
        migrations.CreateModel(
            name='ManagementRoles',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=30, verbose_name='Role name')),
                ('management_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='managements.Management', verbose_name='Management group')),
            ],
            options={
                'verbose_name': 'Role',
                'verbose_name_plural': 'Roles',
            },
        ),
        migrations.AddField(
            model_name='fieldlist',
            name='actions',
            field=models.ManyToManyField(to='managements.ManagementActions', verbose_name='Actions'),
        ),
        migrations.AddField(
            model_name='fieldlist',
            name='permission',
            field=models.ManyToManyField(to='managements.ManagementPermission', verbose_name='Management Permission'),
        ),
    ]
