# coding: utf-8

"""
    VeeRoute.LSS Delivery

    VeeRoute.LSS Delivery API  # noqa: E501

    The version of the OpenAPI document: 3.6.163068
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import unittest
import datetime

import vrt_lss_delivery
from vrt_lss_delivery.models.convert_task import ConvertTask  # noqa: E501
from vrt_lss_delivery.rest import ApiException

class TestConvertTask(unittest.TestCase):
    """ConvertTask unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional):
        """Test ConvertTask
            include_option is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # model = vrt_lss_delivery.models.convert_task.ConvertTask()  # noqa: E501
        if include_optional :
            return ConvertTask(
                plan_task = vrt_lss_delivery.models.plan_task.PlanTask(
                    warehouses = [
                        vrt_lss_delivery.models.warehouse.Warehouse(
                            key = 'whs0001', 
                            location = vrt_lss_delivery.models.location.Location(
                                latitude = 55.692789, 
                                longitude = 37.554554, 
                                arrival_duration = 15, 
                                departure_duration = 5, ), 
                            work_windows = [
                                vrt_lss_delivery.models.time_window.TimeWindow(
                                    from = '2020-10-21T09:30+03:00', 
                                    to = '2020-10-21T19:45Z', )
                                ], )
                        ], 
                    orders = [
                        vrt_lss_delivery.models.order.Order(
                            key = 'order0001', 
                            type = 'DROP', 
                            warehouse_keys = [
                                'whs0001'
                                ], 
                            customer = vrt_lss_delivery.models.customer.Customer(
                                location = vrt_lss_delivery.models.location.Location(
                                    latitude = 55.692789, 
                                    longitude = 37.554554, 
                                    arrival_duration = 15, 
                                    departure_duration = 5, ), 
                                time_windows = [
                                    vrt_lss_delivery.models.time_window.TimeWindow(
                                        from = '2020-10-21T09:30+03:00', 
                                        to = '2020-10-21T19:45Z', )
                                    ], ), 
                            cargos = [
                                vrt_lss_delivery.models.cargo.Cargo(
                                    key = 'cargo01', 
                                    capacity = vrt_lss_delivery.models.capacity.Capacity(
                                        mass = 10, 
                                        volume = 2, 
                                        capacity_x = 1, 
                                        capacity_y = 2, 
                                        capacity_z = 3, ), 
                                    rotation = ["ALL"], 
                                    width = 1, 
                                    height = 0.3, 
                                    length = 2.2, 
                                    max_storage_time = 60, 
                                    restrictions = ["Freezer"], )
                                ], 
                            warehouse_duration = 10, 
                            customer_duration = 10, 
                            cost = vrt_lss_delivery.models.order_cost.OrderCost(
                                reward = 199.1, 
                                penalty = vrt_lss_delivery.models.cost_penalty.CostPenalty(
                                    start_time = '2020-10-21T17:00Z', 
                                    period = 60, 
                                    value = 1000, 
                                    max_value = 10000, ), ), 
                            order_features = ["Special"], 
                            order_restrictions = ["Special"], 
                            performer_restrictions = ["Special"], 
                            performer_blacklist = ["A0"], )
                        ], 
                    performers = [
                        vrt_lss_delivery.models.performer.Performer(
                            key = 'performer0001', 
                            count = 15, 
                            box = vrt_lss_delivery.models.box.Box(
                                key = 'box01', 
                                max_size = vrt_lss_delivery.models.capacity.Capacity(
                                    mass = 10, 
                                    volume = 2, 
                                    capacity_x = 1, 
                                    capacity_y = 2, 
                                    capacity_z = 3, ), 
                                width = 1, 
                                height = 3.1, 
                                length = 2.1, 
                                features = ["Freezer"], ), 
                            start_location = vrt_lss_delivery.models.location.Location(
                                latitude = 55.692789, 
                                longitude = 37.554554, 
                                arrival_duration = 15, 
                                departure_duration = 5, ), 
                            finish_location = vrt_lss_delivery.models.location.Location(
                                latitude = 55.692789, 
                                longitude = 37.554554, 
                                arrival_duration = 15, 
                                departure_duration = 5, ), 
                            features = ["B1","Special"], 
                            transport_type = 'CAR', 
                            shifts = [
                                vrt_lss_delivery.models.shift.Shift(
                                    availability_time = vrt_lss_delivery.models.time_window.TimeWindow(
                                        from = '2020-10-21T09:30+03:00', 
                                        to = '2020-10-21T19:45Z', ), 
                                    working_time = vrt_lss_delivery.models.time_window.TimeWindow(
                                        from = '2020-10-21T09:30+03:00', 
                                        to = '2020-10-21T19:45Z', ), )
                                ], 
                            tariff = vrt_lss_delivery.models.tariff.Tariff(
                                basic = vrt_lss_delivery.models.tariff_primary.TariffPrimary(
                                    cost_per_shift = 1000, 
                                    cost_per_meter = 0.1, 
                                    max_length = 200000, 
                                    cost_per_minute = 0.2, 
                                    max_time = 480, ), 
                                extra = [
                                    vrt_lss_delivery.models.tariff_primary.TariffPrimary(
                                        cost_per_shift = 1000, 
                                        cost_per_meter = 0.1, 
                                        max_length = 200000, 
                                        cost_per_minute = 0.2, 
                                        max_time = 480, )
                                    ], ), )
                        ], 
                    trips = [
                        vrt_lss_delivery.models.trip.Trip(
                            key = 'TRIP0001', 
                            trip_time = vrt_lss_delivery.models.time_window.TimeWindow(
                                from = '2020-10-21T09:30+03:00', 
                                to = '2020-10-21T19:45Z', ), 
                            performer_key = 'performer01', 
                            actions = [
                                vrt_lss_delivery.models.trip_action.TripAction(
                                    order_key = 'order01', 
                                    warehouse_key = 'whs01', 
                                    order_time = vrt_lss_delivery.models.time_window.TimeWindow(
                                        from = '2020-10-21T09:30+03:00', 
                                        to = '2020-10-21T19:45Z', ), 
                                    location_time = vrt_lss_delivery.models.time_window.TimeWindow(
                                        from = '2020-10-21T09:30+03:00', 
                                        to = '2020-10-21T19:45Z', ), )
                                ], 
                            waitlist = ["order02"], )
                        ], 
                    settings = vrt_lss_delivery.models.plan_settings.PlanSettings(
                        configuration = 'default', 
                        planning_time = 30, 
                        result_ttl = 10, 
                        result_timezone = 3, 
                        predict_slots = 2, 
                        transport_factor = [
                            vrt_lss_delivery.models.transport_factor.TransportFactor(
                                transport_type = 'CAR', 
                                speed = 2.5, )
                            ], 
                        capacity_factor = [
                            vrt_lss_delivery.models.capacity_factor.CapacityFactor(
                                transport_type = 'CAR', 
                                capacity = vrt_lss_delivery.models.capacity.Capacity(
                                    mass = 10, 
                                    volume = 2, 
                                    capacity_x = 1, 
                                    capacity_y = 2, 
                                    capacity_z = 3, ), )
                            ], 
                        routing = [
                            vrt_lss_delivery.models.routing.Routing(
                                transport_type = 'CAR', 
                                matrix = {"waypoints":[{"latitude":59.9345,"longitude":30.1504},{"latitude":59.942383,"longitude":30.258951},{"latitude":59.9545,"longitude":30.2004},{"latitude":59.89527,"longitude":30.261747},{"latitude":59.9745,"longitude":30.5004}],"distances":[[0,5822,1820,14130,23304],[5936,0,4931,8365,17731],[1819,4853,0,13161,22335],[14859,9056,13854,0,21440],[21777,16306,20772,19290,0]],"durations":[[0,13,7,24,36],[13,0,9,13,25],[7,9,0,21,32],[26,14,22,0,30],[34,23,30,28,0]]}, 
                                traffic_jams = [
                                    vrt_lss_delivery.models.traffic_factor.TrafficFactor(
                                        time_window = vrt_lss_delivery.models.time_window.TimeWindow(
                                            from = '2020-10-21T09:30+03:00', 
                                            to = '2020-10-21T19:45Z', ), 
                                        length_multiplier = 2, 
                                        length_additive = 20, 
                                        time_multiplier = 2, 
                                        time_additive = 30, )
                                    ], )
                            ], 
                        assumptions = vrt_lss_delivery.models.plan_assumptions.PlanAssumptions(
                            toll_roads = False, 
                            ferry_crossing = False, 
                            flight_distance = True, 
                            disable_compatibility = True, 
                            disable_capacity = True, 
                            same_order_time_window = True, 
                            expand_shift_time_window = True, ), 
                        precision = 3, ), 
                    delivery_settings = vrt_lss_delivery.models.delivery_settings.DeliverySettings(
                        restrict_middle_warehouses = False, 
                        restrict_multiple_warehouses = False, 
                        restrict_multiple_order_types = True, ), ), 
                plan_result = {"tracedata":{"code":"user_LssTestingPreview_LastmileMultidepotPlanner_2020-06-26-16-38_b41fb870-0930-4aac-9cc6-b08e865ff5d4"},"statistics":{"total_statistics":{"cost":0,"reward":0,"measurements":{"driving_time":22,"waiting_time":0,"working_time":0,"arriving_time":0,"departure_time":0,"total_time":22,"distance":5822,"time_window":{"from":"2020-09-13T06:29:00Z","to":"2020-09-13T06:51:00Z"}},"orders_count":1,"performers_count":1,"capacity_utilization":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"trips_statistics":[{"trip_key":"trip_0_shft_perf_perf_0","statistics":{"cost":0,"reward":0,"measurements":{"driving_time":22,"waiting_time":0,"working_time":0,"arriving_time":0,"departure_time":0,"total_time":22,"distance":5822,"time_window":{"from":"2020-09-13T06:29:00Z","to":"2020-09-13T06:51:00Z"}},"orders_count":1,"performers_count":1,"capacity_utilization":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"stop_statistics":[{"location":{"latitude":59.9345,"longitude":30.1504,"arrival_duration":0,"departure_duration":0},"location_key":"loc_WHS","demand_ids":["order_1#dmd_pickup_"],"measurements":{"driving_time":0,"waiting_time":0,"working_time":0,"arriving_time":0,"departure_time":0,"total_time":0,"distance":0,"time_window":{"from":"2020-09-13T06:29:00Z","to":"2020-09-13T06:29:00Z"}},"upload":{"count":1,"capacity":{"mass":1,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"current_load":{"count":1,"capacity":{"mass":1,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}}},{"location":{"latitude":59.9423826,"longitude":30.2589519,"arrival_duration":0,"departure_duration":0},"location_key":"loc_order_1","demand_ids":["order_1#dmd_drop_"],"measurements":{"driving_time":22,"waiting_time":0,"working_time":0,"arriving_time":0,"departure_time":0,"total_time":22,"distance":5822,"time_window":{"from":"2020-09-13T06:51:00Z","to":"2020-09-13T06:51:00Z"}},"download":{"count":1,"capacity":{"mass":1,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"current_load":{"count":0,"capacity":{"mass":0,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}}}],"total_load":{"count":1,"capacity":{"mass":1,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}},"max_load":{"count":1,"capacity":{"mass":1,"volume":0,"capacity_x":0,"capacity_y":0,"capacity_z":0}}}]},"validations":[],"unplanned_orders":[],"progress":100,"info":{"status":"FINISHED_IN_TIME","result_version":0,"planning_time":0,"waiting_time":0}}, 
                settings = vrt_lss_delivery.models.convert_settings.ConvertSettings(
                    route_index_from = 15, 
                    route_index_to = 150, )
            )
        else :
            return ConvertTask(
                plan_task = vrt_lss_delivery.models.plan_task.PlanTask(
                    warehouses = [
                        vrt_lss_delivery.models.warehouse.Warehouse(
                            key = 'whs0001', 
                            location = vrt_lss_delivery.models.location.Location(
                                latitude = 55.692789, 
                                longitude = 37.554554, 
                                arrival_duration = 15, 
                                departure_duration = 5, ), 
                            work_windows = [
                                vrt_lss_delivery.models.time_window.TimeWindow(
                                    from = '2020-10-21T09:30+03:00', 
                                    to = '2020-10-21T19:45Z', )
                                ], )
                        ], 
                    orders = [
                        vrt_lss_delivery.models.order.Order(
                            key = 'order0001', 
                            type = 'DROP', 
                            warehouse_keys = [
                                'whs0001'
                                ], 
                            customer = vrt_lss_delivery.models.customer.Customer(
                                location = vrt_lss_delivery.models.location.Location(
                                    latitude = 55.692789, 
                                    longitude = 37.554554, 
                                    arrival_duration = 15, 
                                    departure_duration = 5, ), 
                                time_windows = [
                                    vrt_lss_delivery.models.time_window.TimeWindow(
                                        from = '2020-10-21T09:30+03:00', 
                                        to = '2020-10-21T19:45Z', )
                                    ], ), 
                            cargos = [
                                vrt_lss_delivery.models.cargo.Cargo(
                                    key = 'cargo01', 
                                    capacity = vrt_lss_delivery.models.capacity.Capacity(
                                        mass = 10, 
                                        volume = 2, 
                                        capacity_x = 1, 
                                        capacity_y = 2, 
                                        capacity_z = 3, ), 
                                    rotation = ["ALL"], 
                                    width = 1, 
                                    height = 0.3, 
                                    length = 2.2, 
                                    max_storage_time = 60, 
                                    restrictions = ["Freezer"], )
                                ], 
                            warehouse_duration = 10, 
                            customer_duration = 10, 
                            cost = vrt_lss_delivery.models.order_cost.OrderCost(
                                reward = 199.1, 
                                penalty = vrt_lss_delivery.models.cost_penalty.CostPenalty(
                                    start_time = '2020-10-21T17:00Z', 
                                    period = 60, 
                                    value = 1000, 
                                    max_value = 10000, ), ), 
                            order_features = ["Special"], 
                            order_restrictions = ["Special"], 
                            performer_restrictions = ["Special"], 
                            performer_blacklist = ["A0"], )
                        ], 
                    performers = [
                        vrt_lss_delivery.models.performer.Performer(
                            key = 'performer0001', 
                            count = 15, 
                            box = vrt_lss_delivery.models.box.Box(
                                key = 'box01', 
                                max_size = vrt_lss_delivery.models.capacity.Capacity(
                                    mass = 10, 
                                    volume = 2, 
                                    capacity_x = 1, 
                                    capacity_y = 2, 
                                    capacity_z = 3, ), 
                                width = 1, 
                                height = 3.1, 
                                length = 2.1, 
                                features = ["Freezer"], ), 
                            start_location = vrt_lss_delivery.models.location.Location(
                                latitude = 55.692789, 
                                longitude = 37.554554, 
                                arrival_duration = 15, 
                                departure_duration = 5, ), 
                            finish_location = vrt_lss_delivery.models.location.Location(
                                latitude = 55.692789, 
                                longitude = 37.554554, 
                                arrival_duration = 15, 
                                departure_duration = 5, ), 
                            features = ["B1","Special"], 
                            transport_type = 'CAR', 
                            shifts = [
                                vrt_lss_delivery.models.shift.Shift(
                                    availability_time = vrt_lss_delivery.models.time_window.TimeWindow(
                                        from = '2020-10-21T09:30+03:00', 
                                        to = '2020-10-21T19:45Z', ), 
                                    working_time = vrt_lss_delivery.models.time_window.TimeWindow(
                                        from = '2020-10-21T09:30+03:00', 
                                        to = '2020-10-21T19:45Z', ), )
                                ], 
                            tariff = vrt_lss_delivery.models.tariff.Tariff(
                                basic = vrt_lss_delivery.models.tariff_primary.TariffPrimary(
                                    cost_per_shift = 1000, 
                                    cost_per_meter = 0.1, 
                                    max_length = 200000, 
                                    cost_per_minute = 0.2, 
                                    max_time = 480, ), 
                                extra = [
                                    vrt_lss_delivery.models.tariff_primary.TariffPrimary(
                                        cost_per_shift = 1000, 
                                        cost_per_meter = 0.1, 
                                        max_length = 200000, 
                                        cost_per_minute = 0.2, 
                                        max_time = 480, )
                                    ], ), )
                        ], 
                    trips = [
                        vrt_lss_delivery.models.trip.Trip(
                            key = 'TRIP0001', 
                            trip_time = vrt_lss_delivery.models.time_window.TimeWindow(
                                from = '2020-10-21T09:30+03:00', 
                                to = '2020-10-21T19:45Z', ), 
                            performer_key = 'performer01', 
                            actions = [
                                vrt_lss_delivery.models.trip_action.TripAction(
                                    order_key = 'order01', 
                                    warehouse_key = 'whs01', 
                                    order_time = vrt_lss_delivery.models.time_window.TimeWindow(
                                        from = '2020-10-21T09:30+03:00', 
                                        to = '2020-10-21T19:45Z', ), 
                                    location_time = vrt_lss_delivery.models.time_window.TimeWindow(
                                        from = '2020-10-21T09:30+03:00', 
                                        to = '2020-10-21T19:45Z', ), )
                                ], 
                            waitlist = ["order02"], )
                        ], 
                    settings = vrt_lss_delivery.models.plan_settings.PlanSettings(
                        configuration = 'default', 
                        planning_time = 30, 
                        result_ttl = 10, 
                        result_timezone = 3, 
                        predict_slots = 2, 
                        transport_factor = [
                            vrt_lss_delivery.models.transport_factor.TransportFactor(
                                transport_type = 'CAR', 
                                speed = 2.5, )
                            ], 
                        capacity_factor = [
                            vrt_lss_delivery.models.capacity_factor.CapacityFactor(
                                transport_type = 'CAR', 
                                capacity = vrt_lss_delivery.models.capacity.Capacity(
                                    mass = 10, 
                                    volume = 2, 
                                    capacity_x = 1, 
                                    capacity_y = 2, 
                                    capacity_z = 3, ), )
                            ], 
                        routing = [
                            vrt_lss_delivery.models.routing.Routing(
                                transport_type = 'CAR', 
                                matrix = {"waypoints":[{"latitude":59.9345,"longitude":30.1504},{"latitude":59.942383,"longitude":30.258951},{"latitude":59.9545,"longitude":30.2004},{"latitude":59.89527,"longitude":30.261747},{"latitude":59.9745,"longitude":30.5004}],"distances":[[0,5822,1820,14130,23304],[5936,0,4931,8365,17731],[1819,4853,0,13161,22335],[14859,9056,13854,0,21440],[21777,16306,20772,19290,0]],"durations":[[0,13,7,24,36],[13,0,9,13,25],[7,9,0,21,32],[26,14,22,0,30],[34,23,30,28,0]]}, 
                                traffic_jams = [
                                    vrt_lss_delivery.models.traffic_factor.TrafficFactor(
                                        time_window = vrt_lss_delivery.models.time_window.TimeWindow(
                                            from = '2020-10-21T09:30+03:00', 
                                            to = '2020-10-21T19:45Z', ), 
                                        length_multiplier = 2, 
                                        length_additive = 20, 
                                        time_multiplier = 2, 
                                        time_additive = 30, )
                                    ], )
                            ], 
                        assumptions = vrt_lss_delivery.models.plan_assumptions.PlanAssumptions(
                            toll_roads = False, 
                            ferry_crossing = False, 
                            flight_distance = True, 
                            disable_compatibility = True, 
                            disable_capacity = True, 
                            same_order_time_window = True, 
                            expand_shift_time_window = True, ), 
                        precision = 3, ), 
                    delivery_settings = vrt_lss_delivery.models.delivery_settings.DeliverySettings(
                        restrict_middle_warehouses = False, 
                        restrict_multiple_warehouses = False, 
                        restrict_multiple_order_types = True, ), ),
        )

    def testConvertTask(self):
        """Test ConvertTask"""
        inst_req_only = self.make_instance(include_optional=False)
        inst_req_and_optional = self.make_instance(include_optional=True)


if __name__ == '__main__':
    unittest.main()
