#include "adani/HighScaleSplitLogs.h"
#include "adani/Constants.h"
#include "adani/Convolutions.h"
#include "adani/MasslessCoefficientFunctions.h"
#include "adani/MatchingConditions.h"
#include "adani/SpecialFunctions.h"
#include <cmath>
#include <iostream>

//==========================================================================================//
//  High scale (Q^2 >> m^2) limit of the gluon coefficient functions for F2 at
//  O(alpha_s^3) expanded in terms of \alpha_s^{[nf]}, for Q=mu.
//
//  Coefficient of log(m^2/Q^2)^3
//------------------------------------------------------------------------------------------//

double C2_g3_highscale_LL(double x, int nf) {

    double x2 = x * x;

    // weight 1
    const double H0 = H(x, 0);
    const double H1 = H(x, 1);

    // weight 2
    const double H00 = H(x, 0, 0);
    const double H10 = H(x, 1, 0);
    const double H01 = H(x, 0, 1);
    const double H11 = H(x, 1, 1);

    return -0.8888888888888888 + 1.7777777777777777 * x
           - 1.7777777777777777 * x2
           - 0.8888888888888888 * ((x - 1.) * (x - 1.) + x2)
           - 1.3333333333333333 * nf
                 * (-36. - 12. * H0 - 8. * H00 + 3.5555555555555554 / x
                    + 60. * x + 16. * H00 * x - 27.555555555555554 * x2
                    + 10.666666666666666 * H0 * x2)
           - 3.
                 * (5.333333333333333 + 10.666666666666666 * H0
                    - 10.666666666666666 * H1 + 7.111111111111111 / x
                    + 42.666666666666664 * x + 42.666666666666664 * H0 * x
                    + 21.333333333333332 * H1 * x - 55.11111111111111 * x2
                    - 21.333333333333332 * H1 * x2)
           + 3.
                 * (2.6666666666666665 + 5.333333333333333 * H0
                    - 5.333333333333333 * H1 + 3.5555555555555554 / x
                    + 21.333333333333332 * x + 21.333333333333332 * H0 * x
                    + 10.666666666666666 * H1 * x - 27.555555555555554 * x2
                    - 10.666666666666666 * H1 * x2)
           + 1.3333333333333333
                 * (-1.3333333333333333 - 2.6666666666666665 * H0
                    - 5.333333333333333 * H1 + 5.333333333333333 * x
                    + 5.333333333333333 * H0 * x + 10.666666666666666 * H1 * x
                    - 10.666666666666666 * H0 * x2
                    - 10.666666666666666 * H1 * x2)
           + 1.3333333333333333 * nf
                 * (-36.666666666666664 - 13.333333333333332 * H0 - 8. * H00
                    - 2.6666666666666665 * H1 + 3.5555555555555554 / x
                    + 62.666666666666664 * x + 2.6666666666666665 * H0 * x
                    + 16. * H00 * x + 5.333333333333333 * H1 * x
                    - 27.555555555555554 * x2 + 5.333333333333333 * H0 * x2
                    - 5.333333333333333 * H1 * x2)
           - 1.3333333333333333
                 * (-12.444444444444443 - 4.888888888888888 * H0
                    - 2.6666666666666665 * H00 - 1.7777777777777777 * H1
                    + 1.1851851851851851 / x + 21.777777777777775 * x
                    + 1.7777777777777777 * H0 * x + 5.333333333333333 * H00 * x
                    + 3.5555555555555554 * H1 * x - 9.185185185185185 * x2
                    - 3.5555555555555554 * H1 * x2)
           - 1.3333333333333333 * nf
                 * (-12.444444444444443 - 4.888888888888888 * H0
                    - 2.6666666666666665 * H00 - 1.7777777777777777 * H1
                    + 1.1851851851851851 / x + 21.777777777777775 * x
                    + 1.7777777777777777 * H0 * x + 5.333333333333333 * H00 * x
                    + 3.5555555555555554 * H1 * x - 9.185185185185185 * x2
                    - 3.5555555555555554 * H1 * x2)
           - 3.
                 * (0.4444444444444444 + 0.8888888888888888 * H0
                    - 0.8888888888888888 * H1 + 0.5925925925925926 / x
                    + 3.5555555555555554 * x + 3.5555555555555554 * H0 * x
                    + 1.7777777777777777 * H1 * x - 4.592592592592593 * x2
                    - 1.7777777777777777 * H1 * x2)
           - 3. * nf
                 * (0.4444444444444444 + 0.8888888888888888 * H0
                    - 0.8888888888888888 * H1 + 0.5925925925925926 / x
                    + 3.5555555555555554 * x + 3.5555555555555554 * H0 * x
                    + 1.7777777777777777 * H1 * x - 4.592592592592593 * x2
                    - 1.7777777777777777 * H1 * x2)
           - 1.7777777777777777
                 * (-5.106315023190541 + 1.3333333333333333 * H00
                    + 5.333333333333333 * H01 + 2.6666666666666665 * H1
                    + 5.333333333333333 * H10 + 10.666666666666666 * H11
                    + 16.879296713047747 * x - 4. * H0 * x
                    - 2.6666666666666665 * H00 * x
                    - 10.666666666666666 * H01 * x - 10.666666666666666 * H1 * x
                    - 10.666666666666666 * H10 * x
                    - 21.333333333333332 * H11 * x - 35.09192675942883 * x2
                    + 10.666666666666666 * H00 * x2
                    + 21.333333333333332 * H01 * x2
                    + 10.666666666666666 * H10 * x2
                    + 21.333333333333332 * H11 * x2)
           - 4.
                 * (1.0531575115952707 + 4.888888888888888 * H0
                    - 2.6666666666666665 * H00 - 2.6666666666666665 * H01
                    + 8.444444444444445 * H1 + 5.333333333333333 * H10
                    + 10.666666666666666 * H11 - (3.5555555555555554 * H1) / x
                    + 33.19824178261936 * x - 17.77777777777778 * H0 * x
                    - 10.666666666666666 * H00 * x
                    - 26.666666666666664 * H01 * x - 46.22222222222222 * H1 * x
                    - 10.666666666666666 * H10 * x
                    - 21.333333333333332 * H11 * x - 10.879296713047749 * x2
                    + 47.11111111111111 * H0 * x2
                    + 10.666666666666666 * H01 * x2
                    + 47.11111111111111 * H1 * x2
                    + 10.666666666666666 * H10 * x2
                    + 21.333333333333332 * H11 * x2)
           - 9.
                 * (44.87929671304775 - 4.888888888888888 * H0
                    + 5.333333333333333 * H00 - 10.666666666666666 * H01
                    - 0.4444444444444444 * H1 + 5.333333333333333 * H10
                    + 10.666666666666666 * H11 - 20.148148148148145 / x
                    - (3.5555555555555554 * H0) / x
                    - (7.111111111111111 * H1) / x - 76.482813147809 * x
                    - 67.55555555555556 * H0 * x - 42.666666666666664 * H00 * x
                    - 42.666666666666664 * H01 * x - 52.44444444444444 * H1 * x
                    - 10.666666666666666 * H10 * x
                    - 21.333333333333332 * H11 * x + 139.48148148148147 * x2
                    + 8. * H0 * x2 + 64.88888888888889 * H1 * x2
                    + 10.666666666666666 * H10 * x2
                    + 21.333333333333332 * H11 * x2)
           + 4.
                 * (-0.5071941318808566 + 7.333333333333333 * H0 - 8. * H00
                    - 8. * H01 + 10.666666666666666 * H1 + 16. * H10 + 32. * H11
                    - (10.666666666666666 * H1) / x + 114.26139201452479 * x
                    - 38.666666666666664 * H0 * x - 32. * H00 * x
                    - 80. * H01 * x - 109.33333333333333 * H1 * x
                    - 32. * H10 * x - 64. * H11 * x - 32.63789013914324 * x2
                    + 112. * H0 * x2 + 32. * H01 * x2 + 112. * H1 * x2
                    + 32. * H10 * x2 + 64. * H11 * x2)
           - 1.3333333333333333
                 * (-1.3333333333333333 + 2.6666666666666665 * x
                    - 2.6666666666666665 * x2
                    - 3.
                          * (4. + 8. * H0 - 8. * H1 + 5.333333333333333 / x
                             + 32. * x + 32. * H0 * x + 16. * H1 * x
                             - 41.33333333333333 * x2 - 16. * H1 * x2)
                    + 3.
                          * (2. + 4. * H0 - 4. * H1 + 2.6666666666666665 / x
                             + 16. * x + 16. * H0 * x + 8. * H1 * x
                             - 20.666666666666664 * x2 - 8. * H1 * x2)
                    + 1.3333333333333333
                          * (-1. - 2. * H0 - 4. * H1 + 4. * x + 4. * H0 * x
                             + 8. * H1 * x - 8. * H0 * x2 - 8. * H1 * x2));
}

//==========================================================================================//
//  High scale (Q^2 >> m^2) limit of the gluon coefficient functions for F2 at
//  O(alpha_s^3) expanded in terms of \alpha_s^{[nf]}, for Q=mu.
//
//  Coefficient of log(m^2/Q^2)^2
//------------------------------------------------------------------------------------------//

double C2_g3_highscale_NLL(double x, int nf) {

    double x2 = x * x;

    // weight 1
    const double Hm1 = H(x, -1);
    const double H0 = H(x, 0);
    const double H1 = H(x, 1);

    // weight 2
    const double Hm10 = H(x, -1, 0);
    const double H00 = H(x, 0, 0);
    const double H10 = H(x, 1, 0);
    const double H01 = H(x, 0, 1);
    const double H11 = H(x, 1, 1);

    // weight 3
    const double Hm1m10 = H(x, -1, -1, 0);
    const double H0m10 = H(x, 0, -1, 0);
    const double Hm100 = H(x, -1, 0, 0);
    const double H000 = H(x, 0, 0, 0);
    const double H100 = H(x, 1, 0, 0);
    const double H010 = H(x, 0, 1, 0);
    const double H110 = H(x, 1, 1, 0);
    const double Hm101 = H(x, -1, 0, 1);
    const double H001 = H(x, 0, 0, 1);
    const double H101 = H(x, 1, 0, 1);
    const double H011 = H(x, 0, 1, 1);
    const double H111 = H(x, 1, 1, 1);

    return -0.8888888888888888 - 0.8888888888888888 * H0
           - 0.8888888888888888 * H1 + 7.111111111111111 * x
           + 1.7777777777777777 * H0 * x + 1.7777777777777777 * H1 * x
           - 7.111111111111111 * x2 - 1.7777777777777777 * H0 * x2
           - 1.7777777777777777 * H1 * x2
           + 25.333333333333332 * ((x - 1.) * (x - 1.) + x2)
           + 1.3333333333333333 * nf
                 * (58.199891528100096 + 34.840527465214194 * H0 + 12. * H00
                    + 8. * H000 + 8. * H001 + 12. * H01 + 36. * H1
                    + 1.7777777777777777 / x - (3.5555555555555554 * H1) / x
                    - 194.9893117716687 * x - 41.68105493042838 * H0 * x
                    - 48. * H00 * x - 16. * H000 * x - 16. * H001 * x
                    - 60. * H1 * x + 142.4348522686033 * x2
                    - 15.11111111111111 * H0 * x2
                    - 10.666666666666666 * H00 * x2
                    - 10.666666666666666 * H01 * x2
                    + 27.555555555555554 * H1 * x2)
           + 3. * nf
                 * (-9.555555555555555 - 1.3333333333333333 * H0
                    - 2.6666666666666665 * H00 + 1.3333333333333333 * H1
                    + 2.6666666666666665 * H10 + 5.333333333333333 * H11
                    + 0.8888888888888888 / x - (1.7777777777777777 * H1) / x
                    - 27.458832708206153 * x - 42.666666666666664 * H0 * x
                    - 10.666666666666666 * H00 * x - 16. * H01 * x
                    - 32. * H1 * x - 5.333333333333333 * H10 * x
                    - 10.666666666666666 * H11 * x + 53.67146275458724 * x2
                    + 13.777777777777777 * H0 * x2
                    + 5.333333333333333 * H01 * x2 + 35.11111111111111 * H1 * x2
                    + 5.333333333333333 * H10 * x2
                    + 10.666666666666666 * H11 * x2)
           + 1.3333333333333333
                 * (146.20468761602064 + 113.72941635410308 * H0
                    + 41.33333333333333 * H00 + 24. * H000 + 8. * H001
                    + 17.333333333333332 * H01 + 49.77777777777777 * H1
                    + 10.666666666666666 * H10 + 8. * H11
                    + 9.481481481481481 / x - (3.5555555555555554 * H1) / x
                    - 245.88779283639872 * x - 26.125499374872824 * H0 * x
                    - 74.66666666666666 * H00 * x - 48. * H000 * x
                    - 16. * H001 * x - 10.666666666666666 * H01 * x
                    - 95.55555555555556 * H1 * x - 21.333333333333332 * H10 * x
                    - 16. * H11 * x + 71.07887016199464 * x2
                    + 54.22222222222222 * H0 * x2
                    - 10.666666666666666 * H00 * x2
                    + 5.333333333333333 * H01 * x2 + 57.77777777777777 * H1 * x2
                    + 21.333333333333332 * H10 * x2 + 16. * H11 * x2)
           + 1.3333333333333333 * nf
                 * (146.20468761602064 + 113.72941635410308 * H0
                    + 41.33333333333333 * H00 + 24. * H000 + 8. * H001
                    + 17.333333333333332 * H01 + 49.77777777777777 * H1
                    + 10.666666666666666 * H10 + 8. * H11
                    + 9.481481481481481 / x - (3.5555555555555554 * H1) / x
                    - 245.88779283639872 * x - 26.125499374872824 * H0 * x
                    - 74.66666666666666 * H00 * x - 48. * H000 * x
                    - 16. * H001 * x - 10.666666666666666 * H01 * x
                    - 95.55555555555556 * H1 * x - 21.333333333333332 * H10 * x
                    - 16. * H11 * x + 71.07887016199464 * x2
                    + 54.22222222222222 * H0 * x2
                    - 10.666666666666666 * H00 * x2
                    + 5.333333333333333 * H01 * x2 + 57.77777777777777 * H1 * x2
                    + 21.333333333333332 * H10 * x2 + 16. * H11 * x2)
           - 1.3333333333333333 * nf
                 * (283.24031052141436 + 216.34772159709505 * H0
                    + 77.33333333333333 * H00 + 48. * H000 + 16. * H001
                    + 32. * H01 + 81.33333333333333 * H1
                    + 10.666666666666666 * H10 + 10.666666666666666 * H11
                    + 18.962962962962962 / x - (7.111111111111111 * H1) / x
                    - 482.3263451404324 * x - 35.36210986085676 * H0 * x
                    - 138.66666666666666 * H00 * x - 96. * H000 * x
                    - 32. * H001 * x - 16. * H01 * x - 152. * H1 * x
                    - 21.333333333333332 * H10 * x
                    - 21.333333333333332 * H11 * x + 167.7037037037037 * x2
                    + 74.66666666666666 * H0 * x2
                    - 42.666666666666664 * H00 * x2
                    + 81.77777777777777 * H1 * x2
                    + 21.333333333333332 * H10 * x2
                    + 21.333333333333332 * H11 * x2)
           + 3.
                 * (-38.22222222222222 - 5.333333333333333 * H0
                    - 10.666666666666666 * H00 + 5.333333333333333 * H1
                    + 10.666666666666666 * H10 + 21.333333333333332 * H11
                    + 3.5555555555555554 / x - (7.111111111111111 * H1) / x
                    - 109.83533083282461 * x - 170.66666666666666 * H0 * x
                    - 42.666666666666664 * H00 * x - 64. * H01 * x
                    - 128. * H1 * x - 21.333333333333332 * H10 * x
                    - 42.666666666666664 * H11 * x + 214.68585101834896 * x2
                    + 55.11111111111111 * H0 * x2
                    + 21.333333333333332 * H01 * x2
                    + 140.44444444444443 * H1 * x2
                    + 21.333333333333332 * H10 * x2
                    + 42.666666666666664 * H11 * x2)
           - 1.3333333333333333
                 * (1.681054930428381 + 5.333333333333333 * H0
                    + 10.666666666666666 * H00 + 16. * H01
                    + 18.666666666666664 * H1 + 21.333333333333332 * H10
                    + 21.333333333333332 * H11 - 0.6954431941900907 * x
                    - 32. * H0 * x - 21.333333333333332 * H00 * x
                    - 32. * H01 * x - 64. * H1 * x
                    - 42.666666666666664 * H10 * x
                    - 42.666666666666664 * H11 * x - 51.517186852190996 * x2
                    + 53.33333333333333 * H0 * x2
                    + 42.666666666666664 * H00 * x2
                    + 42.666666666666664 * H01 * x2
                    + 53.33333333333333 * H1 * x2
                    + 42.666666666666664 * H10 * x2
                    + 42.666666666666664 * H11 * x2)
           - 4.
                 * (151.09021855674422 + 36.347721597095045 * H0
                    - 29.333333333333332 * H00 + 32. * H000 + 16. * H001
                    - 28. * H01 + 16. * H010 - 32. * H011
                    + 180.55156055657295 * H1 - 82.66666666666666 * H10
                    - 64. * H100 - 128. * H101 - 138.66666666666666 * H11
                    - 128. * H110 - 192. * H111 + 16. / x
                    + (21.333333333333332 * H1) / x
                    + (42.666666666666664 * H10) / x
                    + (42.666666666666664 * H11) / x - 674.0036049002209 * x
                    - 90.43645444647927 * H0 * x + 218.66666666666666 * H00 * x
                    + 128. * H000 * x + 256. * H001 * x + 552. * H01 * x
                    + 352. * H010 * x + 448. * H011 * x
                    + 285.5635455535207 * H1 * x + 565.3333333333333 * H10 * x
                    + 128. * H100 * x + 256. * H101 * x
                    + 757.3333333333333 * H11 * x + 256. * H110 * x
                    + 384. * H111 * x + 885.9831962481496 * x2
                    - 445.44843944342705 * H0 * x2 - 448. * H00 * x2
                    - 128. * H001 * x2 - 608. * H01 * x2 - 128. * H010 * x2
                    - 256. * H011 * x2 - 266.8968788868541 * H1 * x2
                    - 608. * H10 * x2 - 128. * H100 * x2 - 256. * H101 * x2
                    - 768. * H11 * x2 - 256. * H110 * x2 - 384. * H111 * x2)
           + 9.
                 * (-74.3296332979029 - 132.3189450695716 * H0
                    + 14.666666666666666 * H00 - 16. * H000 + 16. * H001
                    + 16. * H01 + 16. * H010 + 32. * H011
                    + 96.95683520871486 * H1 - 14.666666666666666 * H10
                    - 16. * H100 - 48. * H101 - 29.333333333333332 * H11
                    - 48. * H110 - 96. * H111 - 49.101518935269965 / x
                    - (5.333333333333333 * H0) / x
                    + (10.666666666666666 * H01) / x
                    + (49.77777777777777 * H1) / x
                    + (21.333333333333332 * H10) / x
                    + (42.666666666666664 * H11) / x + 464.22026483384116 * x
                    + 674.8968788868541 * H0 * x + 586.6666666666666 * H00 * x
                    + 128. * H000 * x + 256. * H001 * x + 744. * H01 * x
                    + 160. * H010 * x + 320. * H011 * x
                    + 1044.7529962492367 * H1 * x + 285.3333333333333 * H10 * x
                    + 32. * H100 * x + 96. * H101 * x
                    + 570.6666666666666 * H11 * x + 96. * H110 * x
                    + 192. * H111 * x - 1575.752195160299 * x2
                    - 558.4444444444445 * H0 * x2 - 24. * H00 * x2
                    - 218.66666666666666 * H01 * x2 - 32. * H010 * x2
                    - 64. * H011 * x2 - 1127.1974406936813 * H1 * x2
                    - 322.66666666666663 * H10 * x2 - 32. * H100 * x2
                    - 96. * H101 * x2 - 645.3333333333333 * H11 * x2
                    - 96. * H110 * x2 - 192. * H111 * x2)
           - 3.
                 * (-42.22222222222222 - 21.333333333333332 * H00
                    + 5.333333333333333 * H1 + 10.666666666666666 * H10
                    + 10.666666666666666 * H11 - 10.666666666666666 * Hm10
                    + 15.407407407407407 / x - (7.111111111111111 * H1) / x
                    - 24.92725759225344 * x - 128. * H0 * x - 64. * H00 * x
                    - 64. * H01 * x - 106.66666666666666 * H1 * x
                    - 21.333333333333332 * H10 * x
                    - 21.333333333333332 * H11 * x
                    - 21.333333333333332 * Hm10 * x + 98.8339991664971 * x2
                    + 133.33333333333331 * H0 * x2
                    + 21.333333333333332 * H01 * x2
                    + 119.1111111111111 * H1 * x2
                    + 21.333333333333332 * H10 * x2
                    + 21.333333333333332 * H11 * x2
                    - 21.333333333333332 * Hm10 * x2)
           - 3. * nf
                 * (-12.888888888888888 - 11.555555555555555 * H0
                    - 5.333333333333333 * H00 + 11.555555555555555 * H1
                    + 5.333333333333333 * H10 + 5.333333333333333 * H11
                    - 5.333333333333333 * Hm10 - 5.925925925925926 / x
                    - (3.5555555555555554 * H1) / x - 97.3525176850156 * x
                    - 120.88888888888889 * H0 * x - 42.666666666666664 * H00 * x
                    - 32. * H01 * x - 71.11111111111111 * H1 * x
                    - 10.666666666666666 * H10 * x
                    - 10.666666666666666 * H11 * x
                    - 10.666666666666666 * Hm10 * x + 137.71329587954483 * x2
                    + 43.55555555555555 * H0 * x2
                    + 10.666666666666666 * H01 * x2
                    + 77.33333333333333 * H1 * x2
                    + 10.666666666666666 * H10 * x2
                    + 10.666666666666666 * H11 * x2
                    - 10.666666666666666 * Hm10 * x2)
           + 3.
                 * (-6.444444444444444 - 5.777777777777778 * H0
                    - 2.6666666666666665 * H00 + 5.777777777777778 * H1
                    + 2.6666666666666665 * H10 + 2.6666666666666665 * H11
                    - 2.6666666666666665 * Hm10 - 2.962962962962963 / x
                    - (1.7777777777777777 * H1) / x - 48.6762588425078 * x
                    - 60.44444444444444 * H0 * x - 21.333333333333332 * H00 * x
                    - 16. * H01 * x - 35.55555555555556 * H1 * x
                    - 5.333333333333333 * H10 * x - 5.333333333333333 * H11 * x
                    - 5.333333333333333 * Hm10 * x + 68.85664793977242 * x2
                    + 21.777777777777775 * H0 * x2
                    + 5.333333333333333 * H01 * x2
                    + 38.666666666666664 * H1 * x2
                    + 5.333333333333333 * H10 * x2
                    + 5.333333333333333 * H11 * x2
                    - 5.333333333333333 * Hm10 * x2)
           + 3. * nf
                 * (-6.444444444444444 - 5.777777777777778 * H0
                    - 2.6666666666666665 * H00 + 5.777777777777778 * H1
                    + 2.6666666666666665 * H10 + 2.6666666666666665 * H11
                    - 2.6666666666666665 * Hm10 - 2.962962962962963 / x
                    - (1.7777777777777777 * H1) / x - 48.6762588425078 * x
                    - 60.44444444444444 * H0 * x - 21.333333333333332 * H00 * x
                    - 16. * H01 * x - 35.55555555555556 * H1 * x
                    - 5.333333333333333 * H10 * x - 5.333333333333333 * H11 * x
                    - 5.333333333333333 * Hm10 * x + 68.85664793977242 * x2
                    + 21.777777777777775 * H0 * x2
                    + 5.333333333333333 * H01 * x2
                    + 38.666666666666664 * H1 * x2
                    + 5.333333333333333 * H10 * x2
                    + 5.333333333333333 * H11 * x2
                    - 5.333333333333333 * Hm10 * x2)
           + 4.
                 * (16.08473262754797 - 27.36730649324632 * H0
                    - 37.33333333333333 * H00 + 24. * H000 + 24. * H001
                    - 29.333333333333332 * H01 + 8. * H010 - 8. * H011
                    + 36.51239076427042 * H1 - 70.66666666666666 * H10
                    - 40. * H100 - 48. * H101 - 80. * H11 - 48. * H110
                    - 48. * H111 - 26.31894506957162 * Hm1 - 12. * Hm10
                    + 8. * Hm100 + 16. * Hm101 + 8. / x
                    - (7.111111111111111 * H1) / x
                    + (21.333333333333332 * H10) / x
                    + (21.333333333333332 * H11) / x - 283.51838848559794 * x
                    - 138.07833958460515 * H0 * x + 130.66666666666666 * H00 * x
                    + 96. * H000 * x + 160. * H001 * x
                    + 202.66666666666666 * H01 * x + 176. * H010 * x
                    + 208. * H011 * x + 81.64188513812582 * H1 * x
                    + 309.3333333333333 * H10 * x + 80. * H100 * x
                    + 96. * H101 * x + 328. * H11 * x + 96. * H110 * x
                    + 96. * H111 * x - 52.63789013914324 * Hm1 * x
                    - 24. * Hm10 * x + 16. * Hm100 * x + 32. * Hm101 * x
                    + 718.478216888231 * x2 - 152.5019974994913 * H0 * x2
                    - 376. * H00 * x2 - 64. * H001 * x2
                    - 418.66666666666663 * H01 * x2 - 64. * H010 * x2
                    - 96. * H011 * x2 - 75.86410736034804 * H1 * x2
                    - 330.66666666666663 * H10 * x2 - 80. * H100 * x2
                    - 96. * H101 * x2 - 349.3333333333333 * H11 * x2
                    - 96. * H110 * x2 - 96. * H111 * x2
                    - 52.63789013914324 * Hm1 * x2 - 24. * Hm10 * x2
                    + 16. * Hm100 * x2 + 32. * Hm101 * x2)
           - 9.
                 * (-81.24318680092482 - 606.3581148618741 * H0
                    + 61.33333333333333 * H00 - 96. * H000 + 96. * H001
                    + 48. * H01 + 64. * H010 + 32. * H011 - 64. * H0m10
                    + 79.05355805606425 * H1 - 13.333333333333332 * H10
                    - 48. * H100 - 96. * H101 - 45.33333333333333 * H11
                    - 96. * H110 - 96. * H111 - 105.27578027828648 * Hm1
                    - 2.6666666666666665 * Hm10 + 48. * Hm100 + 32. * Hm101
                    - 64. * Hm1m10 - 280. / x - (46.22222222222222 * H0) / x
                    + (42.666666666666664 * H01) / x
                    + (74.66666666666666 * H1) / x + (64. * H10) / x
                    + (64. * H11) / x + (42.666666666666664 * Hm10) / x
                    - 54.81636808868324 * x + 823.9584269408834 * H0 * x
                    + 1162.6666666666665 * H00 * x + 512. * H000 * x
                    + 704. * H001 * x + 1360. * H01 * x + 448. * H010 * x
                    + 512. * H011 * x + 256. * H0m10 * x
                    + 1657.8928838878714 * H1 * x + 634.6666666666666 * H10 * x
                    + 96. * H100 * x + 192. * H101 * x
                    + 826.6666666666666 * H11 * x + 192. * H110 * x
                    + 192. * H111 * x - 210.55156055657295 * Hm1 * x
                    + 314.66666666666663 * Hm10 * x + 96. * Hm100 * x
                    + 64. * Hm101 * x - 128. * Hm1m10 * x
                    - 369.9376404113252 * x2 - 2303.555555555555 * H0 * x2
                    - 144. * H00 * x2 - 672. * H01 * x2 - 64. * H010 * x2
                    - 128. * H011 * x2 - 1811.2262172212047 * H1 * x2
                    - 746.6666666666666 * H10 * x2 - 96. * H100 * x2
                    - 192. * H101 * x2 - 938.6666666666666 * H11 * x2
                    - 192. * H110 * x2 - 192. * H111 * x2
                    - 210.55156055657295 * Hm1 * x2
                    + 389.3333333333333 * Hm10 * x2 + 96. * Hm100 * x2
                    + 64. * Hm101 * x2 - 128. * Hm1m10 * x2)
           + 1.7777777777777777
                 * (56.63601089282607 + 37.21762640653615 * H0 - 12. * H000
                    - 36. * H001 - 24. * H01 - 48. * H010 - 64. * H011
                    + 16. * H0m10 + 40.275780278286476 * H1 - 40. * H10
                    - 32. * H100 - 80. * H101 - 64. * H11 - 80. * H110
                    - 96. * H111 - 26.31894506957162 * Hm1 + 32. * Hm10
                    + 16. * Hm100 - 32. * Hm1m10 - 108.76064371604521 * x
                    - 53.79736267392906 * H0 * x - 36. * H00 * x - 8. * H000 * x
                    + 72. * H001 * x + 124. * H01 * x + 96. * H010 * x
                    + 128. * H011 * x + 32. * H0m10 * x
                    - 84.55156055657295 * H1 * x + 144. * H10 * x
                    + 64. * H100 * x + 160. * H101 * x + 224. * H11 * x
                    + 160. * H110 * x + 192. * H111 * x
                    - 52.63789013914324 * Hm1 * x + 80. * Hm10 * x
                    + 32. * Hm100 * x - 64. * Hm1m10 * x
                    + 469.05273430014427 * x2 + 227.18945069571623 * H0 * x2
                    - 128. * H00 * x2 - 96. * H000 * x2 - 160. * H001 * x2
                    - 160. * H01 * x2 - 160. * H010 * x2 - 192. * H011 * x2
                    + 64. * H0m10 * x2 + 174.55156055657295 * H1 * x2
                    - 80. * H10 * x2 - 64. * H100 * x2 - 160. * H101 * x2
                    - 160. * H11 * x2 - 160. * H110 * x2 - 192. * H111 * x2
                    - 52.63789013914324 * Hm1 * x2 + 48. * Hm10 * x2
                    + 32. * Hm100 * x2 - 64. * Hm1m10 * x2)
           + 9.
                 * (-40.62159340046241 - 303.17905743093706 * H0
                    + 30.666666666666664 * H00 - 48. * H000 + 48. * H001
                    + 24. * H01 + 32. * H010 + 16. * H011 - 32. * H0m10
                    + 39.526779028032124 * H1 - 6.666666666666666 * H10
                    - 24. * H100 - 48. * H101 - 22.666666666666664 * H11
                    - 48. * H110 - 48. * H111 - 52.63789013914324 * Hm1
                    - 1.3333333333333333 * Hm10 + 24. * Hm100 + 16. * Hm101
                    - 32. * Hm1m10 - 140. / x - (23.11111111111111 * H0) / x
                    + (21.333333333333332 * H01) / x
                    + (37.33333333333333 * H1) / x + (32. * H10) / x
                    + (32. * H11) / x + (21.333333333333332 * Hm10) / x
                    - 27.40818404434162 * x + 411.9792134704417 * H0 * x
                    + 581.3333333333333 * H00 * x + 256. * H000 * x
                    + 352. * H001 * x + 680. * H01 * x + 224. * H010 * x
                    + 256. * H011 * x + 128. * H0m10 * x
                    + 828.9464419439357 * H1 * x + 317.3333333333333 * H10 * x
                    + 48. * H100 * x + 96. * H101 * x
                    + 413.3333333333333 * H11 * x + 96. * H110 * x
                    + 96. * H111 * x - 105.27578027828648 * Hm1 * x
                    + 157.33333333333331 * Hm10 * x + 48. * Hm100 * x
                    + 32. * Hm101 * x - 64. * Hm1m10 * x
                    - 184.9688202056626 * x2 - 1151.7777777777776 * H0 * x2
                    - 72. * H00 * x2 - 336. * H01 * x2 - 32. * H010 * x2
                    - 64. * H011 * x2 - 905.6131086106024 * H1 * x2
                    - 373.3333333333333 * H10 * x2 - 48. * H100 * x2
                    - 96. * H101 * x2 - 469.3333333333333 * H11 * x2
                    - 96. * H110 * x2 - 96. * H111 * x2
                    - 105.27578027828648 * Hm1 * x2
                    + 194.66666666666666 * Hm10 * x2 + 48. * Hm100 * x2
                    + 32. * Hm101 * x2 - 64. * Hm1m10 * x2)
           - 1.3333333333333333
                 * (-1.3333333333333333 - 1.3333333333333333 * H0
                    - 1.3333333333333333 * H1 + 10.666666666666666 * x
                    + 2.6666666666666665 * H0 * x + 2.6666666666666665 * H1 * x
                    - 10.666666666666666 * x2 - 2.6666666666666665 * H0 * x2
                    - 2.6666666666666665 * H1 * x2
                    + 3.
                          * (-28.666666666666664 - 4. * H0 - 8. * H00 + 4. * H1
                             + 8. * H10 + 16. * H11 + 2.6666666666666665 / x
                             - (5.333333333333333 * H1) / x
                             - 82.37649812461845 * x - 128. * H0 * x
                             - 32. * H00 * x - 48. * H01 * x - 96. * H1 * x
                             - 16. * H10 * x - 32. * H11 * x
                             + 161.0143882637617 * x2
                             + 41.33333333333333 * H0 * x2 + 16. * H01 * x2
                             + 105.33333333333333 * H1 * x2 + 16. * H10 * x2
                             + 32. * H11 * x2)
                    - 1.3333333333333333
                          * (-1.739208802178716 + 4. * H0 + 8. * H00 + 12. * H01
                             + 14. * H1 + 16. * H10 + 16. * H11
                             + 5.478417604357432 * x - 24. * H0 * x
                             - 16. * H00 * x - 24. * H01 * x - 48. * H1 * x
                             - 32. * H10 * x - 32. * H11 * x
                             - 44.63789013914324 * x2 + 40. * H0 * x2
                             + 32. * H00 * x2 + 32. * H01 * x2 + 40. * H1 * x2
                             + 32. * H10 * x2 + 32. * H11 * x2)
                    - 3.
                          * (-36.666666666666664 - 16. * H00 + 4. * H1
                             + 8. * H10 + 8. * H11 - 8. * Hm10
                             + 11.555555555555555 / x
                             - (5.333333333333333 * H1) / x
                             - 8.69544319419009 * x - 96. * H0 * x
                             - 48. * H00 * x - 48. * H01 * x - 80. * H1 * x
                             - 16. * H10 * x - 16. * H11 * x - 16. * Hm10 * x
                             + 64.12549937487282 * x2 + 100. * H0 * x2
                             + 16. * H01 * x2 + 89.33333333333333 * H1 * x2
                             + 16. * H10 * x2 + 16. * H11 * x2
                             - 16. * Hm10 * x2))
           + 0.4444444444444444 * C2_g1_massless(x, 1);
}

//==========================================================================================//
//  High scale (Q^2 >> m^2) limit of the gluon coefficient functions for F2 at
//  O(alpha_s^3) expanded in terms of \alpha_s^{[nf]}, for Q=mu.
//
//  Coefficient of log(m^2/Q^2)^1
//------------------------------------------------------------------------------------------//

double C2_g3_highscale_N2LL(double x, int nf) {

    double x2 = x * x;
    double x3 = x2 * x;

    // Allocate pointers for the harmonic polylogs
    double wx = x;
    int nw = 4;
    int n1 = -1;
    int n2 = 1;
    int sz = n2 - n1 + 1;
    double *Hr1 = new double[sz];
    double *Hr2 = new double[sz * sz];
    double *Hr3 = new double[sz * sz * sz];
    double *Hr4 = new double[sz * sz * sz * sz];
    double *Hr5 = new double[sz * sz * sz * sz * sz];

    // Call polylogs
    apf_hplog_(&wx, &nw, Hr1, Hr2, Hr3, Hr4, Hr5, &n1, &n2);

    // weight 1
    const double Hm1 = Hr1[0];
    const double H0 = Hr1[1];
    const double H1 = Hr1[2];

    // weight 2
    const double Hm1m1 = Hr2[0];
    const double H0m1 = Hr2[1];
    const double Hm10 = Hr2[3];
    const double H00 = Hr2[4];
    const double H10 = Hr2[5];
    const double H01 = Hr2[7];
    const double H11 = Hr2[8];

    // weight 3
    const double Hm1m10 = Hr3[9];
    const double H0m10 = Hr3[10];
    const double Hm100 = Hr3[12];
    const double H000 = Hr3[13];
    const double H100 = Hr3[14];
    const double H010 = Hr3[16];
    const double H110 = Hr3[17];
    const double Hm101 = Hr3[21];
    const double H001 = Hr3[22];
    const double H101 = Hr3[23];
    const double H011 = Hr3[25];
    const double H111 = Hr3[26];

    // weight 4
    const double Hm1m1m10 = Hr4[27];
    const double H0m1m10 = Hr4[28];
    const double Hm10m10 = Hr4[30];
    const double H00m10 = Hr4[31];
    const double H10m10 = Hr4[32];
    const double Hm1m100 = Hr4[36];
    const double H0m100 = Hr4[37];
    const double Hm1000 = Hr4[39];
    const double H0000 = Hr4[40];
    const double H1000 = Hr4[41];
    const double H0100 = Hr4[43];
    const double H1100 = Hr4[44];
    const double Hm1010 = Hr4[48];
    const double H0010 = Hr4[49];
    const double H1010 = Hr4[50];
    const double H0110 = Hr4[52];
    const double H1110 = Hr4[53];
    const double Hm1m101 = Hr4[63];
    const double H0m101 = Hr4[64];
    const double Hm1001 = Hr4[66];
    const double H0001 = Hr4[67];
    const double H1001 = Hr4[68];
    const double H0101 = Hr4[70];
    const double H1101 = Hr4[71];
    const double Hm1011 = Hr4[75];
    const double H0011 = Hr4[76];
    const double H1011 = Hr4[77];
    const double H0111 = Hr4[79];
    const double H1111 = Hr4[80];

    delete[] Hr1;
    delete[] Hr2;
    delete[] Hr3;
    delete[] Hr4;
    delete[] Hr5;

    return -9.333333333333334 * ((x - 1.) * (x - 1.) + x2)
           - 3.
                 * (37.92887199613128 + 18.37037037037037 * H0
                    + 8.88888888888889 * H00 - 2.6666666666666665 * H01
                    - 14.872768414330656 * H1 - 11.555555555555555 * H10
                    - 10.666666666666666 * H100 - 11.555555555555555 * H11
                    - 10.666666666666666 * H110 - 5.333333333333333 * H111
                    - 4.386490844928604 * Hm1 - 7.111111111111111 * Hm10
                    + 10.666666666666666 * Hm100 + 5.333333333333333 * Hm101
                    + 5.333333333333333 * Hm1m10 + 4.324185046268034 / x
                    + (5.925925925925926 * H1) / x
                    + (3.5555555555555554 * H10) / x
                    + (3.5555555555555554 * H11) / x
                    - (3.5555555555555554 * Hm10) / x + 242.07085282197903 * x
                    + 405.30722013846497 * H0 * x + 263.1111111111111 * H00 * x
                    + 74.66666666666666 * H000 * x
                    + 53.33333333333333 * H001 * x + 176. * H01 * x
                    + 32. * H010 * x + 32. * H011 * x
                    + 276.8566479397724 * H1 * x + 71.11111111111111 * H10 * x
                    + 21.333333333333332 * H100 * x
                    + 71.11111111111111 * H11 * x
                    + 21.333333333333332 * H110 * x
                    + 10.666666666666666 * H111 * x
                    - 8.772981689857207 * Hm1 * x
                    + 12.444444444444443 * Hm10 * x
                    + 21.333333333333332 * Hm100 * x
                    + 10.666666666666666 * Hm101 * x
                    + 10.666666666666666 * Hm1m10 * x - 460.7460828164515 * x2
                    - 175.04662921287817 * H0 * x2 - 56. * H00 * x2
                    - 10.666666666666666 * H001 * x2
                    - 93.33333333333333 * H01 * x2
                    - 10.666666666666666 * H010 * x2
                    - 10.666666666666666 * H011 * x2
                    + 10.666666666666666 * H0m10 * x2
                    - 305.77777777777777 * H1 * x2
                    - 77.33333333333333 * H10 * x2 - 16. * H100 * x2
                    - 77.33333333333333 * H11 * x2
                    - 21.333333333333332 * H110 * x2
                    - 10.666666666666666 * H111 * x2
                    - 17.545963379714415 * Hm1 * x2
                    + 30.22222222222222 * Hm10 * x2
                    + 26.666666666666664 * Hm100 * x2
                    + 10.666666666666666 * Hm101 * x2)
           - 3. * nf
                 * (54.225168292427576 + 13.185185185185185 * H0
                    + 17.333333333333332 * H00 + 2.6666666666666665 * H000
                    - 2.6666666666666665 * H01 - 7.909805451367692 * H1
                    - 11.555555555555555 * H10 - 10.666666666666666 * H100
                    - 11.555555555555555 * H11 - 10.666666666666666 * H110
                    - 5.333333333333333 * H111 - 4.386490844928604 * Hm1
                    - 7.111111111111111 * Hm10 + 10.666666666666666 * Hm100
                    + 5.333333333333333 * Hm101 + 5.333333333333333 * Hm1m10
                    - 9.404210015460361 / x + (5.925925925925926 * H1) / x
                    + (3.5555555555555554 * H10) / x
                    + (3.5555555555555554 * H11) / x
                    - (3.5555555555555554 * Hm10) / x + 121.7166029261669 * x
                    + 330.34425717550204 * H0 * x + 240.88888888888889 * H00 * x
                    + 69.33333333333333 * H000 * x
                    + 53.33333333333333 * H001 * x
                    + 173.33333333333331 * H01 * x + 32. * H010 * x
                    + 32. * H011 * x + 258.9307220138465 * H1 * x
                    + 71.11111111111111 * H10 * x
                    + 21.333333333333332 * H100 * x
                    + 71.11111111111111 * H11 * x
                    + 21.333333333333332 * H110 * x
                    + 10.666666666666666 * H111 * x
                    - 8.772981689857207 * Hm1 * x
                    + 12.444444444444443 * Hm10 * x
                    + 21.333333333333332 * Hm100 * x
                    + 10.666666666666666 * Hm101 * x
                    + 10.666666666666666 * Hm1m10 * x - 339.68435442138986 * x2
                    - 207.63922180547075 * H0 * x2 - 56. * H00 * x2
                    - 10.666666666666666 * H001 * x2
                    - 93.33333333333333 * H01 * x2
                    - 10.666666666666666 * H010 * x2
                    - 10.666666666666666 * H011 * x2
                    + 10.666666666666666 * H0m10 * x2
                    - 286.5185185185185 * H1 * x2 - 77.33333333333333 * H10 * x2
                    - 16. * H100 * x2 - 77.33333333333333 * H11 * x2
                    - 21.333333333333332 * H110 * x2
                    - 10.666666666666666 * H111 * x2
                    - 17.545963379714415 * Hm1 * x2
                    + 30.22222222222222 * Hm10 * x2
                    + 26.666666666666664 * Hm100 * x2
                    + 10.666666666666666 * Hm101 * x2)
           + 3.
                 * (77.45266598248878 + 40.676258842507806 * H0
                    + 21.333333333333332 * H000 + 10.666666666666666 * H001
                    - 10.666666666666666 * H01 + 10.666666666666666 * H010
                    + 35.768185601936636 * H1 + 2.6666666666666665 * H10
                    - 16. * H100 - 10.666666666666666 * H101 - 8. * H11
                    - 21.333333333333332 * H110 - 17.545963379714415 * Hm1
                    - 32. * Hm10 + 16. * Hm100 + 10.666666666666666 * Hm101
                    - 5.771382993883684 / x - (15.407407407407407 * H1) / x
                    + (14.222222222222221 * H10) / x
                    + (7.111111111111111 * H11) / x
                    - (7.111111111111111 * Hm10) / x - 212.86684456218336 * x
                    + 94.29895962895134 * H0 * x + 245.33333333333331 * H00 * x
                    + 64. * H000 * x + 85.33333333333333 * H001 * x
                    + 192. * H01 * x + 106.66666666666666 * H010 * x
                    + 64. * H011 * x + 169.35251768501558 * H1 * x
                    + 149.33333333333331 * H10 * x + 32. * H100 * x
                    + 21.333333333333332 * H101 * x
                    + 85.33333333333333 * H11 * x
                    + 42.666666666666664 * H110 * x
                    - 35.09192675942883 * Hm1 * x
                    + 10.666666666666666 * Hm10 * x + 32. * Hm100 * x
                    + 21.333333333333332 * Hm101 * x + 240.30928221052466 * x2
                    - 406.38955472205265 * H0 * x2 - 152. * H00 * x2
                    - 21.333333333333332 * H001 * x2
                    - 194.66666666666666 * H01 * x2
                    - 21.333333333333332 * H010 * x2
                    - 21.333333333333332 * H011 * x2
                    + 21.333333333333332 * H0m10 * x2
                    - 217.71329587954483 * H1 * x2
                    - 176.88888888888889 * H10 * x2
                    - 21.333333333333332 * H100 * x2
                    - 21.333333333333332 * H101 * x2
                    - 95.1111111111111 * H11 * x2
                    - 42.666666666666664 * H110 * x2
                    - 52.63789013914324 * Hm1 * x2
                    + 46.22222222222222 * Hm10 * x2
                    + 42.666666666666664 * Hm100 * x2
                    + 21.333333333333332 * Hm101 * x2
                    - 21.333333333333332 * Hm1m10 * x2)
           + 3. * nf
                 * (58.232293777981766 + 12.888888888888888 * H0
                    + 11.555555555555555 * H00 + 5.333333333333333 * H000
                    - 2.6666666666666665 * H01 + 5.333333333333333 * H010
                    + 0.7729816898572075 * H1 - 7.555555555555555 * H10
                    - 8. * H100 - 5.333333333333333 * H101
                    - 21.777777777777775 * H11 - 10.666666666666666 * H110
                    - 8.772981689857207 * Hm1 - 16. * Hm10 + 8. * Hm100
                    + 5.333333333333333 * Hm101 - 9.700506311756657 / x
                    + (5.925925925925926 * H1) / x
                    + (7.111111111111111 * H10) / x
                    + (3.5555555555555554 * H11) / x
                    - (3.5555555555555554 * Hm10) / x + 158.66363450127915 * x
                    + 290.4924053236502 * H0 * x + 211.55555555555554 * H00 * x
                    + 42.666666666666664 * H000 * x
                    + 53.33333333333333 * H001 * x
                    + 170.66666666666666 * H01 * x
                    + 53.33333333333333 * H010 * x + 32. * H011 * x
                    + 240.67625884250782 * H1 * x + 92.44444444444444 * H10 * x
                    + 16. * H100 * x + 10.666666666666666 * H101 * x
                    + 78.22222222222221 * H11 * x
                    + 21.333333333333332 * H110 * x
                    - 17.545963379714415 * Hm1 * x
                    + 5.333333333333333 * Hm10 * x + 16. * Hm100 * x
                    + 10.666666666666666 * Hm101 * x - 298.0257479920022 * x2
                    - 199.04662921287817 * H0 * x2
                    - 52.888888888888886 * H00 * x2
                    - 10.666666666666666 * H001 * x2 - 92. * H01 * x2
                    - 10.666666666666666 * H010 * x2
                    - 10.666666666666666 * H011 * x2
                    + 10.666666666666666 * H0m10 * x2
                    - 268.2640553471798 * H1 * x2
                    - 106.22222222222221 * H10 * x2
                    - 10.666666666666666 * H100 * x2
                    - 10.666666666666666 * H101 * x2
                    - 83.1111111111111 * H11 * x2
                    - 21.333333333333332 * H110 * x2
                    - 26.31894506957162 * Hm1 * x2
                    + 23.11111111111111 * Hm10 * x2
                    + 21.333333333333332 * Hm100 * x2
                    + 10.666666666666666 * Hm101 * x2
                    - 10.666666666666666 * Hm1m10 * x2)
           + 9.
                 * (-203.00659347808357 + 152.79134228561952 * H0
                    + 618.4156679169209 * H00 - 61.33333333333333 * H000
                    + 96. * H0000 - 32. * H0001 - 80. * H001 - 64. * H0010
                    - 128. * H0011 + 32. * H00m10 + 295.94244694495313 * H01
                    - 53.33333333333333 * H010 - 96. * H0100 - 64. * H0101
                    - 24. * H011 - 96. * H0110 - 105.27578027828648 * H0m1
                    - 80. * H0m10 + 64. * H0m100 + 64. * H0m101
                    - 357.4429949711982 * H1 - 44.01039326477914 * H10
                    - 4. * H100 + 64. * H1000 + 128. * H1001
                    + 45.33333333333333 * H101 + 160. * H1010 + 128. * H1011
                    - 85.44044944546185 * H11 + 58.666666666666664 * H110
                    + 160. * H1100 + 160. * H1101 + 72. * H111 + 192. * H1110
                    - 57.53175048756444 * Hm1 + 386.899282153668 * Hm10
                    + 60. * Hm100 - 64. * Hm1000 - 96. * Hm1001
                    + 98.66666666666666 * Hm101 - 32. * Hm1010 - 64. * Hm1011
                    + 32. * Hm10m10 - 157.91367041742973 * Hm1m1 - 48. * Hm1m10
                    + 96. * Hm1m100 + 64. * Hm1m101 - 64. * Hm1m1m10
                    - 35.07860313234865 / x + (17.31414898165105 * H0) / x
                    + (56.888888888888886 * H01) / x - (64. * H010) / x
                    - (64. * H011) / x + (21.333333333333332 * H0m10) / x
                    + (417.46922597298527 * H1) / x
                    - (179.55555555555554 * H10) / x
                    - (85.33333333333333 * H100) / x
                    - (106.66666666666666 * H101) / x
                    - (44.44444444444444 * H11) / x - (128. * H110) / x
                    - (64. * H111) / x + (52.63789013914324 * Hm1) / x
                    + (103.1111111111111 * Hm10) / x
                    - (42.666666666666664 * Hm100) / x
                    - (21.333333333333332 * Hm101) / x
                    + (21.333333333333332 * Hm1m10) / x + 2803.8973132708356 * x
                    + 638.0418051123645 * H0 * x - 1920.3037452711644 * H00 * x
                    - 2250.6666666666665 * H000 * x - 512. * H0000 * x
                    - 960. * H0001 * x - 2853.333333333333 * H001 * x
                    - 1152. * H0010 * x - 1152. * H0011 * x - 128. * H00m10 * x
                    - 2533.3285267997053 * H01 * x
                    - 2469.333333333333 * H010 * x - 672. * H0100 * x
                    - 832. * H0101 * x - 2128. * H011 * x - 960. * H0110 * x
                    - 576. * H0111 * x + 579.0167915305757 * H0m1 * x
                    - 576. * H0m10 * x - 352. * H0m100 * x - 256. * H0m101 * x
                    + 192. * H0m1m10 * x - 1392.5576429674024 * H1 * x
                    - 3377.3125468037747 * H10 * x - 920. * H100 * x
                    - 128. * H1000 * x - 256. * H1001 * x
                    - 1274.6666666666665 * H101 * x - 320. * H1010 * x
                    - 256. * H1011 * x - 2187.785767775743 * H11 * x
                    - 1461.3333333333333 * H110 * x - 320. * H1100 * x
                    - 320. * H1101 * x - 768. * H111 * x - 384. * H1110 * x
                    + 1306.1595327817386 * Hm1 * x
                    - 706.2014356926638 * Hm10 * x - 632. * Hm100 * x
                    - 128. * Hm1000 * x - 192. * Hm1001 * x
                    - 346.66666666666663 * Hm101 * x - 64. * Hm1010 * x
                    - 128. * Hm1011 * x + 64. * Hm10m10 * x
                    - 315.82734083485946 * Hm1m1 * x + 544. * Hm1m10 * x
                    + 192. * Hm1m100 * x + 128. * Hm1m101 * x
                    - 128. * Hm1m1m10 * x - 8760.231218576322 * x2
                    + 5989.240995583727 * H0 * x2
                    + 3196.6666666666665 * H00 * x2 + 192. * H000 * x2
                    + 824. * H001 * x2 + 64. * H0010 * x2 + 128. * H0011 * x2
                    + 4174.559550554538 * H01 * x2
                    + 1069.3333333333333 * H010 * x2 + 96. * H0100 * x2
                    + 192. * H0101 * x2 + 1440. * H011 * x2 + 192. * H0110 * x2
                    + 192. * H0111 * x2 + 210.55156055657295 * H0m1 * x2
                    - 341.3333333333333 * H0m10 * x2 - 96. * H0m100 * x2
                    - 64. * H0m101 * x2 + 128. * H0m1m10 * x2
                    + 1487.8251051714824 * H1 * x2
                    + 3674.810549304284 * H10 * x2 + 1072. * H100 * x2
                    + 96. * H1000 * x2 + 224. * H1001 * x2
                    + 1461.3333333333333 * H101 * x2 + 320. * H1010 * x2
                    + 256. * H1011 * x2 + 2488.839325831807 * H11 * x2
                    + 1685.3333333333333 * H110 * x2 + 288. * H1100 * x2
                    + 320. * H1101 * x2 + 856. * H111 * x2 + 384. * H1110 * x2
                    + 1896.984953808188 * Hm1 * x2
                    - 729.8145443032663 * Hm10 * x2 - 856. * Hm100 * x2
                    - 160. * Hm1000 * x2 - 224. * Hm1001 * x2
                    - 528. * Hm101 * x2 - 64. * Hm1010 * x2 - 128. * Hm1011 * x2
                    + 128. * Hm10m10 * x2 - 526.3789013914325 * Hm1m1 * x2
                    + 736. * Hm1m10 * x2 + 288. * Hm1m100 * x2
                    + 192. * Hm1m101 * x2 - 256. * Hm1m1m10 * x2)
           - 9.
                 * (662.1147529715028 - 207.50088698735846 * H0
                    + 914.5509597398694 * H00 - 110.66666666666666 * H000
                    + 176. * H0000 - 36. * H0001 - 28. * H001 - 96. * H0010
                    - 80. * H0011 + 104. * H00m10 + 452.11630774350067 * H01
                    - 16. * H010 - 148. * H0100 - 16. * H0101 - 16. * H011
                    - 16. * H0110 + 13.15947253478581 * H0m1 - 152. * H0m10
                    + 72. * H0m100 + 32. * H0m101 + 80. * H0m1m10
                    - 325.960891791053 * H1 - 306.93845194597054 * H10
                    - 81.33333333333333 * H100 + 104. * H1000 + 160. * H1001
                    + 40. * H101 + 96. * H1010 + 112. * H1011 - 48. * H10m10
                    - 192.967228473494 * H11 + 98.66666666666666 * H110
                    + 128. * H1100 + 112. * H1101 + 77.33333333333333 * H111
                    + 112. * H1110 + 96. * H1111 + 13.496647718580153 * Hm1
                    + 245.3725031256359 * Hm10 - 18.666666666666664 * Hm100
                    - 72. * Hm1000 - 112. * Hm1001 + 34.666666666666664 * Hm101
                    - 32. * Hm1010 - 32. * Hm1011 - 16. * Hm10m10
                    - 26.31894506957162 * Hm1m1 + 50.666666666666664 * Hm1m10
                    + 80. * Hm1m100 + 64. * Hm1m101 + 96. * Hm1m1m10
                    - 354.9367857464629 / x - (49.05622138871931 * H0) / x
                    + (92.44444444444444 * H01) / x
                    - (42.666666666666664 * H010) / x
                    - (53.33333333333333 * H011) / x
                    + (21.333333333333332 * H0m10) / x
                    + (436.3677070377153 * H1) / x
                    - (51.55555555555555 * H10) / x - (96. * H100) / x
                    - (74.66666666666666 * H101) / x
                    - (63.11111111111111 * H11) / x
                    - (74.66666666666666 * H110) / x - (64. * H111) / x
                    + (52.63789013914324 * Hm1) / x
                    + (213.33333333333331 * Hm10) / x
                    - (74.66666666666666 * Hm100) / x
                    - (42.666666666666664 * Hm101) / x
                    - (21.333333333333332 * Hm1m10) / x + 654.068341393323 * x
                    + 124.8672006195577 * H0 * x - 1727.5495473885203 * H00 * x
                    - 2197.333333333333 * H000 * x - 816. * H0000 * x
                    - 1064. * H0001 * x - 2729.333333333333 * H001 * x
                    - 896. * H0010 * x - 1024. * H0011 * x - 144. * H00m10 * x
                    - 2401.618695341753 * H01 * x - 1952. * H010 * x
                    - 744. * H0100 * x - 640. * H0101 * x - 2208. * H011 * x
                    - 640. * H0110 * x - 576. * H0111 * x
                    + 447.4220661827176 * H0m1 * x - 328. * H0m10 * x
                    - 496. * H0m100 * x - 320. * H0m101 * x - 96. * H0m1m10 * x
                    - 1898.5845990151297 * H1 * x - 2055.456429441392 * H10 * x
                    - 841.3333333333333 * H100 * x - 208. * H1000 * x
                    - 320. * H1001 * x - 1024. * H101 * x - 192. * H1010 * x
                    - 224. * H1011 * x + 96. * H10m10 * x
                    - 2534.065543053012 * H11 * x
                    - 1141.3333333333333 * H110 * x - 256. * H1100 * x
                    - 224. * H1101 * x - 1018.6666666666666 * H111 * x
                    - 224. * H1110 * x - 192. * H1111 * x
                    + 987.6347904765242 * Hm1 * x + 34.7450062512718 * Hm10 * x
                    - 845.3333333333333 * Hm100 * x - 144. * Hm1000 * x
                    - 224. * Hm1001 * x - 442.66666666666663 * Hm101 * x
                    - 64. * Hm1010 * x - 64. * Hm1011 * x - 32. * Hm10m10 * x
                    - 52.63789013914324 * Hm1m1 * x
                    + 245.33333333333331 * Hm1m10 * x + 160. * Hm1m100 * x
                    + 128. * Hm1m101 * x + 192. * Hm1m1m10 * x
                    - 2131.398631088743 * x2 + 1203.4044631174963 * H0 * x2
                    + 3994.975218471459 * H00 * x2 + 264. * H000 * x2
                    + 96. * H0001 * x2 + 944. * H001 * x2 + 64. * H0010 * x2
                    + 128. * H0011 * x2 + 3878.337328332316 * H01 * x2
                    + 1040. * H010 * x2 + 32. * H0100 * x2 + 192. * H0101 * x2
                    + 1197.3333333333333 * H011 * x2 + 192. * H0110 * x2
                    + 192. * H0111 * x2 + 315.82734083485946 * H0m1 * x2
                    - 693.3333333333333 * H0m10 * x2 - 128. * H0m100 * x2
                    - 128. * H0m101 * x2 + 128. * H0m1m10 * x2
                    + 1684.4895508138839 * H1 * x2
                    + 2356.287765275234 * H10 * x2 + 1096. * H100 * x2
                    + 176. * H1000 * x2 + 288. * H1001 * x2
                    + 1154.6666666666665 * H101 * x2 + 192. * H1010 * x2
                    + 224. * H1011 * x2 - 96. * H10m10 * x2
                    + 2833.1191011090764 * H11 * x2 + 1272. * H110 * x2
                    + 224. * H1100 * x2 + 224. * H1101 * x2
                    + 1130.6666666666665 * H111 * x2 + 224. * H1110 * x2
                    + 192. * H1111 * x2 + 1367.9086509464007 * Hm1 * x2
                    + 126.68745319622496 * Hm10 * x2
                    - 1037.3333333333333 * Hm100 * x2 - 176. * Hm1000 * x2
                    - 256. * Hm1001 * x2 - 581.3333333333333 * Hm101 * x2
                    - 64. * Hm1010 * x2 - 64. * Hm1011 * x2 + 32. * Hm10m10 * x2
                    - 263.18945069571623 * Hm1m1 * x2
                    + 266.66666666666663 * Hm1m10 * x2 + 256. * Hm1m100 * x2
                    + 192. * Hm1m101 * x2 + 64. * Hm1m1m10 * x2)
           - 1.3333333333333333 * nf
                 * (-544.5264689267692 - 491.7133145495824 * H0
                    - 393.932053680174 * H00 - 140. * H000 - 88. * H0000
                    - 48. * H0001 - 88. * H001 - 16. * H0010 - 16. * H0011
                    - 270.66666666666663 * H01 - 34.666666666666664 * H010
                    - 34.666666666666664 * H011 + 53.33333333333333 * H0m10
                    - 362.347721597095 * H1 - 124.44444444444444 * H10
                    - 21.333333333333332 * H100 - 26.666666666666664 * H101
                    - 116.44444444444444 * H11 - 16. * H110 - 16. * H111
                    - 17.545963379714415 * Hm1 + 80. * Hm10
                    + 10.666666666666666 * Hm100 - 21.333333333333332 * Hm1m10
                    + (0.35555555555555557 * Hm10) / x2 + 22.633555277721257 / x
                    - (0.35555555555555557 * H0) / x
                    - (18.962962962962962 * H1) / x
                    + (7.111111111111111 * H10) / x
                    + (7.111111111111111 * H11) / x
                    - (7.111111111111111 * Hm10) / x + 1090.2814654295973 * x
                    + 35.22534944600551 * H0 * x + 174.97521847145913 * H00 * x
                    + 432. * H000 * x + 176. * H0000 * x + 96. * H0001 * x
                    + 160. * H001 * x + 32. * H0010 * x + 32. * H0011 * x
                    + 138.66666666666666 * H01 * x
                    + 21.333333333333332 * H010 * x
                    + 21.333333333333332 * H011 * x - 64. * H0m10 * x
                    + 573.1398876386345 * H1 * x + 251.55555555555554 * H10 * x
                    + 42.666666666666664 * H100 * x
                    + 53.33333333333333 * H101 * x
                    + 224.88888888888889 * H11 * x + 32. * H110 * x
                    + 32. * H111 * x - 35.09192675942883 * Hm1 * x
                    + 14.222222222222221 * Hm10 * x
                    + 21.333333333333332 * Hm100 * x
                    - 42.666666666666664 * Hm1m10 * x - 164.65248015541817 * x2
                    - 193.90151893526996 * H0 * x2
                    - 99.55555555555554 * H00 * x2 + 64. * H000 * x2
                    + 10.666666666666666 * H001 * x2
                    - 142.22222222222223 * H01 * x2
                    - 10.666666666666666 * H010 * x2
                    - 10.666666666666666 * H011 * x2
                    + 42.666666666666664 * H0m10 * x2
                    - 157.96429462929046 * H1 * x2 - 176. * H10 * x2
                    - 53.33333333333333 * H100 * x2
                    - 53.33333333333333 * H101 * x2
                    - 149.33333333333331 * H11 * x2 - 32. * H110 * x2
                    - 32. * H111 * x2 - 17.545963379714415 * Hm1 * x2
                    - 55.11111111111111 * Hm10 * x2
                    + 10.666666666666666 * Hm100 * x2
                    - 21.333333333333332 * Hm1m10 * x2 + 21.055156055657296 * x3
                    - 12.8 * H00 * x3 + 12.8 * Hm10 * x3)
           - 1.3333333333333333
                 * (-811.5264689267692 - 635.7133145495824 * H0
                    - 449.932053680174 * H00 - 160. * H000 - 96. * H0000
                    - 48. * H0001 - 88. * H001 - 16. * H0010 - 16. * H0011
                    - 270.66666666666663 * H01 - 34.666666666666664 * H010
                    - 34.666666666666664 * H011 + 53.33333333333333 * H0m10
                    - 362.347721597095 * H1 - 124.44444444444444 * H10
                    - 21.333333333333332 * H100 - 26.666666666666664 * H101
                    - 116.44444444444444 * H11 - 16. * H110 - 16. * H111
                    - 17.545963379714415 * Hm1 + 80. * Hm10
                    + 10.666666666666666 * Hm100 - 21.333333333333332 * Hm1m10
                    + (0.35555555555555557 * Hm10) / x2 + 17.30022194438792 / x
                    - (0.35555555555555557 * H0) / x
                    - (18.962962962962962 * H1) / x
                    + (7.111111111111111 * H10) / x
                    + (7.111111111111111 * H11) / x
                    - (7.111111111111111 * Hm10) / x + 1564.2814654295973 * x
                    + 55.22534944600551 * H0 * x + 314.97521847145913 * H00 * x
                    + 480. * H000 * x + 192. * H0000 * x + 96. * H0001 * x
                    + 160. * H001 * x + 32. * H0010 * x + 32. * H0011 * x
                    + 138.66666666666666 * H01 * x
                    + 21.333333333333332 * H010 * x
                    + 21.333333333333332 * H011 * x - 64. * H0m10 * x
                    + 573.1398876386345 * H1 * x + 251.55555555555554 * H10 * x
                    + 42.666666666666664 * H100 * x
                    + 53.33333333333333 * H101 * x
                    + 224.88888888888889 * H11 * x + 32. * H110 * x
                    + 32. * H111 * x - 35.09192675942883 * Hm1 * x
                    + 14.222222222222221 * Hm10 * x
                    + 21.333333333333332 * Hm100 * x
                    - 42.666666666666664 * Hm1m10 * x - 381.3191468220849 * x2
                    - 145.90151893526996 * H0 * x2
                    - 99.55555555555554 * H00 * x2 + 64. * H000 * x2
                    + 10.666666666666666 * H001 * x2
                    - 142.22222222222223 * H01 * x2
                    - 10.666666666666666 * H010 * x2
                    - 10.666666666666666 * H011 * x2
                    + 42.666666666666664 * H0m10 * x2
                    - 157.96429462929046 * H1 * x2 - 176. * H10 * x2
                    - 53.33333333333333 * H100 * x2
                    - 53.33333333333333 * H101 * x2
                    - 149.33333333333331 * H11 * x2 - 32. * H110 * x2
                    - 32. * H111 * x2 - 17.545963379714415 * Hm1 * x2
                    - 55.11111111111111 * Hm10 * x2
                    + 10.666666666666666 * Hm100 * x2
                    - 21.333333333333332 * Hm1m10 * x2 + 21.055156055657296 * x3
                    - 12.8 * H00 * x3 + 12.8 * Hm10 * x3)
           + 1.3333333333333333 * nf
                 * (-277.55626164243847 - 318.95211714054665 * H0
                    - 211.70983145795176 * H00 - 77.33333333333333 * H000
                    - 48. * H0000 - 48. * H0001 - 82.66666666666666 * H001
                    - 32. * H0010 - 16. * H0011 - 248. * H01
                    - 58.666666666666664 * H010 - 37.33333333333333 * H011
                    + 53.33333333333333 * H0m10 - 343.6714627545872 * H1
                    - 160. * H10 - 16. * H101 - 86.66666666666666 * H11
                    - 10.666666666666666 * H110 - 16. * H111
                    - 17.545963379714415 * Hm1 + 80. * Hm10
                    + 10.666666666666666 * Hm100 - 21.333333333333332 * Hm1m10
                    + (0.35555555555555557 * Hm10) / x2 - 3.638049660550349 / x
                    - (0.35555555555555557 * H0) / x
                    - (18.962962962962962 * H1) / x
                    + (14.222222222222221 * H10) / x
                    + (7.111111111111111 * H11) / x
                    - (7.111111111111111 * Hm10) / x + 736.5279202406941 * x
                    + 287.4807324057119 * H0 * x + 235.86410736034804 * H00 * x
                    + 394.66666666666663 * H000 * x + 96. * H0000 * x
                    + 96. * H0001 * x + 149.33333333333331 * H001 * x
                    + 64. * H0010 * x + 32. * H0011 * x
                    + 125.33333333333333 * H01 * x
                    + 21.333333333333332 * H010 * x
                    + 26.666666666666664 * H011 * x - 64. * H0m10 * x
                    + 550.89848106473 * H1 * x + 277.3333333333333 * H10 * x
                    + 32. * H101 * x + 178.66666666666666 * H11 * x
                    + 21.333333333333332 * H110 * x + 32. * H111 * x
                    - 35.09192675942883 * Hm1 * x
                    + 14.222222222222221 * Hm10 * x
                    + 21.333333333333332 * Hm100 * x
                    - 42.666666666666664 * Hm1m10 * x - 96.63281612631388 * x2
                    - 359.36381606506916 * H0 * x2 + 88. * H00 * x2
                    + 42.666666666666664 * H000 * x2 + 32. * H001 * x2
                    - 104. * H01 * x2 + 21.333333333333332 * H010 * x2
                    - 10.666666666666666 * H011 * x2
                    + 42.666666666666664 * H0m10 * x2
                    - 159.2784436109415 * H1 * x2
                    - 144.88888888888889 * H10 * x2
                    - 10.666666666666666 * H100 * x2 - 32. * H101 * x2
                    - 111.1111111111111 * H11 * x2
                    - 21.333333333333332 * H110 * x2 - 32. * H111 * x2
                    - 17.545963379714415 * Hm1 * x2
                    - 55.11111111111111 * Hm10 * x2
                    + 10.666666666666666 * Hm100 * x2
                    - 21.333333333333332 * Hm1m10 * x2 + 21.055156055657296 * x3
                    - 12.8 * H00 * x3 + 12.8 * Hm10 * x3)
           + 1.3333333333333333
                 * (27.017958343085354 - 0.5525176850156157 * H0
                    - 5.333333333333333 * H00 - 10.666666666666666 * H000
                    - 21.333333333333332 * H001 - 16. * H01
                    - 21.333333333333332 * H010 - 26.666666666666664 * H011
                    + 42.666666666666664 * H0m10 - 5.120703286952249 * H1
                    - 32. * H10 - 32. * H101 - 29.333333333333332 * H11
                    - 21.333333333333332 * H110 - 32. * H111
                    - 35.09192675942883 * Hm1 + 64. * Hm10
                    + 21.333333333333332 * Hm100 - 42.666666666666664 * Hm1m10
                    + (0.7111111111111111 * Hm10) / x2 + 0.7111111111111111 / x
                    - (0.7111111111111111 * H0) / x - 74.78179115087 * x
                    - 44.05052018552433 * H0 * x + 3.5555555555555554 * H00 * x
                    + 21.333333333333332 * H000 * x
                    + 42.666666666666664 * H001 * x
                    + 106.66666666666666 * H01 * x
                    + 42.666666666666664 * H010 * x
                    + 53.33333333333333 * H011 * x + 60.90807324057117 * H1 * x
                    + 74.66666666666666 * H10 * x + 64. * H101 * x
                    + 117.33333333333333 * H11 * x
                    + 42.666666666666664 * H110 * x + 64. * H111 * x
                    - 70.18385351885766 * Hm1 * x
                    + 28.444444444444443 * Hm10 * x
                    + 42.666666666666664 * Hm100 * x
                    - 85.33333333333333 * Hm1m10 * x + 324.18535182402474 * x2
                    + 7.675780278286467 * H0 * x2 - 69.33333333333333 * H00 * x2
                    - 42.666666666666664 * H000 * x2 - 64. * H001 * x2
                    - 112. * H01 * x2 - 42.666666666666664 * H010 * x2
                    - 64. * H011 * x2 + 42.666666666666664 * H0m10 * x2
                    - 1.81614648114234 * H1 * x2 - 69.33333333333333 * H10 * x2
                    - 21.333333333333332 * H100 * x2 - 64. * H101 * x2
                    - 112. * H11 * x2 - 42.666666666666664 * H110 * x2
                    - 64. * H111 * x2 - 35.09192675942883 * Hm1 * x2
                    + 21.333333333333332 * Hm100 * x2
                    - 42.666666666666664 * Hm1m10 * x2 + 42.11031211131459 * x3
                    - 25.6 * H00 * x3 + 25.6 * Hm10 * x3)
           - 1.7777777777777777
                 * (-333.87851542820187 - 250.4647802013872 * H0
                    - 119.39208802178717 * H00 + 40. * H0000 + 120. * H0001
                    + 72. * H001 + 160. * H0010 + 200. * H0011 - 192. * H00m10
                    - 135.18945069571623 * H01 + 128. * H010 + 80. * H0100
                    + 240. * H0101 + 152. * H011 + 224. * H0110 + 288. * H0111
                    + 184.23261548700137 * H0m1 - 448. * H0m10 - 160. * H0m100
                    - 32. * H0m101 + 160. * H0m1m10 - 439.2910194322317 * H1
                    - 189.1031211131459 * H10 - 24. * H100 + 96. * H1000
                    + 256. * H1001 + 264. * H101 + 288. * H1010 + 352. * H1011
                    - 128. * H10m10 - 111.1031211131459 * H11 + 256. * H110
                    + 160. * H1100 + 320. * H1101 + 288. * H111 + 288. * H1110
                    + 384. * H1111 + 608.3713844061638 * Hm1
                    - 923.3621098608568 * Hm10 - 384. * Hm100 - 64. * Hm1000
                    - 32. * Hm1001 - 64. * Hm101 + 128. * Hm10m10
                    - 210.55156055657295 * Hm1m1 + 448. * Hm1m10
                    + 224. * Hm1m100 + 64. * Hm1m101 - 128. * Hm1m1m10
                    + (2.1333333333333333 * Hm10) / x2 + 2.1333333333333333 / x
                    - (2.1333333333333333 * H0) / x - 686.8823779386669 * x
                    + 1197.3309620949653 * H0 * x + 1024.1750624319545 * H00 * x
                    + 232. * H000 * x + 48. * H0000 * x - 176. * H0001 * x
                    - 312. * H001 * x - 320. * H0010 * x - 400. * H0011 * x
                    + 139.48202250457837 * H01 * x - 624. * H010 * x
                    - 416. * H0100 * x - 480. * H0101 * x - 920. * H011 * x
                    - 448. * H0110 * x - 576. * H0111 * x
                    - 52.63789013914324 * H0m1 * x - 64. * H0m10 * x
                    - 64. * H0m100 * x - 64. * H0m101 * x - 192. * H0m1m10 * x
                    + 1387.4261712298985 * H1 * x + 82.2062422262918 * H10 * x
                    - 320. * H100 * x - 192. * H1000 * x - 512. * H1001 * x
                    - 864. * H101 * x - 576. * H1010 * x - 704. * H1011 * x
                    + 256. * H10m10 * x - 249.7937577737082 * H11 * x
                    - 832. * H110 * x - 320. * H1100 * x - 640. * H1101 * x
                    - 1152. * H111 * x - 576. * H1110 * x - 768. * H1111 * x
                    + 927.2343730470398 * Hm1 * x - 1057.39088638838 * Hm10 * x
                    - 640. * Hm100 * x - 128. * Hm1000 * x - 64. * Hm1001 * x
                    - 160. * Hm101 * x + 256. * Hm10m10 * x
                    - 421.1031211131459 * Hm1m1 * x + 480. * Hm1m10 * x
                    + 448. * Hm1m100 * x + 128. * Hm1m101 * x
                    - 256. * Hm1m1m10 * x - 2098.765620290642 * x2
                    - 1966.9953133029355 * H0 * x2
                    - 331.48202250457837 * H00 * x2 + 656. * H000 * x2
                    + 320. * H0000 * x2 + 576. * H0001 * x2 + 800. * H001 * x2
                    + 576. * H0010 * x2 + 704. * H0011 * x2 - 512. * H00m10 * x2
                    - 106.2062422262918 * H01 * x2 + 704. * H010 * x2
                    + 320. * H0100 * x2 + 640. * H0101 * x2 + 1008. * H011 * x2
                    + 576. * H0110 * x2 + 768. * H0111 * x2
                    + 421.1031211131459 * H0m1 * x2 - 32. * H0m10 * x2
                    - 448. * H0m100 * x2 - 128. * H0m101 * x2
                    + 256. * H0m1m10 * x2 - 1436.7019515081852 * H1 * x2
                    - 402.2062422262918 * H10 * x2 + 400. * H100 * x2
                    + 192. * H1000 * x2 + 512. * H1001 * x2 + 704. * H101 * x2
                    + 576. * H1010 * x2 + 704. * H1011 * x2 - 256. * H10m10 * x2
                    - 106.2062422262918 * H11 * x2 + 704. * H110 * x2
                    + 320. * H1100 * x2 + 640. * H1101 * x2 + 1008. * H111 * x2
                    + 576. * H1110 * x2 + 768. * H1111 * x2
                    + 453.4933617947505 * Hm1 * x2
                    - 70.72421972171352 * Hm10 * x2 - 256. * Hm100 * x2
                    - 128. * Hm1000 * x2 - 64. * Hm1001 * x2 - 96. * Hm101 * x2
                    + 256. * Hm10m10 * x2 - 421.1031211131459 * Hm1m1 * x2
                    + 32. * Hm1m10 * x2 + 448. * Hm1m100 * x2
                    + 128. * Hm1m101 * x2 - 256. * Hm1m1m10 * x2
                    + 126.33093633394378 * x3 - 76.80000000000001 * H00 * x3
                    + 76.80000000000001 * Hm10 * x3)
           - 4.
                 * (282.06990034685174 - 16.44313678622879 * H0
                    + 143.88097691067605 * H00 + 120. * H000 - 80. * H0000
                    - 120. * H0001 + 68. * H001 - 96. * H0010 - 48. * H0011
                    + 224. * H00m10 + 116.41175093769077 * H01
                    + 86.66666666666666 * H010 + 112. * H0100 - 16. * H0101
                    + 142.66666666666666 * H011 + 381.6247035087885 * H0m1
                    + 362.66666666666663 * H0m10 - 104. * H0m100 - 224. * H0m101
                    + 16. * H0m1m10 + 266.921490168407 * H1
                    + 309.66267166768404 * H10 + 429.3333333333333 * H100
                    + 16. * H1000 + 16. * H1001 + 234.66666666666666 * H101
                    + 160. * H1010 + 96. * H1011 + 96. * H10m10
                    + 163.05355805606425 * H11 + 184. * H110 + 112. * H1100
                    + 128. * H1101 + 208. * H111 + 160. * H1110
                    + 981.7261911211181 * Hm1 + 1415.097846461004 * Hm10
                    - 78.66666666666666 * Hm100 - 176. * Hm1000 - 192. * Hm1001
                    - 328. * Hm101 - 64. * Hm1010 - 64. * Hm1011
                    + 192. * Hm10m10 - 736.9304619480055 * Hm1m1
                    - 58.666666666666664 * Hm1m10 + 288. * Hm1m100
                    + 256. * Hm1m101 - 384. * Hm1m1m10
                    + (1.7545963379714413 * H1) / x2
                    + (5.263789013914324 * Hm1) / x2
                    - (4.977777777777778 * Hm10) / x2
                    - (2.1333333333333333 * Hm100) / x2
                    - (2.1333333333333333 * Hm101) / x2
                    + (2.1333333333333333 * Hm1m10) / x2 - 2.483924331139562 / x
                    + (2.8444444444444446 * H0) / x
                    + (2.1333333333333333 * H00) / x
                    + (2.1333333333333333 * H01) / x
                    + (117.36466916717536 * H1) / x
                    + (28.444444444444443 * H10) / x
                    - (42.666666666666664 * H100) / x
                    - (85.33333333333333 * H101) / x
                    + (28.444444444444443 * H11) / x
                    - (85.33333333333333 * H110) / x - (64. * H111) / x
                    + (35.09192675942883 * Hm1) / x
                    - (2.1333333333333333 * Hm10) / x
                    - (21.333333333333332 * Hm100) / x
                    + (42.666666666666664 * Hm1m10) / x + 995.4374057969087 * x
                    - 171.8279072411798 * H0 * x - 265.12181645489954 * H00 * x
                    - 325.3333333333333 * H000 * x - 288. * H0000 * x
                    - 496. * H0001 * x - 442.66666666666663 * H001 * x
                    - 640. * H0010 * x - 640. * H0011 * x - 64. * H00m10 * x
                    + 626.297846461004 * H01 * x - 741.3333333333333 * H010 * x
                    - 224. * H0100 * x - 736. * H0101 * x
                    - 741.3333333333333 * H011 * x - 768. * H0110 * x
                    - 576. * H0111 * x + 763.249407017577 * H0m1 * x
                    - 186.66666666666666 * H0m10 * x - 400. * H0m100 * x
                    - 64. * H0m101 * x + 800. * H0m1m10 * x
                    + 956.0160968763563 * H1 * x - 1096.6586766687014 * H10 * x
                    - 970.6666666666666 * H100 * x - 32. * H1000 * x
                    - 32. * H1001 * x - 1061.3333333333333 * H101 * x
                    - 320. * H1010 * x - 192. * H1011 * x - 192. * H10m10 * x
                    - 518.1071161121286 * H11 * x - 976. * H110 * x
                    - 224. * H1100 * x - 256. * H1101 * x - 656. * H111 * x
                    - 320. * H1110 * x + 1923.9739646378785 * Hm1 * x
                    + 2184.684581810897 * Hm10 * x
                    - 266.66666666666663 * Hm100 * x - 352. * Hm1000 * x
                    - 384. * Hm1001 * x - 357.3333333333333 * Hm101 * x
                    - 128. * Hm1010 * x - 128. * Hm1011 * x + 384. * Hm10m10 * x
                    - 1473.860923896011 * Hm1m1 * x + 432. * Hm1m10 * x
                    + 576. * Hm1m100 * x + 512. * Hm1m101 * x
                    - 768. * Hm1m1m10 * x - 3272.8248584685643 * x2
                    - 2724.389538273392 * H0 * x2 + 1288.664107360348 * H00 * x2
                    + 1229.3333333333333 * H000 * x2 + 96. * H0001 * x2
                    + 1616. * H001 * x2 + 192. * H0010 * x2 + 256. * H0011 * x2
                    + 128. * H00m10 * x2 + 1173.9974406936815 * H01 * x2
                    + 1498.6666666666665 * H010 * x2 + 288. * H0100 * x2
                    + 256. * H0101 * x2 + 1341.3333333333333 * H011 * x2
                    + 320. * H0110 * x2 + 192. * H0111 * x2
                    + 789.5683520871487 * H0m1 * x2 - 640. * H0m10 * x2
                    - 256. * H0m100 * x2 - 320. * H0m101 * x2
                    + 320. * H0m1m10 * x2 - 1452.2759640754152 * H1 * x2
                    + 1025.662671667684 * H10 * x2 + 808. * H100 * x2
                    + 96. * H1000 * x2 + 96. * H1001 * x2
                    + 1178.6666666666665 * H101 * x2 + 320. * H1010 * x2
                    + 192. * H1011 * x2 + 192. * H10m10 * x2
                    + 460.4444444444444 * H11 * x2
                    + 1061.3333333333333 * H110 * x2 + 288. * H1100 * x2
                    + 256. * H1101 * x2 + 744. * H111 * x2 + 320. * H1110 * x2
                    + 1501.1860387576285 * Hm1 * x2
                    + 994.0441323654352 * Hm10 * x2 - 304. * Hm100 * x2
                    - 288. * Hm1000 * x2 - 320. * Hm1001 * x2
                    - 160. * Hm101 * x2 - 128. * Hm1010 * x2
                    - 128. * Hm1011 * x2 + 256. * Hm10m10 * x2
                    - 1052.757802782865 * Hm1m1 * x2 + 640. * Hm1m10 * x2
                    + 384. * Hm1m100 * x2 + 384. * Hm1m101 * x2
                    - 512. * Hm1m1m10 * x2 - 525.5671101858443 * x3
                    - 252.66187266788756 * H0 * x3
                    + 179.20000000000002 * H00 * x3
                    + 76.80000000000001 * H000 * x3
                    + 76.80000000000001 * H001 * x3
                    - 76.80000000000001 * H0m10 * x3
                    - 63.16546816697189 * H1 * x3
                    + 189.49640450091567 * Hm1 * x3
                    - 179.20000000000002 * Hm10 * x3
                    - 76.80000000000001 * Hm100 * x3
                    - 76.80000000000001 * Hm101 * x3
                    + 76.80000000000001 * Hm1m10 * x3)
           + 4.
                 * (-162.8123830314744 + 1.9728647754493807 * H0
                    - 35.095443194190096 * H00 + 29.333333333333332 * H000
                    - 32. * H0000 - 32. * H0001 + 58.666666666666664 * H001
                    + 48. * H0011 + 128. * H00m10 - 20.023501875381534 * H01
                    + 42.666666666666664 * H010 + 64. * H0100 + 48. * H0101
                    + 121.33333333333333 * H011 + 80. * H0110 + 144. * H0111
                    + 210.55156055657295 * H0m1 + 10.666666666666666 * H0m10
                    - 64. * H0m100 - 128. * H0m101 - 127.45787557976347 * H1
                    + 14.02877652752342 * H10 + 128. * H100 + 96. * H1001
                    + 224. * H101 + 160. * H1010 + 288. * H1011
                    - 169.8848938899063 * H11 + 210.66666666666666 * H110
                    + 64. * H1100 + 256. * H1101 + 304. * H111 + 224. * H1110
                    + 384. * H1111 + 734.2287758701809 * Hm1
                    + 424.951560556573 * Hm10 - 186.66666666666666 * Hm100
                    - 64. * Hm1000 - 64. * Hm1001 - 192. * Hm101
                    + 128. * Hm10m10 - 421.1031211131459 * Hm1m1
                    + 181.33333333333331 * Hm1m10 + 192. * Hm1m100
                    + 128. * Hm1m101 - 256. * Hm1m1m10
                    + (1.7545963379714413 * H1) / x2
                    + (5.263789013914324 * Hm1) / x2
                    - (3.9111111111111114 * Hm10) / x2
                    - (2.1333333333333333 * Hm100) / x2
                    - (2.1333333333333333 * Hm101) / x2
                    + (2.1333333333333333 * Hm1m10) / x2 + 62.18105080440779 / x
                    + (1.7777777777777777 * H0) / x
                    + (2.1333333333333333 * H00) / x
                    + (2.1333333333333333 * H01) / x
                    + (44.05052018552433 * H1) / x
                    - (53.33333333333333 * H10) / x
                    - (21.333333333333332 * H100) / x - (64. * H101) / x
                    - (32. * H11) / x - (42.666666666666664 * H110) / x
                    - (64. * H111) / x + (35.09192675942883 * Hm1) / x
                    - (2.1333333333333333 * Hm10) / x
                    - (21.333333333333332 * Hm100) / x
                    + (42.666666666666664 * Hm1m10) / x + 3163.8838378180817 * x
                    + 960.4876196814369 * H0 * x + 1.7566791692102015 * H00 * x
                    - 176. * H000 * x - 128. * H0000 * x - 320. * H0001 * x
                    - 736. * H001 * x - 384. * H0010 * x - 576. * H0011 * x
                    - 279.4407615244712 * H01 * x - 885.3333333333333 * H010 * x
                    - 128. * H0100 * x - 672. * H0101 * x
                    - 1474.6666666666665 * H011 * x - 544. * H0110 * x
                    - 864. * H0111 * x + 421.1031211131459 * H0m1 * x
                    - 42.666666666666664 * H0m10 * x - 256. * H0m100 * x
                    + 512. * H0m1m10 * x + 325.704088687296 * H1 * x
                    - 870.7242197217136 * H10 * x - 352. * H100 * x
                    - 192. * H1001 * x - 1136. * H101 * x - 320. * H1010 * x
                    - 576. * H1011 * x - 1261.5635455535207 * H11 * x
                    - 949.3333333333333 * H110 * x - 128. * H1100 * x
                    - 512. * H1101 * x - 1616. * H111 * x - 448. * H1110 * x
                    - 768. * H1111 * x + 1152.6302109055027 * Hm1 * x
                    + 911.0586766687015 * Hm10 * x
                    - 330.66666666666663 * Hm100 * x - 128. * Hm1000 * x
                    - 128. * Hm1001 * x - 85.33333333333333 * Hm101 * x
                    + 256. * Hm10m10 * x - 842.2062422262918 * Hm1m1 * x
                    + 576. * Hm1m10 * x + 384. * Hm1m100 * x
                    + 256. * Hm1m101 * x - 512. * Hm1m1m10 * x
                    - 4149.404770805476 * x2 - 380.60526243086724 * H0 * x2
                    + 510.2484394434271 * H00 * x2 + 448. * H000 * x2
                    + 128. * H0001 * x2 + 880. * H001 * x2 + 192. * H0010 * x2
                    + 384. * H0011 * x2 + 1171.6968788868544 * H01 * x2
                    + 784. * H010 * x2 + 128. * H0100 * x2 + 320. * H0101 * x2
                    + 1344. * H011 * x2 + 320. * H0110 * x2 + 576. * H0111 * x2
                    + 315.82734083485946 * H0m1 * x2 - 544. * H0m10 * x2
                    - 128. * H0m100 * x2 - 128. * H0m101 * x2
                    + 128. * H0m1m10 * x2 - 873.2785054124748 * H1 * x2
                    + 704.1726591651405 * H10 * x2 + 384. * H100 * x2
                    + 64. * H1000 * x2 + 256. * H1001 * x2 + 1216. * H101 * x2
                    + 320. * H1010 * x2 + 576. * H1011 * x2
                    + 1076.345318330281 * H11 * x2 + 992. * H110 * x2
                    + 192. * H1100 * x2 + 512. * H1101 * x2 + 1680. * H111 * x2
                    + 448. * H1110 * x2 + 768. * H1111 * x2
                    + 716.6828124904666 * Hm1 * x2
                    + 317.75156055657294 * Hm10 * x2 - 272. * Hm100 * x2
                    - 64. * Hm1000 * x2 - 64. * Hm1001 * x2
                    + 128. * Hm10m10 * x2 - 421.1031211131459 * Hm1m1 * x2
                    + 544. * Hm1m10 * x2 + 192. * Hm1m100 * x2
                    + 128. * Hm1m101 * x2 - 256. * Hm1m1m10 * x2
                    - 462.4016420188724 * x3 - 252.66187266788756 * H0 * x3
                    + 140.8 * H00 * x3 + 76.80000000000001 * H000 * x3
                    + 76.80000000000001 * H001 * x3
                    - 76.80000000000001 * H0m10 * x3
                    - 63.16546816697189 * H1 * x3
                    + 189.49640450091567 * Hm1 * x3 - 140.8 * Hm10 * x3
                    - 76.80000000000001 * Hm100 * x3
                    - 76.80000000000001 * Hm101 * x3
                    + 76.80000000000001 * Hm1m10 * x3)
           - 1.3333333333333333
                 * (1.3333333333333333
                        * (1.6120361199687183 - 8. * H0 - 1. * H00 + 2. * H000
                           + 4. * H01 - 4. * H010 - 4. * H011 + 2. * H10
                           + 4. * H100 + 4. * H11 - 4. * H111
                           - 70.86196237908068 * x - 9. * H0 * x - 12. * H00 * x
                           - 4. * H000 * x + 24. * H01 * x + 8. * H010 * x
                           + 8. * H011 * x + 26. * H1 * x - 24. * H10 * x
                           - 8. * H100 * x + 8. * H11 * x + 8. * H111 * x
                           + 69.35566402745548 * x2 - 24. * H0 * x2
                           + 20. * H00 * x2 + 8. * H000 * x2 - 12. * H01 * x2
                           - 8. * H011 * x2 - 24. * H1 * x2 + 20. * H10 * x2
                           + 8. * H100 * x2 - 12. * H11 * x2 - 8. * H111 * x2)
                    + 3.
                          * (44.52325570297974 + 44.840527465214194 * H0
                             - 2. * H00 + 20. * H000 + 8. * H001 - 8. * H01
                             + 33.82613920145248 * H1 - 4. * H10 - 12. * H100
                             - 4. * H101 - 4. * H11 - 12. * H110 - 4. * H111
                             - 6.579736267392905 * Hm1 - 24. * Hm10 + 8. * Hm100
                             + 8. * Hm101 + 8. * Hm1m10 + 3.967759050883533 / x
                             - (11.555555555555555 * H1) / x
                             + (5.333333333333333 * H10) / x
                             + (5.333333333333333 * H11) / x
                             - (5.333333333333333 * Hm10) / x
                             - 175.45812586669405 * x
                             + 89.39088638838018 * H0 * x + 176. * H00 * x
                             + 56. * H000 * x + 64. * H001 * x + 144. * H01 * x
                             + 48. * H010 * x + 48. * H011 * x
                             + 125.0143882637617 * H1 * x + 80. * H10 * x
                             + 24. * H100 * x + 8. * H101 * x + 72. * H11 * x
                             + 24. * H110 * x + 8. * H111 * x
                             - 13.15947253478581 * Hm1 * x + 16. * Hm100 * x
                             + 16. * Hm101 * x + 16. * Hm1m10 * x
                             + 105.89220016196037 * x2
                             - 205.9032771526506 * H0 * x2
                             - 129.33333333333331 * H00 * x2 - 16. * H001 * x2
                             - 148. * H01 * x2 - 16. * H010 * x2
                             - 16. * H011 * x2 + 16. * H0m10 * x2
                             - 161.28497190965862 * H1 * x2
                             - 89.33333333333333 * H10 * x2 - 16. * H100 * x2
                             - 8. * H101 * x2 - 81.33333333333333 * H11 * x2
                             - 24. * H110 * x2 - 8. * H111 * x2
                             - 26.31894506957162 * Hm1 * x2
                             + 26.666666666666664 * Hm10 * x2 + 24. * Hm100 * x2
                             + 16. * Hm101 * x2)
                    + 3.
                          * (18.56624378388684 - 9.333333333333332 * H0
                             + 2. * H00 - 4. * H000 + 8. * H010 - 2. * H1
                             + 6. * H10 - 4. * H101 - 2. * H11 - 4. * H110
                             + 4. * H111 - 6.579736267392905 * Hm1 + 4. * Hm100
                             - 8. * Hm1m10 - 8.296296296296296 / x
                             + (5.333333333333333 * H10) / x
                             - 24.192007554943572 * x
                             - 28.666666666666664 * H0 * x + 8. * H00 * x
                             - 8. * H000 * x + 32. * H010 * x - 8. * H1 * x
                             + 32. * H10 * x + 8. * H101 * x - 8. * H11 * x
                             + 8. * H110 * x - 8. * H111 * x
                             - 13.15947253478581 * Hm1 * x + 8. * Hm10 * x
                             + 8. * Hm100 * x - 16. * Hm1m10 * x
                             + 114.33976149593316 * x2
                             - 88.88888888888889 * H0 * x2
                             + 15.333333333333332 * H00 * x2 + 2. * H01 * x2
                             + 8. * H1 * x2 - 43.33333333333333 * H10 * x2
                             - 8. * H101 * x2 + 10. * H11 * x2 - 8. * H110 * x2
                             + 8. * H111 * x2 - 13.15947253478581 * Hm1 * x2
                             + 8. * Hm10 * x2 + 8. * Hm100 * x2
                             - 16. * Hm1m10 * x2)
                    + 1.3333333333333333
                          * (21.6514326373453 + 10.585611736238286 * H0
                             - 3. * H00 - 10. * H000 - 16. * H001 - 16. * H01
                             - 12. * H010 - 16. * H011 + 32. * H0m10
                             - 0.8405274652141905 * H1 - 26. * H10 - 4. * H100
                             - 24. * H101 - 26. * H11 - 16. * H110 - 20. * H111
                             - 26.31894506957162 * Hm1 + 48. * Hm10
                             + 16. * Hm100 - 32. * Hm1m10
                             + (0.5333333333333333 * Hm10) / x2
                             + 0.5333333333333333 / x
                             - (0.5333333333333333 * H0) / x
                             - 9.224380984071836 * x
                             - 30.037890139143236 * H0 * x
                             + 14.666666666666666 * H00 * x + 20. * H000 * x
                             + 32. * H001 * x + 56. * H01 * x + 24. * H010 * x
                             + 32. * H011 * x + 13.681054930428381 * H1 * x
                             + 80. * H10 * x + 8. * H100 * x + 48. * H101 * x
                             + 80. * H11 * x + 32. * H110 * x + 40. * H111 * x
                             - 52.63789013914324 * Hm1 * x
                             + 21.333333333333332 * Hm10 * x + 32. * Hm100 * x
                             - 64. * Hm1m10 * x + 197.78334984056306 * x2
                             + 35.75683520871486 * H0 * x2 - 72. * H00 * x2
                             - 40. * H000 * x2 - 48. * H001 * x2
                             - 72. * H01 * x2 - 32. * H010 * x2
                             - 40. * H011 * x2 + 32. * H0m10 * x2
                             + 28.637890139143238 * H1 * x2 - 72. * H10 * x2
                             - 24. * H100 * x2 - 48. * H101 * x2
                             - 72. * H11 * x2 - 32. * H110 * x2
                             - 40. * H111 * x2 - 26.31894506957162 * Hm1 * x2
                             + 16. * Hm100 * x2 - 32. * Hm1m10 * x2
                             + 31.582734083485946 * x3
                             - 19.200000000000003 * H00 * x3
                             + 19.200000000000003 * Hm10 * x3))
           - 12.666666666666666 * C2_g1_massless(x, 1);
}

//==========================================================================================//
//  High scale (Q^2 >> m^2) limit of the gluon coefficient functions for F2 at
//  O(alpha_s^3) expanded in terms of \alpha_s^{[nf]}, for Q=mu.
//
//  Coefficient of log(m^2/Q^2)^0
//------------------------------------------------------------------------------------------//

double C2_g3_highscale_N3LL(double x, int nf, int v) {

    double x2 = x * x;

    // Allocate pointers for the harmonic polylogs
    double wx = x;
    int nw = 5;
    int n1 = -1;
    int n2 = 1;
    int sz = n2 - n1 + 1;
    double *Hr1 = new double[sz];
    double *Hr2 = new double[sz * sz];
    double *Hr3 = new double[sz * sz * sz];
    double *Hr4 = new double[sz * sz * sz * sz];
    double *Hr5 = new double[sz * sz * sz * sz * sz];

    // Call polylogs
    apf_hplog_(&wx, &nw, Hr1, Hr2, Hr3, Hr4, Hr5, &n1, &n2);

    // weight 1
    const double Hm1 = Hr1[0];
    const double H0 = Hr1[1];
    const double H1 = Hr1[2];

    // weight 2
    const double Hm1m1 = Hr2[0];
    const double H0m1 = Hr2[1];
    const double Hm10 = Hr2[3];
    const double H00 = Hr2[4];
    const double H10 = Hr2[5];
    const double H01 = Hr2[7];
    const double H11 = Hr2[8];

    // weight 3
    const double Hm1m1m1 = Hr3[0];
    const double H0m1m1 = Hr3[1];
    const double Hm10m1 = Hr3[3];
    const double H00m1 = Hr3[4];
    const double Hm1m10 = Hr3[9];
    const double H0m10 = Hr3[10];
    const double Hm100 = Hr3[12];
    const double H000 = Hr3[13];
    const double H100 = Hr3[14];
    const double H010 = Hr3[16];
    const double H110 = Hr3[17];
    const double Hm101 = Hr3[21];
    const double H001 = Hr3[22];
    const double H101 = Hr3[23];
    const double H011 = Hr3[25];
    const double H111 = Hr3[26];

    // weight 4
    const double Hm1m1m10 = Hr4[27];
    const double H0m1m10 = Hr4[28];
    const double Hm10m10 = Hr4[30];
    const double H00m10 = Hr4[31];
    const double Hm1m100 = Hr4[36];
    const double H0m100 = Hr4[37];
    const double Hm1000 = Hr4[39];
    const double H0000 = Hr4[40];
    const double H1000 = Hr4[41];
    const double H0100 = Hr4[43];
    const double H1100 = Hr4[44];
    const double Hm1010 = Hr4[48];
    const double H0010 = Hr4[49];
    const double H1010 = Hr4[50];
    const double H0110 = Hr4[52];
    const double H1110 = Hr4[53];
    const double Hm1m101 = Hr4[63];
    const double H0m101 = Hr4[64];
    const double Hm1001 = Hr4[66];
    const double H0001 = Hr4[67];
    const double H1001 = Hr4[68];
    const double H0101 = Hr4[70];
    const double H1101 = Hr4[71];
    const double Hm1011 = Hr4[75];
    const double H0011 = Hr4[76];
    const double H1011 = Hr4[77];
    const double H0111 = Hr4[79];
    const double H1111 = Hr4[80];

    //  weight 5
    const double Hm1m1m1m10 = Hr5[81];
    const double H0m1m1m10 = Hr5[82];
    const double Hm10m1m10 = Hr5[84];
    const double H00m1m10 = Hr5[85];
    const double Hm1m10m10 = Hr5[90];
    const double H0m10m10 = Hr5[91];
    const double Hm100m10 = Hr5[93];
    const double Hm1m1m100 = Hr5[108];
    const double H0m1m100 = Hr5[109];
    const double Hm10m100 = Hr5[111];
    const double H00m100 = Hr5[112];
    const double Hm1m1000 = Hr5[117];
    const double H0m1000 = Hr5[118];
    const double Hm10000 = Hr5[120];
    const double H00000 = Hr5[121];
    const double H10000 = Hr5[122];
    const double H01000 = Hr5[124];
    const double H11000 = Hr5[125];
    const double Hm10100 = Hr5[129];
    const double H00100 = Hr5[130];
    const double H10100 = Hr5[131];
    const double H01100 = Hr5[133];
    const double H11100 = Hr5[134];
    const double Hm1m1010 = Hr5[144];
    const double H0m1010 = Hr5[145];
    const double Hm10010 = Hr5[147];
    const double H00010 = Hr5[148];
    const double H10010 = Hr5[149];
    const double H01010 = Hr5[151];
    const double H11010 = Hr5[152];
    const double Hm10110 = Hr5[156];
    const double H00110 = Hr5[157];
    const double H10110 = Hr5[158];
    const double H01110 = Hr5[160];
    const double H11110 = Hr5[161];
    const double Hm1m1m101 = Hr5[189];
    const double H0m1m101 = Hr5[190];
    const double Hm10m101 = Hr5[192];
    const double Hm1m1001 = Hr5[198];
    const double H0m1001 = Hr5[199];
    const double Hm10001 = Hr5[201];
    const double H00001 = Hr5[202];
    const double H10001 = Hr5[203];
    const double H01001 = Hr5[205];
    const double H11001 = Hr5[206];
    const double Hm10101 = Hr5[210];
    const double H00101 = Hr5[211];
    const double H10101 = Hr5[212];
    const double H01101 = Hr5[214];
    const double H11101 = Hr5[215];
    const double Hm1m1011 = Hr5[225];
    const double Hm10011 = Hr5[228];
    const double H00011 = Hr5[229];
    const double H10011 = Hr5[230];
    const double H01011 = Hr5[232];
    const double H11011 = Hr5[233];
    const double H00111 = Hr5[238];
    const double H10111 = Hr5[239];
    const double H01111 = Hr5[241];
    const double H11111 = Hr5[242];

    delete[] Hr1;
    delete[] Hr2;
    delete[] Hr3;
    delete[] Hr4;
    delete[] Hr5;

    return 1.0684950250307503 - 2.1369900500615007 * x + 2.1369900500615007 * x2
           + 30.58912817099955 * nf * (1. - 2. * x + 2. * x2)
           + 1.3333333333333333 * nf
                 * (-342.07370001741117 - 304.83553036103746 * H0
                    - 121.42828818124003 * H00 - 125.7037037037037 * H000
                    - 41.77777777777778 * H0000 - 32. * H00000 + 32. * H00010
                    + 48. * H0010 + 32. * H00100 - 22.748290331832514 * H01
                    + 144.44444444444443 * H010 + 53.33333333333333 * H0100
                    + 5.333333333333333 * H0101 + 11.25925925925926 * H011
                    - 4.444444444444445 * H0111 + 14.391581599422958 * H1
                    + 158.34567901234567 * H10 + 133.92592592592592 * H100
                    - 8.88888888888889 * H1000 - 20.08162366516585 * H11
                    + 5.333333333333333 * H1101 + 11.25925925925926 * H111
                    - 4.444444444444445 * H1111 - 30.5890023118805 / x
                    + (15.407407407407407 * H10) / x
                    - (14.222222222222221 * H100) / x + 604.21724126392 * x
                    - 175.8911246362049 * H0 * x - 252.6249051190014 * H00 * x
                    - 25.037037037037035 * H000 * x
                    + 3.5555555555555554 * H0000 * x + 64. * H00000 * x
                    - 64. * H00010 * x - 32. * H0010 * x - 64. * H00100 * x
                    + 39.8669510340354 * H01 * x + 57.77777777777777 * H010 * x
                    - 10.666666666666666 * H0100 * x
                    - 10.666666666666666 * H0101 * x
                    + 18.37037037037037 * H011 * x
                    + 8.88888888888889 * H0111 * x - 12.536249618599001 * H1 * x
                    - 91.06172839506172 * H10 * x
                    - 194.96296296296296 * H100 * x
                    + 17.77777777777778 * H1000 * x + 51.8669510340354 * H11 * x
                    - 10.666666666666666 * H1101 * x
                    - 2.962962962962963 * H111 * x
                    + 8.88888888888889 * H1111 * x + 365.71608540302014 * x2
                    - 437.65813157184635 * H0 * x2
                    + 285.9753086419753 * H00 * x2
                    - 147.55555555555554 * H000 * x2
                    + 39.11111111111111 * H0000 * x2
                    - 42.666666666666664 * H0010 * x2
                    - 43.8669510340354 * H01 * x2
                    + 78.22222222222221 * H010 * x2
                    - 42.666666666666664 * H0100 * x2
                    + 10.666666666666666 * H0101 * x2
                    - 2.3703703703703702 * H011 * x2
                    - 8.88888888888889 * H0111 * x2
                    + 5.573286655636037 * H1 * x2 - 86.5679012345679 * H10 * x2
                    + 70.51851851851852 * H100 * x2
                    - 17.77777777777778 * H1000 * x2
                    - 43.8669510340354 * H11 * x2
                    + 10.666666666666666 * H1101 * x2
                    - 2.3703703703703702 * H111 * x2
                    - 8.88888888888889 * H1111 * x2)
           + 1.3333333333333333
                 * (-488.22611995468054 - 235.4778921357896 * H0
                    - 48.189346929732565 * H00 - 22.232014670297865 * H000
                    + 2.6666666666666665 * H0000 + 8. * H00001 + 20. * H0001
                    + 56. * H001 - 5.333333333333333 * H0010
                    + 188.51219049203593 * H01 - 8. * H010
                    - 5.333333333333333 * H0100 - 10.666666666666666 * H0101
                    - 5.333333333333333 * H011 + 5.333333333333333 * H0111
                    + 239.3080237952778 * H1 - 17.893684976809457 * H10
                    + 2.6666666666666665 * H100 + 5.333333333333333 * H1000
                    - 10.666666666666666 * H1010 + 39.178857158702584 * H11
                    - 10.666666666666666 * H1101 - 5.333333333333333 * H111
                    + 5.333333333333333 * H1111 - 17.92910146872096 / x
                    + (5.333333333333333 * H1) / x + 114.15784812213988 * x
                    - 224.18020850419003 * H0 * x + 48.4656242587389 * H00 * x
                    - 102.20263732607094 * H000 * x
                    - 53.33333333333333 * H0000 * x - 16. * H00001 * x
                    - 48. * H0001 * x - 140. * H001 * x
                    + 10.666666666666666 * H0010 * x
                    - 135.69104765073848 * H01 * x
                    - 10.666666666666666 * H010 * x
                    + 10.666666666666666 * H0100 * x
                    + 21.333333333333332 * H0101 * x - 32. * H011 * x
                    - 10.666666666666666 * H0111 * x
                    - 491.21516848186525 * H1 * x + 54.454036620285585 * H10 * x
                    - 32. * H100 * x - 10.666666666666666 * H1000 * x
                    + 21.333333333333332 * H1010 * x
                    - 102.35771431740517 * H11 * x
                    + 21.333333333333332 * H1101 * x
                    - 10.666666666666666 * H111 * x
                    - 10.666666666666666 * H1111 * x + 261.4199826326819 * x2
                    + 145.2540032771549 * H0 * x2 - 55.57473990723783 * H00 * x2
                    + 26.666666666666664 * H000 * x2
                    + 10.666666666666666 * H0000 * x2
                    - 21.333333333333332 * H0010 * x2
                    + 41.02438098407184 * H01 * x2
                    - 21.333333333333332 * H0101 * x2 + 16. * H011 * x2
                    + 10.666666666666666 * H0111 * x2
                    + 241.881835148532 * H1 * x2 - 25.12070328695225 * H10 * x2
                    + 26.666666666666664 * H100 * x2
                    + 10.666666666666666 * H1000 * x2
                    - 21.333333333333332 * H1010 * x2
                    + 89.02438098407184 * H11 * x2
                    - 21.333333333333332 * H1101 * x2 + 16. * H111 * x2
                    + 10.666666666666666 * H1111 * x2)
           + 1.7777777777777777
                 * (-93.82398146955963 - 116.1064435423863 * H0
                    + 17.78567671429168 * H00 - 19.869604401089358 * H000
                    - 12. * H0000 + 8. * H00000 + 12. * H00001 + 12. * H0001
                    - 8. * H00010 + 74.8555165456794 * H001 + 12. * H0010
                    - 24. * H00100 - 48. * H00101 + 24. * H0011 - 32. * H00110
                    - 24. * H00111 + 100.20833282411357 * H01
                    + 168.49340668482265 * H010 - 20. * H0100 - 16. * H01000
                    - 72. * H01001 - 28. * H0101 - 96. * H01010 - 120. * H01011
                    + 324.87050562614456 * H011 - 36. * H0110 - 40. * H01100
                    - 104. * H01101 - 44. * H0111 - 56. * H01110 - 56. * H01111
                    - 13.15947253478581 * H0m10 - 305.275895637443 * H1
                    - 109.34711126183375 * H10 + 1.681054930428381 * H100
                    + 48. * H1000 + 32. * H10000 + 32. * H10001 + 60. * H1001
                    - 16. * H10010 + 211.39208802178717 * H101 + 24. * H1010
                    - 16. * H10100 - 80. * H10101 + 12. * H1011 - 48. * H10110
                    - 48. * H10111 + 141.5890298498155 * H11
                    + 132.43525281307228 * H110 + 60. * H1100 + 32. * H11000
                    - 32. * H11001 + 4. * H1101 - 80. * H11010 - 112. * H11011
                    + 387.18945069571623 * H111 + 12. * H1110 - 112. * H11101
                    - 76. * H1111 - 48. * H11110 - 80. * H11111
                    + 21.64646467422276 * Hm1 - 26.31894506957162 * Hm10
                    - 13.15947253478581 * Hm100 + 26.31894506957162 * Hm1m10
                    + 683.7952626281278 * x - 12.180289774840958 * H0 * x
                    - 10.165177551386222 * H00 * x
                    + 42.05815387175034 * H000 * x - 64. * H0000 * x
                    - 16. * H00000 * x - 24. * H00001 * x - 52. * H0001 * x
                    + 16. * H00010 * x - 233.7110330913588 * H001 * x
                    - 48. * H0010 * x + 48. * H00100 * x + 96. * H00101 * x
                    + 32. * H0011 * x + 64. * H00110 * x + 48. * H00111 * x
                    - 587.5911272634781 * H01 * x - 312.9868133696453 * H010 * x
                    - 32. * H0100 * x + 32. * H01000 * x + 144. * H01001 * x
                    + 120. * H0101 * x + 192. * H01010 * x + 240. * H01011 * x
                    - 505.7410112522892 * H011 * x + 120. * H0110 * x
                    + 80. * H01100 * x + 208. * H01101 * x + 208. * H0111 * x
                    + 112. * H01110 * x + 112. * H01111 * x
                    - 26.31894506957162 * H0m10 * x
                    - 101.05610166621125 * H1 * x + 105.39026653456105 * H10 * x
                    + 124.63789013914324 * H100 * x - 272. * H1000 * x
                    - 64. * H10000 * x - 64. * H10001 * x - 224. * H1001 * x
                    + 32. * H10010 * x - 222.78417604357435 * H101 * x
                    - 128. * H1010 * x + 32. * H10100 * x + 160. * H10101 * x
                    + 32. * H1011 * x + 96. * H10110 * x + 96. * H10111 * x
                    - 482.0485653257756 * H11 * x - 64.87050562614459 * H110 * x
                    - 224. * H1100 * x - 64. * H11000 * x + 64. * H11001 * x
                    + 64. * H1101 * x + 160. * H11010 * x + 224. * H11011 * x
                    - 414.37890139143246 * H111 * x + 32. * H1110 * x
                    + 224. * H11101 * x + 304. * H1111 * x + 96. * H11110 * x
                    + 160. * H11111 * x + 43.29292934844552 * Hm1 * x
                    - 65.79736267392906 * Hm10 * x
                    - 26.31894506957162 * Hm100 * x
                    + 52.63789013914324 * Hm1m10 * x - 1088.996105267532 * x2
                    + 11.785643011985286 * H0 * x2
                    + 71.88551374372543 * H00 * x2
                    - 98.31894506957161 * H000 * x2 + 208. * H0000 * x2
                    + 64. * H00000 * x2 + 64. * H00001 * x2 + 160. * H0001 * x2
                    - 32. * H00010 * x2 + 218.78417604357435 * H001 * x2
                    + 112. * H0010 * x2 - 32. * H00100 * x2 - 160. * H00101 * x2
                    - 64. * H0011 * x2 - 96. * H00110 * x2 - 96. * H00111 * x2
                    + 469.72962025620393 * H01 * x2
                    + 60.87050562614459 * H010 * x2 + 160. * H0100 * x2
                    + 64. * H01000 * x2 - 64. * H01001 * x2 - 64. * H0101 * x2
                    - 160. * H01010 * x2 - 224. * H01011 * x2
                    + 278.37890139143246 * H011 * x2 - 64. * H0110 * x2
                    - 224. * H01101 * x2 - 288. * H0111 * x2 - 96. * H01110 * x2
                    - 160. * H01111 * x2 - 52.63789013914324 * H0m10 * x2
                    + 55.07857236043074 * H1 * x2 + 32.40709613936801 * H10 * x2
                    - 124.63789013914324 * H100 * x2 + 208. * H1000 * x2
                    + 64. * H10000 * x2 + 64. * H10001 * x2 + 160. * H1001 * x2
                    - 32. * H10010 * x2 + 218.78417604357435 * H101 * x2
                    + 112. * H1010 * x2 - 32. * H10100 * x2 - 160. * H10101 * x2
                    - 64. * H1011 * x2 - 96. * H10110 * x2 - 96. * H10111 * x2
                    + 469.72962025620393 * H11 * x2
                    + 60.87050562614459 * H110 * x2 + 160. * H1100 * x2
                    + 64. * H11000 * x2 - 64. * H11001 * x2 - 64. * H1101 * x2
                    - 160. * H11010 * x2 - 224. * H11011 * x2
                    + 278.37890139143246 * H111 * x2 - 64. * H1110 * x2
                    - 224. * H11101 * x2 - 288. * H1111 * x2 - 96. * H11110 * x2
                    - 160. * H11111 * x2 + 43.29292934844552 * Hm1 * x2
                    - 39.47841760435743 * Hm10 * x2
                    - 26.31894506957162 * Hm100 * x2
                    + 52.63789013914324 * Hm1m10 * x2)
           + 3.
                 * (-104.37169820336848 + 80.39719946147588 * H0
                    - 53.66513472810464 * H00 + 2.6666666666666665 * H000
                    - 5.333333333333333 * H0000 + 2.6666666666666665 * H0001
                    + 8.444444444444445 * H001 + 10.666666666666666 * H0010
                    - 0.8888888888888888 * H01 - 5.333333333333333 * H010
                    + 10.666666666666666 * H0100 + 0.6489410008900309 * H1
                    + 21.62962962962963 * H10 + 8. * H100
                    + 10.666666666666666 * H1010 + 5.333333333333333 * H1011
                    - 1.0403011863955811 * H11 - 5.333333333333333 * H1100
                    + 10.666666666666666 * H1101 + 2.6666666666666665 * H111
                    + 10.666666666666666 * H1110 - 5.333333333333333 * H1111
                    + 19.232910450553508 * Hm1 - 10.966227112321507 * Hm10
                    + 5.333333333333333 * Hm1000 + 10.666666666666666 * Hm1010
                    - 17.545963379714415 * Hm1m1 + 10.666666666666666 * Hm1m100
                    - 21.333333333333332 * Hm1m1m10 + 82.88298556959812 / x
                    - (15.506172839506172 * H1) / x
                    - (11.851851851851851 * H10) / x
                    + (7.111111111111111 * H100) / x + 311.1515001263101 * x
                    + 110.81625567198459 * H0 * x - 92.0901945486323 * H00 * x
                    - 5.333333333333333 * H000 * x
                    - 10.666666666666666 * H0000 * x
                    - 5.333333333333333 * H0001 * x
                    - 24.888888888888886 * H001 * x
                    + 21.333333333333332 * H0010 * x
                    - 93.77777777777777 * H01 * x - 45.33333333333333 * H010 * x
                    + 42.666666666666664 * H0100 * x - 8. * H011 * x
                    - 143.95802036972964 * H1 * x - 169.92592592592592 * H10 * x
                    + 42.666666666666664 * H100 * x
                    - 10.666666666666666 * H101 * x
                    - 21.333333333333332 * H1010 * x
                    - 10.666666666666666 * H1011 * x
                    + 0.7472690394578301 * H11 * x
                    - 10.666666666666666 * H110 * x
                    + 10.666666666666666 * H1100 * x
                    - 21.333333333333332 * H1101 * x
                    + 10.666666666666666 * H111 * x
                    - 21.333333333333332 * H1110 * x
                    + 10.666666666666666 * H1111 * x
                    + 56.01178428082143 * Hm1 * x - 53.93245422464301 * Hm10 * x
                    - 10.666666666666666 * Hm100 * x
                    + 10.666666666666666 * Hm1000 * x
                    + 21.333333333333332 * Hm1010 * x
                    - 35.09192675942883 * Hm1m1 * x
                    + 21.333333333333332 * Hm1m10 * x
                    + 21.333333333333332 * Hm1m100 * x
                    - 42.666666666666664 * Hm1m1m10 * x
                    - 490.15880433479214 * x2 + 501.97033569492487 * H0 * x2
                    - 121.77777777777777 * H00 * x2
                    + 20.444444444444443 * H000 * x2 - 32. * H01 * x2
                    - 78.22222222222221 * H010 * x2
                    - 2.6666666666666665 * H011 * x2
                    + 142.50123024627283 * H1 * x2
                    + 167.11111111111111 * H10 * x2
                    - 57.77777777777777 * H100 * x2
                    + 10.666666666666666 * H101 * x2
                    + 21.333333333333332 * H1010 * x2
                    + 10.666666666666666 * H1011 * x2
                    + 8.586064293875502 * H11 * x2
                    + 10.666666666666666 * H110 * x2
                    - 10.666666666666666 * H1100 * x2
                    + 21.333333333333332 * H1101 * x2
                    - 13.333333333333332 * H111 * x2
                    + 21.333333333333332 * H1110 * x2
                    - 10.666666666666666 * H1111 * x2
                    + 56.01178428082143 * Hm1 * x2
                    - 53.93245422464301 * Hm10 * x2
                    - 10.666666666666666 * Hm100 * x2
                    + 10.666666666666666 * Hm1000 * x2
                    + 21.333333333333332 * Hm1010 * x2
                    - 35.09192675942883 * Hm1m1 * x2
                    + 21.333333333333332 * Hm1m10 * x2
                    + 21.333333333333332 * Hm1m100 * x2
                    - 42.666666666666664 * Hm1m1m10 * x2)
           + 3. * nf
                 * (0.528934360407554 + 12.712569253743945 * H0
                    + 4.246913580246913 * H00 + 2.3703703703703702 * H000
                    - 1.7777777777777777 * H0000 + 0.8888888888888888 * H01
                    - 8.88888888888889 * H010 - 10.666666666666666 * H0100
                    - 17.143100837653762 * H1 + 1.9066080594206456 * H10
                    - 9.481481481481481 * H100 - 2.6666666666666665 * H1000
                    + 1.7777777777777777 * H1001 + 5.925925925925926 * H101
                    - 4.444444444444445 * H1010 - 4.444444444444445 * H1011
                    + 13.730571161300759 * H11 + 2.962962962962963 * H110
                    + 6.222222222222221 * H1100 - 7.111111111111111 * H1101
                    - 8.592592592592592 * H111 - 0.8888888888888888 * H1110
                    + 4.444444444444445 * H1111 + 0.8998479246965037 * Hm1
                    + 9.917355042459468 * Hm10 - 1.4814814814814814 * Hm100
                    - 6.222222222222221 * Hm1000 - 5.333333333333333 * Hm1010
                    + 5.333333333333333 * Hm10m10 + 4.386490844928604 * Hm1m1
                    + 8.88888888888889 * Hm1m10 + 2.6666666666666665 * Hm1m100
                    + 5.333333333333333 * Hm1m1m10 + 10.186980325541231 / x
                    + (0.5925925925925926 * H1) / x
                    - (7.703703703703703 * H10) / x
                    - (7.111111111111111 * H100) / x - 29.662659823597878 * x
                    - 31.74612616180888 * H0 * x + 22.814814814814813 * H00 * x
                    + 13.185185185185185 * H000 * x
                    + 21.333333333333332 * H0000 * x
                    + 3.5555555555555554 * H001 * x
                    - 21.333333333333332 * H0010 * x
                    + 6.814814814814815 * H01 * x - 37.33333333333333 * H010 * x
                    - 42.666666666666664 * H0100 * x
                    + 0.4444444444444444 * H011 * x
                    + 3.5555555555555554 * H0m10 * x
                    + 52.63507807960025 * H1 * x - 27.368771674396847 * H10 * x
                    - 43.25925925925926 * H100 * x
                    + 5.333333333333333 * H1000 * x
                    - 3.5555555555555554 * H1001 * x
                    - 2.962962962962963 * H101 * x
                    + 8.88888888888889 * H1010 * x
                    + 8.88888888888889 * H1011 * x
                    - 14.275957137416333 * H11 * x
                    - 4.148148148148148 * H110 * x
                    - 12.444444444444443 * H1100 * x
                    + 14.222222222222221 * H1101 * x
                    + 2.962962962962963 * H111 * x
                    + 1.7777777777777777 * H1110 * x
                    - 8.88888888888889 * H1111 * x - 6.973285840464199 * Hm1 * x
                    + 31.982858233067084 * Hm10 * x
                    - 4.7407407407407405 * Hm100 * x
                    - 12.444444444444443 * Hm1000 * x
                    - 10.666666666666666 * Hm1010 * x
                    + 10.666666666666666 * Hm10m10 * x
                    + 8.772981689857207 * Hm1m1 * x
                    + 7.111111111111111 * Hm1m10 * x
                    + 5.333333333333333 * Hm1m100 * x
                    + 10.666666666666666 * Hm1m1m10 * x
                    - 10.079621043914656 * x2 - 103.4310774730574 * H0 * x2
                    + 56.641975308641975 * H00 * x2
                    + 13.037037037037036 * H000 * x2 + 8. * H001 * x2
                    - 1.7777777777777777 * H01 * x2 + 8. * H010 * x2
                    + 10.666666666666666 * H011 * x2 - 16. * H0m10 * x2
                    - 52.33878178330395 * H1 * x2 + 35.07247537810055 * H10 * x2
                    + 58.37037037037037 * H100 * x2
                    - 5.333333333333333 * H1000 * x2
                    + 3.5555555555555554 * H1001 * x2
                    + 2.962962962962963 * H101 * x2
                    - 8.88888888888889 * H1010 * x2
                    - 8.88888888888889 * H1011 * x2
                    + 10.275957137416333 * H11 * x2
                    + 4.148148148148148 * H110 * x2
                    + 12.444444444444443 * H1100 * x2
                    - 14.222222222222221 * H1101 * x2
                    - 0.2962962962962963 * H111 * x2
                    - 1.7777777777777777 * H1110 * x2
                    + 8.88888888888889 * H1111 * x2
                    - 6.973285840464199 * Hm1 * x2
                    + 31.093969344178195 * Hm10 * x2
                    - 4.7407407407407405 * Hm100 * x2
                    - 12.444444444444443 * Hm1000 * x2
                    - 10.666666666666666 * Hm1010 * x2
                    + 10.666666666666666 * Hm10m10 * x2
                    + 8.772981689857207 * Hm1m1 * x2
                    + 7.111111111111111 * Hm1m10 * x2
                    + 5.333333333333333 * Hm1m100 * x2
                    + 10.666666666666666 * Hm1m1m10 * x2)
           + 9.
                 * (1226.276196457856 - 843.267093429962 * H0
                    + 170.31763559642278 * H00 - 89.13069600726239 * H000
                    + 30.666666666666664 * H0000 - 16. * H00000 + 16. * H00001
                    - 8. * H0001 + 32. * H00010 + 129.449641076834 * H001
                    - 61.33333333333333 * H0010 - 32. * H00101 - 32. * H00110
                    - 28.875910234393253 * H01 + 192.46402934059572 * H010
                    - 5.333333333333333 * H0100 - 32. * H01000 - 32. * H01001
                    + 16. * H0101 + 32. * H01010 + 16. * H01011
                    - 44.98561173623828 * H011 + 16. * H0110 - 48. * H01100
                    + 32. * H01101 + 8. * H0111 + 32. * H01110 - 16. * H01111
                    + 57.69873135166053 * H0m1 - 39.47841760435743 * H0m10
                    + 16. * H0m1000 + 32. * H0m1010 - 52.63789013914324 * H0m1m1
                    + 32. * H0m1m100 - 64. * H0m1m1m10 - 89.36819164686227 * H1
                    - 219.3300302125055 * H10 + 99.4202637326071 * H100
                    - 24. * H1000 - 24. * H1001 - 32. * H10010 - 16. * H10011
                    + 62.782974410167355 * H101 - 13.333333333333332 * H1010
                    - 16. * H10100 - 80. * H10101 - 14.666666666666666 * H1011
                    - 80. * H10110 - 32. * H10111 - 56.328023416402324 * H11
                    - 42.49280586811914 * H110 - 17.333333333333332 * H1100
                    + 16. * H11000 - 16. * H11001 - 21.333333333333332 * H1101
                    - 96. * H11010 - 64. * H11011 + 55.971223472476574 * H111
                    - 21.333333333333332 * H1110 - 80. * H11101
                    - 25.333333333333332 * H1111 - 80. * H11110 + 80. * H11111
                    - 108.23355865232446 * Hm1 - 78.52377450062286 * Hm10
                    + 48.550959739869484 * Hm100 - 6.666666666666666 * Hm1000
                    - 16. * Hm10000 - 16. * Hm10001 - 32. * Hm10010
                    + 78.95683520871486 * Hm101 - 13.333333333333332 * Hm1010
                    - 32. * Hm10100 - 32. * Hm10101 - 32. * Hm10110
                    + 52.63789013914324 * Hm10m1 - 32. * Hm10m100
                    + 64. * Hm10m1m10 + 214.26155873017808 * Hm1m1
                    + 87.13069600726239 * Hm1m10 - 13.333333333333332 * Hm1m100
                    - 16. * Hm1m1000 - 32. * Hm1m1001 + 32. * Hm1m1010
                    + 64. * Hm1m10m10 - 263.18945069571623 * Hm1m1m1
                    + 26.666666666666664 * Hm1m1m10 + 128. * Hm1m1m100
                    + 64. * Hm1m1m101 - 192. * Hm1m1m1m10
                    - 531.2093604575047 / x - (98.30737585643715 * H0) / x
                    + (8.772981689857207 * H01) / x
                    + (35.55555555555556 * H010) / x
                    - (21.333333333333332 * H0100) / x
                    - (154.23961622334866 * H1) / x
                    + (249.49453807891564 * H10) / x
                    - (68.44444444444444 * H100) / x
                    - (21.333333333333332 * H1000) / x
                    - (21.333333333333332 * H1001) / x
                    + (53.33333333333333 * H101) / x
                    + (21.333333333333332 * H1010) / x
                    + (10.666666666666666 * H1011) / x
                    - (27.47188930564034 * H11) / x
                    + (53.33333333333333 * H110) / x - (32. * H1100) / x
                    + (21.333333333333332 * H1101) / x
                    - (0.8888888888888888 * H111) / x
                    + (21.333333333333332 * H1110) / x
                    - (10.666666666666666 * H1111) / x
                    - (67.70909320063103 * Hm1) / x
                    + (54.170796921423474 * Hm10) / x
                    + (17.77777777777778 * Hm100) / x
                    - (10.666666666666666 * Hm1000) / x
                    - (21.333333333333332 * Hm1010) / x
                    + (35.09192675942883 * Hm1m1) / x
                    - (35.55555555555556 * Hm1m10) / x
                    - (21.333333333333332 * Hm1m100) / x
                    + (42.666666666666664 * Hm1m1m10) / x
                    - 3811.509065571984 * x - 2097.3187552246136 * H0 * x
                    - 890.9487744677209 * H00 * x + 97.27578027828648 * H000 * x
                    - 34.666666666666664 * H0000 * x + 64. * H00000 * x
                    + 32. * H00001 * x - 32. * H0001 * x - 128. * H00010 * x
                    + 245.2182272232396 * H001 * x
                    + 101.33333333333333 * H0010 * x - 320. * H00100 * x
                    - 64. * H00101 * x - 16. * H0011 * x - 64. * H00110 * x
                    - 248.20028576517012 * H01 * x
                    + 1175.1894506957162 * H010 * x
                    - 293.3333333333333 * H0100 * x - 128. * H01000 * x
                    - 128. * H01001 * x + 160. * H0101 * x + 128. * H01010 * x
                    + 64. * H01011 * x - 230.60911361161982 * H011 * x
                    + 160. * H0110 * x - 192. * H01100 * x + 128. * H01101 * x
                    - 48. * H0111 * x + 128. * H01110 * x - 64. * H01111 * x
                    - 283.43281554578533 * H0m1 * x
                    + 349.9136704174297 * H0m10 * x + 32. * H0m100 * x
                    - 64. * H0m1000 * x - 128. * H0m1010 * x
                    + 210.55156055657295 * H0m1m1 * x - 64. * H0m1m10 * x
                    - 128. * H0m1m100 * x + 256. * H0m1m1m10 * x
                    - 1585.6722017988009 * H1 * x + 2694.661262058418 * H10 * x
                    - 384.1738607985475 * H100 * x - 128. * H1000 * x
                    - 96. * H1001 * x + 64. * H10010 * x + 32. * H10011 * x
                    + 426.4340511796653 * H101 * x
                    + 250.66666666666666 * H1010 * x + 32. * H10100 * x
                    + 160. * H10101 * x + 125.33333333333333 * H1011 * x
                    + 160. * H10110 * x + 64. * H10111 * x
                    - 269.7020680290695 * H11 * x + 636.9856117362383 * H110 * x
                    - 189.33333333333331 * H1100 * x - 32. * H11000 * x
                    + 32. * H11001 * x + 218.66666666666666 * H1101 * x
                    + 192. * H11010 * x + 128. * H11011 * x
                    - 425.27578027828645 * H111 * x
                    + 218.66666666666666 * H1110 * x + 160. * H11101 * x
                    - 221.33333333333331 * H1111 * x + 160. * H11110 * x
                    - 160. * H11111 * x - 1231.7674112821876 * Hm1 * x
                    + 675.5132031866995 * Hm10 * x
                    + 409.1019194797389 * Hm100 * x
                    - 61.33333333333333 * Hm1000 * x - 32. * Hm10000 * x
                    - 32. * Hm10001 * x + 32. * Hm1001 * x - 64. * Hm10010 * x
                    + 253.91367041742973 * Hm101 * x
                    - 186.66666666666666 * Hm1010 * x - 64. * Hm10100 * x
                    - 64. * Hm10101 * x - 64. * Hm10110 * x
                    + 105.27578027828648 * Hm10m1 * x - 64. * Hm10m10 * x
                    - 64. * Hm10m100 * x + 128. * Hm10m1m10 * x
                    + 902.2641287126453 * Hm1m1 * x
                    - 353.7386079854752 * Hm1m10 * x
                    - 282.66666666666663 * Hm1m100 * x - 32. * Hm1m1000 * x
                    - 64. * Hm1m1001 * x - 64. * Hm1m101 * x
                    + 64. * Hm1m1010 * x + 128. * Hm1m10m10 * x
                    - 526.3789013914325 * Hm1m1m1 * x
                    + 501.3333333333333 * Hm1m1m10 * x + 256. * Hm1m1m100 * x
                    + 128. * Hm1m1m101 * x - 384. * Hm1m1m1m10 * x
                    + 14624.667121952376 * x2 - 6650.37256976657 * H0 * x2
                    + 430.4124037675624 * H00 * x2 + 150. * H000 * x2
                    + 24. * H0000 * x2 - 61.33333333333333 * H0001 * x2
                    + 243.55555555555554 * H001 * x2 - 24. * H0011 * x2
                    - 1527.4000182261457 * H01 * x2
                    + 693.3333333333333 * H010 * x2
                    + 258.66666666666663 * H0100 * x2
                    + 194.66666666666666 * H0101 * x2
                    + 118.44444444444444 * H011 * x2
                    + 194.66666666666666 * H0110 * x2 + 48. * H0111 * x2
                    - 78.95683520871486 * H0m1 * x2 + 32. * H0m10 * x2
                    + 48. * H0m100 * x2 - 96. * H0m1m10 * x2
                    + 1509.1374788429193 * H1 * x2
                    - 2740.8806206757504 * H10 * x2
                    + 346.61830524299194 * H100 * x2
                    + 173.33333333333331 * H1000 * x2
                    + 141.33333333333331 * H1001 * x2 - 64. * H10010 * x2
                    - 32. * H10011 * x2 - 458.4340511796653 * H101 * x2
                    - 288. * H1010 * x2 - 32. * H10100 * x2 - 160. * H10101 * x2
                    - 136. * H1011 * x2 - 160. * H10110 * x2 - 64. * H10111 * x2
                    + 318.95173511248765 * H11 * x2
                    - 668.9856117362383 * H110 * x2
                    + 253.33333333333331 * H1100 * x2 + 32. * H11000 * x2
                    - 32. * H11001 * x2 - 248. * H1101 * x2 - 192. * H11010 * x2
                    - 128. * H11011 * x2 + 398.831335833842 * H111 * x2
                    - 248. * H1110 * x2 - 160. * H11101 * x2 + 272. * H1111 * x2
                    - 160. * H11110 * x2 + 160. * H11111 * x2
                    - 1345.8718335383633 * Hm1 * x2
                    + 793.867653354746 * Hm10 * x2
                    + 437.54636392418337 * Hm100 * x2 - 80. * Hm1000 * x2
                    - 32. * Hm10000 * x2 - 32. * Hm10001 * x2
                    + 32. * Hm1001 * x2 - 64. * Hm10010 * x2
                    + 253.91367041742973 * Hm101 * x2 - 224. * Hm1010 * x2
                    - 64. * Hm10100 * x2 - 64. * Hm10101 * x2
                    - 64. * Hm10110 * x2 + 105.27578027828648 * Hm10m1 * x2
                    - 64. * Hm10m10 * x2 - 64. * Hm10m100 * x2
                    + 128. * Hm10m1m10 * x2 + 963.6750005416459 * Hm1m1 * x2
                    - 410.62749687436406 * Hm1m10 * x2 - 320. * Hm1m100 * x2
                    - 32. * Hm1m1000 * x2 - 64. * Hm1m1001 * x2
                    - 64. * Hm1m101 * x2 + 64. * Hm1m1010 * x2
                    + 128. * Hm1m10m10 * x2 - 526.3789013914325 * Hm1m1m1 * x2
                    + 576. * Hm1m1m10 * x2 + 256. * Hm1m1m100 * x2
                    + 128. * Hm1m1m101 * x2 - 384. * Hm1m1m1m10 * x2)
           + 4.
                 * (65.08401931899307 - 362.0738181896769 * H0
                    + 52.53251348258827 * H00 - 73.02877652752342 * H000
                    + 8.666666666666666 * H0000 - 8. * H00000 - 32. * H00001
                    - 4. * H0001 - 16. * H00011 - 54.46402934059573 * H001
                    - 21.333333333333332 * H0010 + 64. * H00100 + 24. * H00101
                    - 12. * H0011 + 56. * H00110 + 24. * H00111
                    - 13.15947253478581 * H00m1 + 8. * H00m100 - 16. * H00m1m10
                    - 316.3607274433135 * H01 - 215.5659488203347 * H010
                    + 94.66666666666666 * H0100 + 96. * H01000 + 104. * H01001
                    + 121.33333333333333 * H0101 + 64. * H01010 + 80. * H01011
                    - 153.62350187538152 * H011 + 76. * H0110 + 64. * H01100
                    + 24. * H01101 - 2.6666666666666665 * H0111 + 24. * H01110
                    - 24. * H01111 + 1.7715086547545278 * H0m1
                    - 16.89868133696453 * H0m10 - 4. * H0m100 + 16. * H0m1000
                    + 8. * H0m1001 + 16. * H0m1010 - 16. * H0m10m10
                    + 26.31894506957162 * H0m1m1 + 8. * H0m1m10 - 8. * H0m1m100
                    - 16. * H0m1m101 - 8.044798703208471 * H1
                    - 62.359978028013586 * H10 + 288.5797362673929 * H100
                    + 33.33333333333333 * H1000 - 16. * H10000 - 32. * H10001
                    + 4. * H1001 + 32. * H10010 - 104.87050562614459 * H101
                    + 5.333333333333333 * H1010 + 16. * H10100 + 96. * H10101
                    + 64. * H10110 + 32. * H10111 - 268.57659355481945 * H11
                    + 3.071941318808541 * H110 - 48. * H11000 + 32. * H11001
                    + 17.333333333333332 * H1101 + 112. * H11010 + 128. * H11011
                    - 411.82734083485946 * H111 + 4. * H1110 - 16. * H11100
                    + 144. * H11101 + 149.33333333333331 * H1111 + 80. * H11110
                    - 65.18542904425881 * Hm1 - 179.15302670138453 * Hm10
                    - 70.69604401089359 * Hm100 + 32. * Hm1000 + 32. * Hm10000
                    + 32. * Hm10001 + 28. * Hm1001 + 48. * Hm10010
                    + 16. * Hm10011 - 32. * Hm100m10
                    - 62.956835208714864 * Hm101 + 8. * Hm1010 + 32. * Hm10100
                    + 32. * Hm10101 + 32. * Hm10110 + 52.63789013914324 * Hm10m1
                    - 56. * Hm10m10 - 16. * Hm10m100 - 32. * Hm10m101
                    + 103.75795637527825 * Hm1m1 - 0.521582395642568 * Hm1m10
                    - 76. * Hm1m100 - 32. * Hm1m1000 - 16. * Hm1m1001
                    - 56. * Hm1m101 - 64. * Hm1m1010 - 32. * Hm1m1011
                    + 78.95683520871486 * Hm1m1m1 + 96. * Hm1m1m10
                    - 48. * Hm1m1m100 + 96. * Hm1m1m1m10
                    - 117.57514045170683 / x + (18.23537034809196 * H1) / x
                    + (2.1769246756715717 * H10) / x
                    - (8.88888888888889 * H100) / x
                    + (53.33333333333333 * H1000) / x
                    + (42.666666666666664 * H1001) / x
                    - (3.5555555555555554 * H101) / x
                    + (21.333333333333332 * H1010) / x
                    + (21.333333333333332 * H1011) / x
                    + (7.027444861195898 * H11) / x
                    - (3.5555555555555554 * H110) / x
                    + (42.666666666666664 * H1100) / x - (16. * H111) / x
                    + (21.333333333333332 * H1110) / x
                    + (10.666666666666666 * H1111) / x - 3783.5953211405936 * x
                    - 315.6427297226099 * H0 * x - 190.42527324118637 * H00 * x
                    - 128.8693039927376 * H000 * x
                    + 118.66666666666666 * H0000 * x - 32. * H00001 * x
                    + 56. * H0001 * x - 32. * H00011 * x
                    + 390.26139201452474 * H001 * x
                    + 82.66666666666666 * H0010 * x + 96. * H00100 * x
                    - 16. * H00101 * x + 208. * H0011 * x + 112. * H00110 * x
                    + 48. * H00111 * x - 26.31894506957162 * H00m1 * x
                    + 32. * H00m10 * x + 16. * H00m100 * x - 32. * H00m1m10 * x
                    + 270.6151625304185 * H01 * x - 586.6091136116198 * H010 * x
                    + 322.66666666666663 * H0100 * x + 288. * H01000 * x
                    + 176. * H01001 * x + 149.33333333333331 * H0101 * x
                    + 64. * H01010 * x + 32. * H01011 * x
                    + 901.1606741681927 * H011 * x + 208. * H0110 * x
                    + 256. * H01100 * x - 48. * H01101 * x
                    + 301.3333333333333 * H0111 * x + 144. * H01110 * x
                    + 144. * H01111 * x - 88.57329043399162 * H0m1 * x
                    - 9.797362673929058 * H0m10 * x + 32. * H0m100 * x
                    + 32. * H0m1000 * x + 16. * H0m1001 * x + 32. * H0m101 * x
                    + 32. * H0m1010 * x - 32. * H0m10m10 * x
                    + 52.63789013914324 * H0m1m1 * x - 32. * H0m1m10 * x
                    - 16. * H0m1m100 * x - 32. * H0m1m101 * x
                    + 1203.6023937436116 * H1 * x - 1377.5230526957532 * H10 * x
                    - 322.49280586811915 * H100 * x
                    + 445.3333333333333 * H1000 * x + 32. * H10000 * x
                    + 64. * H10001 * x + 352. * H1001 * x - 64. * H10010 * x
                    - 38.258988747710816 * H101 * x
                    + 69.33333333333333 * H1010 * x - 32. * H10100 * x
                    - 192. * H10101 * x + 80. * H1011 * x - 128. * H10110 * x
                    - 64. * H10111 * x + 855.5896415561182 * H11 * x
                    - 211.4772159709504 * H110 * x + 368. * H1100 * x
                    + 96. * H11000 * x - 64. * H11001 * x
                    - 122.66666666666666 * H1101 * x - 224. * H11010 * x
                    - 256. * H11011 * x + 1007.6546816697189 * H111 * x
                    + 64. * H1110 * x + 32. * H11100 * x - 288. * H11101 * x
                    - 82.66666666666666 * H1111 * x - 160. * H11110 * x
                    + 53.608072646737384 * Hm1 * x
                    - 356.88578967016196 * Hm10 * x
                    - 197.39208802178717 * Hm100 * x + 80. * Hm1000 * x
                    + 64. * Hm10000 * x + 64. * Hm10001 * x + 64. * Hm1001 * x
                    + 96. * Hm10010 * x + 32. * Hm10011 * x - 64. * Hm100m10 * x
                    - 149.91367041742973 * Hm101 * x + 64. * Hm1010 * x
                    + 64. * Hm10100 * x + 64. * Hm10101 * x + 32. * Hm1011 * x
                    + 64. * Hm10110 * x + 105.27578027828648 * Hm10m1 * x
                    - 96. * Hm10m10 * x - 32. * Hm10m100 * x
                    - 64. * Hm10m101 * x + 102.24013247227003 * Hm1m1 * x
                    + 86.95683520871486 * Hm1m10 * x - 96. * Hm1m100 * x
                    - 64. * Hm1m1000 * x - 32. * Hm1m1001 * x
                    - 96. * Hm1m101 * x - 128. * Hm1m1010 * x
                    - 64. * Hm1m1011 * x + 157.91367041742973 * Hm1m1m1 * x
                    + 96. * Hm1m1m10 * x - 96. * Hm1m1m100 * x
                    + 192. * Hm1m1m1m10 * x + 644.9670683160705 * x2
                    - 390.08988335352 * H0 * x2 + 1148.5041896044715 * H00 * x2
                    - 794.4732209719679 * H000 * x2
                    + 10.666666666666666 * H0000 * x2 - 32. * H00001 * x2
                    + 50.666666666666664 * H0001 * x2
                    - 573.0247815285409 * H001 * x2
                    - 114.66666666666666 * H0010 * x2 + 64. * H00100 * x2
                    + 32. * H00101 * x2 + 109.33333333333333 * H0011 * x2
                    + 32. * H00110 * x2 + 32. * H00111 * x2
                    - 52.63789013914324 * H00m1 * x2 + 32. * H00m10 * x2
                    + 32. * H00m100 * x2 - 64. * H00m1m10 * x2
                    + 392.52488914633676 * H01 * x2
                    - 477.9136704174297 * H010 * x2
                    - 573.3333333333333 * H0100 * x2 + 32. * H01001 * x2
                    - 200. * H0101 * x2 + 64. * H01010 * x2 + 96. * H01011 * x2
                    - 1014.7450062512718 * H011 * x2 - 424. * H0110 * x2
                    - 64. * H01100 * x2 + 64. * H01101 * x2 - 128. * H0111 * x2
                    - 32. * H01111 * x2 - 124.50869072883998 * H0m1 * x2
                    - 139.59472534785812 * H0m10 * x2 + 48. * H0m100 * x2
                    + 64. * H0m1000 * x2 + 32. * H0m1001 * x2
                    + 32. * H0m101 * x2 + 64. * H0m1010 * x2
                    - 64. * H0m10m10 * x2 + 105.27578027828648 * H0m1m1 * x2
                    - 64. * H0m1m10 * x2 - 32. * H0m1m100 * x2
                    - 64. * H0m1m101 * x2 - 526.2270324463396 * H1 * x2
                    + 1476.109517534098 * H10 * x2
                    + 40.71502809034136 * H100 * x2
                    - 538.6666666666666 * H1000 * x2 - 32. * H10000 * x2
                    - 64. * H10001 * x2 - 402.66666666666663 * H1001 * x2
                    + 64. * H10010 * x2 - 110.18545569673364 * H101 * x2
                    - 114.66666666666666 * H1010 * x2 + 32. * H10100 * x2
                    + 192. * H10101 * x2 - 125.33333333333333 * H1011 * x2
                    + 128. * H10110 * x2 + 64. * H10111 * x2
                    - 766.6458629448373 * H11 * x2
                    + 60.36610485983931 * H110 * x2
                    - 402.66666666666663 * H1100 * x2 - 96. * H11000 * x2
                    + 64. * H11001 * x2 + 98.66666666666666 * H1101 * x2
                    + 224. * H11010 * x2 + 256. * H11011 * x2
                    - 859.6546816697189 * H111 * x2
                    - 125.33333333333333 * H1110 * x2 - 32. * H11100 * x2
                    + 288. * H11101 * x2 - 32. * H1111 * x2 + 160. * H11110 * x2
                    + 102.70294547637158 * Hm1 * x2
                    - 271.0884269962329 * Hm10 * x2
                    - 213.39208802178717 * Hm100 * x2 + 48. * Hm1000 * x2
                    + 64. * Hm10000 * x2 + 64. * Hm10001 * x2
                    + 48. * Hm1001 * x2 + 96. * Hm10010 * x2
                    + 32. * Hm10011 * x2 - 64. * Hm100m10 * x2
                    - 165.91367041742973 * Hm101 * x2 + 32. * Hm1010 * x2
                    + 64. * Hm10100 * x2 + 64. * Hm10101 * x2
                    + 32. * Hm1011 * x2 + 64. * Hm10110 * x2
                    + 105.27578027828648 * Hm10m1 * x2 - 64. * Hm10m10 * x2
                    - 32. * Hm10m100 * x2 - 64. * Hm10m101 * x2
                    + 49.60224233312681 * Hm1m1 * x2
                    + 102.95683520871486 * Hm1m10 * x2 - 80. * Hm1m100 * x2
                    - 64. * Hm1m1000 * x2 - 32. * Hm1m1001 * x2
                    - 64. * Hm1m101 * x2 - 128. * Hm1m1010 * x2
                    - 64. * Hm1m1011 * x2 + 157.91367041742973 * Hm1m1m1 * x2
                    + 96. * Hm1m1m10 * x2 - 96. * Hm1m1m100 * x2
                    + 192. * Hm1m1m1m10 * x2)
           + a_Qg_30(x, v) + 4.666666666666667 * C2_g1_massless(x, 1)
           + C2_g3_massless(x, 1 + nf) / (1. + nf);
}

//==========================================================================================//
//  High scale (Q^2 >> m^2) limit of the pure singlet coefficient functions for
//  F2 at O(alpha_s^3) expanded in terms of \alpha_s^{[nf]}, for Q=mu.
//
//  Coefficient of log(m^2/Q^2)^3
//------------------------------------------------------------------------------------------//

double C2_ps3_highscale_LL(double x, int nf) {

    double x2 = x * x;

    // weight 1
    const double H0 = H(x, 0);
    const double H1 = H(x, 1);

    // weight 2
    const double H00 = H(x, 0, 0);
    const double H01 = H(x, 0, 1);

    return -1.3333333333333333
               * (5.333333333333333 + 10.666666666666666 * H0
                  + 7.111111111111111 / x - 5.333333333333333 * x
                  + 10.666666666666666 * H0 * x - 7.111111111111111 * x2)
           + 1.3333333333333333
                 * (2.6666666666666665 + 5.333333333333333 * H0
                    + 3.5555555555555554 / x - 2.6666666666666665 * x
                    + 5.333333333333333 * H0 * x - 3.5555555555555554 * x2)
           - 1.3333333333333333
                 * (0.8888888888888888 + 1.7777777777777777 * H0
                    + 1.1851851851851851 / x - 0.8888888888888888 * x
                    + 1.7777777777777777 * H0 * x - 1.1851851851851851 * x2)
           - 1.3333333333333333 * nf
                 * (0.8888888888888888 + 1.7777777777777777 * H0
                    + 1.1851851851851851 / x - 0.8888888888888888 * x
                    + 1.7777777777777777 * H0 * x - 1.1851851851851851 * x2)
           - 4.
                 * (28.772981689857207 - 9.777777777777777 * H0
                    + 5.333333333333333 * H00 - 5.333333333333333 * H01
                    - 2.6666666666666665 * H1 - 19.555555555555554 / x
                    - (3.5555555555555554 * H0) / x
                    - (3.5555555555555554 * H1) / x - 11.227018310142793 * x
                    - 7.111111111111111 * H0 * x - 10.666666666666666 * H00 * x
                    - 5.333333333333333 * H01 * x + 2.6666666666666665 * H1 * x
                    + 19.555555555555554 * x2 + 3.5555555555555554 * H1 * x2)
           - 1.7777777777777777
                 * (7.323741157492194 - 5.333333333333333 * H00
                    - 10.666666666666666 * H01 - 5.333333333333333 * H1
                    - (7.111111111111111 * H1) / x + 27.768185601936636 * x
                    + 5.333333333333333 * H0 * x - 5.333333333333333 * H00 * x
                    - 10.666666666666666 * H01 * x + 5.333333333333333 * H1 * x
                    + 7.111111111111111 * H0 * x2 + 7.111111111111111 * H1 * x2)
           - 1.7777777777777777
                 * (10.985611736238287 - 8. * H00 - 16. * H01 - 8. * H1
                    - (10.666666666666666 * H1) / x + 41.652278402904955 * x
                    + 8. * H0 * x - 8. * H00 * x - 16. * H01 * x + 8. * H1 * x
                    + 10.666666666666666 * H0 * x2
                    + 10.666666666666666 * H1 * x2)
           + 1.7777777777777777
                 * (21.971223472476574 - 16. * H00 - 32. * H01 - 16. * H1
                    - (21.333333333333332 * H1) / x + 83.30455680580991 * x
                    + 16. * H0 * x - 16. * H00 * x - 32. * H01 * x
                    + 16. * H1 * x + 21.333333333333332 * H0 * x2
                    + 21.333333333333332 * H1 * x2)
           - 0.8888888888888888
                 * (-8. * H0 * (1. + x)
                    + (1.3333333333333333 * (-1. + x) * (4. + 7. * x + 4. * x2))
                          / x);
}

//==========================================================================================//
//  High scale (Q^2 >> m^2) limit of the pure singlet coefficient functions for
//  F2 at O(alpha_s^3) expanded in terms of \alpha_s^{[nf]}, for Q=mu.
//
//  Coefficient of log(m^2/Q^2)^2
//------------------------------------------------------------------------------------------//

double C2_ps3_highscale_NLL(double x, int nf) {

    double x2 = x * x;

    // weight 1
    const double H0 = H(x, 0);
    const double H1 = H(x, 1);

    // weight 2
    const double Hm10 = H(x, -1, 0);
    const double H00 = H(x, 0, 0);
    const double H10 = H(x, 1, 0);
    const double H01 = H(x, 0, 1);
    const double H11 = H(x, 1, 1);

    // weight 3
    const double H0m10 = H(x, 0, -1, 0);
    const double H000 = H(x, 0, 0, 0);
    const double H010 = H(x, 0, 1, 0);
    const double H001 = H(x, 0, 0, 1);
    const double H011 = H(x, 0, 1, 1);

    return 1.3333333333333333
               * (-31.11111111111111 - 14.222222222222221 * H0
                  - 10.666666666666666 * H00 + 1.7777777777777777 / x
                  + 20.444444444444443 * x - 19.555555555555554 * H0 * x
                  - 10.666666666666666 * H00 * x + 8.88888888888889 * x2
                  + 7.111111111111111 * H0 * x2)
           + 1.3333333333333333 * nf
                 * (-31.11111111111111 - 14.222222222222221 * H0
                    - 10.666666666666666 * H00 + 1.7777777777777777 / x
                    + 20.444444444444443 * x - 19.555555555555554 * H0 * x
                    - 10.666666666666666 * H00 * x + 8.88888888888889 * x2
                    + 7.111111111111111 * H0 * x2)
           - 1.3333333333333333 * nf
                 * (-62.22222222222222 - 28.444444444444443 * H0
                    - 21.333333333333332 * H00 + 3.5555555555555554 / x
                    + 40.888888888888886 * x - 39.11111111111111 * H0 * x
                    - 21.333333333333332 * H00 * x + 17.77777777777778 * x2
                    + 14.222222222222221 * H0 * x2)
           + 1.3333333333333333 * nf
                 * (-9.004796087920571 - 2.6666666666666665 * H0
                    - 5.333333333333333 * H00 - 5.333333333333333 * H01
                    - 2.6666666666666665 * H1 + 1.7777777777777777 / x
                    - (3.5555555555555554 * H1) / x + 10.550759467634986 * x
                    - 13.333333333333332 * H0 * x - 5.333333333333333 * H00 * x
                    - 5.333333333333333 * H01 * x + 2.6666666666666665 * H1 * x
                    + 14.222222222222221 * x2 + 3.5555555555555554 * H0 * x2
                    + 3.5555555555555554 * H1 * x2)
           + 1.3333333333333333
                 * (-18.009592175841142 - 5.333333333333333 * H0
                    - 10.666666666666666 * H00 - 10.666666666666666 * H01
                    - 5.333333333333333 * H1 + 3.5555555555555554 / x
                    - (7.111111111111111 * H1) / x + 21.101518935269972 * x
                    - 26.666666666666664 * H0 * x - 10.666666666666666 * H00 * x
                    - 10.666666666666666 * H01 * x + 5.333333333333333 * H1 * x
                    + 28.444444444444443 * x2 + 7.111111111111111 * H0 * x2
                    + 7.111111111111111 * H1 * x2)
           - 1.3333333333333333
                 * (-28.676258842507806 - 21.333333333333332 * H00
                    - 10.666666666666666 * H01 - 5.333333333333333 * H1
                    + 15.407407407407407 / x - (7.111111111111111 * H1) / x
                    + 53.10151893526997 * x - 21.333333333333332 * H00 * x
                    - 10.666666666666666 * H01 * x + 5.333333333333333 * H1 * x
                    - 4.7407407407407405 * x2 + 21.333333333333332 * H0 * x2
                    + 7.111111111111111 * H1 * x2)
           - 1.7777777777777777
                 * (-89.80954749921949 - 70.55156055657295 * H0 - 16. * H00
                    + 80. * H000 + 128. * H001 + 112. * H01 + 96. * H010
                    + 96. * H011 + 296. * H1 + 48. * H10 + 48. * H11 + 16. / x
                    + (7.111111111111111 * H1) / x + (64. * H10) / x
                    + (64. * H11) / x - 398.2539919436639 * x
                    - 446.55156055657295 * H0 * x + 32. * H00 * x
                    + 80. * H000 * x + 128. * H001 * x + 112. * H01 * x
                    + 96. * H010 * x + 96. * H011 * x - 200. * H1 * x
                    - 48. * H10 * x - 48. * H11 * x + 202.12630046381076 * x2
                    - 103.1111111111111 * H0 * x2
                    - 106.66666666666666 * H00 * x2
                    - 106.66666666666666 * H01 * x2
                    - 103.1111111111111 * H1 * x2 - 64. * H10 * x2
                    - 64. * H11 * x2)
           + 1.7777777777777777
                 * (-61.20043388759966 - 43.594725347858116 * H0 - 16. * H00
                    + 48. * H000 + 80. * H001 + 48. * H01 + 48. * H010
                    + 48. * H011 + 164. * H1 + 24. * H10 + 24. * H11 + 8. / x
                    - (14.222222222222221 * H1) / x + (32. * H10) / x
                    + (32. * H11) / x - 155.6736548595675 * x
                    - 271.5947253478581 * H0 * x - 8. * H00 * x + 48. * H000 * x
                    + 80. * H001 * x + 16. * H01 * x + 48. * H010 * x
                    + 48. * H011 * x - 148. * H1 * x - 24. * H10 * x
                    - 24. * H11 * x + 149.48841032466754 * x2
                    - 1.7777777777777777 * H0 * x2
                    - 74.66666666666666 * H00 * x2
                    - 74.66666666666666 * H01 * x2
                    - 1.7777777777777777 * H1 * x2 - 32. * H10 * x2
                    - 32. * H11 * x2)
           + 4.
                 * (-41.41087182900044 - 84. * H0 + 29.333333333333332 * H00
                    - 16. * H000 + 37.33333333333333 * H01 + 16. * H010
                    + 32. * H011 - 6.666666666666666 * H1 + 8. * H10 + 16. * H11
                    - 48.21263004638108 / x - (5.333333333333333 * H0) / x
                    + (10.666666666666666 * H01) / x
                    + (53.33333333333333 * H1) / x
                    + (10.666666666666666 * H10) / x
                    + (21.333333333333332 * H11) / x + 101.4119792149816 * x
                    + 61.043164791285136 * H0 * x + 117.33333333333333 * H00 * x
                    + 32. * H000 * x + 48. * H001 * x
                    + 61.33333333333333 * H01 * x + 16. * H010 * x
                    + 32. * H011 * x + 54.666666666666664 * H1 * x
                    - 8. * H10 * x - 16. * H11 * x - 231.7873699536189 * x2
                    - 58.666666666666664 * H0 * x2
                    - 10.666666666666666 * H01 * x2
                    - 101.33333333333333 * H1 * x2
                    - 10.666666666666666 * H10 * x2
                    - 21.333333333333332 * H11 * x2)
           + 1.7777777777777777
                 * (1.991161789383927 - 12.1450842710241 * H0 + 8. * H000
                    + 24. * H001 + 8. * H01 + 16. * H010 + 32. * H011
                    + 68.66666666666666 * H1 + 8. * H10 + 16. * H11
                    - (5.333333333333333 * H1) / x
                    + (10.666666666666666 * H10) / x
                    + (21.333333333333332 * H11) / x - 125.48725581497351 * x
                    - 74.81175093769076 * H0 * x + 16. * H00 * x + 8. * H000 * x
                    + 24. * H001 * x + 32. * H01 * x + 16. * H010 * x
                    + 32. * H011 * x - 20.666666666666664 * H1 * x
                    - 8. * H10 * x - 16. * H11 * x + 35.09192675942883 * x2
                    - 42.666666666666664 * H0 * x2
                    - 10.666666666666666 * H00 * x2
                    - 21.333333333333332 * H01 * x2
                    - 42.666666666666664 * H1 * x2
                    - 10.666666666666666 * H10 * x2
                    - 21.333333333333332 * H11 * x2)
           + 4.
                 * (143.04137323077384 - 172.09672284734938 * H0
                    + 74.66666666666666 * H00 - 48. * H000 + 16. * H001
                    + 8. * H01 + 32. * H010 + 32. * H011 - 32. * H0m10
                    - 45.33333333333333 * H1 + 16. * H10 + 16. * H11
                    - 16. * Hm10 - 133.48148148148147 / x
                    - (23.11111111111111 * H0) / x
                    + (21.333333333333332 * H01) / x
                    + (39.11111111111111 * H1) / x
                    + (21.333333333333332 * H10) / x
                    + (21.333333333333332 * H11) / x
                    + (21.333333333333332 * Hm10) / x - 95.08603461901811 * x
                    + 41.584332083078976 * H0 * x + 74.66666666666666 * H00 * x
                    + 64. * H000 * x + 64. * H001 * x + 32. * H010 * x
                    + 32. * H011 * x + 32. * H0m10 * x
                    + 61.33333333333333 * H1 * x - 16. * H10 * x - 16. * H11 * x
                    - 16. * Hm10 * x + 61.90674157424364 * x2
                    - 179.55555555555554 * H0 * x2
                    - 21.333333333333332 * H01 * x2
                    - 55.11111111111111 * H1 * x2
                    - 21.333333333333332 * H10 * x2
                    - 21.333333333333332 * H11 * x2
                    + 21.333333333333332 * Hm10 * x2)
           - 4.
                 * (286.0827464615477 - 344.19344569469877 * H0
                    + 149.33333333333331 * H00 - 96. * H000 + 32. * H001
                    + 16. * H01 + 64. * H010 + 64. * H011 - 64. * H0m10
                    - 90.66666666666666 * H1 + 32. * H10 + 32. * H11
                    - 32. * Hm10 - 266.96296296296293 / x
                    - (46.22222222222222 * H0) / x
                    + (42.666666666666664 * H01) / x
                    + (78.22222222222221 * H1) / x
                    + (42.666666666666664 * H10) / x
                    + (42.666666666666664 * H11) / x
                    + (42.666666666666664 * Hm10) / x - 190.17206923803622 * x
                    + 83.16866416615795 * H0 * x + 149.33333333333331 * H00 * x
                    + 128. * H000 * x + 128. * H001 * x + 64. * H010 * x
                    + 64. * H011 * x + 64. * H0m10 * x
                    + 122.66666666666666 * H1 * x - 32. * H10 * x
                    - 32. * H11 * x - 32. * Hm10 * x + 123.81348314848728 * x2
                    - 359.1111111111111 * H0 * x2
                    - 42.666666666666664 * H01 * x2
                    - 110.22222222222221 * H1 * x2
                    - 42.666666666666664 * H10 * x2
                    - 42.666666666666664 * H11 * x2
                    + 42.666666666666664 * Hm10 * x2)
           - 0.8888888888888888
                 * (8. * H0 * H0 * (1. + x)
                    - 2.6666666666666665 * H0 * (3. + 15. * x + 8. * x2)
                    + (1.7777777777777777 * (-1. + x) * (10. + x + 28. * x2))
                          / x);
}

//==========================================================================================//
//  High scale (Q^2 >> m^2) limit of the pure singlet coefficient functions for
//  F2 at O(alpha_s^3) expanded in terms of \alpha_s^{[nf]}, for Q=mu.
//
//  Coefficient of log(m^2/Q^2)^1
//------------------------------------------------------------------------------------------//

double C2_ps3_highscale_N2LL(double x, int nf) {

    double x2 = x * x;
    double x3 = x2 * x;

    // Allocate pointers for the harmonic polylogs
    double wx = x;
    int nw = 4;
    int n1 = -1;
    int n2 = 1;
    int sz = n2 - n1 + 1;
    double *Hr1 = new double[sz];
    double *Hr2 = new double[sz * sz];
    double *Hr3 = new double[sz * sz * sz];
    double *Hr4 = new double[sz * sz * sz * sz];
    double *Hr5 = new double[sz * sz * sz * sz * sz];

    // Call polylogs
    apf_hplog_(&wx, &nw, Hr1, Hr2, Hr3, Hr4, Hr5, &n1, &n2);

    // weight 1
    const double Hm1 = Hr1[0];
    const double H0 = Hr1[1];
    const double H1 = Hr1[2];

    // weight 2
    const double H0m1 = Hr2[1];
    const double Hm10 = Hr2[3];
    const double H00 = Hr2[4];
    const double H10 = Hr2[5];
    const double H01 = Hr2[7];
    const double H11 = Hr2[8];

    // weight 3
    const double Hm1m10 = Hr3[9];
    const double H0m10 = Hr3[10];
    const double Hm100 = Hr3[12];
    const double H000 = Hr3[13];
    const double H100 = Hr3[14];
    const double H010 = Hr3[16];
    const double H110 = Hr3[17];
    const double Hm101 = Hr3[21];
    const double H001 = Hr3[22];
    const double H101 = Hr3[23];
    const double H011 = Hr3[25];
    const double H111 = Hr3[26];

    // weight 4
    const double H0m1m10 = Hr4[28];
    const double H00m10 = Hr4[31];
    const double H0m100 = Hr4[37];
    const double H0000 = Hr4[40];
    const double H0100 = Hr4[43];
    const double H0010 = Hr4[49];
    const double H0110 = Hr4[52];
    const double H0m101 = Hr4[64];
    const double H0001 = Hr4[67];
    const double H0101 = Hr4[70];
    const double H0011 = Hr4[76];
    const double H0111 = Hr4[79];

    delete[] Hr1;
    delete[] Hr2;
    delete[] Hr3;
    delete[] Hr4;
    delete[] Hr5;

    return -1.3333333333333333
               * (135.7037037037037 + 138.07407407407408 * H0
                  + 51.55555555555555 * H00 + 32. * H000
                  - 21.333333333333332 * Hm10 + 12.796518240684216 / x
                  - (7.111111111111111 * Hm10) / x - 135.24007490757697 * x
                  + 91.85185185185185 * H0 * x + 104.88888888888889 * H00 * x
                  + 32. * H000 * x - 21.333333333333332 * Hm10 * x
                  - 60.04938271604938 * x2 - 35.55555555555556 * H0 * x2
                  - 21.333333333333332 * H00 * x2
                  - 7.111111111111111 * Hm10 * x2)
           + 1.3333333333333333
                 * (35.34045881888753 + 27.13029546279339 * H0
                    + 21.333333333333332 * H000 + 21.333333333333332 * H001
                    + 21.333333333333332 * H010 + 10.666666666666666 * H011
                    + 46.22222222222222 * H1 + 10.666666666666666 * H10
                    + 5.333333333333333 * H11 - 21.333333333333332 * Hm10
                    - 5.771382993883684 / x - (15.407407407407407 * H1) / x
                    + (14.222222222222221 * H10) / x
                    + (7.111111111111111 * H11) / x
                    - (7.111111111111111 * Hm10) / x - 112.3440605331339 * x
                    - 93.7585934260955 * H0 * x + 53.33333333333333 * H00 * x
                    + 21.333333333333332 * H000 * x
                    + 21.333333333333332 * H001 * x
                    + 21.333333333333332 * H010 * x
                    + 10.666666666666666 * H011 * x - 35.55555555555556 * H1 * x
                    - 10.666666666666666 * H10 * x - 5.333333333333333 * H11 * x
                    - 21.333333333333332 * Hm10 * x + 96.72155638905846 * x2
                    - 52.148148148148145 * H0 * x2
                    - 21.333333333333332 * H00 * x2
                    - 21.333333333333332 * H01 * x2
                    + 4.7407407407407405 * H1 * x2
                    - 14.222222222222221 * H10 * x2
                    - 7.111111111111111 * H11 * x2
                    - 7.111111111111111 * Hm10 * x2)
           - 1.3333333333333333 * nf
                 * (104.49783379204676 + 112.59259259259258 * H0
                    + 51.55555555555555 * H00 + 32. * H000
                    + 14.222222222222221 * H01 - 5.333333333333333 * H011
                    + 8. * H1 - 2.6666666666666665 * H11
                    - 21.333333333333332 * Hm10 + 1.7347898456224886 / x
                    + (5.925925925925926 * H1) / x
                    - (3.5555555555555554 * H11) / x
                    - (7.111111111111111 * Hm10) / x - 157.44114873131332 * x
                    + 52.148148148148145 * H0 * x + 104.88888888888889 * H00 * x
                    + 32. * H000 * x + 19.555555555555554 * H01 * x
                    - 5.333333333333333 * H011 * x - 2.6666666666666665 * H1 * x
                    + 2.6666666666666665 * H11 * x
                    - 21.333333333333332 * Hm10 * x - 44.169642114225795 * x2
                    - 46.81481481481481 * H0 * x2
                    - 21.333333333333332 * H00 * x2
                    + 3.5555555555555554 * H01 * x2
                    - 11.25925925925926 * H1 * x2
                    + 3.5555555555555554 * H11 * x2
                    - 7.111111111111111 * Hm10 * x2)
           + 1.3333333333333333 * nf
                 * (85.40540438913456 + 60.6762588425078 * H0
                    + 28.444444444444443 * H00 + 21.333333333333332 * H000
                    + 10.666666666666666 * H001 + 23.11111111111111 * H01
                    + 10.666666666666666 * H010 - 10.666666666666666 * H011
                    + 26.666666666666664 * H1 + 5.333333333333333 * H10
                    - 5.333333333333333 * H11 - 21.333333333333332 * Hm10
                    - 11.69730891980961 / x + (7.111111111111111 * H10) / x
                    - (7.111111111111111 * H11) / x
                    - (7.111111111111111 * Hm10) / x - 99.25167010169096 * x
                    + 35.787369953618914 * H0 * x + 92.44444444444444 * H00 * x
                    + 21.333333333333332 * H000 * x
                    + 10.666666666666666 * H001 * x
                    + 12.444444444444443 * H01 * x
                    + 10.666666666666666 * H010 * x
                    - 10.666666666666666 * H011 * x - 37.33333333333333 * H1 * x
                    - 5.333333333333333 * H10 * x + 5.333333333333333 * H11 * x
                    - 21.333333333333332 * Hm10 * x - 16.747135524634835 * x2
                    - 46.22222222222222 * H0 * x2
                    - 14.222222222222221 * H00 * x2
                    - 7.111111111111111 * H01 * x2
                    + 10.666666666666666 * H1 * x2
                    - 7.111111111111111 * H10 * x2
                    + 7.111111111111111 * H11 * x2
                    - 7.111111111111111 * Hm10 * x2)
           - 4.
                 * (-361.74479916421626 - 852.707448629206 * H0
                    + 536.966026840087 * H00 - 272. * H000 + 176. * H0000
                    + 24. * H0001 - 28. * H001 - 64. * H0010 - 80. * H0011
                    + 112. * H00m10 + 558.3581148618741 * H01 - 16. * H010
                    - 136. * H0100 - 80. * H0101 - 2.6666666666666665 * H011
                    - 80. * H0110 - 80. * H0111 - 78.95683520871486 * H0m1
                    - 104. * H0m10 + 112. * H0m100 + 64. * H0m101
                    + 32. * H0m1m10 - 29.39088638838018 * H1
                    + 21.333333333333332 * H10 - 92. * H100 - 40. * H101
                    + 36. * H11 - 40. * H110 - 40. * H111
                    + 39.47841760435743 * Hm1 + 277.3333333333333 * Hm10
                    + 24. * Hm100 + 48. * Hm1m10 - 335.2051932927874 / x
                    - (49.05622138871931 * H0) / x
                    + (92.44444444444444 * H01) / x
                    - (42.666666666666664 * H010) / x
                    - (53.33333333333333 * H011) / x
                    + (21.333333333333332 * H0m10) / x
                    + (415.13722430597943 * H1) / x
                    - (55.11111111111111 * H10) / x
                    - (74.66666666666666 * H100) / x
                    - (53.33333333333333 * H101) / x
                    - (47.11111111111111 * H11) / x
                    - (53.33333333333333 * H110) / x
                    - (53.33333333333333 * H111) / x
                    + (105.27578027828648 * Hm1) / x
                    + (209.77777777777777 * Hm10) / x - (96. * Hm100) / x
                    - (64. * Hm101) / x + 169.7158040400958 * x
                    - 107.80446644010777 * H0 * x - 212.19224406129177 * H00 * x
                    - 328. * H000 * x - 192. * H0000 * x - 200. * H0001 * x
                    - 116. * H001 * x - 160. * H0010 * x - 176. * H0011 * x
                    - 48. * H00m10 * x + 190.35811486187418 * H01 * x
                    - 32. * H010 * x - 136. * H0100 * x - 80. * H0101 * x
                    - 10.666666666666666 * H011 * x - 80. * H0110 * x
                    - 80. * H0111 * x + 78.95683520871486 * H0m1 * x
                    + 8. * H0m10 * x - 112. * H0m100 * x - 64. * H0m101 * x
                    - 32. * H0m1m10 * x - 154.60911361161982 * H1 * x
                    - 101.33333333333333 * H10 * x + 92. * H100 * x
                    + 40. * H101 * x - 116. * H11 * x + 40. * H110 * x
                    + 40. * H111 * x + 39.47841760435743 * Hm1 * x
                    + 197.33333333333331 * Hm10 * x + 24. * Hm100 * x
                    + 48. * Hm1m10 * x - 368.03800076787024 * x2
                    - 225.80389097264612 * H0 * x2
                    + 670.2222222222222 * H00 * x2
                    + 53.33333333333333 * H001 * x2 + 376. * H01 * x2
                    + 74.66666666666666 * H010 * x2
                    + 74.66666666666666 * H011 * x2
                    - 106.66666666666666 * H0m10 * x2
                    - 231.13722430597943 * H1 * x2
                    + 135.11111111111111 * H10 * x2
                    + 74.66666666666666 * H100 * x2
                    + 53.33333333333333 * H101 * x2
                    + 127.1111111111111 * H11 * x2
                    + 53.33333333333333 * H110 * x2
                    + 53.33333333333333 * H111 * x2
                    + 105.27578027828648 * Hm1 * x2
                    + 129.77777777777777 * Hm10 * x2 - 96. * Hm100 * x2
                    - 64. * Hm101 * x2)
           + 4.
                 * (-827.5298358476086 - 206.03179238842367 * H0
                    + 356.25099874974563 * H00 - 149.33333333333331 * H000
                    + 96. * H0000 + 32. * H0001 - 106.66666666666666 * H001
                    - 32. * H0010 - 96. * H0011 + 32. * H00m10
                    + 321.8169475700803 * H01 - 82.66666666666666 * H010
                    - 80. * H0100 - 96. * H0101 + 18.666666666666664 * H011
                    - 128. * H0110 - 96. * H0111 - 131.59472534785812 * H0m1
                    - 80. * H0m10 + 80. * H0m100 + 64. * H0m101 - 32. * H0m1m10
                    - 208.32813670094373 * H1 + 104. * H10 - 56. * H100
                    - 48. * H101 + 61.33333333333333 * H11 - 64. * H110
                    - 48. * H111 - 39.47841760435743 * Hm1
                    + 202.66666666666666 * Hm10 + 24. * Hm100 + 32. * Hm101
                    + 16. * Hm1m10 - 35.29762796262382 / x
                    + (17.31414898165105 * H0) / x
                    + (56.888888888888886 * H01) / x - (64. * H010) / x
                    - (64. * H011) / x + (21.333333333333332 * H0m10) / x
                    + (314.9245942595984 * H1) / x
                    - (179.55555555555554 * H10) / x
                    - (42.666666666666664 * H100) / x - (64. * H101) / x
                    - (44.44444444444444 * H11) / x
                    - (85.33333333333333 * H110) / x - (64. * H111) / x
                    + (105.27578027828648 * Hm1) / x
                    + (99.55555555555554 * Hm10) / x - (64. * Hm100) / x
                    - (42.666666666666664 * Hm101) / x
                    + (42.666666666666664 * Hm1m10) / x + 889.2630655626837 * x
                    + 176.1049240071482 * H0 * x - 45.25499374872817 * H00 * x
                    - 421.3333333333333 * H000 * x - 128. * H0000 * x
                    - 192. * H0001 * x - 202.66666666666666 * H001 * x
                    - 224. * H0010 * x - 192. * H0011 * x - 32. * H00m10 * x
                    + 116.483614236747 * H01 * x - 122.66666666666666 * H010 * x
                    - 80. * H0100 * x - 96. * H0101 * x
                    + 42.666666666666664 * H011 * x - 128. * H0110 * x
                    - 96. * H0111 * x + 131.59472534785812 * H0m1 * x
                    - 96. * H0m10 * x - 80. * H0m100 * x - 64. * H0m101 * x
                    + 32. * H0m1m10 * x + 200.32813670094373 * H1 * x
                    - 240. * H10 * x + 56. * H100 * x + 48. * H101 * x
                    - 117.33333333333333 * H11 * x + 64. * H110 * x
                    + 48. * H111 * x - 39.47841760435743 * Hm1 * x
                    + 10.666666666666666 * Hm10 * x + 24. * Hm100 * x
                    + 32. * Hm101 * x + 16. * Hm1m10 * x
                    - 2007.781501377428 * x2 + 896.6309612959571 * H0 * x2
                    + 400.88888888888886 * H00 * x2
                    + 42.666666666666664 * H001 * x2
                    + 434.66666666666663 * H01 * x2 + 64. * H010 * x2
                    + 85.33333333333333 * H011 * x2
                    - 42.666666666666664 * H0m10 * x2
                    - 306.9245942595984 * H1 * x2
                    + 315.55555555555554 * H10 * x2
                    + 42.666666666666664 * H100 * x2 + 64. * H101 * x2
                    + 100.44444444444444 * H11 * x2
                    + 85.33333333333333 * H110 * x2 + 64. * H111 * x2
                    + 105.27578027828648 * Hm1 * x2
                    - 92.44444444444444 * Hm10 * x2 - 64. * Hm100 * x2
                    - 42.666666666666664 * Hm101 * x2
                    + 42.666666666666664 * Hm1m10 * x2)
           + 1.7777777777777777
                 * (470.32522519311607 + 200.5131416250619 * H0
                    + 77.50839576528784 * H00 + 16. * H000 - 80. * H0000
                    - 176. * H0001 - 80. * H001 - 160. * H0010 - 192. * H0011
                    + 128. * H00m10 - 208.7529962492369 * H01 - 144. * H010
                    - 64. * H0100 - 160. * H0101 - 192. * H011 - 128. * H0110
                    - 96. * H0111 - 105.27578027828648 * H0m1 + 160. * H0m10
                    + 64. * H0m100 - 128. * H0m1m10 - 381.4300561806827 * H1
                    - 306.66666666666663 * H10 - 80. * H101 - 424. * H11
                    - 64. * H110 - 48. * H111 - 263.18945069571623 * Hm1
                    + 378.66666666666663 * Hm10 + 128. * Hm100 + 64. * Hm101
                    - 192. * Hm1m10 + (1.4222222222222223 * Hm10) / x2
                    + 72.39943615629358 / x - (1.4222222222222223 * H0) / x
                    + (132.13589263965196 * H1) / x
                    - (39.11111111111111 * H10) / x - (64. * H100) / x
                    - (106.66666666666666 * H101) / x
                    - (14.222222222222221 * H11) / x
                    - (85.33333333333333 * H110) / x - (64. * H111) / x
                    - (17.545963379714415 * Hm1) / x
                    + (21.333333333333332 * Hm101) / x
                    + (21.333333333333332 * Hm1m10) / x + 1233.2004222983192 * x
                    + 1233.4540195048285 * H0 * x + 119.28617354306564 * H00 * x
                    - 181.33333333333331 * H000 * x - 80. * H0000 * x
                    - 176. * H0001 * x - 368. * H001 * x - 160. * H0010 * x
                    - 192. * H0011 * x + 305.9136704174297 * H01 * x
                    - 96. * H010 * x - 64. * H0100 * x - 160. * H0101 * x
                    - 176. * H011 * x - 128. * H0110 * x - 96. * H0111 * x
                    + 105.27578027828648 * H0m1 * x
                    + 53.33333333333333 * H0m10 * x - 64. * H0m100 * x
                    + 128. * H0m1m10 * x + 309.4300561806827 * H1 * x
                    + 226.66666666666666 * H10 * x + 80. * H101 * x
                    + 312. * H11 * x + 64. * H110 * x + 48. * H111 * x
                    - 263.18945069571623 * Hm1 * x
                    + 392.88888888888886 * Hm10 * x + 128. * Hm100 * x
                    + 64. * Hm101 * x - 192. * Hm1m10 * x
                    - 809.6267767720387 * x2 - 170.15763629765286 * H0 * x2
                    + 289.77777777777777 * H00 * x2
                    + 106.66666666666666 * H000 * x2
                    + 170.66666666666666 * H001 * x2
                    + 296.88888888888886 * H01 * x2 + 128. * H010 * x2
                    + 149.33333333333331 * H011 * x2
                    - 21.333333333333332 * H0m10 * x2
                    - 60.135892639651956 * H1 * x2
                    + 119.1111111111111 * H10 * x2 + 64. * H100 * x2
                    + 106.66666666666666 * H101 * x2
                    + 126.22222222222221 * H11 * x2
                    + 85.33333333333333 * H110 * x2 + 64. * H111 * x2
                    - 17.545963379714415 * Hm1 * x2
                    + 21.333333333333332 * Hm101 * x2
                    + 21.333333333333332 * Hm1m10 * x2 - 21.055156055657296 * x3
                    + 12.8 * H00 * x3 - 12.8 * Hm10 * x3)
           - 1.7777777777777777
                 * (945.0469278250191 + 283.6997160412677 * H0
                    + 131.74101125228918 * H00 + 80. * H000 - 168. * H0000
                    - 288. * H0001 - 160. * H001 - 240. * H0010 - 224. * H0011
                    + 128. * H00m10 - 484.7529962492369 * H01 - 112. * H010
                    - 64. * H0100 - 160. * H0101 - 152. * H011 - 160. * H0110
                    - 112. * H0111 - 105.27578027828648 * H0m1 + 160. * H0m10
                    + 64. * H0m100 - 128. * H0m1m10 - 686.3189450695717 * H1
                    - 441.3333333333333 * H10 - 80. * H101
                    - 433.3333333333333 * H11 - 80. * H110 - 56. * H111
                    - 263.18945069571623 * Hm1 + 378.66666666666663 * Hm10
                    + 128. * Hm100 + 64. * Hm101 - 192. * Hm1m10
                    + (1.4222222222222223 * Hm10) / x2 + 8.801127687412873 / x
                    - (1.4222222222222223 * H0) / x
                    + (114.65441115817046 * H1) / x
                    + (42.666666666666664 * H10) / x - (64. * H100) / x
                    - (106.66666666666666 * H101) / x
                    + (26.666666666666664 * H11) / x
                    - (106.66666666666666 * H110) / x
                    - (74.66666666666666 * H111) / x
                    - (17.545963379714415 * Hm1) / x
                    + (21.333333333333332 * Hm101) / x
                    + (21.333333333333332 * Hm1m10) / x + 881.4066947408315 * x
                    + 1393.3544203779686 * H0 * x + 541.518789030067 * H00 * x
                    - 117.33333333333333 * H000 * x - 168. * H0000 * x
                    - 288. * H0001 * x - 272. * H001 * x - 240. * H0010 * x
                    - 224. * H0011 * x + 453.9136704174297 * H01 * x
                    + 32. * H010 * x - 64. * H0100 * x - 160. * H0101 * x
                    - 40. * H011 * x - 160. * H0110 * x - 112. * H0111 * x
                    + 105.27578027828648 * H0m1 * x
                    + 53.33333333333333 * H0m10 * x - 64. * H0m100 * x
                    + 128. * H0m1m10 * x + 875.6522784029049 * H1 * x
                    + 441.3333333333333 * H10 * x + 80. * H101 * x
                    + 417.3333333333333 * H11 * x + 80. * H110 * x
                    + 56. * H111 * x - 263.18945069571623 * Hm1 * x
                    + 392.88888888888886 * Hm10 * x + 128. * Hm100 * x
                    + 64. * Hm101 * x - 192. * Hm1m10 * x
                    - 611.0982175169864 * x2 - 677.894382039411 * H0 * x2
                    + 163.55555555555554 * H00 * x2
                    + 277.3333333333333 * H000 * x2
                    + 298.66666666666663 * H001 * x2
                    + 195.55555555555554 * H01 * x2
                    + 234.66666666666666 * H010 * x2
                    + 202.66666666666666 * H011 * x2
                    - 21.333333333333332 * H0m10 * x2
                    - 303.9877444915038 * H1 * x2
                    - 42.666666666666664 * H10 * x2 + 64. * H100 * x2
                    + 106.66666666666666 * H101 * x2
                    - 10.666666666666666 * H11 * x2
                    + 106.66666666666666 * H110 * x2
                    + 74.66666666666666 * H111 * x2
                    - 17.545963379714415 * Hm1 * x2
                    + 21.333333333333332 * Hm101 * x2
                    + 21.333333333333332 * Hm1m10 * x2 - 21.055156055657296 * x3
                    + 12.8 * H00 * x3 - 12.8 * Hm10 * x3)
           - 0.8888888888888888
                 * ((19.232910450553508 - 52.63789013914324 * H0
                     + 5.333333333333333 * H0 * H0 * H0 - 32. * H001
                     + 32. * H0 * H01 + 16. * H011)
                        * (1. + x)
                    + ((10.666666666666666 * H0m1
                        - 10.666666666666666 * H0 * Hm1)
                       * (1. + x) * (1. + x) * (1. + x))
                          / x
                    - 8. * H0 * H0 * x * (-5. + 2. * x)
                    + (1.7777777777777777 * H1 * (-1. + x)
                       * (13. - 26. * x + 4. * x2))
                          / x
                    + ((-5.333333333333333 * H0 * H1
                        - 1.3333333333333333 * H1 * H1)
                       * (-1. + x) * (4. + 7. * x + 4. * x2))
                          / x
                    + (1.7777777777777777 * (-1. + x)
                       * (-5. - 24. * x + 52. * x2))
                          / x
                    - 0.8888888888888888 * H0 * (-105. + 99. * x + 88. * x2)
                    - (5.333333333333333 * H01
                       * (4. + 3. * x - 3. * x2 + 2. * x3))
                          / x
                    + (17.545963379714415 * (-1. - 3. * x2 + 3. * x3)) / x);
}

//==========================================================================================//
//  High scale (Q^2 >> m^2) limit of the pure singlet coefficient functions for
//  F2 at O(alpha_s^3) expanded in terms of \alpha_s^{[nf]}, for Q=mu.
//
//  Coefficient of log(m^2/Q^2)^0
//------------------------------------------------------------------------------------------//

double C2_ps3_highscale_N3LL(double x, int nf) {

    double x2 = x * x;

    // Allocate pointers for the harmonic polylogs
    double wx = x;
    int nw = 5;
    int n1 = -1;
    int n2 = 1;
    int sz = n2 - n1 + 1;
    double *Hr1 = new double[sz];
    double *Hr2 = new double[sz * sz];
    double *Hr3 = new double[sz * sz * sz];
    double *Hr4 = new double[sz * sz * sz * sz];
    double *Hr5 = new double[sz * sz * sz * sz * sz];

    // Call polylogs
    apf_hplog_(&wx, &nw, Hr1, Hr2, Hr3, Hr4, Hr5, &n1, &n2);

    // weight 1
    const double Hm1 = Hr1[0];
    const double H0 = Hr1[1];
    const double H1 = Hr1[2];

    // weight 2
    const double Hm1m1 = Hr2[0];
    const double H0m1 = Hr2[1];
    const double Hm10 = Hr2[3];
    const double H00 = Hr2[4];
    const double H10 = Hr2[5];
    const double H01 = Hr2[7];
    const double H11 = Hr2[8];

    // weight 3
    const double H0m1m1 = Hr3[1];
    const double Hm1m10 = Hr3[9];
    const double H0m10 = Hr3[10];
    const double Hm100 = Hr3[12];
    const double H000 = Hr3[13];
    const double H100 = Hr3[14];
    const double H010 = Hr3[16];
    const double H110 = Hr3[17];
    const double H001 = Hr3[22];
    const double H101 = Hr3[23];
    const double H011 = Hr3[25];
    const double H111 = Hr3[26];

    // weight 4
    const double Hm1m1m10 = Hr4[27];
    const double Hm1m100 = Hr4[36];
    const double Hm1000 = Hr4[39];
    const double H0000 = Hr4[40];
    const double H1000 = Hr4[41];
    const double H0100 = Hr4[43];
    const double H1100 = Hr4[44];
    const double Hm1010 = Hr4[48];
    const double H0010 = Hr4[49];
    const double H1010 = Hr4[50];
    const double H0110 = Hr4[52];
    const double H1110 = Hr4[53];
    const double H0001 = Hr4[67];
    const double H1001 = Hr4[68];
    const double H0101 = Hr4[70];
    const double H1101 = Hr4[71];
    const double H0011 = Hr4[76];
    const double H1011 = Hr4[77];
    const double H0111 = Hr4[79];
    const double H1111 = Hr4[80];

    //  weight 5
    const double H0m1m1m10 = Hr5[82];
    const double H0m1m100 = Hr5[109];
    const double H0m1000 = Hr5[118];
    const double H00000 = Hr5[121];
    const double H01000 = Hr5[124];
    const double H00100 = Hr5[130];
    const double H01100 = Hr5[133];
    const double H0m1010 = Hr5[145];
    const double H00010 = Hr5[148];
    const double H01010 = Hr5[151];
    const double H00110 = Hr5[157];
    const double H01110 = Hr5[160];
    const double H00001 = Hr5[202];
    const double H01001 = Hr5[205];
    const double H00101 = Hr5[211];
    const double H01101 = Hr5[214];
    const double H00011 = Hr5[229];
    const double H01011 = Hr5[232];
    const double H00111 = Hr5[238];
    const double H01111 = Hr5[241];

    delete[] Hr1;
    delete[] Hr2;
    delete[] Hr3;
    delete[] Hr4;
    delete[] Hr5;

    return 1.3333333333333333 * nf
               * (93.23867290201594 + 30.790649761035212 * H0
                  + 38.759037314871335 * H00 + 14.518518518518517 * H000
                  + 8.88888888888889 * H0000 - 7.111111111111111 * H0001
                  - 5.925925925925926 * H001 - 10.666666666666666 * H0010
                  + 3.5555555555555554 * H0011 - 37.2990497994675 * H01
                  - 23.11111111111111 * H010 - 10.666666666666666 * H0100
                  + 10.666666666666666 * H0101 + 2.962962962962963 * H011
                  + 10.666666666666666 * H0110 - 1.7777777777777777 * H0111
                  - 17.266808850351033 * H1 - 26.666666666666664 * H10
                  - 5.333333333333333 * H100 + 5.333333333333333 * H101
                  + 6.222222222222221 * H11 + 5.333333333333333 * H110
                  - 0.8888888888888888 * H111 - 5.107520830399018 / x
                  - (23.549160771661462 * H1) / x
                  - (7.111111111111111 * H100) / x
                  + (7.111111111111111 * H101) / x
                  - (1.9753086419753085 * H11) / x
                  + (7.111111111111111 * H110) / x
                  - (1.1851851851851851 * H111) / x - 58.8730862969503 * x
                  + 19.76320489983932 * H0 * x + 17.425703981538003 * H00 * x
                  + 3.8518518518518516 * H000 * x + 8.88888888888889 * H0000 * x
                  - 7.111111111111111 * H0001 * x
                  + 4.7407407407407405 * H001 * x
                  - 10.666666666666666 * H0010 * x
                  + 3.5555555555555554 * H0011 * x - 30.18793868835639 * H01 * x
                  - 12.444444444444443 * H010 * x
                  - 10.666666666666666 * H0100 * x
                  + 10.666666666666666 * H0101 * x
                  - 2.3703703703703702 * H011 * x
                  + 10.666666666666666 * H0110 * x
                  - 1.7777777777777777 * H0111 * x - 0.5109689274267417 * H1 * x
                  + 37.33333333333333 * H10 * x + 5.333333333333333 * H100 * x
                  - 5.333333333333333 * H101 * x - 11.555555555555555 * H11 * x
                  - 5.333333333333333 * H110 * x + 0.8888888888888888 * H111 * x
                  + 74.73690437425505 * x2 - 21.573852129686152 * H0 * x2
                  + 10.666666666666666 * H00 * x2
                  - 7.111111111111111 * H000 * x2
                  + 7.111111111111111 * H001 * x2
                  - 21.925925925925924 * H01 * x2
                  + 7.111111111111111 * H010 * x2
                  - 3.5555555555555554 * H011 * x2
                  + 41.326938549439234 * H1 * x2 - 10.666666666666666 * H10 * x2
                  + 7.111111111111111 * H100 * x2
                  - 7.111111111111111 * H101 * x2 + 7.308641975308642 * H11 * x2
                  - 7.111111111111111 * H110 * x2
                  + 1.1851851851851851 * H111 * x2)
           + 1.3333333333333333
                 * (-21.84246469548236 + 90.7176968578255 * H0
                    - 46.69890761578313 * H00 + 2.6666666666666665 * H000
                    - 5.333333333333333 * H0000 + 14.222222222222221 * H001
                    + 10.666666666666666 * H0010 - 5.333333333333333 * H0011
                    - 42.96296296296296 * H01 + 8.88888888888889 * H010
                    + 10.666666666666666 * H0100 - 5.333333333333333 * H0101
                    + 40. * H011 - 5.333333333333333 * H0110
                    - 21.333333333333332 * H0111 + 9.185185185185185 * H1
                    + 18.666666666666664 * H10 + 5.333333333333333 * H100
                    - 2.6666666666666665 * H101 + 6.222222222222221 * H11
                    - 2.6666666666666665 * H110 - 10.666666666666666 * H111
                    + 73.91843483523763 / x - (25.086419753086417 * H1) / x
                    - (5.925925925925926 * H10) / x
                    + (7.111111111111111 * H100) / x
                    - (3.5555555555555554 * H101) / x
                    + (19.555555555555554 * H11) / x
                    - (3.5555555555555554 * H110) / x
                    - (14.222222222222221 * H111) / x + 43.35449874068793 * x
                    + 15.819215793095484 * H0 * x - 68.03224094911646 * H00 * x
                    + 13.333333333333332 * H000 * x
                    - 5.333333333333333 * H0000 * x
                    + 19.555555555555554 * H001 * x
                    + 10.666666666666666 * H0010 * x
                    - 5.333333333333333 * H0011 * x
                    - 23.407407407407405 * H01 * x
                    - 7.111111111111111 * H010 * x
                    + 10.666666666666666 * H0100 * x
                    - 5.333333333333333 * H0101 * x
                    + 45.33333333333333 * H011 * x
                    - 5.333333333333333 * H0110 * x
                    - 21.333333333333332 * H0111 * x
                    + 17.48148148148148 * H1 * x - 34.666666666666664 * H10 * x
                    - 5.333333333333333 * H100 * x
                    + 2.6666666666666665 * H101 * x
                    - 6.222222222222221 * H11 * x
                    + 2.6666666666666665 * H110 * x
                    + 10.666666666666666 * H111 * x - 96.71319110631546 * x2
                    + 89.12940768524172 * H0 * x2 - 44.44444444444444 * H00 * x2
                    + 7.111111111111111 * H000 * x2
                    + 3.5555555555555554 * H001 * x2
                    - 19.555555555555554 * H01 * x2
                    - 10.666666666666666 * H010 * x2
                    + 14.222222222222221 * H011 * x2
                    - 1.5802469135802468 * H1 * x2
                    + 21.925925925925924 * H10 * x2
                    - 7.111111111111111 * H100 * x2
                    + 3.5555555555555554 * H101 * x2
                    - 19.555555555555554 * H11 * x2
                    + 3.5555555555555554 * H110 * x2
                    + 14.222222222222221 * H111 * x2)
           + 1.7777777777777777
                 * (-265.3836164095999 - 383.4451156257267 * H0
                    - 81.59921921249372 * H00 - 59.10131866303547 * H000
                    + 8. * H0000 - 8. * H00001 - 16. * H0001 - 16. * H00010
                    - 16. * H00011 + 73.30455680580991 * H001 - 24. * H0010
                    - 16. * H00101 - 8. * H0011 + 16. * H00110 + 16. * H00111
                    - 157.79226799258993 * H01 - 71.65227840290495 * H010
                    + 64. * H0100 + 48. * H01000 + 32. * H01001 + 64. * H0101
                    + 32. * H01010 + 32. * H01011 + 15.826139201452476 * H011
                    + 48. * H0110 + 32. * H01100 - 24. * H0111 + 32. * H01110
                    + 16. * H01111 - 263.7303334350265 * H1
                    - 187.82613920145246 * H10 + 114.66666666666666 * H100
                    + 24. * H1000 + 16. * H1001 + 60. * H101 + 16. * H1010
                    + 16. * H1011 - 36.08693039927376 * H11
                    + 54.666666666666664 * H110 + 16. * H1100
                    + 13.333333333333332 * H111 + 16. * H1110 + 8. * H1111
                    - 117.57514045170683 / x - (99.75519697186941 * H1) / x
                    + (37.268851435100395 * H10) / x
                    + (26.666666666666664 * H100) / x + (32. * H1000) / x
                    + (21.333333333333332 * H1001) / x + (32. * H101) / x
                    + (21.333333333333332 * H1010) / x
                    + (21.333333333333332 * H1011) / x
                    - (1.7455368286613098 * H11) / x + (32. * H110) / x
                    + (21.333333333333332 * H1100) / x - (16. * H111) / x
                    + (21.333333333333332 * H1110) / x
                    + (10.666666666666666 * H1111) / x + 65.84833077336046 * x
                    - 112.45894478160976 * H0 * x - 133.91816428206536 * H00 * x
                    - 67.10131866303547 * H000 * x + 24. * H0000 * x
                    - 8. * H00001 * x - 16. * H00010 * x - 16. * H00011 * x
                    + 155.97122347247657 * H001 * x + 88. * H0010 * x
                    - 16. * H00101 * x + 88. * H0011 * x + 16. * H00110 * x
                    + 16. * H00111 * x - 318.9517405273757 * H01 * x
                    - 228.98561173623827 * H010 * x + 96. * H0100 * x
                    + 48. * H01000 * x + 32. * H01001 * x + 80. * H0101 * x
                    + 32. * H01010 * x + 32. * H01011 * x
                    - 25.507194131880855 * H011 * x + 32. * H0110 * x
                    + 32. * H01100 * x - 8. * H0111 * x + 32. * H01110 * x
                    + 16. * H01111 * x + 148.31986215049508 * H1 * x
                    - 6.8405274652141905 * H10 * x
                    - 82.66666666666666 * H100 * x - 24. * H1000 * x
                    - 16. * H1001 * x - 60. * H101 * x - 16. * H1010 * x
                    - 16. * H1011 * x - 39.91306960072623 * H11 * x
                    - 54.666666666666664 * H110 * x - 16. * H1100 * x
                    + 18.666666666666664 * H111 * x - 16. * H1110 * x
                    - 8. * H1111 * x + 294.4794135038783 * x2
                    + 214.09665729989337 * H0 * x2
                    - 46.11937162062472 * H00 * x2
                    - 94.22222222222221 * H000 * x2
                    + 10.666666666666666 * H0000 * x2
                    + 21.333333333333332 * H0001 * x2
                    - 67.55555555555556 * H001 * x2
                    + 21.333333333333332 * H0010 * x2
                    + 21.333333333333332 * H0011 * x2
                    - 98.25446317133868 * H01 * x2
                    - 131.55555555555554 * H010 * x2
                    - 21.333333333333332 * H0100 * x2
                    - 115.55555555555554 * H011 * x2
                    - 21.333333333333332 * H0110 * x2
                    - 10.666666666666666 * H0111 * x2
                    + 215.16566825640086 * H1 * x2
                    + 157.39781523156626 * H10 * x2
                    - 58.666666666666664 * H100 * x2 - 32. * H1000 * x2
                    - 21.333333333333332 * H1001 * x2 - 32. * H101 * x2
                    - 21.333333333333332 * H1010 * x2
                    - 21.333333333333332 * H1011 * x2
                    + 77.74553682866132 * H11 * x2 - 32. * H110 * x2
                    - 21.333333333333332 * H1100 * x2 - 16. * H111 * x2
                    - 21.333333333333332 * H1110 * x2
                    - 10.666666666666666 * H1111 * x2)
           + 4.
                 * (1267.4301392150908 - 780.9852394381068 * H0
                    + 284.57962298285145 * H00 - 87.47841760435743 * H000
                    + 45.33333333333333 * H0000 - 16. * H00000 + 32. * H00010
                    + 13.15947253478581 * H001 - 90.66666666666666 * H0010
                    + 32. * H00100 - 25.848626673962585 * H01
                    + 146.49280586811912 * H010 - 50.666666666666664 * H0100
                    + 32. * H01010 + 16. * H01011 - 31.826139201452474 * H011
                    - 16. * H01100 + 32. * H01101 + 8. * H0111 + 32. * H01110
                    - 16. * H01111 + 57.69873135166053 * H0m1
                    - 39.47841760435743 * H0m10 + 16. * H0m1000 + 32. * H0m1010
                    - 52.63789013914324 * H0m1m1 + 32. * H0m1m100
                    - 64. * H0m1m1m10 - 51.03715665888892 * H1
                    - 229.8647081770515 * H10 + 117.33333333333333 * H100
                    + 10.666666666666666 * H101 + 16. * H1010 + 8. * H1011
                    - 43.024180711837346 * H11 + 10.666666666666666 * H110
                    - 8. * H1100 + 16. * H1101 - 13.333333333333332 * H111
                    + 16. * H1110 - 8. * H1111 + 46.39532905554468 * Hm1
                    - 64.18365324662315 * Hm10 - 10.666666666666666 * Hm100
                    + 8. * Hm1000 + 16. * Hm1010 - 26.31894506957162 * Hm1m1
                    + 21.333333333333332 * Hm1m10 + 16. * Hm1m100
                    - 32. * Hm1m1m10 - 512.6315523923008 / x
                    - (98.30737585643715 * H0) / x
                    + (8.772981689857207 * H01) / x
                    + (35.55555555555556 * H010) / x
                    - (21.333333333333332 * H0100) / x
                    - (39.173376133339694 * H1) / x
                    + (208.4766853935609 * H10) / x
                    - (100.44444444444444 * H100) / x
                    + (17.77777777777778 * H101) / x
                    + (21.333333333333332 * H1010) / x
                    + (10.666666666666666 * H1011) / x
                    - (18.698907615783135 * H11) / x
                    + (17.77777777777778 * H110) / x
                    - (10.666666666666666 * H1100) / x
                    + (21.333333333333332 * H1101) / x
                    - (0.8888888888888888 * H111) / x
                    + (21.333333333333332 * H1110) / x
                    - (10.666666666666666 * H1111) / x
                    - (67.70909320063103 * Hm1) / x
                    + (54.170796921423474 * Hm10) / x
                    + (17.77777777777778 * Hm100) / x
                    - (10.666666666666666 * Hm1000) / x
                    - (21.333333333333332 * Hm1010) / x
                    + (35.09192675942883 * Hm1m1) / x
                    - (35.55555555555556 * Hm1m10) / x
                    - (21.333333333333332 * Hm1m100) / x
                    + (42.666666666666664 * Hm1m1m10) / x
                    - 1204.799682613077 * x - 96.4194750961299 * H0 * x
                    - 234.50737944075792 * H00 * x
                    - 23.188249062309232 * H000 * x
                    - 10.666666666666666 * H0000 * x + 16. * H00000 * x
                    - 32. * H00010 * x + 13.15947253478581 * H001 * x
                    + 5.333333333333333 * H0010 * x - 64. * H00100 * x
                    - 8. * H0011 * x - 35.19175245537154 * H01 * x
                    + 226.49280586811912 * H010 * x
                    - 50.666666666666664 * H0100 * x + 32. * H01010 * x
                    + 16. * H01011 * x - 54.492805868119135 * H011 * x
                    - 16. * H01100 * x + 32. * H01101 * x - 8. * H0111 * x
                    + 32. * H01110 * x - 16. * H01111 * x
                    - 57.69873135166053 * H0m1 * x
                    + 87.47841760435743 * H0m10 * x - 16. * H0m1000 * x
                    - 32. * H0m1010 * x + 52.63789013914324 * H0m1m1 * x
                    - 32. * H0m1m100 * x + 64. * H0m1m1m10 * x
                    - 6.441260945468508 * H1 * x + 485.8647081770515 * H10 * x
                    - 125.33333333333333 * H100 * x
                    + 5.333333333333333 * H101 * x - 16. * H1010 * x
                    - 8. * H1011 * x + 4.357514045170682 * H11 * x
                    + 5.333333333333333 * H110 * x + 8. * H1100 * x
                    - 16. * H1101 * x - 10.666666666666666 * H111 * x
                    - 16. * H1110 * x + 8. * H1111 * x
                    + 20.076383985973056 * Hm1 * x
                    + 15.816346753376841 * Hm10 * x
                    + 5.333333333333333 * Hm100 * x + 8. * Hm1000 * x
                    + 16. * Hm1010 * x - 26.31894506957162 * Hm1m1 * x
                    - 10.666666666666666 * Hm1m10 * x + 16. * Hm1m100 * x
                    - 32. * Hm1m1m10 * x + 2737.966194515747 * x2
                    - 1511.63675874505 * H0 * x2 + 315.85185185185185 * H00 * x2
                    - 48. * H000 * x2 - 25.3655742824498 * H01 * x2
                    + 156.44444444444443 * H010 * x2
                    - 8.88888888888889 * H011 * x2 + 96.65179373769712 * H1 * x2
                    - 464.4766853935609 * H10 * x2
                    + 108.44444444444444 * H100 * x2
                    - 33.77777777777778 * H101 * x2
                    - 21.333333333333332 * H1010 * x2
                    - 10.666666666666666 * H1011 * x2
                    + 57.3655742824498 * H11 * x2
                    - 33.77777777777778 * H110 * x2
                    + 10.666666666666666 * H1100 * x2
                    - 21.333333333333332 * H1101 * x2
                    + 24.888888888888886 * H111 * x2
                    - 21.333333333333332 * H1110 * x2
                    + 10.666666666666666 * H1111 * x2
                    - 94.02803827020267 * Hm1 * x2
                    + 134.17079692142346 * Hm10 * x2
                    + 33.77777777777778 * Hm100 * x2
                    - 10.666666666666666 * Hm1000 * x2
                    - 21.333333333333332 * Hm1010 * x2
                    + 35.09192675942883 * Hm1m1 * x2
                    - 67.55555555555556 * Hm1m10 * x2
                    - 21.333333333333332 * Hm1m100 * x2
                    + 42.666666666666664 * Hm1m1m10 * x2)
           + a_Qq_PS_30(x, 0) + C2_ps3_massless(x, 1 + nf) / (1. + nf);
}

//==========================================================================================//
//  High scale (Q^2 >> m^2) limit of the gluon coefficient functions for FL at
//  O(alpha_s^3) expanded in terms of \alpha_s^{[nf]}, for Q=mu.
//
//  Coefficient of log(m^2/Q^2)^2
//------------------------------------------------------------------------------------------//

double CL_g3_highscale_NLL(double x) {

    double x2 = x * x;

    // weight 1
    const double H0 = H(x, 0);
    const double H1 = H(x, 1);

    // weight 2
    const double H01 = H(x, 0, 1);

    return -83.55555555555556 - 56.88888888888889 * H0 + 35.55555555555556 * H1
           - 11.25925925925926 / x + 275.91579969079277 * x
           + 120.88888888888891 * H0 * x + 92.44444444444446 * H0 * H0 * x
           + 71.11111111111111 * H01 * x + 3.555555555555557 * H1 * x
           - 298.0740740740741 * x2 + 28.444444444444443 * H0 * x2
           - 39.111111111111114 * H1 * x2
           + 0.4444444444444444 * CL_g1_massless(x, 1);
}

//==========================================================================================//
//  High scale (Q^2 >> m^2) limit of the gluon coefficient functions for FL at
//  O(alpha_s^3) expanded in terms of \alpha_s^{[nf]}, for Q=mu.
//
//  Coefficient of log(m^2/Q^2)^1
//------------------------------------------------------------------------------------------//

double CL_g3_highscale_N2LL(double x, int nf) {

    double x2 = x * x;
    double x3 = x2 * x;

    // Allocate pointers for the harmonic polylogs
    double wx = x;
    int nw = 4;
    int n1 = -1;
    int n2 = 1;
    int sz = n2 - n1 + 1;
    double *Hr1 = new double[sz];
    double *Hr2 = new double[sz * sz];
    double *Hr3 = new double[sz * sz * sz];
    double *Hr4 = new double[sz * sz * sz * sz];
    double *Hr5 = new double[sz * sz * sz * sz * sz];

    // Call polylogs
    apf_hplog_(&wx, &nw, Hr1, Hr2, Hr3, Hr4, Hr5, &n1, &n2);

    // weight 1
    const double Hm1 = Hr1[0];
    const double H0 = Hr1[1];
    const double H1 = Hr1[2];

    // weight 2
    const double H0m1 = Hr2[1];
    const double H01 = Hr2[7];

    // weight 3
    const double H0m1m1 = Hr3[1];
    const double H00m1 = Hr3[4];
    const double H001 = Hr3[22];
    const double H011 = Hr3[25];

    // weight 4
    const double H000m1 = Hr4[13];
    const double H0001 = Hr4[67];

    delete[] Hr1;
    delete[] Hr2;
    delete[] Hr3;
    delete[] Hr4;
    delete[] Hr5;

    return -14.556887221883166 + 74.66666666666663 * H0
           + 78.22222222222221 * H0 * H0 - 14.222222222222229 * H001
           + 42.666666666666686 * H00m1 + 71.11111111111111 * H01
           + 14.222222222222229 * H0 * H01 - 56.888888888888914 * H0m1
           - 14.222222222222229 * H0 * H0m1 + 28.444444444444457 * H0m1m1
           - 111.71649327149186 * H1 - 113.77777777777777 * H0 * H1
           - 7.111111111111114 * H0 * H0 * H1 + 7.111111111111114 * H1 * H1
           + 23.39461783961923 * Hm1 + 56.888888888888914 * H0 * Hm1
           - 7.111111111111114 * H0 * H0 * Hm1 - 28.444444444444457 * H0m1 * Hm1
           + 14.222222222222229 * H0 * Hm1 * Hm1 + 29.629629629629626 * nf
           + 7.111111111111111 * H0 * nf + 7.111111111111111 * H1 * nf
           - 28.24691358024691 / x + (20.148148148148145 * H1) / x
           + 844.4103600465205 * x - 278.4108807425805 * H0 * x
           - 305.7777777777777 * H0 * H0 * x
           - 118.51851851851852 * H0 * H0 * H0 * x
           - 85.33333333333337 * H0001 * x + 85.33333333333337 * H000m1 * x
           + 71.11111111111114 * H001 * x + 56.888888888888914 * H0 * H001 * x
           + 469.3333333333333 * H00m1 * x - 56.888888888888914 * H0 * H00m1 * x
           - 287.43298654298377 * H01 * x - 213.33333333333331 * H0 * H01 * x
           - 14.222222222222229 * H0 * H0 * H01 * x
           + 28.444444444444457 * H011 * x + 202.09965320965057 * H0m1 * x
           - 241.77777777777777 * H0 * H0m1 * x
           + 14.222222222222229 * H0 * H0 * H0m1 * x
           + 28.444444444444457 * H0m1 * H0m1 * x
           - 28.444444444444457 * H0m1m1 * x
           - 56.888888888888914 * H0 * H0m1m1 * x - 431.71649327149174 * H1 * x
           - 177.77777777777777 * H0 * H1 * x
           - 7.111111111111114 * H0 * H0 * H1 * x
           - 24.888888888888886 * H1 * H1 * x - 23.39461783961923 * Hm1 * x
           - 248.88888888888908 * H0 * Hm1 * x
           + 7.111111111111114 * H0 * H0 * Hm1 * x
           + 28.444444444444457 * H0m1 * Hm1 * x
           - 14.222222222222229 * H0 * Hm1 * Hm1 * x
           + 27.56834512334374 * nf * x + 73.48148148148147 * H0 * nf * x
           + 14.222222222222221 * H0 * H0 * nf * x
           + 14.222222222222221 * H01 * nf * x + 7.111111111111111 * H1 * nf * x
           - 1243.6902066993962 * x2 + 2176. * H0 * x2
           + 21.333333333333343 * H0 * H0 * x2 + 28.444444444444457 * H001 * x2
           - 85.33333333333337 * H00m1 * x2 - 56.888888888888886 * H01 * x2
           - 28.444444444444457 * H0 * H01 * x2 + 305.77777777777777 * H0m1 * x2
           + 28.444444444444457 * H0 * H0m1 * x2
           - 56.888888888888914 * H0m1m1 * x2 + 523.2848383948356 * H1 * x2
           + 291.55555555555554 * H0 * H1 * x2
           + 14.222222222222229 * H0 * H0 * H1 * x2
           + 17.77777777777777 * H1 * H1 * x2 - 46.78923567923846 * Hm1 * x2
           - 305.77777777777777 * H0 * Hm1 * x2
           + 14.222222222222229 * H0 * H0 * Hm1 * x2
           + 56.888888888888914 * H0m1 * Hm1 * x2
           - 28.444444444444457 * H0 * Hm1 * Hm1 * x2
           - 80.59259259259258 * nf * x2 - 14.222222222222221 * H0 * nf * x2
           - 14.222222222222221 * H1 * nf * x2 + 2.842170943040401e-14 * x3
           - 7.105427357601002e-15 * H0 * H0 * x3
           - 1.4210854715202004e-14 * H0m1 * x3
           + 1.4210854715202004e-14 * H0 * Hm1 * x3
           - 12.666666666666666 * CL_g1_massless(x, 1);
}

//==========================================================================================//
//  High scale (Q^2 >> m^2) limit of the gluon coefficient functions for FL at
//  O(alpha_s^3) expanded in terms of \alpha_s^{[nf]}, for Q=mu.
//
//  Coefficient of log(m^2/Q^2)^0
//------------------------------------------------------------------------------------------//

double CL_g3_highscale_N3LL(double x, int nf) {

    double x2 = x * x;

    // Allocate pointers for the harmonic polylogs
    double wx = x;
    int nw = 4;
    int n1 = -1;
    int n2 = 1;
    int sz = n2 - n1 + 1;
    double *Hr1 = new double[sz];
    double *Hr2 = new double[sz * sz];
    double *Hr3 = new double[sz * sz * sz];
    double *Hr4 = new double[sz * sz * sz * sz];
    double *Hr5 = new double[sz * sz * sz * sz * sz];

    // Call polylogs
    apf_hplog_(&wx, &nw, Hr1, Hr2, Hr3, Hr4, Hr5, &n1, &n2);

    // weight 1
    const double Hm1 = Hr1[0];
    const double H0 = Hr1[1];
    const double H1 = Hr1[2];

    // weight 2
    const double H0m1 = Hr2[1];
    const double H01 = Hr2[7];

    // weight 3
    const double H0m1m1 = Hr3[1];
    const double H00m1 = Hr3[4];
    const double H001 = Hr3[22];
    const double H011 = Hr3[25];

    // weight 4
    const double H000m1 = Hr4[13];
    const double H0001 = Hr4[67];
    const double H0011 = Hr4[76];
    const double H0111 = Hr4[79];

    delete[] Hr1;
    delete[] Hr2;
    delete[] Hr3;
    delete[] Hr4;
    delete[] Hr5;

    return 547.6343796175224 + 40.888888888888886 * H0
           + 27.555555555555557 * H0 * H0 - 4.7407407407407405 * H0 * H0 * H0
           - 170.66666666666669 * H001 + 64. * H00m1 - 181.33333333333334 * H01
           + 71.11111111111111 * H0 * H01 + 35.55555555555556 * H011
           - 64. * H0 * H0m1 - 128. * H0m1m1 - 3.555555555555557 * H1
           + 209.77777777777774 * H0 * H1 + 14.222222222222221 * H0 * H0 * H1
           - 16. * H1 * H1 - 32. * H0 * H1 * H1
           + 5.925925925925926 * H1 * H1 * H1 - 105.27578027828648 * Hm1
           + 32. * H0 * H0 * Hm1 + 128. * H0m1 * Hm1 - 64. * H0 * Hm1 * Hm1
           - 32.2962962962963 / x - (42.666666666666664 * H01) / x
           + (42.666666666666664 * H0 * H1) / x + 766.5164922945999 * x
           + 358.03296696417954 * H0 * x - 142.2222222222222 * H0 * H0 * x
           - 52.74074074074074 * H0 * H0 * H0 * x
           + 4.7407407407407405 * H0 * H0 * H0 * H0 * x
           + 1877.3333333333333 * H0001 * x - 384. * H000m1 * x
           + 476.44444444444446 * H001 * x - 682.6666666666666 * H0 * H001 * x
           + 199.11111111111111 * H0011 * x - 64. * H00m1 * x
           + 256. * H0 * H00m1 * x + 890.6666666666667 * H01 * x
           - 305.77777777777777 * H0 * H01 * x
           + 28.444444444444443 * H0 * H0 * H01 * x
           + 99.55555555555556 * H011 * x - 128. * H0 * H011 * x
           + 71.11111111111111 * H0111 * x + 594.5515605565729 * H0m1 * x
           + 64. * H0 * H0m1 * x - 64. * H0 * H0 * H0m1 * x
           - 128. * H0m1 * H0m1 * x + 128. * H0m1m1 * x + 256. * H0 * H0m1m1 * x
           + 229.33333333333337 * H1 * x - 931.5555555555555 * H0 * H1 * x
           + 14.222222222222221 * H0 * H0 * H1 * x
           + 117.33333333333334 * H1 * H1 * x - 32. * H0 * H1 * H1 * x
           + 5.925925925925926 * H1 * H1 * H1 * x + 105.27578027828648 * Hm1 * x
           - 384. * H0 * Hm1 * x - 32. * H0 * H0 * Hm1 * x
           - 128. * H0m1 * Hm1 * x + 64. * H0 * Hm1 * Hm1 * x
           - 4376.146540538595 * x2 + 2591.9999999999995 * H0 * x2
           - 129.77777777777777 * H0 * H0 * x2
           - 9.481481481481481 * H0 * H0 * H0 * x2
           - 56.888888888888886 * H001 * x2 - 128. * H00m1 * x2
           - 497.7777777777777 * H01 * x2 + 56.888888888888886 * H0 * H01 * x2
           - 71.11111111111111 * H011 * x2 + 384. * H0m1 * x2
           + 128. * H0 * H0m1 * x2 + 256. * H0m1m1 * x2
           - 225.77777777777783 * H1 * x2 + 679.1111111111111 * H0 * H1 * x2
           - 28.444444444444443 * H0 * H0 * H1 * x2
           - 101.33333333333334 * H1 * H1 * x2 + 64. * H0 * H1 * H1 * x2
           - 11.851851851851851 * H1 * H1 * H1 * x2
           + 210.55156055657295 * Hm1 * x2 - 384. * H0 * Hm1 * x2
           - 64. * H0 * H0 * Hm1 * x2 - 256. * H0m1 * Hm1 * x2
           + 128. * H0 * Hm1 * Hm1 * x2
           + 4.666666666666667 * CL_g1_massless(x, 1)
           + CL_g3_massless(x, 1 + nf) / (1. + nf);
}

//==========================================================================================//
//  High scale (Q^2 >> m^2) limit of the pure singlet coefficient functions for
//  FL at O(alpha_s^3) expanded in terms of \alpha_s^{[nf]}, for Q=mu.
//
//  Coefficient of log(m^2/Q^2)^2
//------------------------------------------------------------------------------------------//

double CL_ps3_highscale_NLL(double x) {

    double x2 = x * x;

    const double H0 = H(x, 0);

    return -56.888888888888886 - 28.444444444444443 * H0
           - 4.7407407407407405 / x + 71.11111111111111 * x
           - 28.444444444444443 * H0 * x + 14.222222222222221 * H0 * H0 * x
           - 9.481481481481481 * x2;
}

//==========================================================================================//
//  High scale (Q^2 >> m^2) limit of the pure singlet coefficient functions for
//  FL at O(alpha_s^3) expanded in terms of \alpha_s^{[nf]}, for Q=mu.
//
//  Coefficient of log(m^2/Q^2)^1
//------------------------------------------------------------------------------------------//

double CL_ps3_highscale_N2LL(double x) {

    double x2 = x * x;

    const double H0 = H(x, 0);

    return 9.481481481481495 + 28.444444444444443 * H0 * H0
           - 12.641975308641975 / x + 227.55555555555551 * x
           + 94.81481481481482 * H0 * x + 42.66666666666667 * H0 * H0 * x
           - 9.481481481481481 * H0 * H0 * H0 * x - 224.39506172839506 * x2
           + 113.77777777777777 * H0 * x2;
}

//==========================================================================================//
//  High scale (Q^2 >> m^2) limit of the pure singlet coefficient functions for
//  FL at O(alpha_s^3) expanded in terms of \alpha_s^{[nf]}, for Q=mu.
//
//  Coefficient of log(m^2/Q^2)^0
//------------------------------------------------------------------------------------------//

double CL_ps3_highscale_N3LL(double x, int nf) {

    double x2 = x * x;

    // Allocate pointers for the harmonic polylogs
    double wx = x;
    int nw = 4;
    int n1 = -1;
    int n2 = 1;
    int sz = n2 - n1 + 1;
    double *Hr1 = new double[sz];
    double *Hr2 = new double[sz * sz];
    double *Hr3 = new double[sz * sz * sz];
    double *Hr4 = new double[sz * sz * sz * sz];
    double *Hr5 = new double[sz * sz * sz * sz * sz];

    // Call polylogs
    apf_hplog_(&wx, &nw, Hr1, Hr2, Hr3, Hr4, Hr5, &n1, &n2);

    // weight 1
    const double H0 = Hr1[1];
    const double H1 = Hr1[2];

    // weight 2
    const double H01 = Hr2[7];

    // weight 3
    const double H001 = Hr3[22];
    const double H011 = Hr3[25];

    // weight 4
    const double H0001 = Hr4[67];

    delete[] Hr1;
    delete[] Hr2;
    delete[] Hr3;
    delete[] Hr4;
    delete[] Hr5;

    return 10.347610117516318 - 61.62962962962962 * H0
           - 7.111111111111111 * H0 * H0 - 4.7407407407407405 * H0 * H0 * H0
           - 113.77777777777777 * H001 - 85.33333333333333 * H01
           + 56.888888888888886 * H0 * H01 + 33.185185185185176 * H1
           + 85.33333333333333 * H0 * H1 - 7.111111111111111 * H1 * H1
           - 14.748971193415636 / x - (18.962962962962962 * H01) / x
           - (7.901234567901234 * H1) / x + (18.962962962962962 * H0 * H1) / x
           + (2.3703703703703702 * H1 * H1) / x + 361.7482701359206 * x
           - 95.68094345084964 * H0 * x - 11.85185185185185 * H0 * H0 * H0 * x
           + 1.1851851851851851 * H0 * H0 * H0 * H0 * x
           + 170.66666666666666 * H0001 * x - 56.888888888888886 * H001 * x
           - 56.888888888888886 * H0 * H001 * x + 194.37037037037038 * H01 * x
           + 28.444444444444443 * H0 * H01 * x - 14.222222222222221 * H011 * x
           + 4.740740740740742 * H1 * x - 142.22222222222223 * H0 * H1 * x
           - 421.19311971200943 * x2 + 222.8148148148148 * H0 * x2
           - 18.962962962962962 * H0 * H0 * x2 - 28.444444444444443 * H01 * x2
           - 30.02469135802469 * H1 * x2 + 37.925925925925924 * H0 * H1 * x2
           + 4.7407407407407405 * H1 * H1 * x2
           + CL_ps3_massless(x, 1 + nf) / (1. + nf);
}
