# Generated by Django 2.2.3 on 2019-07-17 17:19

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('wagtailcore', '0041_group_collection_permissions_verbose_name_plural'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('wagtail_review', '0003_response'),
    ]

    operations = [
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quote', models.TextField()),
                ('text', models.TextField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('resolved_at', models.DateTimeField(null=True)),
                ('content_path', models.TextField()),
                ('start_xpath', models.TextField()),
                ('start_offset', models.IntegerField()),
                ('end_xpath', models.TextField()),
                ('end_offset', models.IntegerField()),
                ('page_revision', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='wagtailreview_comments', to='wagtailcore.PageRevision')),
            ],
        ),
        migrations.CreateModel(
            name='ExternalUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=254)),
            ],
        ),
        migrations.CreateModel(
            name='ReviewRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('submitted_at', models.DateTimeField(auto_now_add=True)),
                ('is_closed', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('external', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='wagtail_review.ExternalUser')),
                ('internal', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Share',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('shared_at', models.DateTimeField(auto_now_add=True)),
                ('can_comment', models.BooleanField(default=False)),
                ('first_accessed_at', models.DateTimeField(null=True)),
                ('last_accessed_at', models.DateTimeField(null=True)),
                ('expires_at', models.DateTimeField(null=True)),
                ('external_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='shares', to='wagtail_review.ExternalUser')),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='wagtailreview_shares', to='wagtailcore.Page')),
                ('shared_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ReviewResponse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('submitted_at', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(choices=[('approved', 'approved'), ('needs-changes', 'needs changes')], max_length=255)),
                ('comment', models.TextField(blank=True)),
                ('request', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='responses', to='wagtail_review.ReviewRequest')),
                ('submitted_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='wagtail_review.User')),
            ],
        ),
        migrations.AddField(
            model_name='reviewrequest',
            name='assignees',
            field=models.ManyToManyField(to='wagtail_review.User'),
        ),
        migrations.AddField(
            model_name='reviewrequest',
            name='page_revision',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='wagtailreview_reviewrequests', to='wagtailcore.PageRevision'),
        ),
        migrations.AddField(
            model_name='reviewrequest',
            name='submitted_by',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='CommentReply',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.TextField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('comment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='replies', to='wagtail_review.Comment')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comment_replies', to='wagtail_review.User')),
            ],
        ),
        migrations.AddField(
            model_name='comment',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comments', to='wagtail_review.User'),
        ),
        migrations.AddConstraint(
            model_name='user',
            constraint=models.CheckConstraint(check=models.Q(models.Q(('external__isnull', True), ('internal__isnull', False)), models.Q(('external__isnull', False), ('internal__isnull', True)), _connector='OR'), name='either_internal_or_external'),
        ),
        migrations.AddConstraint(
            model_name='user',
            constraint=models.UniqueConstraint(condition=models.Q(internal__isnull=False), fields=('internal',), name='unique_internal'),
        ),
        migrations.AddConstraint(
            model_name='user',
            constraint=models.UniqueConstraint(condition=models.Q(external__isnull=False), fields=('external',), name='unique_external'),
        ),
        migrations.AlterUniqueTogether(
            name='share',
            unique_together={('external_user', 'page')},
        ),
    ]
