import unittest

from hanlp.utils.string_util import split_long_sentence_into


class TestStringUtil(unittest.TestCase):
    def test_split_long_sentence_into(self):
        sent = ['a', 'b', 'c', ',', 'd', 'e', ',', 'f', 'g', ',', 'h']
        self.assertListEqual([['a', 'b', 'c', ','], ['d', 'e', ','], ['f', 'g', ','], ['h']],
                             list(split_long_sentence_into(sent, 2)))

    def test_split_127(self):
        sent = ['“', '旧', '货', '”', '不', '仅', '仅', '是', '指', '新', '货', '被', '使', '用', '才', '成', '为', '旧', '货', '；', '还',
                '包', '括', '商', '品', '的', '调', '剂', '，', '即', '卖', '出', '旧', '货', '的', '人', '是', '为', '了', '买', '入', '新',
                '货', '，', '买', '入', '旧', '货', '的', '人', '是', '因', '为', '符', '合', '自', '己', '的', '需', '要', '，', '不', '管',
                '新', '旧', '；', '有', '的', '商', '店', '还', '包', '括', '一', '些', '高', '档', '的', '工', '艺', '品', '、', '古', '董',
                '、', '字', '画', '、', '家', '具', '等', '商', '品', '；', '有', '的', '还', '包', '括', '新', '货', '卖', '不', '出', '去',
                '，', '企', '业', '或', '店', '主', '为', '了', '盘', '活', '资', '金', '，', '削', '价', '销', '售', '积', '压', '产', '品',
                '。']
        results = list(split_long_sentence_into(sent, 126))
        self.assertListEqual([['“', '旧', '货', '”', '不', '仅', '仅', '是', '指', '新', '货', '被', '使', '用', '才', '成', '为', '旧',
                               '货', '；', '还', '包', '括', '商', '品', '的', '调', '剂', '，', '即', '卖', '出', '旧', '货', '的', '人',
                               '是', '为', '了', '买', '入', '新', '货', '，', '买', '入', '旧', '货', '的', '人', '是', '因', '为', '符',
                               '合', '自', '己', '的', '需', '要', '，', '不', '管', '新', '旧', '；', '有', '的', '商', '店', '还', '包',
                               '括', '一', '些', '高', '档', '的', '工', '艺', '品', '、', '古', '董', '、', '字', '画', '、', '家', '具',
                               '等', '商', '品', '；', '有', '的', '还', '包', '括', '新', '货', '卖', '不', '出', '去', '，', '企', '业',
                               '或', '店', '主', '为', '了', '盘', '活', '资', '金', '，'],
                              ['削', '价', '销', '售', '积', '压', '产', '品', '。']], results)


if __name__ == '__main__':
    unittest.main()
