# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['cloud_connectors',
 'cloud_connectors.aws_connector',
 'cloud_connectors.azure_connector',
 'cloud_connectors.common',
 'cloud_connectors.common.cli',
 'cloud_connectors.common.cli.commands',
 'cloud_connectors.gcp_connector']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0',
 'backoff>=2.1.2,<3.0.0',
 'censys>=2.1.2,<3.0.0',
 'inquirerpy>=0.3.3,<0.4.0',
 'pydantic[email,dotenv]>=1.9.0,<2.0.0',
 'requests>=2.27.1,<3.0.0',
 'rich>=12.4.4,<13.0.0']

extras_require = \
{':python_version <= "3.8"': ['importlib-metadata'],
 'aws': ['boto3>=1.24.2,<2.0.0',
         'boto3-stubs[elb,route53domains,apigateway,sts,ecs,elbv2,rds,route53,apigatewayv2,ec2,s3]>=1.24.24,<2.0.0'],
 'azure': ['azure-cli>=2.34.1,<3.0.0',
           'azure-common>=1.1.28,<2.0.0',
           'azure-core>=1.22.0,<2.0.0',
           'azure-identity>=1.7.1,<2.0.0',
           'azure-mgmt-compute>=25.0.0,<25.1.0',
           'azure-mgmt-containerinstance>=9.1.0,<10.0.0',
           'azure-mgmt-core>=1.3.0,<2.0.0',
           'azure-mgmt-dns>=8.0.0,<9.0.0',
           'azure-mgmt-network>=19.3.0,<20.0.0',
           'azure-mgmt-resource==20.0.0',
           'azure-mgmt-resource==20.0.0',
           'azure-mgmt-sql>=3.0.1,<4.0.0',
           'azure-mgmt-storage>=19.1.0,<20.0.0',
           'azure-storage-blob>=12.9.0,<13.0.0'],
 'gcp': ['google-auth>=2.6.0,<3.0.0',
         'google-cloud-resource-manager>=1.4.1,<2.0.0',
         'google-cloud-securitycenter>=1.9.0,<2.0.0']}

entry_points = \
{'console_scripts': ['censys-cc = censys.cloud_connectors.common.cli:main']}

setup_kwargs = {
    'name': 'censys-cloud-connectors',
    'version': '3.0.1b2',
    'description': 'The Censys Unified Cloud Connector is a standalone connector that gathers assets from various cloud providers and stores them in Censys ASM.',
    'long_description': '# Censys Unified Cloud Connector\n\nThe Censys Unified Cloud Connector is a standalone connector that gathers\nassets from various cloud providers and stores them in Censys ASM. This\nConnector offers users the ability to supercharge our ASM Platform with total\ncloud visibility. This connector currently supports the following cloud\nproviders: Azure and GCP. Support for AWS and other cloud providers will be\nadded in the future.\n\n## Supported Platforms and Services\n\nThe following platforms and services are supported and will be used to import\nSeeds (IP Addresses, Domain Names, CIDRs, and ASNs) as well as Cloud Assets\n(Object Storage Buckets) into the Censys ASM platform.\n\n### Google Cloud Platform\n\n- [Google Cloud Compute](https://cloud.google.com/products/compute)\n  - [Compute Engine](https://cloud.google.com/compute)\n- [Google Cloud Containers](https://cloud.google.com/containers)\n  - [Kubernetes Engine](https://cloud.google.com/kubernetes-engine)\n- [Google Cloud Networking](https://cloud.google.com/products/networking)\n  - [Cloud DNS](https://cloud.google.com/dns)\n- [Google Cloud Databases](https://cloud.google.com/products/databases)\n  - [Cloud SQL](https://cloud.google.com/sql)\n- [Google Cloud Storage](https://cloud.google.com/products/storage)\n  - [Cloud Storage](https://cloud.google.com/storage)\n\n### Amazon Web Services\n\n- [Compute](https://aws.amazon.com/products/compute/)\n  - [Elastic Container Service (ECS)](https://aws.amazon.com/ecs/)\n  - [Elastic Compute Cloud (EC2)](https://aws.amazon.com/ec2/)\n- [Database](https://aws.amazon.com/products/databases/)\n  - [Relational Database Service (RDS)](https://aws.amazon.com/rds/)\n- [Network & Content Delivery](https://aws.amazon.com/products/networking)\n  - [API Gateway](https://aws.amazon.com/api-gateway)\n  - [Elastic Load Balancing (ELB)](https://aws.amazon.com/elasticloadbalancing/)\n  - [Route53](https://aws.amazon.com/route53/)\n- [Simple Storage Service (S3)](https://aws.amazon.com/s3/features/)\n\n### Azure Cloud\n\n- [Azure Networking](https://azure.microsoft.com/en-us/product-categories/networking/)\n  - [Azure DNS](https://azure.microsoft.com/en-us/services/dns/)\n- [Azure Container Services](https://azure.microsoft.com/en-us/product-categories/containers/)\n  - [Container Instances](https://azure.microsoft.com/en-us/services/container-instances/)\n- [Azure Databases](https://azure.microsoft.com/en-us/product-categories/databases/)\n  - [Azure SQL](https://azure.microsoft.com/en-us/products/azure-sql/)\n- [Azure Storage](https://azure.microsoft.com/en-us/product-categories/storage/)\n  - [Azure Blob Storage](https://azure.microsoft.com/en-us/services/storage/blobs/)\n\n## Getting Started\n\nIt is important to note that this connector is a Python package. This allows\nyou to run the connector from the command line as well as enables you to run\nthe connector in as many different environments as you wish. We have provided\na variety of deployment types and configuration options. We recommend that you\ninstall the package locally to take advantage of the configuration command line\ninterface (`censys-cc config`). After you have configured the connector, you\ncan deploy it to your environment. In the following sections, we will provide\na brief overview of how to deploy the connector to your environment.\n\n## Deployment Methods\n\n- [Local Deployment](#local-deployment)\n- [Terraform](#terraform)\n- [Docker Standalone](#docker-standalone)\n- [Docker Compose](#docker-compose)\n- [Kubernetes](#kubernetes)\n\n---\n\n### Local Installation\n\n#### Prerequisites\n\n- [Python 3.9+][python-install]\n- [Poetry][poetry-install]\n\n#### Installation\n\n```sh\n# Clone the repository\ngit clone https://github.com/censys/censys-cloud-connector.git\ncd censys-cloud-connector\n\n# Ensure you have poetry installed\npip install --upgrade poetry\n\n# Recommended installation\npoetry install -E azure -E gcp  # All dependencies (This is recommended)\n\n# Other installations\n# poetry install -E azure  # Only Azure dependencies\n# poetry install -E gcp  # Only GCP dependencies\n\n# Copy .env file\ncp .env.sample .env\n```\n\n#### Environment Variables\n\nThe following environment variables are available for use in the connector:\n\n- `CENSYS_API_KEY` - Your Censys ASM API key found in the\n  [ASM Integrations Page][censys-asm-integrations]. (**Required**)\n- `PROVIDERS_CONFIG_FILE` - The path to the `providers.yml` file.\n- `SECRETS_DIR` - The path to the directory containing the secrets.\n- `LOGGING_LEVEL` - The logging level. Valid values are `DEBUG`, `INFO`,\n  `WARN`, `ERROR`, and `CRITICAL`.\n- `DRY_RUN` - If set to `true`, the connector will not write any data to the\n  ASM platform. This is useful for testing.\n\n`.env.sample` is a sample file that contains the above environment variables.\nPlease use this file as a template to create your own `.env` file.\n\n#### Configuration\n\nTo configure the connector, you can use the command line interface. The base\ncommand is `censys-cc`. The configuration command is:\n\n```sh\npoetry run censys-cc config  # Configure supported providers\n```\n\nThe `censys-cc config` command will guide you through the configuration of\nsupported cloud providers. This command will assist you in generating a\n`providers.yml` file. This file can contain multiple provider configurations.\nYou can optionally specify a provider in the command line with the flag\n`--provider`.\n\n> Before configuring the connector, make sure you are logged in to your cloud\n> provider\'s CLI tool. See our [supported providers](#supported-providers)\n> below for more information.\n\n**You have successfully configured your cloud connector if your\n[providers.yml](./providers.yml) file is populated with your credentials.**\n\n#### Supported Providers\n\nLog in to your cloud provider\'s CLI tool using the following commands:\n\n- [Google\'s gcloud CLI][gcloud-cli]: `gcloud auth login`\n\n- [AWS CLI][aws-cli]: `aws configure`\n\n- [Azure CLI][azure-cli]: `az login`\n\n#### providers.yml\n\nThe `providers.yml` file contains the configuration for all cloud providers.\nThe file is a YAML file and is structured as follows:\n\n> You will need to have generated your `providers.yml` file using the\n> `censys-cc config` command before you can run the connector.\n\n```yaml\n- provider: aws\n  account_number: xxxxxxxxxxxx\n  access_key: xxxxxxxxxxxxxxxxxxxx\n  secret_key: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\n  regions:\n    - xxxxxxxxx\n  # The ignore field takes a list of Azure resource types to ignore during scanning.\n  # ignore:\n  #   - AWS::ApiGateway\n  #   - AWS::ECS\n  #   - AWS::ElasticLoadBalancing\n  #   - AWS::NetworkInterface\n  #   - AWS::RDS\n  #   - AWS::Route53\n  #   - AWS::S3\n  # It is also possible to define roles to assume for multiple accounts.\n  # accounts:\n  # - account_number: xxxxxxxxxxxx\n  #   access_key: xxxxxxxxxxxxxxxxxxxx\n  #   secret_key: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\n  #   role_name: xxxxxxxxxxxxxxxxxxxx\n- provider: azure\n  tenant_id: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx\n  client_id: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx\n  client_secret: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx\n  subscription_id: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx\n  # The subscription_id field takes one or more subscription IDs.\n  # subscription_id:\n  #   - xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx\n  #   - xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx\n  # The ignore field takes a list of Azure resource types to ignore during scanning.\n  # ignore:\n  #   - Microsoft.Network/publicIPAddresses\n  #   - Microsoft.ContainerInstance/containerGroups\n  #   - Microsoft.Sql/servers\n  #   - Microsoft.Network/dnszones\n  #   - Microsoft.Storage/storageAccounts\n- provider: gcp\n  organization_id: xxxxxxxx-xxxx-xxxx\n  service_account_json_file: service_account.json\n  service_account_email: censys-cloud-connector@project-id.iam.gserviceaccount.com\n  # The ignore field takes a list of GCP resource types to ignore during scanning.\n  # ignore:\n  #   - google.compute.Address\n  #   - google.container.Cluster\n  #   - google.cloud.sql.Instance\n  #   - google.cloud.dns.ManagedZone\n  #   - google.cloud.storage.Bucket\n```\n\n---\n\n### Local Deployment\n\nTo run the connector, you can use the command line interface.\n\n```sh\npoetry run censys-cc scan  # Scan cloud assets\n```\n\nThe `censys-cc scan` command runs the connector.\n\n#### Default settings\n\n- The connector will scan for assets from all providers in\n[`providers.yml`](./providers.yml).\n- The connector will run once.\n\n#### Additional options\n\n- You can specify one or more providers in the command line with the flag\n`--provider`. The connector will only scan for assets from the specified\nproviders.\n\n- You can set a scheduled interval for the connector to run on with the flag\n`--daemon`. This option takes in a time interval in hours. If you do not\nspecify an interval, the default will be set to 1 hour.\n\n  ```sh\n  censys-cc scan --daemon       # Run every 1 hour\n  censys-cc scan --daemon 1.5   # Run every 1.5 hours\n  ```\n\n---\n\n### [Terraform](./terraform/README.md)\n\nWe offer several Terraform deployment options for you to choose from. These\noptions deploy the connector to the serverless environment in your provider\'s\ncloud.\n\n#### [Option 1: Deploy to GCP](./terraform/google-scheduled-function/README.md)\n\nThis option deploys the connector to GCP as a Google Cloud Function.\n\n#### [Option 2: Deploy to Azure](./terraform/azure-scheduled-function/README.md)\n\n> Coming Soon!\n\n#### [Option 3: Deploy to AWS](./terraform/aws-scheduled-function/README.md)\n\n> Coming Soon!\n\nThis option deploys the connector to Azure as a Azure Function.\n\n---\n\n### [Docker Standalone](./Dockerfile)\n\nThis method assumes you have Docker installed and running on your server.\n\n1. Authenticate to the [GitHub Container Registry](https://docs.github.com/en/packages/working-with-a-github-packages-registry/working-with-the-container-registry#authenticating-to-the-container-registry)\n\n2. Pull the Docker image <!-- markdownlint-disable -->\n\n```sh\ndocker pull gcr.io/censys-io/censys-cloud-connector:latest\n```\n\n- If your environment does not allow you to pull the Docker image, you can\n  build it from the Dockerfile using the following command. You can then\n  push the image to a Docker registry.\n\n  ```sh\n  docker build -t gcr.io/censys-io/censys-cloud-connector:latest .\n  ```\n\n3. Run the Docker container <!-- markdownlint-disable -->\n\nThe following command will run the Docker container. You can specify the\nenvironment variables you want to pass to the container using the `-e` flag.\nThe container also requires the `providers.yml` file. The `-v` flag will\nmount the `providers.yml` file as a volume. If your `providers.yml` references\nadditional secret files, you can mount it as a volume as well. The `-d` flag\nis used to run the container in the background. We also include the `--rm`\nflag to ensure the container is removed after it has finished.\n\n```sh\n# Ensure you have sourced your environmental variables\nsource .env\n\n# Mount the providers.yml and secrets files as volumes\ndocker run -d --rm \\\n  -e "CENSYS_API_KEY=$CENSYS_API_KEY" \\\n  -v $(pwd)/providers.yml:/app/providers.yml \\\n  -v $(pwd)/secrets:/app/secrets \\\n  gcr.io/censys-io/censys-cloud-connector:latest \\\n  scan --daemon 4\n\n# Alternatively if you do not need the secrets volume\ndocker run -d --rm \\\n  -e "CENSYS_API_KEY=$CENSYS_API_KEY" \\\n  -v $(pwd)/providers.yml:/app/providers.yml \\\n  gcr.io/censys-io/censys-cloud-connector:latest \\\n  scan --daemon 4\n\n# Additionally if you only need to scan once\ndocker run --rm \\\n  -e "CENSYS_API_KEY=$CENSYS_API_KEY" \\\n  -v $(pwd)/providers.yml:/app/providers.yml \\\n  -v $(pwd)/secrets:/app/secrets \\\n  gcr.io/censys-io/censys-cloud-connector:latest\n```\n\n> More information about the `--daemon` flag is found\n> [here](#additional-options).\n\n---\n\n### [Docker Compose](./docker-compose.yml)\n\nThis method assumes you have Docker and Docker Compose installed and running on\nyour server.\n\n1. Run the Docker Compose file\n\n```sh\ndocker-compose up -d\n```\n\n2. [Optional] Run your connector on a scheduled interval\n\nUncomment the line `# command: scan --daemon 4` in\n[docker-compose.yml](./docker-compose.yml).\n\nDetails about the `--daemon` option can be found [here](#additional-options).\n\n---\n\n### [Kubernetes](./kubernetes/censys-cloud-connectors/README.md)\n\nThis method assumes you have Kubernetes installed and running on your server.\n\n<!-- TODO: Add steps -->\n\n---\n\n### Confirm Results\n\nVisit the [Seed Data Page][seed-data] and the [Storage Buckets Page][storage-bucket] to confirm that you\'re seeing seeds and storage buckets from your cloud provider(s).\n\n---\n\n## Known Issues\n\n### Azure Scan Immediately After Creating a Service Principal\n\n<!-- TODO: Remove once this feature has been added to the setup cli -->\n\nIn the case where the user has just run the `censys-cc config` command\nfor Azure and then promptly runs the `censys-cc scan` command, the scan may\nfail with a `ClientSecretCredential.get_token failed` exception. This is due\nto the fact that Azure is in the process of creating the service principal.\nPlease wait a few minutes and try again.\n\nExample error message:\n\n```error <!-- markdownlint-disable-next-line MD013 -->\nClientSecretCredential.get_token failed: Authentication failed: AADSTS7000215:Invalid client secret provided. Ensure the secret being sent in the request is the client secret value, not the client secret ID, for a secret added to app \'xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx\'.\n```\n\n## FAQs\n\n### My Python Version is Not Compatible\n\nIt is highly recommended that a Python version shim like\n[pyenv][pyenv-install] is used.\nOnce installed, Poetry will make a virtualenv using the\ncorrect version of Python automatically.\n\n### AWS Policy Actions\n\nThe following permissions are required to scan:\n\n- `route53:ListHostedZones`,\n- `elasticloadbalancing:DescribeLoadBalancers`,\n- `route53domains:ListDomains`,\n- `ec2:DescribeNetworkInterfaces`,\n- `rds:DescribeDBInstances`,\n- `route53:ListResourceRecordSets`,\n- `ecs:ListContainerInstances`,\n- `apigateway:GET`,\n- `s3:GetBucketLocation`,\n- `s3:ListBucket`,\n- `s3:ListAllMyBuckets`,\n- `ecs:ListClusters`\n\n### Azure Roles\n\nEnsure the account\'s Access control (IAM) role has the following permission to create a service principal with a Reader role:\n\n- `Microsoft.Authorization/roleAssignments/write` over scope `/subscriptions/uuid`\n\nThe following permissions will be used with this service principal:\n\n- `Microsoft.ContainerInstance/containerGroups/read`\n- `Microsoft.Network/dnszones/read`\n- `Microsoft.Network/publicIPAddresses/read`\n- `Microsoft.Sql/servers/read`\n- `Microsoft.Storage/storageAccounts/read`\n\nIf you see the following error message, check that you are logged into an account with the correct permissions:\n\n```error\nThe client \'user@example.com\' with object id \'uuid\' does not have authorization to perform action \'Microsoft.Authorization/roleAssignments/write\' over scope \'/subscriptions/uuid\' or the scope is invalid. If access was recently granted, please refresh your credentials.\n```\n\n### GCP Service Account Keys\n\nIf you encounter the following error while configuring your GCP Cloud Connector, a likely cause is that your service account has reached its maximum quota of keys.\n\n```error\nFailed to enable service account. ERROR: (gcloud.iam.service-accounts.keys.create) FAILED_PRECONDITION: Precondition check failed.\n```\n\nGo to <https://console.cloud.google.com/iam-admin/serviceaccounts> to manage your service account keys.\n\n## Developer Documentation\n\nAll contributions (no matter how small) are always welcome. See\n[Contributing to the Cloud Connector](https://github.com/censys/censys-cloud-connector/tree/main/.github/CONTRIBUTING.md) to change or\ntest the code or for information on the CI/CD pipeline.\n\n## License\n\nThis software is licensed under [Apache License, Version 2.0](http://www.apache.org/licenses/LICENSE-2.0)\n\n- Copyright (C) 2022 Censys, Inc.\n\n<!-- References -->\n\n[python-install]: https://www.python.org/downloads/\n[poetry-install]: https://python-poetry.org/docs/\n[pyenv-install]: https://github.com/pyenv/pyenv#installation\n[censys-asm-integrations]: https://app.censys.io/integrations\n[aws-cli]: https://docs.aws.amazon.com/cli/latest/userguide/getting-started-install.html\n[azure-cli]: https://docs.microsoft.com/en-us/cli/azure/install-azure-cli\n[gcloud-cli]: https://cloud.google.com/sdk/docs/install\n[seed-data]: https://app.censys.io/seeds\n[storage-bucket]: https://app.censys.io/storage-bucket\n',
    'author': 'Censys, Inc.',
    'author_email': 'support@censys.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
