# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class KubernetesNodePool(pulumi.CustomResource):
    actual_node_count: pulumi.Output[float]
    """
    A computed field representing the actual number of nodes in the node pool, which is especially useful when auto-scaling is enabled.
    """
    auto_scale: pulumi.Output[bool]
    """
    Enable auto-scaling of the number of nodes in the node pool within the given min/max range.
    """
    cluster_id: pulumi.Output[str]
    """
    The ID of the Kubernetes cluster to which the node pool is associated.
    """
    labels: pulumi.Output[dict]
    """
    A map of key/value pairs to apply to nodes in the pool. The labels are exposed in the Kubernetes API as labels in the metadata of the corresponding [Node resources](https://kubernetes.io/docs/concepts/architecture/nodes/).
    """
    max_nodes: pulumi.Output[float]
    """
    If auto-scaling is enabled, this represents the maximum number of nodes that the node pool can be scaled up to.
    """
    min_nodes: pulumi.Output[float]
    """
    If auto-scaling is enabled, this represents the minimum number of nodes that the node pool can be scaled down to.
    """
    name: pulumi.Output[str]
    """
    A name for the node pool.
    """
    node_count: pulumi.Output[float]
    """
    The number of Droplet instances in the node pool. If auto-scaling is enabled, this should only be set if the desired result is to explicitly reset the number of nodes to this value. If auto-scaling is enabled, and the node count is outside of the given min/max range, it will use the min nodes value.
    """
    nodes: pulumi.Output[list]
    """
    A list of nodes in the pool. Each node exports the following attributes:
    - `id` -  A unique ID that can be used to identify and reference the node.
    - `name` - The auto-generated name for the node.
    - `status` -  A string indicating the current status of the individual node.
    - `droplet_id` - The id of the node's droplet
    - `created_at` - The date and time when the node was created.
    - `updated_at` - The date and time when the node was last updated.

      * `created_at` (`str`)
      * `droplet_id` (`str`)
      * `id` (`str`) - A unique ID that can be used to identify and reference the node pool.
      * `name` (`str`) - A name for the node pool.
      * `status` (`str`)
      * `updated_at` (`str`)
    """
    size: pulumi.Output[str]
    """
    The slug identifier for the type of Droplet to be used as workers in the node pool.
    """
    tags: pulumi.Output[list]
    """
    A list of tag names to be applied to the Kubernetes cluster.
    """
    def __init__(__self__, resource_name, opts=None, auto_scale=None, cluster_id=None, labels=None, max_nodes=None, min_nodes=None, name=None, node_count=None, size=None, tags=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a DigitalOcean Kubernetes node pool resource. While the default node pool must be defined in the `.KubernetesCluster` resource, this resource can be used to add additional ones to a cluster.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-digitalocean/blob/master/website/docs/r/kubernetes_node_pool.html.markdown.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_scale: Enable auto-scaling of the number of nodes in the node pool within the given min/max range.
        :param pulumi.Input[str] cluster_id: The ID of the Kubernetes cluster to which the node pool is associated.
        :param pulumi.Input[dict] labels: A map of key/value pairs to apply to nodes in the pool. The labels are exposed in the Kubernetes API as labels in the metadata of the corresponding [Node resources](https://kubernetes.io/docs/concepts/architecture/nodes/).
        :param pulumi.Input[float] max_nodes: If auto-scaling is enabled, this represents the maximum number of nodes that the node pool can be scaled up to.
        :param pulumi.Input[float] min_nodes: If auto-scaling is enabled, this represents the minimum number of nodes that the node pool can be scaled down to.
        :param pulumi.Input[str] name: A name for the node pool.
        :param pulumi.Input[float] node_count: The number of Droplet instances in the node pool. If auto-scaling is enabled, this should only be set if the desired result is to explicitly reset the number of nodes to this value. If auto-scaling is enabled, and the node count is outside of the given min/max range, it will use the min nodes value.
        :param pulumi.Input[str] size: The slug identifier for the type of Droplet to be used as workers in the node pool.
        :param pulumi.Input[list] tags: A list of tag names to be applied to the Kubernetes cluster.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['auto_scale'] = auto_scale
            if cluster_id is None:
                raise TypeError("Missing required property 'cluster_id'")
            __props__['cluster_id'] = cluster_id
            __props__['labels'] = labels
            __props__['max_nodes'] = max_nodes
            __props__['min_nodes'] = min_nodes
            __props__['name'] = name
            __props__['node_count'] = node_count
            if size is None:
                raise TypeError("Missing required property 'size'")
            __props__['size'] = size
            __props__['tags'] = tags
            __props__['actual_node_count'] = None
            __props__['nodes'] = None
        super(KubernetesNodePool, __self__).__init__(
            'digitalocean:index/kubernetesNodePool:KubernetesNodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, actual_node_count=None, auto_scale=None, cluster_id=None, labels=None, max_nodes=None, min_nodes=None, name=None, node_count=None, nodes=None, size=None, tags=None):
        """
        Get an existing KubernetesNodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] actual_node_count: A computed field representing the actual number of nodes in the node pool, which is especially useful when auto-scaling is enabled.
        :param pulumi.Input[bool] auto_scale: Enable auto-scaling of the number of nodes in the node pool within the given min/max range.
        :param pulumi.Input[str] cluster_id: The ID of the Kubernetes cluster to which the node pool is associated.
        :param pulumi.Input[dict] labels: A map of key/value pairs to apply to nodes in the pool. The labels are exposed in the Kubernetes API as labels in the metadata of the corresponding [Node resources](https://kubernetes.io/docs/concepts/architecture/nodes/).
        :param pulumi.Input[float] max_nodes: If auto-scaling is enabled, this represents the maximum number of nodes that the node pool can be scaled up to.
        :param pulumi.Input[float] min_nodes: If auto-scaling is enabled, this represents the minimum number of nodes that the node pool can be scaled down to.
        :param pulumi.Input[str] name: A name for the node pool.
        :param pulumi.Input[float] node_count: The number of Droplet instances in the node pool. If auto-scaling is enabled, this should only be set if the desired result is to explicitly reset the number of nodes to this value. If auto-scaling is enabled, and the node count is outside of the given min/max range, it will use the min nodes value.
        :param pulumi.Input[list] nodes: A list of nodes in the pool. Each node exports the following attributes:
               - `id` -  A unique ID that can be used to identify and reference the node.
               - `name` - The auto-generated name for the node.
               - `status` -  A string indicating the current status of the individual node.
               - `droplet_id` - The id of the node's droplet
               - `created_at` - The date and time when the node was created.
               - `updated_at` - The date and time when the node was last updated.
        :param pulumi.Input[str] size: The slug identifier for the type of Droplet to be used as workers in the node pool.
        :param pulumi.Input[list] tags: A list of tag names to be applied to the Kubernetes cluster.

        The **nodes** object supports the following:

          * `created_at` (`pulumi.Input[str]`)
          * `droplet_id` (`pulumi.Input[str]`)
          * `id` (`pulumi.Input[str]`) - A unique ID that can be used to identify and reference the node pool.
          * `name` (`pulumi.Input[str]`) - A name for the node pool.
          * `status` (`pulumi.Input[str]`)
          * `updated_at` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["actual_node_count"] = actual_node_count
        __props__["auto_scale"] = auto_scale
        __props__["cluster_id"] = cluster_id
        __props__["labels"] = labels
        __props__["max_nodes"] = max_nodes
        __props__["min_nodes"] = min_nodes
        __props__["name"] = name
        __props__["node_count"] = node_count
        __props__["nodes"] = nodes
        __props__["size"] = size
        __props__["tags"] = tags
        return KubernetesNodePool(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

