# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tbpore']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.0.3,<9.0.0',
 'cyvcf2>=0.30,<0.31',
 'loguru>=0.5.3,<0.6.0',
 'networkx>=2.8,<3.0',
 'pandas>=1.4.2,<2.0.0',
 'pysam>=0.17,<0.18',
 'pyyaml>=6.0']

entry_points = \
{'console_scripts': ['tbpore = tbpore.tbpore:main']}

setup_kwargs = {
    'name': 'tbpore',
    'version': '0.1.1',
    'description': 'Mycobacterium tuberculosis genomic analysis from Nanopore sequencing data',
    'long_description': '# TBpore\n\n*Mycobacterium tuberculosis* genomic analysis from Nanopore sequencing data\n\n[![Python CI](https://github.com/mbhall88/tbpore/actions/workflows/ci.yaml/badge.svg)](https://github.com/mbhall88/tbpore/actions/workflows/ci.yaml)\n[![codecov](https://codecov.io/gh/mbhall88/tbpore/branch/main/graph/badge.svg)](https://codecov.io/gh/mbhall88/tbpore)\n[![PyPI](https://img.shields.io/pypi/v/tbpore)](https://pypi.org/project/tbpore/)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/tbpore)\n[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\n[TOC]: #\n\n# Table of Contents\n- [Synopsis](#synopsis)\n- [Installation](#installation)\n- [Walkthrough](#walkthrough)\n- [Configuring the decontamination database index](#configuring-the-decontamination-database-index)\n- [Performance](#performance)\n- [Usage](#usage)\n\n# Synopsis\n\n`tbpore` is a tool with two main goals.\nFirst is to process Nanopore Mycobacterium tuberculosis sequencing data to describe variants with respect to the\ncanonical TB strain H37Rv and predict antibiotic resistance (command `tbpore process`).\nVariant description is done by decontaminating reads, calling variants with\n[bcftools](https://github.com/samtools/bcftools) and filtering variants.\nAntibiotic resistance is predicted with [mykrobe](https://github.com/Mykrobe-tools/mykrobe).\nSecond, `tbpore` can be used to cluster TB samples based on their genotyping and a given distance threshold (command\n`tbpore cluster`).\n\n## Installation\n\n### conda\n\n[![Conda (channel only)](https://img.shields.io/conda/vn/bioconda/tbpore)](https://anaconda.org/bioconda/tbpore)\n[![bioconda version](https://anaconda.org/bioconda/tbpore/badges/platforms.svg)](https://anaconda.org/bioconda/tbpore)\n![Conda](https://img.shields.io/conda/dn/bioconda/tbpore)\n\nPrerequisite: [`conda`][conda] (and bioconda channel [correctly set up][channels])\n\n```shell\n$ conda install tbpore\n```\n\n### pip\n\n![PyPI](https://img.shields.io/pypi/v/tbpore)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/tbpore)\n\nThe python components of `tbpore` are availble to install through [PyPI].\n\n```shell\npip install tbpore\n```\n\n**However**, you will need to install the following dependencies, which cannot be installed through PyPI.\n\n#### Dependencies\n* [`rasusa`](https://github.com/mbhall88/rasusa)\n* [`psdm`](https://github.com/mbhall88/psdm) version 0.1\n* [`samtools`](https://github.com/samtools/samtools) version 1.13\n* [`bcftools`](https://github.com/samtools/bcftools) version 1.13\n* [`mykrobe`](https://github.com/Mykrobe-tools/mykrobe) version ≥ 0.11\n* [`minimap2`](https://github.com/lh3/minimap2) version 2.22\n* [`seqkit`](https://bioinf.shenwei.me/seqkit/) version 2.0\n\nWe make no guarentees about the performance of `tbpore` with versions other than those specified above. In particular, the `bcftools` version is very important. The latest versions of the other dependencies can likely be used.\n\n### Container\n\nDocker images are provided through biocontainers.\n\n#### `singularity`\n\nPrerequisite: [`singularity`][singularity]\n\n```shell\n$ URI="docker://quay.io/biocontainers/tbpore:<tag>"\n$ singularity exec "$URI" tbpore --help\n```\n\nsee [here][tags] for valid values for `<tag>`.\n\n#### `docker`\n\n[![Docker Repository on Quay](https://quay.io/repository/biocontainers/tbpore/status "Docker Repository on Quay")](https://quay.io/repository/biocontainers/tbpore)\n\nPrerequisite: [Docker]\n\n```shell\n$ docker pull quay.io/biocontainers/tbpore:<tag>\n$ docker run quay.io/biocontainers/tbpore:<tag> tbpore --help\n```\n\nsee [here][tags] for valid values for `<tag>`.\n\n### Configuring the decontamination database index\n\nWhen you run your first `tbpore process`, you will get this error:\n```\nERROR    | Decontamination DB index tbpore/data/decontamination_db/tbpore.remove_contam.fa.gz.map-ont.mmi does not\nexist, please follow the instructions at https://github.com/mbhall88/tbpore#configuring-the-decontamination-database-index\nto download and configure it before running tbpore\n```\nThis means you need to download the [minimap2](https://github.com/lh3/minimap2) decontamination database index before\nproceeding. You can [download this index here](https://figshare.com/ndownloader/files/36708444) or by running:\n```shell\nwget https://figshare.com/ndownloader/files/36708444 -O tbpore.remove_contam.fa.gz.map-ont.mmi.gz\n```\n\nOnce the download is complete, you can:\n\n1. Ensure that the compressed index was transferred correctly by checking its `md5sum`:\n```shell\nmd5sum tbpore.remove_contam.fa.gz.map-ont.mmi.gz\n82d050e0f1cba052f0c94f16fcb32f7b  tbpore.remove_contam.fa.gz.map-ont.mmi.gz\n```\n\n2. Decompress the index:\n```shell\ngunzip tbpore.remove_contam.fa.gz.map-ont.mmi.gz\n```\n\n3. Check the md5sum of the decompressed index:\n```shell\nmd5sum tbpore.remove_contam.fa.gz.map-ont.mmi\n810c5c09eaf9421128e4e52cdf2fa32a  tbpore.remove_contam.fa.gz.map-ont.mmi\n```\n\n4. Move the decompressed index to `<tbpore_dir>/data/decontamination_db/tbpore.remove_contam.fa.gz.map-ont.mmi`\n\nOnce these four steps above are done, you should be able to run `tbpore` on an example isolate by going into the\n`tbpore` dir and running:\n```shell\njust test-run\n```\n\n# Performance\n\n## `tbpore process`\n\nBenchmarked on 151 TB ONT samples with 1 thread:\n* Runtime: `2103`s avg, `4048`s max (s = seconds);\n* RAM: `12.4`GB avg, `13.1`GB max (GB = Gigabytes);\n\n## `tbpore cluster`\n\nClustering 151 TB ONT samples:\n* Runtime: `286`s;\n* RAM: `<1`GB;\n\n# Usage\n\n## General usage\n\n```\nUsage: tbpore [OPTIONS] COMMAND [ARGS]...\n\nOptions:\n  -h, --help     Show this message and exit.\n  -V, --version  Show the version and exit.\n  -v, --verbose  Turns on debug-level logger. Option is mutually exclusive\n                 with quiet.\n  -q, --quiet    Turns off all logging except errors. Option is mutually\n                 exclusive with verbose.\n\nCommands:\n  cluster  Cluster consensus sequences\n  process  Single-sample TB genomic analysis from Nanopore sequencing data\n```\n\n## process subcommand\n\n```\nUsage: tbpore process [OPTIONS] [INPUTS]...\n\n  Single-sample TB genomic analysis from Nanopore sequencing data\n\n  INPUTS: Fastq file(s) and/or a directory containing fastq files. All files\n  will be joined into a single fastq file, so ensure they\'re all part of the\n  same sample/isolate.\n\nOptions:\n  -o, --outdir DIRECTORY          Directory to place output files  [default:\n                                  tbpore_out]\n  -r, --recursive                 Recursively search INPUTS for fastq files\n  --tmp DIRECTORY                 Specify where to write all (tbpore)\n                                  temporary files. [default: <outdir>/.tbpore]\n  -S, --name TEXT                 Name of the sample. By default, will use the\n                                  first INPUT file with any extensions\n                                  stripped\n  -t, --threads INTEGER           Number of threads to use in multithreaded\n                                  tools  [default: 1]\n  -A, --report_all_mykrobe_calls  Report all mykrobe calls (turn on flag -A,\n                                  --report_all_calls when calling mykrobe)\n  -d, --cleanup / -D, --no-cleanup\n                                  Remove all temporary files on *successful*\n                                  completion  [default: no-cleanup]\n  --help                          Show this message and exit.\n```\n\n## cluster subcommand\n\n```\nUsage: tbpore cluster [OPTIONS] [INPUTS]...\n\n  Cluster consensus sequences\n\n  Preferably input consensus sequences previously generated with tbpore\n  process.\n\n  INPUTS: Two or more consensus fasta sequences. Use glob patterns to input\n  several easily (e.g. output/sample_*/*.consensus.fa).\n\nOptions:\n  -T, --threshold INTEGER         Clustering threshold  [default: 6]\n  -o, --outdir DIRECTORY          Directory to place output files  [default:\n                                  cluster_out]\n  --tmp DIRECTORY                 Specify where to write all (tbpore)\n                                  temporary files. [default: <outdir>/.tbpore]\n  -t, --threads INTEGER           Number of threads to use in multithreaded\n                                  tools  [default: 1]\n  -d, --cleanup / -D, --no-cleanup\n                                  Remove all temporary files on *successful*\n                                  completion  [default: no-cleanup]\n  --help                          Show this message and exit.\n```\n\n[channels]: https://bioconda.github.io/#usage\n[conda]: https://docs.conda.io/projects/conda/en/latest/user-guide/install/\n[PyPI]: https://pypi.org/project/tbpore/\n[singularity]: https://sylabs.io/guides/3.6/user-guide/quick_start.html#quick-installation-steps\n[tags]: https://quay.io/repository/biocontainers/tbpore?tab=tags\n[Docker]: https://docs.docker.com/v17.12/install/',
    'author': 'Michael Hall',
    'author_email': 'michael@mbh.sh',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/mbhall88/tbpore',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
