# Generated by Django 3.2.11 on 2022-02-23 18:42

import _socket
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_model.models.fields.other_charfield
import edc_model.models.validators.date
import edc_protocol.validators
import edc_sites.models
import edc_utils.date
import simple_history.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='Microbiology',
            fields=[
                ('revision', django_revision.revision_field.RevisionField(blank=True, editable=False, help_text='System field. Git repository tag:branch:commit.', max_length=75, null=True, verbose_name='Revision')),
                ('created', models.DateTimeField(blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow)),
                ('modified', models.DateTimeField(blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow)),
                ('user_created', django_audit_fields.fields.userfield.UserField(blank=True, help_text='Updated by admin.save_model', max_length=50, verbose_name='user created')),
                ('user_modified', django_audit_fields.fields.userfield.UserField(blank=True, help_text='Updated by admin.save_model', max_length=50, verbose_name='user modified')),
                ('hostname_created', models.CharField(blank=True, default=_socket.gethostname, help_text='System field. (modified on create only)', max_length=60)),
                ('hostname_modified', django_audit_fields.fields.hostname_modification_field.HostnameModificationField(blank=True, help_text='System field. (modified on every save)', max_length=50)),
                ('device_created', models.CharField(blank=True, max_length=10)),
                ('device_modified', models.CharField(blank=True, max_length=10)),
                ('id', django_audit_fields.fields.uuid_auto_field.UUIDAutoField(blank=True, editable=False, help_text='System auto field. UUID primary key.', primary_key=True, serialize=False)),
                ('subject_identifier', models.CharField(max_length=50, unique=True)),
                ('blood_culture_performed', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], max_length=5)),
                ('blood_culture_taken_date', models.DateField(blank=True, null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future])),
                ('blood_culture_result', models.CharField(choices=[('N/A', 'Not applicable'), ('no_growth', 'No growth'), ('POS', 'Positive')], default='N/A', max_length=10, verbose_name='Blood culture results, if completed')),
                ('blood_culture_day_taken', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1)], verbose_name='If positive, study day positive blood sample taken')),
                ('blood_culture_organism_text', models.TextField(blank=True, null=True, verbose_name='If growth positive, organism')),
                ('blood_culture_organism', models.CharField(choices=[('N/A', 'Not applicable'), ('cryptococcus_neoformans', 'Cryptococcus neoformans'), ('bacteria', 'Bacteria'), ('bacteria_and_cryptococcus', 'Bacteria and Cryptococcus'), ('OTHER', 'Other')], default='N/A', max_length=50, verbose_name='If growth positive, organism')),
                ('blood_culture_organism_other', edc_model.models.fields.other_charfield.OtherCharField(blank=True, max_length=50, null=True, verbose_name='If other, please specify ...')),
                ('blood_culture_bacteria', models.CharField(choices=[('N/A', 'Not applicable'), ('e_coli', 'E.coli'), ('klebsiella_sp', 'Klebsiella spp.'), ('streptococcus_pneumoniae', 'Streptococcus pneumoniae'), ('staphylococus_aureus', '(Sensitive) Staphylococus aureus'), ('mrsa', 'MRSA'), ('OTHER', 'Other')], default='N/A', max_length=50, verbose_name='If bacteria identified, select type')),
                ('blood_culture_bacteria_other', edc_model.models.fields.other_charfield.OtherCharField(blank=True, max_length=100, null=True, verbose_name='If other, please specify ...')),
                ('tissue_biopsy_taken', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], max_length=5, verbose_name='Was a tissue biopsy taken')),
                ('tissue_biopsy_result', models.CharField(choices=[('N/A', 'Not applicable'), ('no_growth', 'No growth'), ('POS', 'Positive')], default='N/A', max_length=10, verbose_name='If YES, results')),
                ('tissue_biopsy_date', models.DateField(blank=True, null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future])),
                ('tissue_biopsy_day_taken', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1)], verbose_name='If POSITIVE, `study day` positive tissue biospy sample taken')),
                ('tissue_biopsy_organism', models.CharField(choices=[('N/A', 'Not applicable'), ('cryptococcus_neoformans', 'Cryptococcus neoformans'), ('mycobacterium_tuberculosis', 'Mycobacterium Tuberculosis'), ('OTHER', 'Other')], default='N/A', max_length=50, verbose_name='If growth POSITIVE, organism')),
                ('tissue_biopsy_organism_other', edc_model.models.fields.other_charfield.OtherCharField(blank=True, max_length=50, null=True, verbose_name='If other, please specify ...')),
                ('tissue_biopsy_report', models.TextField(blank=True, null=True, verbose_name='Histopathoplogy report')),
                ('sputum_afb_performed', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], help_text='Was sputum AFB done?', max_length=5, verbose_name='AFB microscopy performed?')),
                ('sputum_afb_date', models.DateField(blank=True, null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future])),
                ('sputum_afb_result', models.CharField(choices=[('POS', 'Positive'), ('NEG', 'Negative'), ('N/A', 'Not applicable')], default='N/A', max_length=10, verbose_name='AFB results')),
                ('sputum_culture_performed', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No'), ('N/A', 'Not applicable')], default='N/A', max_length=15, verbose_name='Culture performed?')),
                ('sputum_culture_taken_date', models.DateField(blank=True, null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future])),
                ('sputum_culture_result', models.CharField(choices=[('POS', 'MTB Positive'), ('NEG', 'MTB Negative'), ('IND', 'Contaminated/indeterminate')], default='N/A', max_length=10, verbose_name='Culture results')),
                ('sputum_culture_pos_description', models.CharField(blank=True, max_length=50, null=True, verbose_name='If Culture is positive, please specify:')),
                ('sputum_genexpert_performed', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No'), ('N/A', 'Not applicable')], default='N/A', max_length=15, verbose_name='Sputum Gene-Xpert performed?')),
                ('sputum_genexpert_date', models.DateField(blank=True, null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future], verbose_name='Date sputum Gene-Xpert taken')),
                ('sputum_genexpert_result', models.CharField(choices=[('mtb_detected_rif_resistance_detected', 'MTB DETECTED & Rif Resistance DETECTED'), ('mtb_detected_rif_resistance_not_detected', 'MTB DETECTED & Rif Resistance NOT detected'), ('mtb_detected_rif_resistance_indeterminate', 'MTB DETECTED & Rif Resistance INDETERMINATE'), ('mtb_not_detected', 'MTB NOT detected'), ('N/A', 'Not applicable')], default='N/A', max_length=45, verbose_name='Sputum Gene-Xpert results')),
                ('urinary_lam_performed', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], max_length=15, verbose_name='Urinary LAM performed?')),
                ('urinary_lam_date', models.DateField(blank=True, null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future])),
                ('urinary_lam_result', models.CharField(choices=[('POS', 'Positive'), ('NEG', 'Negative'), ('N/A', 'Not applicable')], max_length=25, verbose_name='Urinary LAM result')),
                ('urinary_lam_result_grade', models.CharField(blank=True, choices=[('1', '1+ (low)'), ('2', '2+'), ('3', '3+'), ('4', '4+'), ('5', '5+ (high)'), ('unknown', 'Unknown')], max_length=25, null=True, verbose_name='If Urinary LAM is positive, grade')),
                ('urine_culture_performed', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], help_text='only for patients with >50 white cells in urine', max_length=5)),
                ('urine_culture_taken_date', models.DateField(blank=True, null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future])),
                ('urine_culture_result', models.CharField(choices=[('N/A', 'Not applicable'), ('no_growth', 'No growth'), ('POS', 'Positive')], default='N/A', max_length=10, verbose_name='Urine culture results, if completed')),
                ('urine_culture_organism', models.CharField(choices=[('N/A', 'Not applicable'), ('e_coli', 'E.coli'), ('klebsiella_sp', 'Klebsiella spp.'), ('OTHER', 'Other')], default='N/A', max_length=25, verbose_name='If positive, organism')),
                ('urine_culture_organism_other', edc_model.models.fields.other_charfield.OtherCharField(blank=True, max_length=50, null=True, verbose_name='If other, please specify ...')),
                ('report_datetime', models.DateTimeField(default=edc_utils.date.get_utcnow)),
                ('site', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='sites.site')),
            ],
            options={
                'verbose_name': 'Microbiology',
                'verbose_name_plural': 'Microbiology',
                'ordering': ('-modified', '-created'),
                'get_latest_by': 'modified',
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'export', 'import'),
            },
            managers=[
                ('on_site', edc_sites.models.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='HistoricalMicrobiology',
            fields=[
                ('revision', django_revision.revision_field.RevisionField(blank=True, editable=False, help_text='System field. Git repository tag:branch:commit.', max_length=75, null=True, verbose_name='Revision')),
                ('created', models.DateTimeField(blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow)),
                ('modified', models.DateTimeField(blank=True, default=django_audit_fields.models.audit_model_mixin.utcnow)),
                ('user_created', django_audit_fields.fields.userfield.UserField(blank=True, help_text='Updated by admin.save_model', max_length=50, verbose_name='user created')),
                ('user_modified', django_audit_fields.fields.userfield.UserField(blank=True, help_text='Updated by admin.save_model', max_length=50, verbose_name='user modified')),
                ('hostname_created', models.CharField(blank=True, default=_socket.gethostname, help_text='System field. (modified on create only)', max_length=60)),
                ('hostname_modified', django_audit_fields.fields.hostname_modification_field.HostnameModificationField(blank=True, help_text='System field. (modified on every save)', max_length=50)),
                ('device_created', models.CharField(blank=True, max_length=10)),
                ('device_modified', models.CharField(blank=True, max_length=10)),
                ('id', django_audit_fields.fields.uuid_auto_field.UUIDAutoField(blank=True, db_index=True, editable=False, help_text='System auto field. UUID primary key.')),
                ('subject_identifier', models.CharField(db_index=True, max_length=50)),
                ('blood_culture_performed', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], max_length=5)),
                ('blood_culture_taken_date', models.DateField(blank=True, null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future])),
                ('blood_culture_result', models.CharField(choices=[('N/A', 'Not applicable'), ('no_growth', 'No growth'), ('POS', 'Positive')], default='N/A', max_length=10, verbose_name='Blood culture results, if completed')),
                ('blood_culture_day_taken', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1)], verbose_name='If positive, study day positive blood sample taken')),
                ('blood_culture_organism_text', models.TextField(blank=True, null=True, verbose_name='If growth positive, organism')),
                ('blood_culture_organism', models.CharField(choices=[('N/A', 'Not applicable'), ('cryptococcus_neoformans', 'Cryptococcus neoformans'), ('bacteria', 'Bacteria'), ('bacteria_and_cryptococcus', 'Bacteria and Cryptococcus'), ('OTHER', 'Other')], default='N/A', max_length=50, verbose_name='If growth positive, organism')),
                ('blood_culture_organism_other', edc_model.models.fields.other_charfield.OtherCharField(blank=True, max_length=50, null=True, verbose_name='If other, please specify ...')),
                ('blood_culture_bacteria', models.CharField(choices=[('N/A', 'Not applicable'), ('e_coli', 'E.coli'), ('klebsiella_sp', 'Klebsiella spp.'), ('streptococcus_pneumoniae', 'Streptococcus pneumoniae'), ('staphylococus_aureus', '(Sensitive) Staphylococus aureus'), ('mrsa', 'MRSA'), ('OTHER', 'Other')], default='N/A', max_length=50, verbose_name='If bacteria identified, select type')),
                ('blood_culture_bacteria_other', edc_model.models.fields.other_charfield.OtherCharField(blank=True, max_length=100, null=True, verbose_name='If other, please specify ...')),
                ('tissue_biopsy_taken', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], max_length=5, verbose_name='Was a tissue biopsy taken')),
                ('tissue_biopsy_result', models.CharField(choices=[('N/A', 'Not applicable'), ('no_growth', 'No growth'), ('POS', 'Positive')], default='N/A', max_length=10, verbose_name='If YES, results')),
                ('tissue_biopsy_date', models.DateField(blank=True, null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future])),
                ('tissue_biopsy_day_taken', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1)], verbose_name='If POSITIVE, `study day` positive tissue biospy sample taken')),
                ('tissue_biopsy_organism', models.CharField(choices=[('N/A', 'Not applicable'), ('cryptococcus_neoformans', 'Cryptococcus neoformans'), ('mycobacterium_tuberculosis', 'Mycobacterium Tuberculosis'), ('OTHER', 'Other')], default='N/A', max_length=50, verbose_name='If growth POSITIVE, organism')),
                ('tissue_biopsy_organism_other', edc_model.models.fields.other_charfield.OtherCharField(blank=True, max_length=50, null=True, verbose_name='If other, please specify ...')),
                ('tissue_biopsy_report', models.TextField(blank=True, null=True, verbose_name='Histopathoplogy report')),
                ('sputum_afb_performed', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], help_text='Was sputum AFB done?', max_length=5, verbose_name='AFB microscopy performed?')),
                ('sputum_afb_date', models.DateField(blank=True, null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future])),
                ('sputum_afb_result', models.CharField(choices=[('POS', 'Positive'), ('NEG', 'Negative'), ('N/A', 'Not applicable')], default='N/A', max_length=10, verbose_name='AFB results')),
                ('sputum_culture_performed', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No'), ('N/A', 'Not applicable')], default='N/A', max_length=15, verbose_name='Culture performed?')),
                ('sputum_culture_taken_date', models.DateField(blank=True, null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future])),
                ('sputum_culture_result', models.CharField(choices=[('POS', 'MTB Positive'), ('NEG', 'MTB Negative'), ('IND', 'Contaminated/indeterminate')], default='N/A', max_length=10, verbose_name='Culture results')),
                ('sputum_culture_pos_description', models.CharField(blank=True, max_length=50, null=True, verbose_name='If Culture is positive, please specify:')),
                ('sputum_genexpert_performed', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No'), ('N/A', 'Not applicable')], default='N/A', max_length=15, verbose_name='Sputum Gene-Xpert performed?')),
                ('sputum_genexpert_date', models.DateField(blank=True, null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future], verbose_name='Date sputum Gene-Xpert taken')),
                ('sputum_genexpert_result', models.CharField(choices=[('mtb_detected_rif_resistance_detected', 'MTB DETECTED & Rif Resistance DETECTED'), ('mtb_detected_rif_resistance_not_detected', 'MTB DETECTED & Rif Resistance NOT detected'), ('mtb_detected_rif_resistance_indeterminate', 'MTB DETECTED & Rif Resistance INDETERMINATE'), ('mtb_not_detected', 'MTB NOT detected'), ('N/A', 'Not applicable')], default='N/A', max_length=45, verbose_name='Sputum Gene-Xpert results')),
                ('urinary_lam_performed', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], max_length=15, verbose_name='Urinary LAM performed?')),
                ('urinary_lam_date', models.DateField(blank=True, null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future])),
                ('urinary_lam_result', models.CharField(choices=[('POS', 'Positive'), ('NEG', 'Negative'), ('N/A', 'Not applicable')], max_length=25, verbose_name='Urinary LAM result')),
                ('urinary_lam_result_grade', models.CharField(blank=True, choices=[('1', '1+ (low)'), ('2', '2+'), ('3', '3+'), ('4', '4+'), ('5', '5+ (high)'), ('unknown', 'Unknown')], max_length=25, null=True, verbose_name='If Urinary LAM is positive, grade')),
                ('urine_culture_performed', models.CharField(choices=[('Yes', 'Yes'), ('No', 'No')], help_text='only for patients with >50 white cells in urine', max_length=5)),
                ('urine_culture_taken_date', models.DateField(blank=True, null=True, validators=[edc_protocol.validators.date_not_before_study_start, edc_model.models.validators.date.date_not_future])),
                ('urine_culture_result', models.CharField(choices=[('N/A', 'Not applicable'), ('no_growth', 'No growth'), ('POS', 'Positive')], default='N/A', max_length=10, verbose_name='Urine culture results, if completed')),
                ('urine_culture_organism', models.CharField(choices=[('N/A', 'Not applicable'), ('e_coli', 'E.coli'), ('klebsiella_sp', 'Klebsiella spp.'), ('OTHER', 'Other')], default='N/A', max_length=25, verbose_name='If positive, organism')),
                ('urine_culture_organism_other', edc_model.models.fields.other_charfield.OtherCharField(blank=True, max_length=50, null=True, verbose_name='If other, please specify ...')),
                ('report_datetime', models.DateTimeField(default=edc_utils.date.get_utcnow)),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('site', models.ForeignKey(blank=True, db_constraint=False, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='sites.site')),
            ],
            options={
                'verbose_name': 'historical Microbiology',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
