from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '1.2.0'
DESCRIPTION = 'Simple python package for download tweet from Twitter'
LONG_DESCRIPTION = 'Simple python package for download tweet from Twitter'

# Setting up
setup(
    name="TwiGram",
    version=VERSION,
    author="Matin Baloochestani (Matin-B)",
    author_email="MatiinBaloochestani@Gmail.com",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=long_description,
    packages=find_packages(),
    install_requires=['requests'],
    keywords=['python', 'twitter'],
    classifiers=[
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)